/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.common;

import com.kingdee.eas.common.RefChkFilterItemEnum;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.HashSet;

public class RefChkFilter
implements Serializable {
    private String sql = "";
    private static String CU_IN = " and FControlUnitID in ({0}) ";
    private static String CU_NOTIN = " and FControlUnitID not in ({0}) ";
    private static String REFTABLENAME_IN = " and FRefTableName in (select FTableName from T_PF_BOSObject where FBOSType in ({0})) ";
    private static String REFTABLENAME_NOTIN = " and FRefTableName not in (select FTableName from T_PF_BOSObject where FBOSType in ({0})) ";
    private RefChkFilterItemEnum filterItem;
    private HashSet filterValue;

    public RefChkFilter(RefChkFilterItemEnum filterItem, HashSet filterValue) {
        this.filterItem = filterItem;
        this.filterValue = filterValue;
        this.generateSQL();
    }

    public RefChkFilterItemEnum getFilterItem() {
        return this.filterItem;
    }

    public String getSQL() {
        return this.sql;
    }

    private boolean hasSQL() {
        return this.sql.trim().length() > 0;
    }

    public boolean isSQL4CU() {
        return this.hasSQL() && (this.filterItem.getValue() == 0 || this.filterItem.getValue() == 2);
    }

    public boolean isSQL4RefTableName() {
        return this.hasSQL() && (this.filterItem.getValue() == 1 || this.filterItem.getValue() == 3);
    }

    private void generateSQL() {
        if (this.filterValue.size() != 0) {
            String template = "";
            switch (this.filterItem.getValue()) {
                case 0: {
                    template = CU_IN;
                    break;
                }
                case 2: {
                    template = CU_NOTIN;
                    break;
                }
                case 1: {
                    template = REFTABLENAME_IN;
                    break;
                }
                case 3: {
                    template = REFTABLENAME_NOTIN;
                }
            }
            this.makeSQL(template, this.filterValue);
        }
    }

    private void makeSQL(String template, HashSet set) {
        StringBuffer param = new StringBuffer("");
        Object[] objs = set.toArray();
        int n = objs.length;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                param.append(",");
            }
            param.append("'" + objs[i].toString() + "'");
        }
        this.sql = MessageFormat.format(template, param.toString());
    }
}

