/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.view.BusinessObjectBriefView;
import com.kingdee.bos.metadata.view.ExtendedPropertyFilter;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.metadata.view.MetaDataBriefCollection;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.metadata.view.MetaDataBriefViewFilter;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SubSystemPromptBox;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.subsystemhelper.UserCustomSubSystem;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class SubSystemUtils {
    private static final Logger logger = Logger.getLogger((String)SubSystemUtils.class.getName());
    public static final String BASE_MDB_VIEW_NAME = "eas_base_subsystem";
    public static final String DEFAULT_METADATA_PATH = "w:\\apusic\\metas";
    public static final String RESOURCE_NAME = "MetaDataPath.properties";
    private static IMetaDataLoader loader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMetaDataPath() {
        BufferedReader reader = null;
        try {
            InputStream in = SubSystemUtils.class.getResourceAsStream(RESOURCE_NAME);
            InputStreamReader ireader = new InputStreamReader(in);
            reader = new BufferedReader(ireader);
            String path = reader.readLine();
            reader.close();
            String string = path;
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            String string = DEFAULT_METADATA_PATH;
            return string;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static IMetaDataLoader getMetaDataLoader() {
        loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        return loader;
    }

    public static IMetaDataLoader getMetaDataLoader(Context ctx) {
        loader = ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        return loader;
    }

    private static MetaDataBriefViewFilter getFilterByName(String mdbViewName) {
        MetaDataBriefViewFilter filter = new MetaDataBriefViewFilter();
        filter.setViewName(mdbViewName);
        filter.addMetaDataTypeFilter(MetaDataTypeList.ENTITY);
        filter.addMetaDataTypeFilter(MetaDataTypeList.FACADE);
        filter.addMetaDataTypeFilter(MetaDataTypeList.UIOBJECT);
        filter.addMetaDataTypeFilter(MetaDataTypeList.DATATABLE);
        filter.addMetaDataTypeFilter(MetaDataTypeList.JOINQUERY);
        filter.addMetaDataTypeFilter(MetaDataTypeList.FUNCTION);
        return filter;
    }

    private static MetaDataBriefViewFilter getFilterByName(String mdbViewName, BOSObjectType[] types) {
        MetaDataBriefViewFilter filter = new MetaDataBriefViewFilter();
        filter.setViewName(mdbViewName);
        if (types != null) {
            for (int i = 0; i < types.length; ++i) {
                filter.addMetaDataTypeFilter(types[i]);
            }
        }
        return filter;
    }

    private static MetaDataBriefViewFilter getFilterByName(String mdbViewName, BOSObjectType type) {
        return SubSystemUtils.getFilterByName(mdbViewName, new BOSObjectType[]{type});
    }

    public static MetaDataBriefViewFilter getGeneratedSubSystemFilter() {
        MetaDataBriefViewFilter filter = SubSystemUtils.getSubSystemFilter();
        filter.addMetaDataTypeFilter(MetaDataTypeList.ENTITY);
        filter.addMetaDataTypeFilter(MetaDataTypeList.FACADE);
        filter.addMetaDataTypeFilter(MetaDataTypeList.UIOBJECT);
        filter.addMetaDataTypeFilter(MetaDataTypeList.DATATABLE);
        filter.addMetaDataTypeFilter(MetaDataTypeList.JOINQUERY);
        filter.addMetaDataTypeFilter(MetaDataTypeList.FUNCTION);
        filter.setPackagePrefix("com.kingdee.eas");
        return filter;
    }

    private static MetaDataBriefViewFilter getSubSystemFilter() {
        MetaDataBriefViewFilter filter = new MetaDataBriefViewFilter();
        filter.setViewName(BASE_MDB_VIEW_NAME);
        filter.setPackagePrefix("com.kingdee.eas");
        filter.addMetaDataTypeFilter(MetaDataTypeList.PACKAGE);
        return filter;
    }

    private static MetaDataBriefViewFilter getFacadeFilter() {
        MetaDataBriefViewFilter filter = SubSystemUtils.getSubSystemFilter();
        filter.addMetaDataTypeFilter(MetaDataTypeList.FACADE);
        return filter;
    }

    private static MetaDataBriefViewFilter getUIFilter() {
        MetaDataBriefViewFilter filter = SubSystemUtils.getSubSystemFilter();
        filter.addMetaDataTypeFilter(MetaDataTypeList.UIOBJECT);
        return filter;
    }

    private static MetaDataBriefViewFilter getEntityFilter(ExtendedPropertyFilter[] extfilters, String baseEntityFullName) {
        MetaDataBriefViewFilter filter = SubSystemUtils.getSubSystemFilter();
        filter.addMetaDataTypeFilter(MetaDataTypeList.ENTITY);
        if (extfilters != null) {
            for (int i = 0; i < extfilters.length; ++i) {
                filter.addExtendedPropertyFilter(extfilters[i]);
            }
        }
        if (baseEntityFullName != null) {
            filter.setEntityChainFilter(baseEntityFullName);
        }
        return filter;
    }

    private static MetaDataBriefViewFilter getEntityFilter() {
        return SubSystemUtils.getEntityFilter(null, null);
    }

    private static MetaDataBriefViewFilter getFilter(BOSObjectType type) {
        return SubSystemUtils.getFilter(new BOSObjectType[]{type});
    }

    private static MetaDataBriefViewFilter getFilter(BOSObjectType[] types) {
        MetaDataBriefViewFilter filter = new MetaDataBriefViewFilter();
        filter.setViewName(BASE_MDB_VIEW_NAME);
        if (types != null) {
            for (int i = 0; i < types.length; ++i) {
                filter.addMetaDataTypeFilter(types[i]);
            }
        }
        return filter;
    }

    private static IBriefViewTreeNode getIBriefViewTreeNode(MetaDataBriefViewFilter filter) {
        return SubSystemUtils.getIBriefViewTreeNode(null, filter);
    }

    private static IBriefViewTreeNode getIBriefViewTreeNode(Context ctx, MetaDataBriefViewFilter filter) {
        return SubSystemUtils.getBusinessObjectBriefView(ctx, filter.getViewName()).getViewRootByType(filter.getMetaDataTypeFilters());
    }

    public static IBriefViewTreeNode getBaseSubSystem(BOSObjectType[] types) {
        return SubSystemUtils.getIBriefViewTreeNode(SubSystemUtils.getFilter(types));
    }

    public static IBriefViewTreeNode getBaseSubSystem(BOSObjectType type) {
        return SubSystemUtils.getIBriefViewTreeNode(SubSystemUtils.getFilter(type));
    }

    public static IBriefViewTreeNode getSubSystem() {
        return SubSystemUtils.getIBriefViewTreeNode(SubSystemUtils.getSubSystemFilter());
    }

    public static IBriefViewTreeNode getEntityTree() {
        return SubSystemUtils.getIBriefViewTreeNode(SubSystemUtils.getEntityFilter());
    }

    public static IBriefViewTreeNode getFacadeTree() {
        return SubSystemUtils.getIBriefViewTreeNode(SubSystemUtils.getFacadeFilter());
    }

    public static IBriefViewTreeNode getUITree() {
        return SubSystemUtils.getIBriefViewTreeNode(SubSystemUtils.getUIFilter());
    }

    public static IBriefViewTreeNode getSubSystemByName(String mdbViewName, BOSObjectType[] types) {
        return SubSystemUtils.getSubSystemByName(null, mdbViewName, types);
    }

    public static IBriefViewTreeNode getSubSystemByName(Context ctx, String mdbViewName, BOSObjectType[] types) {
        return SubSystemUtils.getIBriefViewTreeNode(ctx, SubSystemUtils.getFilterByName(mdbViewName, types));
    }

    public static IBriefViewTreeNode getSubSystemByName(String mdbViewName, BOSObjectType type) {
        return SubSystemUtils.getIBriefViewTreeNode(SubSystemUtils.getFilterByName(mdbViewName, type));
    }

    public static IBriefViewTreeNode getSubSystemByName(String mdbViewName) {
        return SubSystemUtils.getIBriefViewTreeNode(SubSystemUtils.getFilterByName(mdbViewName));
    }

    public static IBriefViewTreeNode getStandardSubSystemByName(String mdbViewName) {
        return SubSystemUtils.getStandardBusinessObjectBriefView(null, mdbViewName).getViewRootByType(SubSystemUtils.getFilterByName(mdbViewName).getMetaDataTypeFilters());
    }

    public static EntityObjectInfo getEntityObjectInfo(MetaDataBriefInfo info) {
        if (!info.getMetaDataType().equals((Object)MetaDataTypeList.ENTITY)) {
            return null;
        }
        IMetaDataPK pk = info.getMetaDataPK();
        return SubSystemUtils.getMetaDataLoader().getEntity(pk);
    }

    public static PropertyCollection getProperties(MetaDataBriefInfo info) {
        if (!info.getMetaDataType().equals((Object)MetaDataTypeList.ENTITY)) {
            return null;
        }
        IMetaDataPK pk = info.getMetaDataPK();
        return SubSystemUtils.getMetaDataLoader().getEntity(pk).getProperties();
    }

    public static String getExtendPropertyValue(MetaDataBriefInfo info, String propertyKey) {
        if (!info.getMetaDataType().equals((Object)MetaDataTypeList.ENTITY)) {
            return null;
        }
        IMetaDataPK pk = info.getMetaDataPK();
        return SubSystemUtils.getMetaDataLoader().getEntity(pk).getExtendedProperty(propertyKey);
    }

    public static SubSystemPromptBox createSubSystemF7(IUIObject owner, boolean isMultiSelect, BOSObjectType[] types, String mdbViewName) {
        return new SubSystemPromptBox(owner, isMultiSelect, types, mdbViewName, false);
    }

    public static SubSystemPromptBox createSubSystemF7(IUIObject owner, boolean isMultiSelect, BOSObjectType[] types, String mdbViewName, boolean isRemoveEmptyPackage) {
        return new SubSystemPromptBox(owner, isMultiSelect, types, mdbViewName, isRemoveEmptyPackage);
    }

    public static SubSystemPromptBox createSubSystemF7(IUIObject owner, boolean isMultiSelect, BOSObjectType[] types, String mdbViewName, boolean isRemoveEmptyPackage, boolean isMustSelectLeaf) {
        return new SubSystemPromptBox(owner, isMultiSelect, types, mdbViewName, isRemoveEmptyPackage, isMustSelectLeaf);
    }

    public static SubSystemPromptBox createSubSystemF7(IUIObject owner, BOSObjectType[] types, String mdbViewName) {
        return SubSystemUtils.createSubSystemF7(owner, false, types, mdbViewName);
    }

    public static SubSystemPromptBox createSubSystemF7(IUIObject owner, String mdbViewName, boolean isRemoveEmptyPackage) {
        return SubSystemUtils.createSubSystemF7(owner, false, null, mdbViewName, isRemoveEmptyPackage);
    }

    public static SubSystemPromptBox createSubSystemF7(IUIObject owner, String mdbViewName, boolean isRemoveEmptyPackage, boolean isMustSelectLeaf) {
        return SubSystemUtils.createSubSystemF7(owner, false, null, mdbViewName, isRemoveEmptyPackage, isMustSelectLeaf);
    }

    public static SubSystemPromptBox createSubSystemF7(IUIObject owner, String mdbViewName) {
        return SubSystemUtils.createSubSystemF7(owner, false, null, mdbViewName);
    }

    public static SubSystemPromptBox createEntityTreeF7(IUIObject owner, boolean isMultiSelect) {
        return SubSystemUtils.createSubSystemF7(owner, isMultiSelect, new BOSObjectType[]{MetaDataTypeList.ENTITY}, null);
    }

    public static SubSystemPromptBox createFacadeTreeF7(IUIObject owner, boolean isMultiSelect) {
        return SubSystemUtils.createSubSystemF7(owner, isMultiSelect, new BOSObjectType[]{MetaDataTypeList.FACADE}, null);
    }

    public static SubSystemPromptBox createUITreeF7(IUIObject owner, boolean isMultiSelect) {
        return SubSystemUtils.createSubSystemF7(owner, isMultiSelect, new BOSObjectType[]{MetaDataTypeList.UIOBJECT}, null);
    }

    private static DefaultKingdeeTreeNode getNode(IBriefViewTreeNode node) {
        DefaultKingdeeTreeNode newNode = new DefaultKingdeeTreeNode();
        newNode.setText(node.getAlias());
        newNode.setUserObject((Object)node.getMetaDataObjectBriefInfo());
        return newNode;
    }

    public static DefaultKingdeeTreeNode getKDTreeNode_new(IBriefViewTreeNode root) {
        if (root.getChildCount() == 0) {
            return SubSystemUtils.getNode(root);
        }
        DefaultKingdeeTreeNode newRoot = SubSystemUtils.getNode(root);
        IBriefViewTreeNode node = null;
        for (int i = 0; i < root.getChildCount(); ++i) {
            node = (IBriefViewTreeNode)root.getChildAt(i);
            newRoot.add((MutableTreeNode)SubSystemUtils.getKDTreeNode(node));
        }
        return newRoot;
    }

    public static DefaultKingdeeTreeNode getKDTreeNode(IBriefViewTreeNode root) {
        return SubSystemUtils.doAfterTreeCreated(SubSystemUtils.getKDTreeNodeAfterHandle(root));
    }

    private static DefaultKingdeeTreeNode doAfterTreeCreated(DefaultKingdeeTreeNode root) {
        String calName = "com.kingdee.eas.scm.cal";
        String fiName = "com.kingdee.eas.fi";
        String faName = "com.kingdee.eas.fi.fa";
        String lcmName = "com.kingdee.eas.fi.lcm";
        String fxName = "com.kingdee.eas.am";
        DefaultKingdeeTreeNode calNode = null;
        DefaultKingdeeTreeNode fiNode = null;
        DefaultKingdeeTreeNode faNode = null;
        DefaultKingdeeTreeNode lcmNode = null;
        DefaultKingdeeTreeNode fxNode = null;
        boolean hasFiNode = false;
        boolean hasCalNode = false;
        boolean hasFxNode = false;
        boolean hasFaNode = false;
        boolean hasLcmNode = false;
        DefaultKingdeeTreeNode aNode = null;
        MetaDataBriefInfo mdbi = null;
        String pkgName = "";
        Enumeration enu = root.breadthFirstEnumeration();
        while (enu.hasMoreElements()) {
            aNode = (DefaultKingdeeTreeNode)enu.nextElement();
            mdbi = (MetaDataBriefInfo)aNode.getUserObject();
            if (!mdbi.isPackage()) continue;
            pkgName = mdbi.getPackgeName().trim();
            if (pkgName.equals("com.kingdee.eas.fi")) {
                fiNode = aNode;
                hasFiNode = true;
                if (!hasFiNode || !hasCalNode || !hasFaNode || !hasLcmNode || !hasFxNode) continue;
                break;
            }
            if (pkgName.equals("com.kingdee.eas.scm.cal")) {
                calNode = aNode;
                hasCalNode = true;
                if (!hasFiNode || !hasCalNode || !hasFaNode || !hasLcmNode || !hasFxNode) continue;
                break;
            }
            if (pkgName.equals("com.kingdee.eas.fi.fa")) {
                faNode = aNode;
                hasFaNode = true;
                if (!hasFiNode || !hasCalNode || !hasFaNode || !hasLcmNode || !hasFxNode) continue;
                break;
            }
            if (pkgName.equals("com.kingdee.eas.fi.lcm")) {
                lcmNode = aNode;
                hasLcmNode = true;
                if (!hasFiNode || !hasCalNode || !hasFaNode || !hasLcmNode || !hasFxNode) continue;
                break;
            }
            if (!pkgName.equals("com.kingdee.eas.am")) continue;
            fxNode = aNode;
            hasFxNode = true;
            if (!hasFiNode || !hasCalNode || !hasFaNode || !hasLcmNode || !hasFxNode) continue;
        }
        if (hasFiNode && hasCalNode) {
            if (calNode != null) {
                calNode.removeFromParent();
            }
            if (fiNode != null) {
                fiNode.add(calNode);
            }
        }
        if (hasFxNode && hasFaNode) {
            if ("com.kingdee.eas.fi.fa" != null) {
                faNode.removeFromParent();
            }
            if (fxNode != null) {
                fxNode.add(faNode);
            }
        }
        if (hasFxNode && hasLcmNode) {
            if (lcmNode != null) {
                lcmNode.removeFromParent();
            }
            if (fxNode != null) {
                fxNode.add(lcmNode);
            }
        }
        return root;
    }

    public static DefaultKingdeeTreeNode getKDTreeNodeAfterHandle(IBriefViewTreeNode root) {
        if (root.getChildCount() == 0) {
            return SubSystemUtils.getNode(root);
        }
        DefaultKingdeeTreeNode newRoot = SubSystemUtils.getNode(root);
        IBriefViewTreeNode node = null;
        for (int i = 0; i < root.getChildCount(); ++i) {
            node = (IBriefViewTreeNode)root.getChildAt(i);
            newRoot.add((MutableTreeNode)SubSystemUtils.getKDTreeNodeAfterHandle(node));
        }
        return newRoot;
    }

    public static String getSubSystemName(String fullName) {
        return SubSystemUtils.getSubSystemName(fullName, null);
    }

    public static String getSubSystemName(String fullName, String mdbViewName) {
        MetaDataBriefInfo info;
        if (mdbViewName == null) {
            mdbViewName = BASE_MDB_VIEW_NAME;
        }
        if ((info = SubSystemUtils.getMetaDataBriefInfoByFullName(SubSystemUtils.getParentFullName(fullName), mdbViewName)) == null) {
            return null;
        }
        if (info.getAlias() != null && info.getAlias().trim().length() > 0) {
            return info.getAlias();
        }
        return info.getName();
    }

    public static String getAncestorSubSystemName(String fullName, String mdbViewName) {
        String fullpath;
        MetaDataBriefInfo info;
        if (mdbViewName == null) {
            mdbViewName = BASE_MDB_VIEW_NAME;
        }
        if ((info = SubSystemUtils.getMetaDataBriefInfoByFullName(fullpath = SubSystemUtils.getParentFullName(fullName), mdbViewName)) == null) {
            if ("com.kingdee.eas".equals(fullpath) || fullpath.indexOf(".") == -1) {
                return null;
            }
            return SubSystemUtils.getAncestorSubSystemName(fullpath, mdbViewName);
        }
        if (info.getAlias() != null && info.getAlias().trim().length() > 0) {
            return info.getAlias();
        }
        return info.getName();
    }

    private static String getParentFullName(String name) {
        String sourceName = name;
        if (name.indexOf(".app.") >= 0) {
            name = name.substring(0, name.indexOf(".app."));
        } else if (name.indexOf(".client.") >= 0) {
            name = name.substring(0, name.indexOf(".client."));
        } else if (name.indexOf(".") != -1) {
            name = name.substring(0, name.lastIndexOf("."));
        }
        return name;
    }

    private static boolean isAvaliablePackage(MetaDataBriefInfo info) {
        if (!info.getMetaDataType().equals((Object)MetaDataTypeList.PACKAGE)) {
            return false;
        }
        if (info.getPackgeName() == null) {
            return false;
        }
        String[] strs = info.getPackgeName().split("\\.");
        if (strs.length >= 5) {
            return info.getPackgeName().indexOf(".app") < 0 && info.getPackgeName().indexOf(".client") < 0;
        }
        return false;
    }

    private static BusinessObjectBriefView getCustomerBusinessObjectBriefView(Context ctx, String mdbViewName) {
        BusinessObjectBriefView retView = null;
        try {
            if (UserCustomSubSystem.startUserCustom(ctx, mdbViewName)) {
                retView = UserCustomSubSystem.getSubSystemByName(ctx, mdbViewName);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)((Object)e));
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return retView;
    }

    private static BusinessObjectBriefView getStandardBusinessObjectBriefView(Context ctx, String mdbViewName) {
        Project depend = null;
        if (SysContext.getSysContext().getProperty("DTKF_DEPEND") != null) {
            depend = (Project)SysContext.getSysContext().getProperty("DTKF_DEPEND");
        }
        BusinessObjectBriefView retView = null;
        retView = depend == null ? SubSystemUtils.getMetaDataLoader(ctx).getBusinessObjectBriefView((IMetaDataPK)MetaDataPK.create(null, (String)mdbViewName)) : SubSystemUtils.getMetaDataLoader(ctx).getBusinessObjectBriefView((IMetaDataPK)MetaDataPK.create(null, (String)mdbViewName), Project.Projects.getProjects((Project[])new Project[]{depend}));
        return retView;
    }

    private static BusinessObjectBriefView getBusinessObjectBriefView(Context ctx, String mdbViewName) {
        BusinessObjectBriefView retView = SubSystemUtils.getCustomerBusinessObjectBriefView(ctx, mdbViewName);
        if (retView == null) {
            retView = SubSystemUtils.getStandardBusinessObjectBriefView(ctx, mdbViewName);
        }
        return retView;
    }

    public static MetaDataBriefCollection getSubSystemCollection(String mdbViewName) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)SubSystemUtils.getBusinessObjectBriefView(null, mdbViewName).getViewRoot();
        Enumeration<TreeNode> enum1 = root.breadthFirstEnumeration();
        MetaDataBriefInfo info = null;
        MetaDataBriefCollection c = new MetaDataBriefCollection();
        while (enum1.hasMoreElements()) {
            info = ((IBriefViewTreeNode)enum1.nextElement()).getMetaDataObjectBriefInfo();
            if (!SubSystemUtils.isAvaliablePackage(info)) continue;
            c.add(info);
        }
        return c;
    }

    public static MetaDataBriefInfo getMetaDataBriefInfoByFullName(String fullName) {
        return SubSystemUtils.getMetaDataBriefInfoByFullName(fullName, null);
    }

    public static MetaDataBriefInfo getMetaDataBriefInfoByFullName(String fullName, String mdbViewName) {
        if (mdbViewName == null) {
            mdbViewName = BASE_MDB_VIEW_NAME;
        }
        Context ctx = new Context();
        ctx.put((Object)"METADATAPATH", (Object)SubSystemUtils.getMetaDataPath());
        BusinessObjectBriefView view = SubSystemUtils.getMetaDataLoader().getBusinessObjectBriefView((IMetaDataPK)MetaDataPK.create(null, (String)mdbViewName));
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)view.getViewRoot();
        Enumeration<TreeNode> enum1 = root.breadthFirstEnumeration();
        MetaDataBriefInfo info = null;
        while (enum1.hasMoreElements()) {
            info = ((IBriefViewTreeNode)enum1.nextElement()).getMetaDataObjectBriefInfo();
            if (info == null) continue;
            if (info.getMetaDataType().equals((Object)MetaDataTypeList.PACKAGE) && info.getPackgeName() != null && info.getPackgeName().equals(fullName)) {
                return info;
            }
            if (!info.getFullName().equals(fullName)) continue;
            return info;
        }
        return null;
    }

    public static IBriefViewTreeNode getRemoveEmptyPackageNode(IBriefViewTreeNode root) {
        SubSystemUtils.removeEmptyPackageNode(root);
        return root;
    }

    private static void removeEmptyPackageNode(IBriefViewTreeNode root) {
        IBriefViewTreeNode node = null;
        if (root.getChildCount() > 0) {
            for (int i = root.getChildCount() - 1; i >= 0; --i) {
                node = (IBriefViewTreeNode)root.getChildAt(i);
                SubSystemUtils.removeEmptyPackageNode(node);
                if (node.getChildCount() != 0 || !node.getMetaDataType().equals((Object)MetaDataTypeList.PACKAGE)) continue;
                root.remove((MutableTreeNode)node);
            }
        }
    }

    public static MetaDataBriefCollection getSubSystemCollection() {
        return SubSystemUtils.getSubSystemCollection(BASE_MDB_VIEW_NAME);
    }
}

