/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.common.calc;

import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCurrencyEditor;
import com.kingdee.eas.common.calc.CalculatorDialog;
import com.kingdee.eas.common.calc.ICalculatorActionListener;
import java.awt.Container;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;

public class CalculatorF7Binder {
    private CalculatorDialog cd;
    private Map listenerMap = new HashMap();
    private F7KeyListener lastFiredEditorF7KeyListener = null;

    public CalculatorF7Binder(Container parent) {
        this(parent, false);
    }

    public CalculatorF7Binder(Container parent, boolean modal) {
        this.cd = new CalculatorDialog(parent, modal);
        this.cd.addCalculatorActionListener(new ICalculatorActionListener(){

            @Override
            public void ok() {
                if (CalculatorF7Binder.this.lastFiredEditorF7KeyListener != null) {
                    CalculatorF7Binder.this.lastFiredEditorF7KeyListener.setEditorValue();
                }
            }

            @Override
            public void cancel() {
            }
        });
    }

    public synchronized void bindF7Key(JComponent inputableComponent) {
        this.bindF7Key(inputableComponent, 2, false);
    }

    public synchronized void bindF7Key(JComponent inputableComponent, int decimalDigits, boolean enableChange) {
        F7KeyListener listener;
        this.checkBindParams(inputableComponent, decimalDigits);
        this.lastFiredEditorF7KeyListener = listener = new F7KeyListener(inputableComponent, decimalDigits, enableChange);
        this.listenerMap.put(inputableComponent, listener);
        if (inputableComponent instanceof JComboBox) {
            ((JComboBox)inputableComponent).getEditor().getEditorComponent().addKeyListener(listener);
        } else {
            inputableComponent.addKeyListener(listener);
        }
    }

    public synchronized void bindF7Key(ICellEditor editor) {
        this.bindF7Key(editor, 2, false);
    }

    public synchronized void bindF7Key(ICellEditor editor, int decimalDigits, boolean enableChange) {
        this.checkBindParams(editor, decimalDigits);
        if (editor.getComponent() == null) {
            throw new RuntimeException("Editor's component can not be null(" + editor.getClass().getName() + ")!");
        }
        F7KeyListener listener = new F7KeyListener(editor.getComponent(), decimalDigits, enableChange);
        editor.getComponent().addKeyListener(listener);
        this.listenerMap.put(editor, listener);
    }

    public synchronized void unbindF7Key(Object inputableComponent) {
        F7KeyListener listener = (F7KeyListener)this.listenerMap.get(inputableComponent);
        if (listener != null) {
            if (inputableComponent instanceof JComboBox) {
                ((JComboBox)inputableComponent).getEditor().getEditorComponent().removeKeyListener(listener);
            } else if (inputableComponent instanceof JComponent) {
                ((JComponent)inputableComponent).removeKeyListener(listener);
            } else if (inputableComponent instanceof ICellEditor) {
                ((ICellEditor)inputableComponent).getComponent().removeKeyListener(listener);
            }
            this.listenerMap.remove(inputableComponent);
            if (listener == this.lastFiredEditorF7KeyListener) {
                this.lastFiredEditorF7KeyListener = null;
                this.cd.cancel();
            }
        }
    }

    private void checkBindParams(Object editor, int scale) {
        if (editor == null) {
            throw new RuntimeException("Editor can not be null");
        }
        if (this.listenerMap.containsKey(editor)) {
            throw new RuntimeException(editor + " already be binded");
        }
        if (scale < 0 || scale > 15) {
            throw new ArithmeticException("Precision out of range [0,15]");
        }
    }

    class F7KeyListener
    implements KeyListener {
        private Object inputableComponent;
        private int decimalDigits;
        private boolean enableChange;

        F7KeyListener(Object inputableComponent, int decimalDigits, boolean enableChange) {
            this.inputableComponent = inputableComponent;
            this.decimalDigits = decimalDigits;
            this.enableChange = enableChange;
        }

        public void setEditorValue() {
            BigDecimal value = CalculatorF7Binder.this.cd.getReturnValue();
            if (value != null) {
                if (this.inputableComponent instanceof JTextComponent) {
                    ((JTextComponent)this.inputableComponent).setText(value.toString());
                } else if (this.inputableComponent instanceof JComboBox) {
                    JComboBox jcb = (JComboBox)this.inputableComponent;
                    jcb.getEditor().setItem(value);
                } else if (this.inputableComponent instanceof ICellEditor) {
                    ((ICellEditor)this.inputableComponent).setValue((Object)value.toString());
                } else if (this.inputableComponent instanceof IKDEditor) {
                    ((IKDEditor)this.inputableComponent).setValue((Object)value);
                } else {
                    throw new RuntimeException("[F7Component] " + this.inputableComponent.getClass().getName() + " not supported!");
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (!(e.isControlDown() || e.isAltDown() || e.isShiftDown() || e.getKeyCode() != 118)) {
                CalculatorF7Binder.this.lastFiredEditorF7KeyListener = this;
                CalculatorF7Binder.this.cd.reset();
                try {
                    BigDecimal value = null;
                    if (this.inputableComponent instanceof JTextComponent) {
                        value = new BigDecimal(((JTextComponent)this.inputableComponent).getText());
                    } else if (this.inputableComponent instanceof JComboBox) {
                        JComboBox jcb = (JComboBox)this.inputableComponent;
                        value = new BigDecimal(String.valueOf(jcb.getSelectedItem()));
                    } else if (this.inputableComponent instanceof ICellEditor) {
                        value = new BigDecimal(String.valueOf(((ICellEditor)this.inputableComponent).getValue()));
                    } else if (this.inputableComponent instanceof IKDEditor) {
                        value = new BigDecimal(String.valueOf(((KDCurrencyEditor)this.inputableComponent).getValue()));
                    }
                    if (value != null) {
                        CalculatorF7Binder.this.cd.setInitValue(value);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                CalculatorF7Binder.this.cd.inputAsNew();
                CalculatorF7Binder.this.cd.showUnModalDialog(this.decimalDigits, this.enableChange);
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }
}

