/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.common.client;

import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.QualityOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.org.TransportOrgUnitInfo;
import com.kingdee.util.LocaleUtils;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class SysContext {
    private static SysContext instance;
    private String userName;
    private final String slnName;
    private final String dcName;
    private final Locale locale;
    private final Locale originLocale;
    private Map extProperties = new HashMap();

    public static SysContext getSysContext() {
        if (instance == null) {
            instance = new SysContext("test", "eas", "eas", LocaleUtils.locale_zh_CN);
        }
        return instance;
    }

    public static void setSysContext(SysContext sysContext) {
        instance = sysContext;
    }

    public SysContext(String userName, String slnName, String dcName, Locale locale) {
        this.userName = userName;
        this.slnName = slnName;
        this.dcName = dcName;
        this.locale = LocaleUtils.getShortLocale((Locale)locale);
        this.originLocale = LocaleUtils.getFirstOriginLocale((Locale)locale);
    }

    public String getUserName() {
        return this.userName;
    }

    public String getSlnName() {
        return this.slnName;
    }

    public String getDcName() {
        return this.dcName;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Locale getOriginLocale() {
        return this.originLocale;
    }

    public Object getProperty(Object key) {
        return this.extProperties.get(key);
    }

    public void setProperty(Object key, Object value) {
        this.extProperties.put(key, value);
        if ("UserInfo".equals(key)) {
            assert (value != null);
            assert (value instanceof UserInfo);
            UserInfo user = (UserInfo)value;
            this.userName = user.getNumber();
        }
    }

    public Object getCurrentUser() {
        return this.getCurrentUserInfo();
    }

    public Object getCurrentCompany() {
        return this.getCurrentFIUnit();
    }

    public String getSessionID() {
        return (String)this.getProperty("SessionId");
    }

    public CtrlUnitInfo getCurrentCtrlUnit() {
        return (CtrlUnitInfo)this.getCurrentOrgUnit(OrgType.ControlUnit);
    }

    public void setCurrentCtrlUnit(CtrlUnitInfo cu) {
        this.setCurrentOrgUnit(OrgType.ControlUnit, (OrgUnitInfo)cu);
    }

    public CompanyOrgUnitInfo getCurrentFIUnit() {
        return (CompanyOrgUnitInfo)this.getCurrentOrgUnit(OrgType.Company);
    }

    public void setCurrentFIUnit(CompanyOrgUnitInfo company) {
        this.setCurrentOrgUnit(OrgType.Company, (OrgUnitInfo)company);
    }

    public AdminOrgUnitInfo getCurrentAdminUnit() {
        return (AdminOrgUnitInfo)this.getCurrentOrgUnit(OrgType.Admin);
    }

    public void setCurrentAdminUnit(AdminOrgUnitInfo adminUnit) {
        this.setCurrentOrgUnit(OrgType.Admin, (OrgUnitInfo)adminUnit);
    }

    public ProfitCenterOrgUnitInfo getCurrentProfitUnit() {
        return (ProfitCenterOrgUnitInfo)this.getCurrentOrgUnit(OrgType.ProfitCenter);
    }

    public void setCurrentProfitUnit(ProfitCenterOrgUnitInfo profitCenter) {
        this.setCurrentOrgUnit(OrgType.ProfitCenter, (OrgUnitInfo)profitCenter);
    }

    public CostCenterOrgUnitInfo getCurrentCostUnit() {
        return (CostCenterOrgUnitInfo)this.getCurrentOrgUnit(OrgType.CostCenter);
    }

    public void setCurrentCostUnit(CostCenterOrgUnitInfo costCenter) {
        this.setCurrentOrgUnit(OrgType.CostCenter, (OrgUnitInfo)costCenter);
    }

    public SaleOrgUnitInfo getCurrentSaleUnit() {
        return (SaleOrgUnitInfo)this.getCurrentOrgUnit(OrgType.Sale);
    }

    public void setCurrentSaleUnit(SaleOrgUnitInfo saleUnit) {
        this.setCurrentOrgUnit(OrgType.Sale, (OrgUnitInfo)saleUnit);
    }

    public StorageOrgUnitInfo getCurrentStorageUnit() {
        return (StorageOrgUnitInfo)this.getCurrentOrgUnit(OrgType.Storage);
    }

    public void setCurrentStorageUnit(StorageOrgUnitInfo storageUnit) {
        this.setCurrentOrgUnit(OrgType.Storage, (OrgUnitInfo)storageUnit);
    }

    public PurchaseOrgUnitInfo getCurrentPurchaseUnit() {
        return (PurchaseOrgUnitInfo)this.getCurrentOrgUnit(OrgType.Purchase);
    }

    public void setCurrentPurchaseUnit(PurchaseOrgUnitInfo purchaseUnit) {
        this.setCurrentOrgUnit(OrgType.Purchase, (OrgUnitInfo)purchaseUnit);
    }

    public OrgUnitInfo getCurrentOrgUnit(OrgType orgType) {
        return (OrgUnitInfo)this.getProperty(orgType);
    }

    public void setCurrentOrgUnit(OrgType orgType, OrgUnitInfo orgUnit) {
        this.setProperty(orgType, orgUnit);
    }

    public OrgUnitInfo getCurrentOrgUnit() {
        return (OrgUnitInfo)this.getProperty("CurOU");
    }

    public void setCurrentOrgUnit(OrgUnitInfo orgUnit) {
        this.setProperty("CurOU", orgUnit);
    }

    public UserInfo getCurrentUserInfo() {
        return (UserInfo)this.getProperty("UserInfo");
    }

    public void setCurrentUserInfo(UserInfo user) {
        this.setProperty("UserInfo", user);
    }

    public String getClientIP() {
        return (String)this.getProperty("ClientIP");
    }

    public void setClientIP(String ip) {
        this.setProperty("ClientIP", ip);
    }

    public String getClientName() {
        return (String)this.getProperty("ClientName");
    }

    public void setClientName(String clientName) {
        this.setProperty("ClientName", clientName);
    }

    public void setSessionID(String sessionId) {
        this.setProperty("SessionId", sessionId);
    }

    public String getDcAlias() {
        return (String)this.getProperty("DcAlias");
    }

    public void setDcAlias(String dcAlias) {
        this.setProperty("DcAlias", dcAlias);
    }

    public HROrgUnitInfo getCurrentHRUnit() {
        return (HROrgUnitInfo)this.getCurrentOrgUnit(OrgType.HRO);
    }

    public void setCurrentHRUnit(HROrgUnitInfo hroInfo) {
        this.setCurrentOrgUnit(OrgType.HRO, (OrgUnitInfo)hroInfo);
    }

    public TransportOrgUnitInfo getCurrentTransportUnit() {
        return (TransportOrgUnitInfo)this.getCurrentOrgUnit(OrgType.Transport);
    }

    public void setCurrentTransportUnit(TransportOrgUnitInfo transportInfo) {
        this.setCurrentOrgUnit(OrgType.Transport, (OrgUnitInfo)transportInfo);
    }

    public boolean isRefreshOrgUnit() {
        return this.isKnownCachesToBeRefreshed("refreshOrgUnit");
    }

    public boolean isRefreshFuncMenu() {
        return this.isKnownCachesToBeRefreshed("refreshFuncMenu");
    }

    public boolean isRefreshPersonalizedSetting() {
        return this.isKnownCachesToBeRefreshed("refreshPersonalizedSetting");
    }

    private boolean isKnownCachesToBeRefreshed(String key) {
        boolean refresh = false;
        if (this.getProperty(key) != null) {
            refresh = Boolean.getBoolean((String)this.getProperty(key));
        }
        return refresh;
    }

    public void setDCNumber(String number) {
        this.setProperty("DataCenterNumber", number);
    }

    public String getDCNumber() {
        return (String)this.getProperty("DataCenterNumber");
    }

    public void setCurrentQualityUnit(QualityOrgUnitInfo qualityUnit) {
        this.setProperty(OrgType.Quality, qualityUnit);
    }

    public QualityOrgUnitInfo getCurrentQualityUnit() {
        return (QualityOrgUnitInfo)this.getProperty(OrgType.Quality);
    }
}

