/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.common.subsystemhelper;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.xml.impl.MDLoader;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.view.BriefViewTreeNode;
import com.kingdee.bos.metadata.view.BusinessObjectBriefView;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.metadata.view.MetaDataBriefCollection;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.metadata.view.MetaDataBriefViewInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;

public class BusinessObjectBriefViewHelper {
    private IBriefViewTreeNode getRoot(MetaDataBriefViewInfo view) {
        HashMap<String, BriefViewTreeNode> tree = new HashMap<String, BriefViewTreeNode>();
        MetaDataBriefInfo info = new MetaDataBriefInfo();
        MetaDataBriefCollection metas = view.getMetaDataBriefs();
        BriefViewTreeNode node = null;
        BriefViewTreeNode root = null;
        IBriefViewTreeNode parent = null;
        int size = metas.size();
        for (int i = 0; i < size; ++i) {
            info = metas.get(i);
            node = new BriefViewTreeNode(info);
            if (StringUtils.isEmpty((String)info.getParent())) {
                root = node;
            }
            if (info.getMetaDataType().equals((Object)MetaDataTypeList.PACKAGE)) {
                tree.put(info.getFullName(), node);
            }
            if ((parent = (IBriefViewTreeNode)tree.get(info.getParent())) == null) continue;
            ((DefaultMutableTreeNode)parent).add((MutableTreeNode)node);
        }
        return root;
    }

    private Map createMetaDataResource() {
        HashMap<BOSObjectType, MetaDataBriefInfo> resource = new HashMap<BOSObjectType, MetaDataBriefInfo>();
        resource.put(MetaDataTypeList.ENTITY, this.createMetaDataResource(MetaDataTypeList.ENTITY));
        resource.put(MetaDataTypeList.FACADE, this.createMetaDataResource(MetaDataTypeList.FACADE));
        resource.put(MetaDataTypeList.FUNCTION, this.createMetaDataResource(MetaDataTypeList.FUNCTION));
        resource.put(MetaDataTypeList.UIOBJECT, this.createMetaDataResource(MetaDataTypeList.UIOBJECT));
        resource.put(MetaDataTypeList.PACKAGE, this.createMetaDataResource(MetaDataTypeList.PACKAGE));
        return resource;
    }

    private MetaDataBriefInfo createMetaDataResource(BOSObjectType bosType) {
        try {
            MetaDataBriefInfo meta = new MetaDataBriefInfo();
            meta.setMetaDataType(MetaDataTypeList.PACKAGE);
            SolutionInfo slnInfo = BusinessObjectBriefViewHelper.getSolutionInfo(null);
            EntityObjectInfo entity = (EntityObjectInfo)MDLoader.getInstance().loadMDMeta(bosType);
            Locale[] locales = slnInfo.getSupportedLocales();
            meta.setName(entity.getName());
            int len = locales.length;
            for (int i = 0; i < len; ++i) {
                meta.setAlias(entity.getAlias(locales[i]), locales[i]);
                meta.setDescription(entity.getDescription(locales[i]), locales[i]);
            }
            return meta;
        }
        catch (Exception e) {
            e.printStackTrace();
            assert (false);
            return null;
        }
    }

    private IMetaDataLoader getLoad() {
        return MetaDataLoaderFactory.getRemoteMetaDataLoader();
    }

    public BusinessObjectBriefView getBusinessObjectBriefView(MetaDataBriefViewInfo info) {
        return new BusinessObjectBriefView(this.getRoot(info), this.createMetaDataResource());
    }

    public static SolutionInfo getSolutionInfo(Context ctx) {
        SolutionInfo sln = new SolutionInfo();
        sln.setName("solution");
        LanguageInfo langEn = new LanguageInfo();
        langEn.setName("US");
        langEn.setLocaleString(Locale.US.toString());
        langEn.setPostfix("L1");
        sln.getLanguages().add(langEn);
        LanguageInfo lang = new LanguageInfo();
        lang.setName("chinese");
        lang.setLocaleString(Locale.SIMPLIFIED_CHINESE.toString());
        lang.setPostfix("L2");
        sln.getLanguages().add(lang);
        LanguageInfo langTw = new LanguageInfo();
        langTw.setName("tw");
        langTw.setLocaleString(Locale.TAIWAN.toString());
        langTw.setPostfix("L3");
        sln.getLanguages().add(langTw);
        if (ctx != null && ctx.getLocale() != null) {
            if ("L1".equalsIgnoreCase(StringUtils.cnulls((Object)ctx.getLocale()))) {
                sln.setDefaultLanguage(langEn);
            } else if ("L2".equalsIgnoreCase(StringUtils.cnulls((Object)ctx.getLocale()))) {
                sln.setDefaultLanguage(lang);
            }
            if ("L3".equalsIgnoreCase(StringUtils.cnulls((Object)ctx.getLocale()))) {
                sln.setDefaultLanguage(langTw);
            }
        }
        return sln;
    }
}

