/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ep.LockCollection;
import com.kingdee.eas.ep.LockInfo;
import com.kingdee.eas.ep.LockState;
import com.kingdee.eas.ep.app.AbstractLockControllerBean;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class LockControllerBean
extends AbstractLockControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ep.app.LockControllerBean");

    @Override
    protected LockState _lock(Context ctx, String pk, String password, String user) throws BOSException, EASBizException {
        PKInfo pkInfo = PKInfo.parse(pk);
        LockState lckState = this.isHigherLocked(ctx, pkInfo, password, false);
        if (lckState.isLocked()) {
            lckState.setSuccess(false);
            return lckState;
        }
        lckState = this.isLowerLocked(ctx, pkInfo, password, false);
        if (lckState.isLocked()) {
            lckState.setSuccess(false);
            return lckState;
        }
        lckState = this.isHigherLocked(ctx, pkInfo, password, true);
        if (lckState.isLocked()) {
            lckState.setSuccess(true);
            return lckState;
        }
        lckState = this.isLowerLocked(ctx, pkInfo, password, true);
        if (lckState.isLocked()) {
            this.deleteLowerLocks(ctx, pkInfo);
        }
        LockInfo lock = new LockInfo();
        lock.setMetaPK(pkInfo.metaPK);
        lock.setUnitID(pkInfo.unitID);
        lock.setSchemeID(pkInfo.schemeID);
        lock.setPassword(password);
        lock.setUser(user);
        this._addnew(ctx, (IObjectValue)lock);
        lckState.setSuccess(true);
        return lckState;
    }

    @Override
    protected LockState _unlock(Context ctx, String pk, String password) throws BOSException, EASBizException {
        LockState lckState = new LockState();
        PKInfo pkInfo = PKInfo.parse(pk);
        String oql = pkInfo.getSelfOql();
        if (oql != null && this._exists(ctx, oql = oql + " and password = '" + password + "'")) {
            this._delete(ctx, oql);
            lckState.setSuccess(true);
            return lckState;
        }
        lckState.setSuccess(false);
        return lckState;
    }

    @Override
    protected LockState _unlockAll(Context ctx, String pk, String password) throws BOSException, EASBizException {
        LockState lckState = new LockState();
        PKInfo pkInfo = PKInfo.parse(pk);
        String oql = pkInfo.getSubOql();
        if (oql != null) {
            this._delete(ctx, oql);
            lckState.setSuccess(true);
            return lckState;
        }
        lckState.setSuccess(false);
        return lckState;
    }

    @Override
    protected List _getLocks(Context ctx) throws BOSException, EASBizException {
        LockCollection lc = this.getLockCollection(ctx);
        ArrayList<String> lst = new ArrayList<String>();
        int size = lc.size();
        for (int i = 0; i < size; ++i) {
            lst.add(PKInfo.build(lc.get(i)).toString());
        }
        return lst;
    }

    @Override
    protected LockState _isLocked(Context ctx, String pk, String password) throws BOSException, EASBizException {
        PKInfo pkInfo = PKInfo.parse(pk);
        return this.isHigherLocked(ctx, pkInfo, password, false);
    }

    private LockState isHigherLocked(Context ctx, PKInfo pkInfo, String password, boolean isSelf) throws BOSException, EASBizException {
        LockState lckState = new LockState();
        boolean locked = false;
        String oql = pkInfo.getSchemeSelfOql();
        if (oql != null) {
            String psdOql = " and password <> '" + password + "'";
            if (isSelf) {
                psdOql = " and password = '" + password + "'";
            }
            if (!(locked = this._exists(ctx, oql + psdOql))) {
                oql = pkInfo.getUnitSelfOql();
                if (oql != null) {
                    locked = this._exists(ctx, oql + psdOql);
                    if (!locked) {
                        oql = pkInfo.getMetaSelfOql();
                        if (oql != null && (locked = this._exists(ctx, oql + psdOql))) {
                            LockCollection lck = this.getLockCollection(ctx, oql + psdOql);
                            lckState.setUser(lck.get(0).getUser());
                        }
                    } else {
                        LockCollection lck = this.getLockCollection(ctx, oql + psdOql);
                        lckState.setUser(lck.get(0).getUser());
                    }
                }
            } else {
                LockCollection lck = this.getLockCollection(ctx, oql + psdOql);
                lckState.setUser(lck.get(0).getUser());
            }
        }
        lckState.setLocked(locked);
        return lckState;
    }

    private LockState isLowerLocked(Context ctx, PKInfo pkInfo, String password, boolean isSelf) throws BOSException, EASBizException {
        LockState lckState = new LockState();
        boolean locked = false;
        String oql = pkInfo.getUnitLowOql();
        String psdOql = " and password <> '" + password + "'";
        if (isSelf) {
            psdOql = " and password = '" + password + "'";
        }
        if (oql != null) {
            locked = this._exists(ctx, oql + psdOql);
            if (locked) {
                LockCollection lck = this.getLockCollection(ctx, oql + psdOql);
                lckState.setUser(lck.get(0).getUser());
            }
        } else {
            oql = pkInfo.getSchemeLowOql();
            if (oql != null && (locked = this._exists(ctx, oql + psdOql))) {
                LockCollection lck = this.getLockCollection(ctx, oql + psdOql);
                lckState.setUser(lck.get(0).getUser());
            }
        }
        lckState.setLocked(locked);
        return lckState;
    }

    private void deleteLowerLocks(Context ctx, PKInfo pkInfo) throws BOSException, EASBizException {
        String oql = pkInfo.getUnitLowOql();
        if (oql != null) {
            this._delete(ctx, oql);
        } else {
            oql = pkInfo.getSchemeLowOql();
            if (oql != null) {
                this._delete(ctx, oql);
            }
        }
    }

    static class PKInfo {
        String metaPK;
        String unitID;
        String schemeID;

        PKInfo() {
        }

        static PKInfo build(LockInfo lock) {
            PKInfo pInfo = new PKInfo();
            pInfo.metaPK = lock.getMetaPK();
            pInfo.unitID = lock.getUnitID();
            pInfo.schemeID = lock.getSchemeID();
            return pInfo;
        }

        public String toString() {
            String s = this.schemeID;
            if (s != null && this.unitID != null) {
                s = s + "_" + this.unitID;
            }
            if (s != null && this.metaPK != null) {
                s = s + "_" + this.metaPK;
            }
            return s;
        }

        static PKInfo parse(String pks) {
            PKInfo pInfo = new PKInfo();
            String[] ps = StringUtils.split((String)pks, (String)"_");
            if (ps.length == 1) {
                pInfo.schemeID = ps[0];
            } else if (ps.length == 2) {
                pInfo.schemeID = ps[0];
                pInfo.unitID = ps[1];
            } else if (ps.length == 3) {
                pInfo.schemeID = ps[0];
                pInfo.unitID = ps[1];
                pInfo.metaPK = ps[2];
            }
            return pInfo;
        }

        String getSubOql() {
            if (this.schemeID != null && this.unitID != null && this.metaPK != null) {
                return this.getMetaSelfOql();
            }
            if (this.schemeID != null && this.unitID != null) {
                StringBuffer oql = new StringBuffer("where ");
                oql.append("unitID = '");
                oql.append(this.unitID);
                oql.append("' and schemeID = '");
                oql.append(this.schemeID);
                oql.append("'");
                return oql.toString();
            }
            if (this.schemeID != null) {
                StringBuffer oql = new StringBuffer("where ");
                oql.append("schemeID = '");
                oql.append(this.schemeID);
                oql.append("'");
                return oql.toString();
            }
            return null;
        }

        String getSelfOql() {
            if (this.schemeID != null && this.unitID != null && this.metaPK != null) {
                return this.getMetaSelfOql();
            }
            if (this.schemeID != null && this.unitID != null) {
                return this.getUnitSelfOql();
            }
            if (this.schemeID != null) {
                return this.getSchemeSelfOql();
            }
            return null;
        }

        String getSchemeSelfOql() {
            if (this.schemeID == null) {
                return null;
            }
            StringBuffer oql = new StringBuffer("where ");
            oql.append("metaPK is null and unitID is null and schemeID = '");
            oql.append(this.schemeID);
            oql.append("'");
            return oql.toString();
        }

        String getSchemeLowOql() {
            if (this.schemeID == null || this.unitID != null || this.metaPK != null) {
                return null;
            }
            StringBuffer oql = new StringBuffer("where ");
            oql.append("unitID is not null and schemeID = '");
            oql.append(this.schemeID);
            oql.append("'");
            return oql.toString();
        }

        String getUnitSelfOql() {
            if (this.schemeID == null || this.unitID == null) {
                return null;
            }
            StringBuffer oql = new StringBuffer("where ");
            oql.append("metaPK is null and unitID = '");
            oql.append(this.unitID);
            oql.append("' and schemeID = '");
            oql.append(this.schemeID);
            oql.append("'");
            return oql.toString();
        }

        String getUnitLowOql() {
            if (this.schemeID == null || this.unitID == null || this.metaPK != null) {
                return null;
            }
            StringBuffer oql = new StringBuffer("where ");
            oql.append("metaPK is not null and unitID = '");
            oql.append(this.unitID);
            oql.append("' and schemeID = '");
            oql.append(this.schemeID);
            oql.append("'");
            return oql.toString();
        }

        String getMetaSelfOql() {
            if (this.schemeID == null || this.unitID == null || this.metaPK == null) {
                return null;
            }
            StringBuffer oql = new StringBuffer("where ");
            oql.append("metaPK = '");
            oql.append(this.metaPK);
            oql.append("' and unitID = '");
            oql.append(this.unitID);
            oql.append("' and schemeID = '");
            oql.append(this.schemeID);
            oql.append("'");
            return oql.toString();
        }
    }
}

