/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.webclient.editor.webui.designer;

import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.MissingDAOMetaDataException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.engine.MDSaveException;
import com.kingdee.bos.engine.impl.XMLException;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.ui.ActionCollection;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.DataObjectCollection;
import com.kingdee.bos.metadata.ui.DataObjectInfo;
import com.kingdee.bos.metadata.util.CloneUtils;
import com.kingdee.bos.metadata.webui.WebUIObjectInfo;
import com.kingdee.bos.metadata.webui.transfer.UIType;
import com.kingdee.bos.ui.dtp.model.ComponentNameManager;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ep.EditUIConfigureFactory;
import com.kingdee.eas.ep.EditUIConfigureInfo;
import com.kingdee.eas.ep.IEditUIConfigure;
import com.kingdee.eas.ep.client.CustomizedUnitUI;
import com.kingdee.eas.ep.client.IEditorTabPanel;
import com.kingdee.eas.ep.client.editor.editui.designer.AbstractEditPartViewer;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPartViewer;
import com.kingdee.eas.ep.client.editor.editui.designer.IUIEditor;
import com.kingdee.eas.ep.client.editor.editui.designer.action.DeleteAction;
import com.kingdee.eas.ep.client.editor.editui.designer.action.EditEventAction;
import com.kingdee.eas.ep.client.editor.editui.designer.action.RedoAction;
import com.kingdee.eas.ep.client.editor.editui.designer.action.UndoAction;
import com.kingdee.eas.ep.client.editor.editui.designer.commands.CommandStack;
import com.kingdee.eas.ep.client.editor.editui.designer.listener.SelectionChangedEvent;
import com.kingdee.eas.ep.client.figure.FigureHelper;
import com.kingdee.eas.ep.client.model.ComponentTreeNode;
import com.kingdee.eas.ep.client.util.UictUtils;
import com.kingdee.eas.ep.webclient.editor.webui.designer.AbstractWebEditPartViewer;
import com.kingdee.eas.ep.webclient.editor.webui.designer.WebContext;
import com.kingdee.eas.ep.webclient.editor.webui.designer.WebLayoutWebEditPartViewer;
import com.kingdee.eas.ep.webclient.editor.webui.designer.action.WebAlignAction;
import com.kingdee.eas.ep.webclient.editor.webui.designer.action.WebExtendAction;
import com.kingdee.eas.ep.webclient.editor.webui.designer.action.WebOutlineAction;
import com.kingdee.eas.ep.webclient.editor.webui.designer.action.WebSameSizeAction;
import com.kingdee.eas.ep.webclient.editor.webui.designer.util.ColorConstants;
import com.kingdee.eas.ep.webclient.model.WebTreeNode;
import com.kingdee.eas.ep.webclient.util.WebUIEditorHelper;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;

public class WebUIEditor
extends KDPanel
implements IEditorTabPanel,
IUIEditor {
    private static final Logger logger = CoreUIObject.getLogger(WebUIEditor.class);
    private CustomizedUnitUI ui;
    private String customizedSchemeID;
    private Project depend;
    private BizUnitInfo bizUnit;
    private WebUIObjectInfo baseUIInfo;
    private EntityObjectInfo bindEntity;
    private UIType uiType;
    private boolean isDirty;
    private boolean isBase;
    private int status;
    private EditUIConfigureInfo configure;
    private WebTreeNode node;
    private AbstractWebEditPartViewer epv;
    private AbstractWebEditPartViewer viewer;

    public WebUIEditor(MetaDataPK uipk, boolean isBase, int status, EditUIConfigureInfo configure, Project depend) throws MissingDAOMetaDataException, MDSaveException, XMLException {
        assert (configure != null);
        this.isBase = isBase;
        this.status = status;
        this.configure = configure;
        this.depend = depend;
        this.baseUIInfo = WebUIEditorHelper.loadUIObject(uipk, depend);
        this.baseUIInfo = (WebUIObjectInfo)this.baseUIInfo.clone();
        DataObjectCollection col = this.baseUIInfo.getDataObjects();
        if (col != null) {
            for (int i = 0; i < col.size(); ++i) {
                DataObjectInfo doInfo = col.get(i);
                this.configure.setDataObjectPK(doInfo.getType());
                if (doInfo.getObjectType().equals(MetaDataTypeList.ENTITY.toString())) {
                    MetaDataPK entitypk = new MetaDataPK(doInfo.getType());
                    try {
                        this.bindEntity = CloneUtils.clone((EntityObjectInfo)UictUtils.loadEntity((IMetaDataPK)entitypk, (Project)depend));
                    }
                    catch (CloneNotSupportedException e) {
                        logger.error((Object)e);
                    }
                    if (this.bindEntity == null) continue;
                    this.uiType = UIType.EDITUI;
                    break;
                }
                if (!doInfo.getObjectType().equals(MetaDataTypeList.JOINQUERY.toString())) continue;
                this.uiType = UIType.LISTUI;
                break;
            }
        }
        this.bizUnit = new BizUnitInfo();
        this.bizUnit.setName("tmpBizUnit");
        this.bizUnit.setEntity(this.bindEntity);
        this.bizUnit.setWebEditUI(this.baseUIInfo);
        WebUIEditorHelper.extraBizUnit(this.bizUnit, this.baseUIInfo);
        this.node = WebUIEditorHelper.getBizConfigureTree(this.baseUIInfo, this.bindEntity, isBase);
        if (this.node == null) {
            MsgBox.showInfo((String)"\u8fd0\u884c\u6709\u9519\uff0c\u8bf7\u786e\u8ba4\u80fd\u5426\u5728bos6.1\u53ca\u4ee5\u4e0a\u7248\u672c\u4e2d\u6b63\u5e38\u5c55\u793a\uff01");
            return;
        }
        if (2 != status && !isBase) {
            WebUIEditorHelper.loadConfigure(this.baseUIInfo, this.node, configure);
        }
        this.initViewer();
    }

    protected void initViewer() {
        this.setBounds(new Rectangle(10, 10, 1016, 600));
        this.setLayout(new BorderLayout());
        CommandStack commandStack = new CommandStack();
        WebContext context = new WebContext();
        context.setStatus(this.status);
        context.setCommandStack(commandStack);
        context.setEditorUI(this);
        context.setShowContainer(false);
        context.setBase(this.isBase);
        context.setUiModel(this.baseUIInfo);
        this.initNameManager(this.baseUIInfo);
        Dimension size = new Dimension(1020, 760);
        this.epv = new WebLayoutWebEditPartViewer(this.node, size, context);
        context.setRootViewer(this.epv);
        this.setViewer(this.epv);
        KDToolBar toolbar = new KDToolBar();
        if (this.isBase) {
            KDWorkButton createCtrl = new KDWorkButton("\u63a7\u4ef6");
            createCtrl.setIcon((Icon)FigureHelper.getImageIcon((String)"type/function.gif"));
            createCtrl.setToolTipText("\u521b\u5efa\u63a7\u4ef6");
            final KDPopupMenu popMenu = new KDPopupMenu();
            WebUIEditorHelper.buildCreateCtrlMenu(this.epv, popMenu);
            createCtrl.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WebUIEditor.this.showCreateCtrlMenu(popMenu);
                }
            });
            toolbar.add((Component)createCtrl);
            DeleteAction deleteAction = new DeleteAction((EditPartViewer)this.epv);
            deleteAction.setToolTips("\u5220\u9664\u63a7\u4ef6");
            JButton btnDelete = toolbar.add((Action)deleteAction);
            btnDelete.setText("\u5220\u9664");
            WebExtendAction extendAction = new WebExtendAction((EditPartViewer)this.epv);
            extendAction.setToolTips("\u6269\u5c55\u5b9a\u4e49");
            JButton btnExtend = toolbar.add((Action)((Object)extendAction));
            btnExtend.setText("\u6269\u5c55");
        } else {
            EditEventAction eventAction = new EditEventAction((AbstractEditPartViewer)this.epv, this.bizUnit, (ComponentTreeNode)this.node);
            eventAction.setToolTips("\u4e8b\u4ef6\u7ba1\u7406\u5668");
            JButton btnEvent = toolbar.add((Action)eventAction);
            btnEvent.setText("\u4e8b\u4ef6");
        }
        WebOutlineAction menuAction = new WebOutlineAction((EditPartViewer)this.epv);
        menuAction.setToolTips("\u5927\u7eb2\u7ba1\u7406\u5668");
        JButton btnMenu = toolbar.add((Action)((Object)menuAction));
        btnMenu.setText("\u5927\u7eb2");
        toolbar.add((Component)new KDSeparator());
        WebAlignAction alignLeftAction = new WebAlignAction((EditPartViewer)this.epv, 0, "designer/figures/align/alignleft.gif");
        JButton alignLeft = toolbar.add((Action)((Object)alignLeftAction));
        alignLeft.setText(null);
        alignLeft.setToolTipText("\u5de6\u5bf9\u9f50");
        WebAlignAction alignCenterAction = new WebAlignAction((EditPartViewer)this.epv, 1, "designer/figures/align/aligncenter.gif");
        JButton alignCenter = toolbar.add((Action)((Object)alignCenterAction));
        alignCenter.setText(null);
        alignCenter.setToolTipText("\u6c34\u5e73\u4e2d\u5fc3\u5bf9\u9f50");
        WebAlignAction alignRightAction = new WebAlignAction((EditPartViewer)this.epv, 2, "designer/figures/align/alignright.gif");
        JButton alignRight = toolbar.add((Action)((Object)alignRightAction));
        alignRight.setText(null);
        alignRight.setToolTipText("\u53f3\u5bf9\u9f50");
        toolbar.add((Component)new KDSeparator());
        WebAlignAction alignTopAction = new WebAlignAction((EditPartViewer)this.epv, 3, "designer/figures/align/aligntop.gif");
        JButton alignTop = toolbar.add((Action)((Object)alignTopAction));
        alignTop.setText(null);
        alignTop.setToolTipText("\u4e0a\u5bf9\u9f50");
        WebAlignAction alignMiddleAction = new WebAlignAction((EditPartViewer)this.epv, 4, "designer/figures/align/alignmid.gif");
        JButton alignMiddle = toolbar.add((Action)((Object)alignMiddleAction));
        alignMiddle.setText(null);
        alignMiddle.setToolTipText("\u5782\u76f4\u4e2d\u5fc3\u5bf9\u9f50");
        WebAlignAction alignBottomAction = new WebAlignAction((EditPartViewer)this.epv, 5, "designer/figures/align/alignbottom.gif");
        JButton alignBottom = toolbar.add((Action)((Object)alignBottomAction));
        alignBottom.setText(null);
        alignBottom.setToolTipText("\u5e95\u5bf9\u9f50");
        toolbar.add((Component)new KDSeparator());
        WebSameSizeAction sameWidthAction = new WebSameSizeAction((EditPartViewer)this.epv, 0, "designer/SameWidth.gif");
        JButton sameWidth = toolbar.add((Action)((Object)sameWidthAction));
        sameWidth.setText(null);
        sameWidth.setToolTipText("\u7b49\u5bbd");
        WebSameSizeAction sameHeightAction = new WebSameSizeAction((EditPartViewer)this.epv, 1, "designer/SameHeight.gif");
        JButton sameHeight = toolbar.add((Action)((Object)sameHeightAction));
        sameHeight.setText(null);
        sameHeight.setToolTipText("\u7b49\u9ad8");
        WebSameSizeAction sameWidthAndHeightAction = new WebSameSizeAction((EditPartViewer)this.epv, 2, "designer/SameHeightAndWidth.gif");
        JButton sameWidthAndHeight = toolbar.add((Action)((Object)sameWidthAndHeightAction));
        sameWidthAndHeight.setText(null);
        sameWidthAndHeight.setToolTipText("\u7b49\u5bbd\u7b49\u9ad8");
        toolbar.add((Component)new KDSeparator());
        RedoAction redoAction = new RedoAction((EditPartViewer)this.epv);
        JButton redo = toolbar.add((Action)redoAction);
        redo.setText(null);
        redo.setToolTipText("\u91cd\u505a");
        UndoAction undoAction = new UndoAction((EditPartViewer)this.epv);
        JButton undo = toolbar.add((Action)undoAction);
        undo.setText(null);
        undo.setToolTipText("\u64a4\u9500");
        this.add((Component)toolbar, "North");
        if (1 == this.status) {
            toolbar.setVisible(false);
        }
        KDPanel mainPanel = new KDPanel();
        mainPanel.setLayout((LayoutManager)new BorderLayout());
        mainPanel.setBackground(ColorConstants.designerBackGround);
        JScrollPane sp = new JScrollPane();
        sp.setName("WebUIEditorScrollPane");
        sp.setViewportView((Component)((Object)this.epv));
        sp.setHorizontalScrollBarPolicy(30);
        sp.setVerticalScrollBarPolicy(20);
        mainPanel.add((Component)sp, (Object)"Center");
        this.add((Component)mainPanel, "Center");
    }

    private void initNameManager(WebUIObjectInfo uiModel) {
        if (uiModel != null) {
            ComponentNameManager manager = uiModel.getNameManager();
            ComponentCollection col = uiModel.getComponents();
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                manager.put(col.get(i).getName());
            }
            ActionCollection actions = uiModel.getActions();
            int size2 = actions.size();
            for (int i = 0; i < size2; ++i) {
                manager.put(actions.get(i).getClassName());
                manager.put(actions.get(i).getName());
            }
        }
    }

    public void showCreateCtrlMenu(KDPopupMenu popMenu) {
        popMenu.show((Component)((Object)this), 0, 27);
    }

    public void setViewer(AbstractWebEditPartViewer viewer) {
        this.viewer = viewer;
    }

    public void getEntitys(EntityObjectInfo entity, List entitys) throws Exception {
        PropertyCollection props = entity.getInheritedNoDuplicatedProperties();
        int n = props.size();
        for (int i = 0; i < n; ++i) {
            EntityObjectInfo subEntity;
            Object field = null;
            PropertyInfo prop = props.get(i);
            if (entity.getLogicalKey() != null && entity.getLogicalKey().getKeyPropertys().size() == 1 && entity.getLogicalKey().getKeyPropertys().get(0).getName().equalsIgnoreCase(prop.getName()) || !(prop instanceof LinkPropertyInfo)) continue;
            LinkPropertyInfo lnkProp = (LinkPropertyInfo)prop;
            RelationshipInfo relation = lnkProp.getRelationship();
            if (relation == null) {
                throw new Exception("entity: " + entity.getRealFullName() + " 's linkProperty " + lnkProp.getName() + " 's relation is null");
            }
            if (relation.getSupplierCardinality() != CardinalityType.ZERO_TO_UNBOUNDED && relation.getSupplierCardinality() != CardinalityType.ONE_TO_UNBOUNDED || (subEntity = relation.getSupplierObject()).equals((Object)entity)) continue;
            entitys.add(subEntity);
            this.getEntitys(subEntity, entitys);
        }
    }

    public void doSave() throws Exception {
        IEditUIConfigure ioc = EditUIConfigureFactory.getRemoteInstance();
        if (2 == this.status) {
            WebUIEditorHelper.storeConfigureModel(this.baseUIInfo, this.configure, this.node);
            IObjectPK pk = ioc.addnew(this.configure);
            this.configure.setId(BOSUuid.read((String)pk.toString()));
            this.status = 0;
        } else if (0 == this.status) {
            if (!this.isBase) {
                WebUIEditorHelper.storeConfigureModel(this.baseUIInfo, this.configure, this.node, this.bizUnit);
                ObjectUuidPK pk = new ObjectUuidPK(this.configure.getId());
                ioc.update((IObjectPK)pk, this.configure);
            } else {
                WebUIEditorHelper.adjustComponents4Base(this.baseUIInfo, this.node);
                UictUtils.saveMetadata((AbstractMetaDataValue)this.baseUIInfo, (String)this.customizedSchemeID, (Project)this.depend);
            }
        }
        this.setDirty(false);
    }

    public void loadData() {
    }

    public EditUIConfigureInfo getData() {
        return this.configure;
    }

    public void destory() {
    }

    public boolean isDirty() {
        if (1 == this.status) {
            return false;
        }
        if (this.viewer != null) {
            CommandStack stack = this.viewer.getContext().getCommandStack();
            this.isDirty = stack.canRedo() || stack.canUndo() ? true : this.viewer.getContext().isDirty();
        }
        return this.isDirty;
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
        if (!isDirty) {
            if (this.viewer != null) {
                CommandStack stack = this.viewer.getContext().getCommandStack();
                stack.flush();
            }
            this.viewer.getContext().setDirty(false);
        }
    }

    public CustomizedUnitUI getCustomizedUnitUI() {
        return this.ui;
    }

    public void setCustomizedUnitUI(CustomizedUnitUI ui) {
        this.ui = ui;
    }

    public void setBosObjectType(BOSObjectType type) {
    }

    public void setCustomizedSchemeID(String id) {
        this.customizedSchemeID = id;
    }

    public String getCustomizedSchemeID() {
        return this.customizedSchemeID;
    }

    public void setMetadataPK(String pk) {
    }

    public void setDepends(Project depend) {
        this.depend = depend;
    }

    public UIType getUiType() {
        return this.uiType;
    }

    public void beforeSave() throws Exception {
    }

    public BizUnitInfo getModel() {
        return this.bizUnit;
    }

    public void reset() {
    }

    public ComponentTreeNode getRootNode() {
        return this.node;
    }

    public Project getDepends() {
        return this.depend;
    }

    public void editPartSelectionChanged(SelectionChangedEvent event) {
    }
}

