/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.webclient.editor.webui.designer.ui;

import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPartViewer;
import com.kingdee.eas.ep.webclient.editor.webui.designer.AbstractWebEditPartViewer;
import com.kingdee.eas.ep.webclient.editor.webui.designer.util.WebEditorHelper;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class WebTabbedPane
extends KDTabbedPane
implements ChangeListener,
FocusListener,
MouseMotionListener,
MouseListener {
    private static final long serialVersionUID = -6572788437357426307L;
    private static Logger logger = Logger.getLogger(WebTabbedPane.class);

    public WebTabbedPane() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addHeadMouseListener(this);
        this.addFocusListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof EditPartViewer)) continue;
            JComponent panel = ((EditPartViewer)container).getMaskPanel();
            panel.setFocusable(true);
            panel.requestFocus();
            break;
        }
    }

    @Override
    public void focusGained(FocusEvent arg0) {
        AbstractWebEditPartViewer parentViewer = WebEditorHelper.getParentViewer((JComponent)((Object)this));
        if (parentViewer != null) {
            JPanel panel = parentViewer.getMaskPanel();
            panel.setFocusable(true);
            panel.requestFocus();
        }
    }

    @Override
    public void focusLost(FocusEvent arg0) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int index = this.mouseInTabIndex(e.getX(), e.getY());
        int selected = this.getSelectedIndex();
        if (index != -1 && selected != -1) {
            this.setSelectedIndex(index);
            return;
        }
        this.dispatchEvent2ParentViewer(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.dispatchEvent2ParentViewer(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.dispatchEvent2ParentViewer(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.dispatchEvent2ParentViewer(e);
    }

    private int mouseInTabIndex(int x, int y) {
        List tis = this.getTabInfos();
        int size = tis.size();
        for (int i = 0; i < size; ++i) {
            TabInfo tabInfo = (TabInfo)tis.get(i);
            Rectangle bounds = tabInfo.bounds;
            if (bounds == null || x < bounds.x || x > bounds.x + bounds.width || y < bounds.y || y > bounds.y + bounds.height) continue;
            return tabInfo.index;
        }
        return -1;
    }

    private void dispatchEvent2ParentViewer(MouseEvent e) {
        int index = this.mouseInTabIndex(e.getX(), e.getY());
        if (index == -1) {
            WebEditorHelper.dispatchEvent2ParentViewer((JComponent)((Object)this), e);
        }
    }

    private List getTabInfos() {
        ArrayList<TabInfo> tis = new ArrayList<TabInfo>(5);
        int counts = this.getTabCount();
        for (int i = 0; i < counts; ++i) {
            tis.add(new TabInfo(i, this.getBoundsAt(i)));
        }
        return tis;
    }

    private class TabInfo {
        int index;
        Rectangle bounds;

        public TabInfo(int index, Rectangle bounds) {
            this.index = index;
            this.bounds = bounds;
        }
    }
}

