/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.index;

import java.io.IOException;
import org.apache.lucene.ep.analysis.TokenStream;
import org.apache.lucene.ep.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.ep.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.ep.index.DocFieldConsumerPerField;
import org.apache.lucene.ep.index.DocFieldConsumerPerThread;
import org.apache.lucene.ep.index.DocFieldProcessorPerThread;
import org.apache.lucene.ep.index.DocInverter;
import org.apache.lucene.ep.index.DocInverterPerField;
import org.apache.lucene.ep.index.DocumentsWriter;
import org.apache.lucene.ep.index.FieldInfo;
import org.apache.lucene.ep.index.FieldInvertState;
import org.apache.lucene.ep.index.InvertedDocConsumerPerThread;
import org.apache.lucene.ep.index.InvertedDocEndConsumerPerThread;
import org.apache.lucene.ep.index.ReusableStringReader;

final class DocInverterPerThread
extends DocFieldConsumerPerThread {
    final DocInverter docInverter;
    final InvertedDocConsumerPerThread consumer;
    final InvertedDocEndConsumerPerThread endConsumer;
    final SingleTokenTokenStream singleTokenTokenStream = new SingleTokenTokenStream();
    final DocumentsWriter.DocState docState;
    final FieldInvertState fieldState = new FieldInvertState();
    final ReusableStringReader stringReader = new ReusableStringReader();

    public DocInverterPerThread(DocFieldProcessorPerThread docFieldProcessorPerThread, DocInverter docInverter) {
        this.docInverter = docInverter;
        this.docState = docFieldProcessorPerThread.docState;
        this.consumer = docInverter.consumer.addThread(this);
        this.endConsumer = docInverter.endConsumer.addThread(this);
    }

    @Override
    public void startDocument() throws IOException {
        this.consumer.startDocument();
        this.endConsumer.startDocument();
    }

    @Override
    public DocumentsWriter.DocWriter finishDocument() throws IOException {
        this.endConsumer.finishDocument();
        return this.consumer.finishDocument();
    }

    @Override
    void abort() {
        try {
            this.consumer.abort();
        }
        finally {
            this.endConsumer.abort();
        }
    }

    @Override
    public DocFieldConsumerPerField addField(FieldInfo fi) {
        return new DocInverterPerField(this, fi);
    }

    static class SingleTokenTokenStream
    extends TokenStream {
        TermAttribute termAttribute = (TermAttribute)this.addAttribute(TermAttribute.class);
        OffsetAttribute offsetAttribute = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);

        SingleTokenTokenStream() {
        }

        public void reinit(String stringValue, int startOffset, int endOffset) {
            this.termAttribute.setTermBuffer(stringValue);
            this.offsetAttribute.setOffset(startOffset, endOffset);
        }

        @Override
        public boolean incrementToken() {
            throw new UnsupportedOperationException();
        }
    }
}

