/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.index;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.ep.index.DocInverterPerThread;
import org.apache.lucene.ep.index.DocumentsWriter;
import org.apache.lucene.ep.index.FieldInfos;
import org.apache.lucene.ep.index.InvertedDocConsumer;
import org.apache.lucene.ep.index.InvertedDocConsumerPerThread;
import org.apache.lucene.ep.index.RawPostingList;
import org.apache.lucene.ep.index.SegmentWriteState;
import org.apache.lucene.ep.index.TermsHashConsumer;
import org.apache.lucene.ep.index.TermsHashConsumerPerField;
import org.apache.lucene.ep.index.TermsHashPerField;
import org.apache.lucene.ep.index.TermsHashPerThread;
import org.apache.lucene.ep.util.ArrayUtil;

final class TermsHash
extends InvertedDocConsumer {
    final TermsHashConsumer consumer;
    final TermsHash nextTermsHash;
    final int bytesPerPosting;
    final int postingsFreeChunk;
    final DocumentsWriter docWriter;
    private TermsHash primaryTermsHash;
    private RawPostingList[] postingsFreeList = new RawPostingList[1];
    private int postingsFreeCount;
    private int postingsAllocCount;
    boolean trackAllocations;

    public TermsHash(DocumentsWriter docWriter, boolean trackAllocations, TermsHashConsumer consumer, TermsHash nextTermsHash) {
        this.docWriter = docWriter;
        this.consumer = consumer;
        this.nextTermsHash = nextTermsHash;
        this.trackAllocations = trackAllocations;
        this.bytesPerPosting = consumer.bytesPerPosting() + 4 * DocumentsWriter.POINTER_NUM_BYTE;
        this.postingsFreeChunk = 32768 / this.bytesPerPosting;
    }

    @Override
    InvertedDocConsumerPerThread addThread(DocInverterPerThread docInverterPerThread) {
        return new TermsHashPerThread(docInverterPerThread, this, this.nextTermsHash, null);
    }

    TermsHashPerThread addThread(DocInverterPerThread docInverterPerThread, TermsHashPerThread primaryPerThread) {
        return new TermsHashPerThread(docInverterPerThread, this, this.nextTermsHash, primaryPerThread);
    }

    @Override
    void setFieldInfos(FieldInfos fieldInfos) {
        this.fieldInfos = fieldInfos;
        this.consumer.setFieldInfos(fieldInfos);
    }

    @Override
    public synchronized void abort() {
        this.consumer.abort();
        if (this.nextTermsHash != null) {
            this.nextTermsHash.abort();
        }
    }

    void shrinkFreePostings(Map threadsAndFields, SegmentWriteState state) {
        assert (this.postingsFreeCount == this.postingsAllocCount) : Thread.currentThread().getName() + ": postingsFreeCount=" + this.postingsFreeCount + " postingsAllocCount=" + this.postingsAllocCount + " consumer=" + this.consumer;
        boolean newSize = true;
        if (1 != this.postingsFreeList.length) {
            if (this.postingsFreeCount > 1) {
                if (this.trackAllocations) {
                    this.docWriter.bytesAllocated(-(this.postingsFreeCount - 1) * this.bytesPerPosting);
                }
                this.postingsFreeCount = 1;
                this.postingsAllocCount = 1;
            }
            RawPostingList[] newArray = new RawPostingList[1];
            System.arraycopy(this.postingsFreeList, 0, newArray, 0, this.postingsFreeCount);
            this.postingsFreeList = newArray;
        }
    }

    @Override
    synchronized void closeDocStore(SegmentWriteState state) throws IOException {
        this.consumer.closeDocStore(state);
        if (this.nextTermsHash != null) {
            this.nextTermsHash.closeDocStore(state);
        }
    }

    @Override
    synchronized void flush(Map threadsAndFields, SegmentWriteState state) throws IOException {
        HashMap childThreadsAndFields = new HashMap();
        HashMap nextThreadsAndFields = this.nextTermsHash != null ? new HashMap() : null;
        for (Map.Entry entry : threadsAndFields.entrySet()) {
            TermsHashPerThread perThread = (TermsHashPerThread)entry.getKey();
            Collection fields = (Collection)entry.getValue();
            Iterator fieldsIt = fields.iterator();
            HashSet<TermsHashConsumerPerField> childFields = new HashSet<TermsHashConsumerPerField>();
            HashSet<TermsHashPerField> nextChildFields = this.nextTermsHash != null ? new HashSet<TermsHashPerField>() : null;
            while (fieldsIt.hasNext()) {
                TermsHashPerField perField = (TermsHashPerField)fieldsIt.next();
                childFields.add(perField.consumer);
                if (this.nextTermsHash == null) continue;
                nextChildFields.add(perField.nextPerField);
            }
            childThreadsAndFields.put(perThread.consumer, childFields);
            if (this.nextTermsHash == null) continue;
            nextThreadsAndFields.put(perThread.nextPerThread, nextChildFields);
        }
        this.consumer.flush(childThreadsAndFields, state);
        this.shrinkFreePostings(threadsAndFields, state);
        if (this.nextTermsHash != null) {
            this.nextTermsHash.flush(nextThreadsAndFields, state);
        }
    }

    @Override
    public synchronized boolean freeRAM() {
        boolean any;
        if (!this.trackAllocations) {
            return false;
        }
        int numToFree = this.postingsFreeCount >= this.postingsFreeChunk ? this.postingsFreeChunk : this.postingsFreeCount;
        boolean bl = any = numToFree > 0;
        if (any) {
            Arrays.fill(this.postingsFreeList, this.postingsFreeCount - numToFree, this.postingsFreeCount, null);
            this.postingsFreeCount -= numToFree;
            this.postingsAllocCount -= numToFree;
            this.docWriter.bytesAllocated(-numToFree * this.bytesPerPosting);
            any = true;
        }
        if (this.nextTermsHash != null) {
            any |= this.nextTermsHash.freeRAM();
        }
        return any;
    }

    public synchronized void recyclePostings(RawPostingList[] postings, int numPostings) {
        assert (postings.length >= numPostings);
        assert (this.postingsFreeCount + numPostings <= this.postingsFreeList.length);
        System.arraycopy(postings, 0, this.postingsFreeList, this.postingsFreeCount, numPostings);
        this.postingsFreeCount += numPostings;
    }

    public synchronized void getPostings(RawPostingList[] postings) {
        assert (this.docWriter.writer.testPoint("TermsHash.getPostings start"));
        assert (this.postingsFreeCount <= this.postingsFreeList.length);
        assert (this.postingsFreeCount <= this.postingsAllocCount) : "postingsFreeCount=" + this.postingsFreeCount + " postingsAllocCount=" + this.postingsAllocCount;
        int numToCopy = this.postingsFreeCount < postings.length ? this.postingsFreeCount : postings.length;
        int start = this.postingsFreeCount - numToCopy;
        assert (start >= 0);
        assert (start + numToCopy <= this.postingsFreeList.length);
        assert (numToCopy <= postings.length);
        System.arraycopy(this.postingsFreeList, start, postings, 0, numToCopy);
        if (numToCopy != postings.length) {
            int extra = postings.length - numToCopy;
            int newPostingsAllocCount = this.postingsAllocCount + extra;
            this.consumer.createPostings(postings, numToCopy, extra);
            assert (this.docWriter.writer.testPoint("TermsHash.getPostings after create"));
            this.postingsAllocCount += extra;
            if (this.trackAllocations) {
                this.docWriter.bytesAllocated(extra * this.bytesPerPosting);
            }
            if (newPostingsAllocCount > this.postingsFreeList.length) {
                this.postingsFreeList = new RawPostingList[ArrayUtil.getNextSize(newPostingsAllocCount)];
            }
        }
        this.postingsFreeCount -= numToCopy;
        if (this.trackAllocations) {
            this.docWriter.bytesUsed(postings.length * this.bytesPerPosting);
        }
    }
}

