/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.search;

import java.io.IOException;
import org.apache.lucene.ep.index.IndexReader;
import org.apache.lucene.ep.index.Term;
import org.apache.lucene.ep.search.Collector;
import org.apache.lucene.ep.search.FieldDocSortedHitQueue;
import org.apache.lucene.ep.search.Filter;
import org.apache.lucene.ep.search.HitQueue;
import org.apache.lucene.ep.search.MultiSearcher;
import org.apache.lucene.ep.search.MultiSearcherThread;
import org.apache.lucene.ep.search.Query;
import org.apache.lucene.ep.search.ScoreDoc;
import org.apache.lucene.ep.search.Scorer;
import org.apache.lucene.ep.search.Searchable;
import org.apache.lucene.ep.search.Sort;
import org.apache.lucene.ep.search.TopDocs;
import org.apache.lucene.ep.search.TopFieldDocs;
import org.apache.lucene.ep.search.Weight;

public class ParallelMultiSearcher
extends MultiSearcher {
    private Searchable[] searchables;
    private int[] starts;

    public ParallelMultiSearcher(Searchable[] searchables) throws IOException {
        super(searchables);
        this.searchables = searchables;
        this.starts = this.getStarts();
    }

    @Override
    public int docFreq(Term term) throws IOException {
        return super.docFreq(term);
    }

    @Override
    public TopDocs search(Weight weight, Filter filter, int nDocs) throws IOException {
        int i;
        HitQueue hq = new HitQueue(nDocs, false);
        int totalHits = 0;
        MultiSearcherThread[] msta = new MultiSearcherThread[this.searchables.length];
        for (i = 0; i < this.searchables.length; ++i) {
            msta[i] = new MultiSearcherThread(this.searchables[i], weight, filter, nDocs, hq, i, this.starts, "MultiSearcher thread #" + (i + 1));
            msta[i].start();
        }
        for (i = 0; i < this.searchables.length; ++i) {
            try {
                msta[i].join();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(ie);
            }
            IOException ioe = msta[i].getIOException();
            if (ioe == null) {
                totalHits += msta[i].hits();
                continue;
            }
            throw ioe;
        }
        ScoreDoc[] scoreDocs = new ScoreDoc[hq.size()];
        for (int i2 = hq.size() - 1; i2 >= 0; --i2) {
            scoreDocs[i2] = (ScoreDoc)hq.pop();
        }
        float maxScore = totalHits == 0 ? Float.NEGATIVE_INFINITY : scoreDocs[0].score;
        return new TopDocs(totalHits, scoreDocs, maxScore);
    }

    @Override
    public TopFieldDocs search(Weight weight, Filter filter, int nDocs, Sort sort) throws IOException {
        FieldDocSortedHitQueue hq = new FieldDocSortedHitQueue(null, nDocs);
        int totalHits = 0;
        MultiSearcherThread[] msta = new MultiSearcherThread[this.searchables.length];
        for (int i = 0; i < this.searchables.length; ++i) {
            msta[i] = new MultiSearcherThread(this.searchables[i], weight, filter, nDocs, hq, sort, i, this.starts, "MultiSearcher thread #" + (i + 1));
            msta[i].start();
        }
        float maxScore = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < this.searchables.length; ++i) {
            try {
                msta[i].join();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(ie);
            }
            IOException ioe = msta[i].getIOException();
            if (ioe == null) {
                totalHits += msta[i].hits();
            } else {
                throw ioe;
            }
            maxScore = Math.max(maxScore, msta[i].getMaxScore());
        }
        ScoreDoc[] scoreDocs = new ScoreDoc[hq.size()];
        for (int i = hq.size() - 1; i >= 0; --i) {
            scoreDocs[i] = (ScoreDoc)hq.pop();
        }
        return new TopFieldDocs(totalHits, scoreDocs, hq.getFields(), maxScore);
    }

    @Override
    public void search(Weight weight, Filter filter, final Collector collector) throws IOException {
        for (int i = 0; i < this.searchables.length; ++i) {
            final int start = this.starts[i];
            Collector hc = new Collector(){

                @Override
                public void setScorer(Scorer scorer) throws IOException {
                    collector.setScorer(scorer);
                }

                @Override
                public void collect(int doc) throws IOException {
                    collector.collect(doc);
                }

                @Override
                public void setNextReader(IndexReader reader, int docBase) throws IOException {
                    collector.setNextReader(reader, start + docBase);
                }

                @Override
                public boolean acceptsDocsOutOfOrder() {
                    return collector.acceptsDocsOutOfOrder();
                }
            };
            this.searchables[i].search(weight, filter, hc);
        }
    }

    @Override
    public Query rewrite(Query original) throws IOException {
        return super.rewrite(original);
    }
}

