/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.search;

import java.io.IOException;
import org.apache.lucene.ep.index.IndexReader;
import org.apache.lucene.ep.index.Term;
import org.apache.lucene.ep.search.FilteredTermEnum;
import org.apache.lucene.ep.search.MultiTermQuery;
import org.apache.lucene.ep.search.Query;
import org.apache.lucene.ep.search.TermQuery;
import org.apache.lucene.ep.search.WildcardTermEnum;
import org.apache.lucene.ep.util.ToStringUtils;

public class WildcardQuery
extends MultiTermQuery {
    private boolean termContainsWildcard;

    public WildcardQuery(Term term) {
        super(term);
        this.term = term;
        this.termContainsWildcard = term.text().indexOf(42) != -1 || term.text().indexOf(63) != -1;
    }

    @Override
    protected FilteredTermEnum getEnum(IndexReader reader) throws IOException {
        return new WildcardTermEnum(reader, this.getTerm());
    }

    @Override
    public Term getTerm() {
        return this.term;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        if (!this.termContainsWildcard) {
            return new TermQuery(this.getTerm());
        }
        return super.rewrite(reader);
    }

    @Override
    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        if (!this.term.field().equals(field)) {
            buffer.append(this.term.field());
            buffer.append(":");
        }
        buffer.append(this.term.text());
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.term == null ? 0 : this.term.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WildcardQuery other = (WildcardQuery)obj;
        return !(this.term == null ? other.term != null : !this.term.equals(other.term));
    }
}

