/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;

public class IndexableBinaryStringTools {
    private static final CodingCase[] CODING_CASES = new CodingCase[]{new CodingCase(7, 1), new CodingCase(14, 6, 2), new CodingCase(13, 5, 3), new CodingCase(12, 4, 4), new CodingCase(11, 3, 5), new CodingCase(10, 2, 6), new CodingCase(9, 1, 7), new CodingCase(8, 0)};

    private IndexableBinaryStringTools() {
    }

    public static int getEncodedLength(ByteBuffer original) throws IllegalArgumentException {
        if (original.hasArray()) {
            long length = original.limit() - original.arrayOffset();
            return (int)((length * 8L + 14L) / 15L) + 1;
        }
        throw new IllegalArgumentException("original argument must have a backing array");
    }

    public static int getDecodedLength(CharBuffer encoded) throws IllegalArgumentException {
        if (encoded.hasArray()) {
            int numChars = encoded.limit() - encoded.arrayOffset() - 1;
            if (numChars <= 0) {
                return 0;
            }
            char numFullBytesInFinalChar = encoded.charAt(encoded.limit() - 1);
            int numEncodedChars = numChars - 1;
            return (numEncodedChars * 15 + 7) / 8 + numFullBytesInFinalChar;
        }
        throw new IllegalArgumentException("encoded argument must have a backing array");
    }

    public static void encode(ByteBuffer input, CharBuffer output) {
        if (input.hasArray() && output.hasArray()) {
            byte[] inputArray = input.array();
            int inputOffset = input.arrayOffset();
            int inputLength = input.limit() - inputOffset;
            char[] outputArray = output.array();
            int outputOffset = output.arrayOffset();
            int outputLength = IndexableBinaryStringTools.getEncodedLength(input);
            output.limit(outputOffset + outputLength);
            output.position(0);
            if (inputLength > 0) {
                CodingCase codingCase;
                int inputByteNum = inputOffset;
                int caseNum = 0;
                int outputCharNum = outputOffset;
                while (inputByteNum + IndexableBinaryStringTools.CODING_CASES[caseNum].numBytes <= inputLength) {
                    codingCase = CODING_CASES[caseNum];
                    outputArray[outputCharNum] = 2 == codingCase.numBytes ? (char)(((inputArray[inputByteNum] & 0xFF) << codingCase.initialShift) + ((inputArray[inputByteNum + 1] & 0xFF) >>> codingCase.finalShift & codingCase.finalMask) & Short.MAX_VALUE) : (char)(((inputArray[inputByteNum] & 0xFF) << codingCase.initialShift) + ((inputArray[inputByteNum + 1] & 0xFF) << codingCase.middleShift) + ((inputArray[inputByteNum + 2] & 0xFF) >>> codingCase.finalShift & codingCase.finalMask) & Short.MAX_VALUE);
                    inputByteNum += codingCase.advanceBytes;
                    if (++caseNum == CODING_CASES.length) {
                        caseNum = 0;
                    }
                    ++outputCharNum;
                }
                codingCase = CODING_CASES[caseNum];
                if (inputByteNum + 1 < inputLength) {
                    outputArray[outputCharNum++] = (char)(((inputArray[inputByteNum] & 0xFF) << codingCase.initialShift) + ((inputArray[inputByteNum + 1] & 0xFF) << codingCase.middleShift) & Short.MAX_VALUE);
                    outputArray[outputCharNum++] = '\u0001';
                } else if (inputByteNum < inputLength) {
                    outputArray[outputCharNum++] = (char)((inputArray[inputByteNum] & 0xFF) << codingCase.initialShift & Short.MAX_VALUE);
                    outputArray[outputCharNum++] = caseNum == 0 ? (char)'\u0001' : '\u0000';
                } else {
                    outputArray[outputCharNum++] = '\u0001';
                }
            }
        } else {
            throw new IllegalArgumentException("Arguments must have backing arrays");
        }
    }

    public static void decode(CharBuffer input, ByteBuffer output) {
        if (input.hasArray() && output.hasArray()) {
            int numInputChars = input.limit() - input.arrayOffset() - 1;
            int numOutputBytes = IndexableBinaryStringTools.getDecodedLength(input);
            output.limit(numOutputBytes + output.arrayOffset());
            output.position(0);
            byte[] outputArray = output.array();
            char[] inputArray = input.array();
            if (numOutputBytes > 0) {
                short inputChar;
                CodingCase codingCase;
                int inputCharNum;
                int caseNum = 0;
                int outputByteNum = output.arrayOffset();
                for (inputCharNum = input.arrayOffset(); inputCharNum < numInputChars - 1; ++inputCharNum) {
                    codingCase = CODING_CASES[caseNum];
                    inputChar = (short)inputArray[inputCharNum];
                    if (2 == codingCase.numBytes) {
                        if (0 == caseNum) {
                            outputArray[outputByteNum] = (byte)(inputChar >>> codingCase.initialShift);
                        } else {
                            int n = outputByteNum;
                            outputArray[n] = (byte)(outputArray[n] + (byte)(inputChar >>> codingCase.initialShift));
                        }
                        outputArray[outputByteNum + 1] = (byte)((inputChar & codingCase.finalMask) << codingCase.finalShift);
                    } else {
                        int n = outputByteNum;
                        outputArray[n] = (byte)(outputArray[n] + (byte)(inputChar >>> codingCase.initialShift));
                        outputArray[outputByteNum + 1] = (byte)((inputChar & codingCase.middleMask) >>> codingCase.middleShift);
                        outputArray[outputByteNum + 2] = (byte)((inputChar & codingCase.finalMask) << codingCase.finalShift);
                    }
                    outputByteNum += codingCase.advanceBytes;
                    if (++caseNum != CODING_CASES.length) continue;
                    caseNum = 0;
                }
                inputChar = (short)inputArray[inputCharNum];
                codingCase = CODING_CASES[caseNum];
                if (0 == caseNum) {
                    outputArray[outputByteNum] = 0;
                }
                int n = outputByteNum;
                outputArray[n] = (byte)(outputArray[n] + (byte)(inputChar >>> codingCase.initialShift));
                int bytesLeft = numOutputBytes - outputByteNum;
                if (bytesLeft > 1) {
                    if (2 == codingCase.numBytes) {
                        outputArray[outputByteNum + 1] = (byte)((inputChar & codingCase.finalMask) >>> codingCase.finalShift);
                    } else {
                        outputArray[outputByteNum + 1] = (byte)((inputChar & codingCase.middleMask) >>> codingCase.middleShift);
                        if (bytesLeft > 2) {
                            outputArray[outputByteNum + 2] = (byte)((inputChar & codingCase.finalMask) << codingCase.finalShift);
                        }
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Arguments must have backing arrays");
        }
    }

    public static ByteBuffer decode(CharBuffer input) {
        byte[] outputArray = new byte[IndexableBinaryStringTools.getDecodedLength(input)];
        ByteBuffer output = ByteBuffer.wrap(outputArray);
        IndexableBinaryStringTools.decode(input, output);
        return output;
    }

    public static CharBuffer encode(ByteBuffer input) {
        char[] outputArray = new char[IndexableBinaryStringTools.getEncodedLength(input)];
        CharBuffer output = CharBuffer.wrap(outputArray);
        IndexableBinaryStringTools.encode(input, output);
        return output;
    }

    static class CodingCase {
        int numBytes;
        int initialShift;
        int middleShift;
        int finalShift;
        int advanceBytes = 2;
        short middleMask;
        short finalMask;

        CodingCase(int initialShift, int middleShift, int finalShift) {
            this.numBytes = 3;
            this.initialShift = initialShift;
            this.middleShift = middleShift;
            this.finalShift = finalShift;
            this.finalMask = (short)(255 >>> finalShift);
            this.middleMask = (short)(255 << middleShift);
        }

        CodingCase(int initialShift, int finalShift) {
            this.numBytes = 2;
            this.initialShift = initialShift;
            this.finalShift = finalShift;
            this.finalMask = (short)(255 >>> finalShift);
            if (finalShift != 0) {
                this.advanceBytes = 1;
            }
        }
    }
}

