/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ep.ui.autocomplete;

import java.util.Collections;
import java.util.List;
import javax.swing.ListCellRenderer;
import javax.swing.text.JTextComponent;
import org.fife.ep.ui.autocomplete.CompletionProvider;

public abstract class CompletionProviderBase
implements CompletionProvider {
    private CompletionProvider parent;
    private ListCellRenderer listCellRenderer;
    private char paramListStart;
    private char paramListEnd;
    private String paramListSeparator;
    protected static final String EMPTY_STRING = "";

    @Override
    public void clearParameterizedCompletionParams() {
        this.paramListStart = '\u0000';
        this.paramListEnd = '\u0000';
        this.paramListSeparator = null;
    }

    @Override
    public List getCompletions(JTextComponent comp) {
        List completions = this.getCompletionsImpl(comp);
        if (this.parent != null) {
            completions.addAll(this.parent.getCompletions(comp));
            Collections.sort(completions);
        }
        return completions;
    }

    protected abstract List getCompletionsImpl(JTextComponent var1);

    @Override
    public ListCellRenderer getListCellRenderer() {
        return this.listCellRenderer;
    }

    @Override
    public char getParameterListEnd() {
        return this.paramListEnd;
    }

    @Override
    public String getParameterListSeparator() {
        return this.paramListSeparator;
    }

    @Override
    public char getParameterListStart() {
        return this.paramListStart;
    }

    @Override
    public CompletionProvider getParent() {
        return this.parent;
    }

    @Override
    public void setListCellRenderer(ListCellRenderer r) {
        this.listCellRenderer = r;
    }

    @Override
    public void setParameterizedCompletionParams(char listStart, String separator, char listEnd) {
        if (listStart < ' ' || listStart == '\u007f') {
            throw new IllegalArgumentException("Invalid listStart");
        }
        if (listEnd < ' ' || listEnd == '\u007f') {
            throw new IllegalArgumentException("Invalid listEnd");
        }
        if (separator == null || separator.length() == 0) {
            throw new IllegalArgumentException("Invalid separator");
        }
        this.paramListStart = listStart;
        this.paramListSeparator = separator;
        this.paramListEnd = listEnd;
    }

    @Override
    public void setParent(CompletionProvider parent) {
        this.parent = parent;
    }
}

