/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.query.JoinCollection;
import com.kingdee.bos.metadata.query.JoinItemCollection;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.PropertyRefCollection;
import com.kingdee.bos.metadata.query.QueryFieldCollection;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.service.job.util.SQL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.springframework.util.CollectionUtils;

public class PrivacyPlanHelper {
    private static Logger logger = Logger.getLogger(PrivacyPlanHelper.class);

    public static List<HashMap<String, Object>> getDesensitizationRules(Context ctx, QueryInfo queryInfo) {
        try {
            if (queryInfo != null && queryInfo.getMainObject() != null) {
                SubObjectInfo mainObject = queryInfo.getMainObject();
                String entityName = ((EntityObjectInfo)mainObject.get("entityRef")).getFullName();
                EntityObjectInfo entityInfo = PrivacyPlanHelper.getEntity(ctx, entityName);
                List<HashMap<String, Object>> ruleList = PrivacyPlanHelper.getDesensitizationRules(ctx, entityInfo);
                PrivacyPlanHelper.matchRuleField(ruleList, entityName, queryInfo, ctx);
                return ruleList;
            }
        }
        catch (BOSException e) {
            logger.error((Object)"get query main object error", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"get desensitization rules by query error", (Throwable)e);
        }
        return null;
    }

    public static List<HashMap<String, Object>> getDesensitizationRules(Context ctx, EntityObjectInfo entityInfo) {
        int i;
        ArrayList<HashMap<String, Object>> desensitizationRules = new ArrayList<HashMap<String, Object>>();
        PropertyCollection properties = entityInfo.getInheritedProperties();
        HashMap<String, String> baseDatas = new HashMap<String, String>();
        for (int i2 = 0; i2 < properties.size(); ++i2) {
            PropertyInfo property = properties.get(i2);
            if (!(property instanceof LinkPropertyInfo)) continue;
            LinkPropertyInfo linkProperty = (LinkPropertyInfo)property;
            baseDatas.put(linkProperty.getName(), linkProperty.getRelationship().getSupplierObject().getFullName());
        }
        List<HashMap<String, Object>> baseDataRules = PrivacyPlanHelper.getDesensitizationRuleByBaseData(ctx, baseDatas, entityInfo);
        ArrayList privacyPlans = PrivacyPlanHelper.getPrivacyPlansByEntity(ctx, entityInfo.getFullName());
        if ((privacyPlans == null || privacyPlans.size() == 0) && baseDataRules.size() == 0) {
            return desensitizationRules;
        }
        ArrayList entityRules = new ArrayList();
        for (i = 0; privacyPlans != null && i < privacyPlans.size(); ++i) {
            HashMap map = (HashMap)privacyPlans.get(i);
            HashMap<String, Object> rule = new HashMap<String, Object>();
            rule.put("fieldName", (String)map.get("fieldname"));
            rule.put("replaceTo", (String)map.get("replaceto"));
            if (map.get("desensitizationmode") != null) {
                int desensitizeMode = Integer.parseInt(map.get("desensitizationmode").toString());
                rule.put("desensitizeMode", desensitizeMode);
                if (desensitizeMode == 1) {
                    if (map.get("firstddigits") != null) {
                        int firstddigits = Integer.parseInt(map.get("firstddigits").toString());
                        rule.put("firstdDigits", firstddigits);
                    }
                    if (map.get("lastdigits") != null) {
                        int lastdigits = Integer.parseInt(map.get("lastdigits").toString());
                        rule.put("lastDigits", lastdigits);
                    }
                } else if (desensitizeMode == 2) {
                    rule.put("regExp", (String)map.get("regexp"));
                }
            }
            entityRules.add(rule);
        }
        desensitizationRules.addAll(entityRules);
        for (i = 0; i < baseDataRules.size(); ++i) {
            boolean flag = true;
            for (int j = 0; j < entityRules.size(); ++j) {
                if (!baseDataRules.get(i).get("fieldName").equals(((HashMap)entityRules.get(j)).get("fieldName"))) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            desensitizationRules.add(baseDataRules.get(i));
        }
        return desensitizationRules;
    }

    private static EntityObjectInfo getEntity(Context ctx, String entityName) {
        MetaDataPK entityPK = MetaDataPK.create((String)entityName);
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        return loader.getEntity((IMetaDataPK)entityPK);
    }

    private static void matchRuleField(List<HashMap<String, Object>> rules, String entityName, QueryInfo queryInfo, Context ctx) {
        if (CollectionUtils.isEmpty(rules)) {
            return;
        }
        EntityObjectInfo entityInfo = PrivacyPlanHelper.getEntity(ctx, entityName);
        Map<String, String> mapping = PrivacyPlanHelper.getEntity2QueryFieldName(queryInfo, entityInfo);
        for (HashMap<String, Object> rule : rules) {
            String fieldName = (String)rule.get("fieldName");
            int index = fieldName.indexOf(".");
            if (index != -1) {
                LinkPropertyInfo property = (LinkPropertyInfo)entityInfo.getPropertyByName(fieldName.substring(0, fieldName.indexOf(".")));
                RelationshipInfo relationship = property.getRelationship();
                EntityObjectInfo supplierObject = relationship.getSupplierObject();
                String mappingFieldName = mapping.get(supplierObject.getFullName() + "." + fieldName);
                if (PrivacyPlanHelper.isEntry(property)) {
                    mappingFieldName = mapping.get(supplierObject.getFullName() + "." + fieldName.substring(index + 1));
                }
                rule.put("fieldName", mappingFieldName == null ? fieldName : mappingFieldName);
                continue;
            }
            String mappingFieldName = mapping.get(entityName + "." + entityInfo.getName() + "." + fieldName);
            rule.put("fieldName", mappingFieldName == null ? fieldName : mappingFieldName);
        }
    }

    private static Map<String, String> getEntity2QueryFieldName(QueryInfo queryInfo, EntityObjectInfo entityInfo) {
        HashMap<String, String> result = new HashMap<String, String>();
        ArrayList<EntityObjectInfo> entryEntityList = new ArrayList<EntityObjectInfo>();
        PropertyCollection properties = entityInfo.getInheritedProperties();
        for (int i = 0; i < properties.size(); ++i) {
            PropertyInfo property = properties.get(i);
            if (!(property instanceof LinkPropertyInfo) || !PrivacyPlanHelper.isEntry((LinkPropertyInfo)property)) continue;
            entryEntityList.add(((LinkPropertyInfo)property).getRelationship().getSupplierObject());
        }
        HashMap<String, String> subObjectName2EntityNameMap = new HashMap<String, String>();
        JoinCollection joins = ((JoinQueryInfo)queryInfo).getJoins();
        HashMap<String, SubObjectInfo> entryLinkedProperty = new HashMap<String, SubObjectInfo>();
        for (int i = 0; i < joins.size(); ++i) {
            JoinItemCollection joinItem = joins.get(i).getJoinItems();
            SubObjectInfo leftObject = joins.get(i).getLeftObject();
            String rightObjectName = joins.get(i).getRightObject().getName();
            PropertyRefCollection propRefs = joinItem.get(0).getLeftField().getPropertyRefs();
            if (propRefs.size() != 1) continue;
            if (PrivacyPlanHelper.isEntryObject(leftObject, entryEntityList)) {
                entryLinkedProperty.put(rightObjectName, leftObject);
                subObjectName2EntityNameMap.put(leftObject.getName() + "." + rightObjectName, propRefs.get(0).getRefProperty().getName());
                continue;
            }
            subObjectName2EntityNameMap.put(rightObjectName, propRefs.get(0).getRefProperty().getName());
        }
        QueryFieldCollection queryFields = queryInfo.getUnits().getQueryFields();
        for (int i = 0; i < queryFields.size(); ++i) {
            String realEntityObjectName;
            QueryFieldInfo queryField = queryFields.get(i);
            PropertyRefCollection propertyRefCollection = queryField.getPropertyRefs();
            if (propertyRefCollection.size() != 1) continue;
            SubEntityInfo subObject = propertyRefCollection.get(0).getSubEntity();
            String subObjectName = subObject.getName();
            if (entryLinkedProperty.containsKey(subObjectName)) {
                EntityObjectInfo entryEntity = (EntityObjectInfo)((SubObjectInfo)entryLinkedProperty.get(subObjectName)).get("entityRef");
                realEntityObjectName = subObjectName2EntityNameMap.get(entryLinkedProperty.get(subObjectName) + "." + subObjectName) != null ? (String)subObjectName2EntityNameMap.get(entryLinkedProperty.get(subObjectName) + "." + subObjectName) : subObjectName;
                String refPropertyName = propertyRefCollection.get(0).getRefProperty().getName();
                result.put(entryEntity.getFullName() + "." + realEntityObjectName + "." + refPropertyName, queryField.getName());
                continue;
            }
            String refPropertyName = propertyRefCollection.get(0).getRefProperty().getName();
            if (PrivacyPlanHelper.isEntryObject((SubObjectInfo)subObject, entryEntityList)) {
                result.put(((EntityObjectInfo)subObject.get("entityRef")).getFullName() + "." + refPropertyName, queryField.getName());
                continue;
            }
            realEntityObjectName = subObjectName2EntityNameMap.get(subObjectName) != null ? (String)subObjectName2EntityNameMap.get(subObjectName) : subObjectName;
            result.put(((EntityObjectInfo)subObject.get("entityRef")).getFullName() + "." + realEntityObjectName + "." + refPropertyName, queryField.getName());
        }
        return result;
    }

    private static boolean isEntryObject(SubObjectInfo leftObject, List<EntityObjectInfo> entryEntityList) {
        for (EntityObjectInfo entryEntity : entryEntityList) {
            if (!((EntityObjectInfo)leftObject.get("entityRef")).getFullName().equals(entryEntity.getFullName())) continue;
            return true;
        }
        return false;
    }

    private static boolean isEntry(LinkPropertyInfo property) {
        RelationshipInfo relationship = property.getRelationship();
        return Boolean.TRUE.toString().equalsIgnoreCase(property.getExtendedProperty("isEntries")) || relationship != null && relationship.getClientObject() != null && RelationshipType.COMPOSITION.equals((Object)relationship.getType()) && (CardinalityType.ONE.equals((Object)relationship.getClientCardinality()) || CardinalityType.ZERO_TO_ONE.equals((Object)relationship.getClientCardinality())) && (CardinalityType.ZERO_TO_UNBOUNDED.equals((Object)relationship.getSupplierCardinality()) || CardinalityType.ONE_TO_UNBOUNDED.equals((Object)relationship.getSupplierCardinality()));
    }

    private static List<HashMap<String, Object>> getDesensitizationRuleByBaseData(Context ctx, Map<String, String> baseDatas, EntityObjectInfo entityInfo) {
        ArrayList<HashMap<String, Object>> baseDataRules = new ArrayList<HashMap<String, Object>>();
        if (CollectionUtils.isEmpty(baseDatas)) {
            return baseDataRules;
        }
        HashSet<String> baseDatasSet = new HashSet<String>();
        for (String baseData : baseDatas.values()) {
            baseDatasSet.add(baseData);
        }
        String sql = "SELECT PRIVACYPLAN.FBillType AS BILLTYPE, RULES.FFieldName AS FIELDNAME, RULETYPE.FReplaceTo AS REPLACETO, RULETYPE.FDESENSITIZATIONMODE AS DESENSITIZATIONMODE, RULETYPE.FirstdDigits AS FIRSTDDIGITS, RULETYPE.FLastDigits AS LASTDIGITS, RULETYPE.FRegExp AS REGEXP FROM T_DYN_PrivacyPlan AS PRIVACYPLAN INNER JOIN T_DYN_DesensitizationRule AS RULES ON PRIVACYPLAN.FID = RULES.FPlanID  INNER JOIN T_DYN_RuleDetail AS RULETYPE ON RULES.FRuleTyleID = RULETYPE.FID  where PRIVACYPLAN.FBillType in (" + PrivacyPlanHelper.concat(baseDatasSet) + ") and PRIVACYPLAN.FEnabled = 1 and PRIVACYPLAN.FIsBaseData = 1";
        try {
            ArrayList result = SQL.executeQuery((Context)ctx, (String)sql);
            if (result.size() > 0) {
                for (int i = 0; i < result.size(); ++i) {
                    HashMap map = (HashMap)result.get(i);
                    String billType = (String)map.get("billtype");
                    for (Map.Entry<String, String> entry : baseDatas.entrySet()) {
                        if (!billType.equals(entry.getValue())) continue;
                        HashMap<String, Object> rule = new HashMap<String, Object>();
                        rule.put("fieldName", entry.getKey() + "." + (String)map.get("fieldname"));
                        rule.put("replaceTo", (String)map.get("replaceto"));
                        if (map.get("desensitizationmode") != null) {
                            int desensitizeMode = Integer.parseInt(map.get("desensitizationmode").toString());
                            rule.put("desensitizeMode", desensitizeMode);
                            if (desensitizeMode == 1) {
                                if (map.get("firstddigits") != null) {
                                    int firstddigits = Integer.parseInt(map.get("firstddigits").toString());
                                    rule.put("firstdDigits", firstddigits);
                                }
                                if (map.get("lastdigits") != null) {
                                    int lastdigits = Integer.parseInt(map.get("lastdigits").toString());
                                    rule.put("lastDigits", lastdigits);
                                }
                            } else if (desensitizeMode == 2) {
                                rule.put("regExp", (String)map.get("regexp"));
                            }
                        }
                        baseDataRules.add(rule);
                    }
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return baseDataRules;
    }

    private static ArrayList getPrivacyPlansByEntity(Context ctx, String entityName) {
        String sql = "SELECT PRIVACYPLAN.FBillType AS BILLTYPE, RULES.FFieldName AS FIELDNAME, RULETYPE.FReplaceTo AS REPLACETO, RULETYPE.FDesensitizationMode AS DESENSITIZATIONMODE, RULETYPE.FirstdDigits AS FIRSTDDIGITS, RULETYPE.FLastDigits AS LASTDIGITS, RULETYPE.FRegExp AS REGEXP FROM T_DYN_PrivacyPlan AS PRIVACYPLAN INNER JOIN T_DYN_DesensitizationRule AS RULES ON PRIVACYPLAN.FID = RULES.FPlanID  INNER JOIN T_DYN_RuleDetail AS RULETYPE ON RULES.FRuleTyleID = RULETYPE.FID  where PRIVACYPLAN.FBillType = ? and PRIVACYPLAN.FEnabled = 1";
        int[] types = new int[]{12};
        Object[] values = new Object[]{entityName};
        ArrayList result = null;
        try {
            result = SQL.executeQuery((Context)ctx, (String)sql, (int[])types, (Object[])values);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return result;
    }

    private static String concat(Set<String> s) {
        StringBuffer sb = new StringBuffer();
        for (String string : s) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append("'").append(string.replace('\'', ' ')).append("'");
        }
        return sb.toString();
    }
}

