/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.app;

import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.app.AbstractTreeListUIHandler;
import com.kingdee.eas.framework.app.tree.DefaultLNTreeNodeCtrl;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import org.apache.log4j.Logger;

public class TreeListUIHandler
extends AbstractTreeListUIHandler {
    private static final Logger logger = Logger.getLogger(TreeListUIHandler.class);

    public void buildTreeFilter(RequestContext request, Context context) throws Exception {
        EntityViewInfo mainQuery = request.getQuery();
        if (mainQuery == null) {
            mainQuery = new EntityViewInfo();
            request.setQuery(mainQuery);
        }
        if (mainQuery.getFilter() == null) {
            mainQuery.setFilter(new FilterInfo());
        }
        EntityViewInfo defaultEntityViewInfo = (EntityViewInfo)request.get("defaultEntityViewInfo");
        this.removeQueryFilterAndSorter(mainQuery);
        mainQuery.getFilter().remove("maskString");
        if (this.getSelectedTreeNode(request, context) != null) {
            TreeBaseInfo node = this.getSelectedTreeNode(request, context);
            mainQuery.getFilter().getFilterItems().add(new FilterItemInfo(this.getLongNumberFieldName(), (Object)node.getLongNumber()));
            mainQuery.getFilter().getFilterItems().add(new FilterItemInfo(this.getLongNumberFieldName(), (Object)(node.getLongNumber() + "!%"), CompareType.LIKE));
            if (!this.isIncludeAllChildren(request, context)) {
                mainQuery.getFilter().getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(node.getLevel() - 1)));
                mainQuery.getFilter().setMaskString("#0 or (#1 and #2)");
            } else {
                mainQuery.getFilter().setMaskString("#0 or #1");
            }
        } else if (!this.isIncludeAllChildren(request, context)) {
            mainQuery.getFilter().getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(1)));
        }
        this.getEntityViewInfo(request, mainQuery, context);
        if (defaultEntityViewInfo != null) {
            this.MergeCommonQuery(mainQuery, defaultEntityViewInfo, request, context);
        }
        if (this.getCurrentOrder(request, context) != null) {
            mainQuery.getSorter().add(this.getCurrentOrder(request, context));
        } else {
            mainQuery.getSorter().add(new SorterItemInfo(this.getLongNumberFieldName()));
        }
    }

    protected boolean isIncludeAllChildren(RequestContext request, Context context) throws Exception {
        return (Boolean)request.get("isIncludeAllChildren");
    }

    protected String getLongNumberFieldName() {
        return "longNumber";
    }

    protected TreeBaseInfo getSelectedTreeNode(RequestContext request, Context context) {
        return (TreeBaseInfo)request.get("selectedTreeNode");
    }

    @Override
    protected void _handleInit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleInit(request, response, context);
        this.initTree(request, context);
    }

    protected String getSelectedKeyValue(RequestContext request, Context context) throws Exception {
        return (String)request.get("selectedKeyValue");
    }

    protected ITreeBase getTreeInterface(RequestContext request, Context context) throws Exception {
        BOSObjectType bosType = (BOSObjectType)request.get("TreeCtrlBOSObjectType");
        if (bosType == null) {
            return null;
        }
        ITreeBase coreBase = (ITreeBase)BOSObjectFactory.createBOSObject((Context)context, (BOSObjectType)bosType);
        return coreBase;
    }

    @Override
    public void handleRemove(RequestContext request, ResponseContext response, Context context) throws Exception {
        TreeBaseInfo parent = (TreeBaseInfo)request.get("parentNode");
        if (request.get("selectedTreeNode") == null) {
            request.put("selectedTreeNode", parent);
        }
        request.put("NotBuildTreeFilter", "true");
        super.handleRemove(request, response, context);
        if (parent != null) {
            this.getBizInterface(request, context).exists((IObjectPK)new ObjectUuidPK(parent.getId()));
        }
        ITreeBase treeBase = this.getTreeInterface(request, context);
        DefaultLNTreeNodeCtrl ctrl = new DefaultLNTreeNodeCtrl(treeBase);
        int treeExpandLevel = (Integer)request.get("TreeExpandLevel");
        ctrl.getChildren(parent, treeExpandLevel, this.getDefaultFilterForTree(request, context));
    }

    @Override
    protected ResponseContext _tableRequestData(RequestContext request, ResponseContext response, Context context) throws Exception {
        if (!"true".equals(request.get("NotBuildTreeFilter"))) {
            this.buildTreeFilter(request, context);
        }
        return super._tableRequestData(request, response, context);
    }

    protected void initTree(RequestContext request, Context context) throws Exception {
        String keyValue;
        ITreeBase treeBase = this.getTreeInterface(request, context);
        if (treeBase == null) {
            return;
        }
        DefaultLNTreeNodeCtrl ctrl = new DefaultLNTreeNodeCtrl(treeBase);
        int treeInitialLevel = (Integer)request.get("TreeInitialLevel");
        int treeExpandLevel = (Integer)request.get("TreeExpandLevel");
        SelectorItemCollection selectorForTree = (SelectorItemCollection)request.get("selectorForTree");
        ctrl.getChildren(request.getRootInfo(), treeInitialLevel, this.getDefaultFilterForTree(request, context), selectorForTree);
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(this.getDefaultFilterForTree(request, context));
        ev.getSelector().add(new SelectorItemInfo("id"));
        treeBase.getAllChildren(null, ev);
        String selectNodeId = request.getSelectNodeId();
        if (selectNodeId != null) {
            this.getBizInterface(request, context).exists((IObjectPK)new ObjectUuidPK(selectNodeId));
        }
        if ((keyValue = this.getSelectedKeyValue(request, context)) != null) {
            treeBase.getTreeBaseInfo((IObjectPK)new ObjectUuidPK(keyValue));
        }
    }

    protected FilterInfo getDefaultFilterForTree(RequestContext request, Context context) throws Exception {
        FilterInfo info = (FilterInfo)request.get("treeDefaultFilter");
        if (info == null) {
            info = new FilterInfo();
        }
        return (FilterInfo)info.clone();
    }

    @Override
    protected void _handleActionRefresh(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionRefresh(request, response, context);
        this.initTree(request, context);
        String selectedKeyValue = this.getSelectedKeyValue(request, context);
        if (selectedKeyValue != null) {
            ITreeBase treeBase = this.getTreeInterface(request, context);
            DefaultLNTreeNodeCtrl ctrl = new DefaultLNTreeNodeCtrl(treeBase);
            TreeBaseInfo info = treeBase.getTreeBaseInfo((IObjectPK)new ObjectUuidPK(selectedKeyValue));
            int treeExpandLevel = (Integer)request.get("TreeExpandLevel");
            ctrl.getChildren(info, treeExpandLevel, this.getDefaultFilterForTree(request, context));
        }
    }

    @Override
    protected void _handleActionMoveTree(RequestContext request, ResponseContext response, Context context) throws Exception {
    }
}

