/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.framework.session.ISessionManager;
import com.kingdee.bos.framework.session.SessionInfo;
import com.kingdee.bos.framework.session.SessionListener;
import com.kingdee.bos.framework.session.SessionManager;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.AuthorizeTypeEnum;
import com.kingdee.eas.base.permission.IDSecondAuthorizeFactory;
import com.kingdee.eas.base.permission.IIDSecondAuthorize;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.service.helper.IPermissionParameter;
import com.kingdee.eas.base.permission.service.helper.PermissionParameterFactory;
import com.kingdee.eas.framework.app.BaseFrameService;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class UIHandlerPermissionHelper
implements SessionListener {
    private static final Logger logger = Logger.getLogger(UIHandlerPermissionHelper.class);

    private static Set functionSet(Context context) throws Exception {
        ISessionManager sessionManager = SessionManager.getInstance();
        SessionInfo session = sessionManager.getSessionWithException(context.getContextID());
        HashSet functionSet = (HashSet)session.get((Object)"hndFuncPerm");
        if (functionSet == null) {
            functionSet = new HashSet();
            session.put((Object)"hndFuncPerm", functionSet);
        }
        return functionSet;
    }

    private static Set fieldSet(Context context) throws Exception {
        ISessionManager sessionManager = SessionManager.getInstance();
        SessionInfo session = sessionManager.getSessionWithException(context.getContextID());
        HashSet filedSet = (HashSet)session.get((Object)"hndFieldPerm");
        if (filedSet == null) {
            filedSet = new HashSet();
            session.put((Object)"hndFieldPerm", filedSet);
        }
        return filedSet;
    }

    public static void clearCache(Context context) throws Exception {
        ISessionManager sessionManager = SessionManager.getInstance();
        SessionInfo session = sessionManager.getSessionWithException(context.getContextID());
        UIHandlerPermissionHelper.clearCache(session);
    }

    public static void clearCache(SessionInfo session) {
        Set filedSet;
        Set functionSet = (Set)session.get((Object)"hndFuncPerm");
        if (functionSet != null) {
            functionSet.clear();
        }
        if ((filedSet = (Set)session.get((Object)"hndFieldPerm")) != null) {
            filedSet.clear();
        }
    }

    public void create(String sessionID, SessionInfo session) {
        HashSet functionSet = (HashSet)session.get((Object)"hndFuncPerm");
        if (functionSet == null) {
            functionSet = new HashSet();
            session.put((Object)"hndFuncPerm", functionSet);
        }
    }

    public void destory(String sessionID, SessionInfo session) {
        UIHandlerPermissionHelper.clearCache(session);
    }

    public static void idAuthorize(Context context, String permissionItem, ResponseContext response) throws Exception {
        boolean iDAuthorizeEnabled = PermissionParameterFactory.getLocalInstance((Context)context).isIDAuthorizeEnabled();
        BaseFrameService.getMultiKey(response, IPermissionParameter.class, "isIDAuthorizeEnabled", null, null, new Boolean(iDAuthorizeEnabled));
        if (iDAuthorizeEnabled) {
            AuthorizeTypeEnum authorizeType = IDSecondAuthorizeFactory.getLocalInstance((Context)context).getAuthorizeType(permissionItem);
            BaseFrameService.getMultiKey(response, IIDSecondAuthorize.class, "getAuthorizeType", new Class[]{String.class}, new Object[]{permissionItem}, authorizeType);
            if (5 == authorizeType.getValue()) {
                IParamControl paramControl = ParamControlFactory.getLocalInstance((Context)context);
                String control = paramControl.getParamValue(null, "isPasswordIDAuthorizeEnabled");
                BaseFrameService.getMultiKey(response, IParamControl.class, "getParamValue", new Class[]{IObjectPK.class, String.class}, new Object[]{null, "isPasswordIDAuthorizeEnabled"}, control);
            }
        }
    }

    public static void checkFunctionPermission(Context context, IObjectPK userPK, IObjectPK orgPK, IMetaDataPK uiMedataPK, IMetaDataPK actionPK, String permItemName, boolean orgExtFromCtx) throws Exception {
        if (permItemName != null) {
            UIHandlerPermissionHelper.checkFunctionPermission(context, userPK, orgPK, permItemName, orgExtFromCtx);
        } else {
            UIHandlerPermissionHelper.checkFunctionPermission(context, userPK, orgPK, uiMedataPK, actionPK, orgExtFromCtx);
        }
    }

    private static void checkFunctionPermission(Context context, IObjectPK userPK, IObjectPK orgPK, String permItemName, boolean orgExtFromCtx) throws Exception {
        String keyStr = StringUtils.cnulls((Object)orgPK) + StringUtils.cnulls((String)permItemName) + orgExtFromCtx;
        if (!UIHandlerPermissionHelper.functionSet(context).contains(keyStr)) {
            IPermission iPermission = PermissionFactory.getLocalInstance((Context)context);
            iPermission.checkFunctionPermission(userPK, orgPK, null, null, permItemName, orgExtFromCtx);
            UIHandlerPermissionHelper.functionSet(context).add(keyStr);
        }
    }

    private static void checkFunctionPermission(Context context, IObjectPK userPK, IObjectPK orgPK, IMetaDataPK uiMedataPK, IMetaDataPK actionPK, boolean orgExtFromCtx) throws Exception {
        String keyStr = StringUtils.cnulls((Object)orgPK) + StringUtils.cnulls((Object)uiMedataPK) + StringUtils.cnulls((Object)actionPK) + orgExtFromCtx;
        if (!UIHandlerPermissionHelper.functionSet(context).contains(keyStr)) {
            IPermission iPermission = PermissionFactory.getLocalInstance((Context)context);
            iPermission.checkFunctionPermission(userPK, orgPK, uiMedataPK, actionPK, null, orgExtFromCtx);
            UIHandlerPermissionHelper.functionSet(context).add(keyStr);
        }
    }

    public static void getFieldPermission(Context context, BOSObjectType bizObjectType, IObjectPK userPK, IObjectPK orgPK) throws Exception {
        String keyStr = StringUtils.cnulls((Object)bizObjectType) + StringUtils.cnulls((Object)orgPK);
        if (!UIHandlerPermissionHelper.fieldSet(context).contains(keyStr)) {
            IPermission iPermission = PermissionFactory.getLocalInstance((Context)context);
            iPermission.getFieldPermission(bizObjectType, userPK, orgPK);
            UIHandlerPermissionHelper.fieldSet(context).add(keyStr);
        }
    }

    public static void getQueryFieldPermission(Context context, IMetaDataPK queryPK, IObjectPK userPK, IObjectPK orgPK) throws Exception {
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)context);
        iPermission.getQueryFieldPermission(queryPK, userPK, orgPK);
    }

    public static void getQueryFieldPermission(Context context, IMetaDataPK queryPK, IObjectPK userPK, List orgIdStrList) throws Exception {
        ArrayList<String> notCacheOrgList = new ArrayList<String>();
        for (int i = 0; i < orgIdStrList.size(); ++i) {
            String orgIdStr = (String)orgIdStrList.get(i);
            String keyStr = StringUtils.cnulls((Object)queryPK) + StringUtils.cnulls((String)orgIdStr);
            if (UIHandlerPermissionHelper.fieldSet(context).contains(keyStr)) continue;
            notCacheOrgList.add(orgIdStr);
        }
        if (notCacheOrgList != null && !notCacheOrgList.isEmpty()) {
            IPermission iPermission = PermissionFactory.getLocalInstance((Context)context);
            Map fieldPermissionMap = iPermission.getQueryFieldPermission(queryPK, userPK, notCacheOrgList);
            Set keySet = fieldPermissionMap.keySet();
            Iterator it = keySet.iterator();
            while (it.hasNext()) {
                String orgIdStr = StringUtils.cnulls((String)it.next().toString());
                UIHandlerPermissionHelper.fieldSet(context).add(StringUtils.cnulls((Object)queryPK) + orgIdStr);
            }
        }
    }

    static {
        SessionManager.addSessionListener((SessionListener)new UIHandlerPermissionHelper());
    }
}

