/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.query;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.eas.base.commonquery.BooleanEnum;
import com.kingdee.eas.base.commonquery.CompareSignBooleanEnum;
import com.kingdee.eas.base.commonquery.CompareSignDateEnum;
import com.kingdee.eas.base.commonquery.CompareSignEnumEnum;
import com.kingdee.eas.base.commonquery.CompareSignIntEnum;
import com.kingdee.eas.base.commonquery.CompareSignStringEnum;
import com.kingdee.eas.base.commonquery.client.CommonFilterUtil;
import com.kingdee.util.enums.DoubleEnum;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.FloatEnum;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.LongEnum;
import com.kingdee.util.enums.StringEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class CompareEnumUtility {
    private static final Set<StringEnum> DISABLED_ENUM_ITEMS = new HashSet<StringEnum>();
    private static Map<String, Object[]> enumLists;

    private CompareEnumUtility() {
    }

    public static String getCompareEnumClassNameByDateType(String dataType) {
        if (CommonFilterUtil.isEnumType((String)dataType)) {
            return CompareSignEnumEnum.class.getName();
        }
        if (CommonFilterUtil.isBooleanType((String)dataType)) {
            return CompareSignBooleanEnum.class.getName();
        }
        if (CommonFilterUtil.isDateType((String)dataType)) {
            return CompareSignDateEnum.class.getName();
        }
        if (CommonFilterUtil.isIntType((String)dataType)) {
            return CompareSignIntEnum.class.getName();
        }
        return CompareSignStringEnum.class.getName();
    }

    public static KDComboBox getSelectedEnumComboBox(String enumClassName, String selectedValue) {
        KDComboBox comboBox = CompareEnumUtility.getEnumComboBox(enumClassName);
        return CompareEnumUtility.getSelectedEnumComboBox(comboBox, selectedValue);
    }

    static KDComboBox getEnumComboBox(String enumClassName) {
        Object[] array;
        if (enumLists.containsKey(enumClassName)) {
            array = enumLists.get(enumClassName);
        } else {
            ArrayList list = new ArrayList();
            for (Object o : EnumUtils.getEnumList((String)enumClassName)) {
                if (DISABLED_ENUM_ITEMS.contains(o)) continue;
                list.add(o);
            }
            array = list.toArray();
            enumLists.put(enumClassName, array);
        }
        KDComboBox kdComboBox = new KDComboBox(array);
        kdComboBox.setMaximumRowCount(10);
        return kdComboBox;
    }

    static KDComboBox getSelectedEnumComboBox(KDComboBox comboBox, String selectedValue) {
        int count = comboBox.getItemCount();
        int selectedIndex = -1;
        for (int i = 0; i < count; ++i) {
            Object obj = comboBox.getItemAt(i);
            Object value = null;
            if (obj == null || !(obj instanceof Enum) || !(value = CompareEnumUtility.getEnumValue((Enum)obj)).toString().equalsIgnoreCase(selectedValue)) continue;
            selectedIndex = i;
            break;
        }
        comboBox.setSelectedIndex(selectedIndex);
        return comboBox;
    }

    static Object getEnumValue(Enum enumValue) {
        Object value = null;
        if (enumValue instanceof BooleanEnum) {
            value = new Integer(((IntEnum)enumValue).getValue());
        } else if (enumValue instanceof IntEnum) {
            value = new Integer(((IntEnum)enumValue).getValue());
        } else if (enumValue instanceof FloatEnum) {
            value = String.valueOf(((FloatEnum)enumValue).getValue());
        } else if (enumValue instanceof DoubleEnum) {
            value = String.valueOf(((DoubleEnum)enumValue).getValue());
        } else if (enumValue instanceof LongEnum) {
            value = String.valueOf(((LongEnum)enumValue).getValue());
        } else if (enumValue instanceof StringEnum) {
            value = ((StringEnum)enumValue).getValue();
        }
        return value;
    }

    static {
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignStringEnum.FIELDEQUAL);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignStringEnum.FIELDLARGE);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignStringEnum.FIELDLARGEEQUAL);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignStringEnum.FIELDLESS);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignStringEnum.FIELDLESSEQUAL);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignStringEnum.FIELDNOTEQUAL);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignDateEnum.FIELDEQUAL);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignDateEnum.FIELDLARGE);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignDateEnum.FIELDLARGEEQUAL);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignDateEnum.FIELDLESS);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignDateEnum.FIELDLESSEQUAL);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignDateEnum.FIELDNOTEQUAL);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignDateEnum.IN_X_DAYS_AFTER);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignDateEnum.IN_X_DAYS_BEFORE);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignDateEnum.IN_X_DAYS_EQUAL);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignDateEnum.X_DAYS_AGO_AFTER);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignDateEnum.X_DAYS_AGO_BEFORE);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignDateEnum.X_DAYS_AGO_EQUAL);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignIntEnum.FIELDEQUAL);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignIntEnum.FIELDLARGE);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignIntEnum.FIELDLARGEEQUAL);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignIntEnum.FIELDLESS);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignIntEnum.FIELDLESSEQUAL);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignIntEnum.FIELDNOTEQUAL);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignDateEnum.AFTERTODAY);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignDateEnum.BEFORETODAY);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignDateEnum.LASTMONTH);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignDateEnum.LASTWEEK);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignDateEnum.NEXTMONTH);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignDateEnum.NEXTWEEK);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignDateEnum.THISMONTH);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignDateEnum.THISWEEK);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignDateEnum.TODAY);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignDateEnum.TOMORROW);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignDateEnum.YESTERDAY);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignStringEnum.NULLSIGN);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignStringEnum.NOTNULLSIGN);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignDateEnum.NULLSIGN);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignDateEnum.NOTNULLSIGN);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignIntEnum.NULLSIGN);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignIntEnum.NOTNULLSIGN);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignStringEnum.LARGESIGN);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignStringEnum.LARGEEQUALSSIGN);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignStringEnum.SMALLSIGN);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignStringEnum.SMALLEQUALSSIGN);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignBooleanEnum.FIELDEQUAL);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignBooleanEnum.FIELDNOTEQUAL);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignBooleanEnum.NULLSIGN);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignBooleanEnum.NOTNULLSIGN);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignBooleanEnum.FALSE);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignEnumEnum.FIELDEQUAL);
        DISABLED_ENUM_ITEMS.add((StringEnum)CompareSignEnumEnum.FIELDNOTEQUAL);
        enumLists = new HashMap<String, Object[]>();
    }
}

