/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.query;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.framework.configuration.IConfiguration;
import com.kingdee.eas.framework.configuration.client.ClientConfiguationManager;
import com.kingdee.eas.framework.query.IQuickFilterReLayoutHandler;
import com.kingdee.eas.framework.query.QuickSearchItems;
import com.kingdee.eas.framework.query.SystemSolutionItem;
import com.kingdee.eas.framework.query.component.FixedPopupItem;
import com.kingdee.eas.framework.query.component.IListPopupItem;
import com.kingdee.eas.framework.query.resource.QuickFilterResources;
import com.kingdee.eas.framework.util.DateEnum;
import com.kingdee.eas.framework.util.FilterUtility;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class QuickFilteringSupportItems {
    private static Logger logger = Logger.getLogger(QuickFilteringSupportItems.class);
    boolean isNotSupportAny = true;
    boolean isSupportQuickSearch = false;
    boolean isSupportSolutionList = false;
    boolean isSupportNoRowsTips = true;
    boolean isSupportMultipleMainOrgs = true;
    SystemSolutionItem systemSolutionItem;
    private String bizDateField;
    private String bosType;
    private OrgUnitInfo defaultMainOrgInfo;
    private String bizOrgPropertyName;
    private LinkedList<IListPopupItem> dateRangePopupModel;
    private IMetaDataPK queryPK;
    private boolean isMustQueryAtFirst = false;
    private IQuickFilterReLayoutHandler quickFilterReLayoutHandler;
    private boolean isExecuteQueryWithoutFilters = true;
    private boolean isSupportOrgUnitFilter = true;
    public static final String DEFAULT_CUSTOMIZE = "CUSTOMIZE";
    private Object[] quickSearchConfigs;

    public void setQueryPK(IMetaDataPK queryPK) {
        this.queryPK = queryPK;
    }

    public QuickFilteringSupportItems() {
    }

    public void setBosType(String bosType) {
        this.bosType = bosType;
    }

    public String getBosType() {
        return this.bosType;
    }

    public SystemSolutionItem getSystemSolutionItem() {
        if (this.systemSolutionItem == null) {
            this.systemSolutionItem = new SystemSolutionItem(this);
        }
        return this.systemSolutionItem;
    }

    public String getBizDateField() {
        return this.bizDateField;
    }

    private void setBizDateField(String bizDateField) {
        this.bizDateField = bizDateField;
    }

    public QuickFilteringSupportItems supportSingleMainOrg() {
        this.isSupportMultipleMainOrgs = false;
        return this;
    }

    public QuickFilteringSupportItems supportSingleMainOrg(OrgUnitInfo defaultMainOrgInfo) {
        this.defaultMainOrgInfo = defaultMainOrgInfo;
        return this.supportSingleMainOrg();
    }

    public void setBizOrgPropertyName(String bizOrgPropertyName) {
        this.bizOrgPropertyName = bizOrgPropertyName;
    }

    public String getBizOrgPropertyName() {
        return this.bizOrgPropertyName;
    }

    OrgUnitInfo getDefaultMainOrgInfo() {
        return this.defaultMainOrgInfo;
    }

    public void setSupportNoRowsTips(boolean isSupportNoRowsTips) {
        this.isSupportNoRowsTips = isSupportNoRowsTips;
    }

    public boolean isSupportNoRowsTips() {
        return this.isSupportNoRowsTips;
    }

    public QuickFilteringSupportItems supportNoRowsTips(boolean isSupportNoRowsTips) {
        this.isSupportNoRowsTips = isSupportNoRowsTips;
        return this;
    }

    public QuickFilteringSupportItems(boolean isNotSupportAny) {
        this.isNotSupportAny = isNotSupportAny;
    }

    public QuickFilteringSupportItems(boolean isSupportQuickSearch, boolean isSupportSolutionList) {
        this.isSupportQuickSearch = isSupportQuickSearch;
        this.isSupportSolutionList = isSupportSolutionList;
        this.setNotSupportAny();
    }

    private void setNotSupportAny() {
        this.isNotSupportAny = !this.isSupportQuickSearch && !this.isSupportSolutionList;
    }

    public boolean isNotSupportAny() {
        return this.isNotSupportAny;
    }

    public boolean isSupportQuickSearch() {
        return this.isSupportQuickSearch;
    }

    public void setSupportQuickSearch(boolean isSupportQuickSearch) {
        this.isSupportQuickSearch = isSupportQuickSearch;
        this.setNotSupportAny();
    }

    public boolean isSupportSolutionList() {
        return this.isSupportSolutionList;
    }

    public void setSupportSolutionList(boolean isSupportSolutionList) {
        this.isSupportSolutionList = isSupportSolutionList;
        this.setNotSupportAny();
    }

    public LinkedList<IListPopupItem> getDateRangePopupModel() {
        if (this.dateRangePopupModel == null) {
            this.initDateRangePopupModel();
        }
        return this.dateRangePopupModel;
    }

    public Object[] getQuickSearchConfigs() {
        if (this.quickSearchConfigs == null) {
            try {
                this.quickSearchConfigs = new QuickSearchItems().getDefaultQuickSearchItems(this.queryPK);
                this.setBizDateField((String)this.quickSearchConfigs[2]);
            }
            catch (BOSException e) {
                logger.error((Object)"getQuickSearchConfigs error", (Throwable)e);
            }
        }
        return this.quickSearchConfigs;
    }

    private void addFilter(String tit, DateEnum dataEnum) {
        String itemTitle = QuickFilterResources.getMessage(tit);
        FixedPopupItem item = new FixedPopupItem(null, itemTitle, FilterUtility.createFilterByDate(this.getBizDateField(), null, dataEnum));
        this.dateRangePopupModel.add(item);
    }

    private boolean canAddFilter(String filterConfig) {
        IConfiguration config = ClientConfiguationManager.getConfiguation((String)"bos");
        return config.getBoolean(filterConfig, false);
    }

    private void initDateRangePopupModel() {
        this.dateRangePopupModel = new LinkedList();
        Object item = null;
        if (this.canAddFilter("easframework.quickfilter.showrecentoneweek")) {
            this.addFilter("RECENTONEWEEK", DateEnum.RECENTONEWEEK);
        }
        if (this.canAddFilter("easframework.quickfilter.showrecentonemonth")) {
            this.addFilter("ONEMONTH", DateEnum.RECENTONEMONTH);
        }
        this.addFilter("THREEMONTHS", DateEnum.RECENTTHREEMONTHS);
        this.addFilter("HALFYEAR", DateEnum.RECENTHALFYEAR);
        this.addFilter("ONEYEAR", DateEnum.RECENTONEYEAR);
        this.addFilter(DEFAULT_CUSTOMIZE, DateEnum.CUSTOMIZE);
    }

    public boolean isMustQueryAtFirst() {
        return this.isMustQueryAtFirst;
    }

    public void setMustQueryAtFirst(boolean isMustQueryAtFirst) {
        this.isMustQueryAtFirst = isMustQueryAtFirst;
    }

    public IQuickFilterReLayoutHandler getQuickFilterReLayoutHandler() {
        return this.quickFilterReLayoutHandler;
    }

    public void setQuickFilterReLayoutHandler(IQuickFilterReLayoutHandler quickFilterReLayoutHandler) {
        this.quickFilterReLayoutHandler = quickFilterReLayoutHandler;
    }

    public boolean isExecuteQueryWithoutFilters() {
        return this.isExecuteQueryWithoutFilters;
    }

    public QuickFilteringSupportItems supportExecutionWithoutFilters() {
        this.isExecuteQueryWithoutFilters = true;
        return this;
    }

    public QuickFilteringSupportItems notSupportMainOrgUnitFilter() {
        this.isSupportOrgUnitFilter = false;
        return this;
    }

    public boolean isSupportOrgUnitFilter() {
        return this.isSupportOrgUnitFilter;
    }
}

