/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.datasource.DSParam;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.framework.print.IMultiapproveDataFilter;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class MultiapproveDataProvider
implements BOSQueryDelegate {
    private static final Logger logger = Logger.getLogger((String)MultiapproveDataProvider.class.getName());
    private static final String MULTIAPPROVE_QUERY_METADATAPK = "com.kingdee.eas.base.multiapprove.app.MultiApproveQuery";
    private static final String MULTIAPPROVE_HISTORY_QUERY_METADATAPK = "com.kingdee.eas.base.multiapprove.app.MultiapproveHstQuery";
    private static final String MULTIAPPROVE_PRINT_SHOW_HISTORY = "showHistory";
    private static final String MULTIAPPROVE_PRINT_PARAM_BILLID = "billId";
    private Set ids = null;
    private boolean showHistory = false;
    private Object paramBillIdValue;
    private String paramName = "billId";
    private IMultiapproveDataFilter multiapproveDataFilter = null;

    public MultiapproveDataProvider(List id, boolean needShowHistory, String paramName) {
        this.ids = new HashSet(id);
        this.showHistory = needShowHistory;
        this.paramName = paramName;
    }

    public MultiapproveDataProvider(List id, boolean needShowHistory) {
        this.ids = new HashSet(id);
        this.showHistory = needShowHistory;
    }

    public MultiapproveDataProvider(Set id, boolean needShowHistory) {
        this.ids = id;
        this.showHistory = needShowHistory;
    }

    public MultiapproveDataProvider(Set id, boolean needShowHistory, String paramName) {
        this.ids = id;
        this.showHistory = needShowHistory;
        this.paramName = paramName;
    }

    private void retrieveParameterFromDataSourceParams(BOSQueryDataSource ds) {
        ArrayList params = ds.getParams();
        if (params != null && params.size() > 0) {
            for (int i = 0; i < params.size(); ++i) {
                DSParam param = (DSParam)params.get(i);
                if (MULTIAPPROVE_PRINT_SHOW_HISTORY.equalsIgnoreCase(param.getColName()) && param.getValue() != null && param.getValue().getValue() != null && "true".equalsIgnoreCase(param.getValue().getValue().toString())) {
                    this.showHistory = true;
                    continue;
                }
                if (!MULTIAPPROVE_PRINT_PARAM_BILLID.equalsIgnoreCase(param.getColName()) || param.getValue() == null || param.getValue().getValue() == null) continue;
                this.paramBillIdValue = param.getValue().getValue();
            }
        }
    }

    private EntityViewInfo getMultiapproveEntityView() {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1)));
        if (this.paramBillIdValue != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo(this.paramName, this.paramBillIdValue, CompareType.EQUALS));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo(this.paramName, (Object)this.ids, CompareType.INCLUDE));
        }
        entityViewInfo.setFilter(filterInfo);
        return entityViewInfo;
    }

    private IRowSet executeQuery(String queryPkString) throws BOSException {
        EntityViewInfo entityViewInfo = this.getMultiapproveEntityView();
        MetaDataPK queryMultiApproveQueryPK = new MetaDataPK(queryPkString);
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryMultiApproveQueryPK);
        exec.option().isAutoTranslateEnum = true;
        exec.setObjectView(entityViewInfo);
        return exec.executeQuery();
    }

    private IRowSet mergeRowSet(IRowSet currentRowSet, IRowSet historyRowSet) throws Exception {
        if (currentRowSet == null || currentRowSet.size() <= 0) {
            return historyRowSet;
        }
        if (historyRowSet == null || historyRowSet.size() <= 0) {
            return currentRowSet;
        }
        Collection col = historyRowSet.toCollection();
        for (Vector row : col) {
            currentRowSet.moveToInsertRow();
            for (int i = 0; i < row.size(); ++i) {
                currentRowSet.updateObject(i + 1, row.get(i));
            }
            currentRowSet.insertRow();
        }
        currentRowSet.beforeFirst();
        return currentRowSet;
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        this.retrieveParameterFromDataSourceParams(ds);
        IRowSet iRowSet = null;
        try {
            IRowSet currentRowSet = this.executeQuery(MULTIAPPROVE_QUERY_METADATAPK);
            if (currentRowSet.size() > 0 && !this.showHistory) {
                iRowSet = currentRowSet;
            } else if (currentRowSet.size() <= 0 || currentRowSet.size() > 0 && this.showHistory) {
                IRowSet historyRowSet = this.executeQuery(MULTIAPPROVE_HISTORY_QUERY_METADATAPK);
                iRowSet = this.mergeRowSet(currentRowSet, historyRowSet);
            }
            if (this.multiapproveDataFilter != null) {
                iRowSet = this.multiapproveDataFilter.filtrateMultiapproveData(iRowSet);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return iRowSet;
    }

    public IMultiapproveDataFilter getMultiapproveDataFilter() {
        return this.multiapproveDataFilter;
    }

    public void setMultiapproveDataFilter(IMultiapproveDataFilter multiapproveDataFilter) {
        this.multiapproveDataFilter = multiapproveDataFilter;
    }
}

