/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.exception;

import com.kingdee.lightapp.exception.enums.WorkflowError;
import java.lang.reflect.Field;
import java.util.HashMap;

public class WorkflowException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private WorkflowError iErrorCode;
    private String errorCode;
    private String errorMessage;
    private String errorDetail;
    private String errorUrl;

    public WorkflowException(WorkflowError iErrorCode) {
        super(iErrorCode.getErrorMessage());
        this.iErrorCode = iErrorCode;
        this.errorCode = iErrorCode.getErrorCode();
        this.errorMessage = iErrorCode.getErrorMessage();
        this.errorDetail = iErrorCode.getErrorDetail();
    }

    public WorkflowException(WorkflowError iErrorCode, String errorUrl, String moreDetail) {
        super(iErrorCode.getErrorMessage());
        this.iErrorCode = iErrorCode;
        this.errorCode = iErrorCode.getErrorCode();
        this.errorMessage = iErrorCode.getErrorMessage();
        this.errorDetail = iErrorCode.getErrorDetail() + (moreDetail == null ? "" : moreDetail);
        this.errorUrl = errorUrl;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getErrorDetail() {
        return this.errorDetail;
    }

    public String getErrorUrl() {
        return this.errorUrl;
    }

    public WorkflowError getWorkflowError() {
        return this.iErrorCode;
    }

    public HashMap<String, Object> toInfoMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            Class<?> cls = this.getClass();
            Field[] fields = cls.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field f = fields[i];
                f.setAccessible(true);
                if ("serialVersionUID".equals(f.getName()) || "iErrorCode".equals(f.getName())) continue;
                hashMap.put(f.getName(), f.get(this));
            }
        }
        catch (Exception e) {
            hashMap.put("errorCode", "EAS_E0001");
            hashMap.put("errorMessage", "EAS\u5185\u90e8\u51fa\u9519");
            hashMap.put("errorDetail", "EAS\u9519\u8bef\u4fe1\u606f\u8f6c\u6362\u5f02\u5e38");
            System.out.println("EAS\u9519\u8bef\u4fe1\u606f\u8f6c\u6362\u5f02\u5e38" + e.getMessage());
        }
        return hashMap;
    }
}

