/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.filter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.lightapp.util.AppAuth2;
import com.kingdee.lightapp.util.StringUtil;
import com.kingdee.lightapp.xt.XTServiceConfig;
import com.kingdee.util.StringUtils;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;

public class DeployTestUtil {
    public static Map check(HttpServletRequest httpRequest, ServletResponse response) {
        String eid = httpRequest.getParameter("eid");
        HashMap<String, String> map = new HashMap<String, String>();
        String time = DeployTestUtil.checkTime();
        map.put("time", time);
        XTServiceConfig cfg = XTServiceConfig.getInstance();
        int type = cfg.getDbType(eid);
        String aix = cfg.getDbCode(eid);
        map.put("aix", aix);
        String geteid = XTServiceConfig.getInstance().getEidByDbCode(aix);
        map.put("geteid", geteid);
        String appId = "10036";
        String secret = cfg.getAppSecret(appId);
        if (StringUtils.isEmpty((String)secret)) {
            map.put("hasappid", "false");
        } else {
            String mcloudHost = "";
            try {
                mcloudHost = cfg.getXTMcloudUrl();
                boolean mcloudLink = DeployTestUtil.checkMcloud(httpRequest, mcloudHost, appId, secret);
                map.put("checkMcloud", String.valueOf(mcloudLink));
            }
            catch (Exception e) {
                map.put("checkMcloud", "false");
            }
        }
        return map;
    }

    public static boolean checkMcloud(HttpServletRequest httpRequest, String mcloudHost, String appId, String secret) throws Exception {
        String url = mcloudHost + "/openauth2/api/token?grant_type=client_credential&appid=" + appId + "&secret=" + secret;
        String response = DeployTestUtil.getMessage(httpRequest, url, appId, secret);
        String accessToken = "";
        if (StringUtil.isNotEmpty(response)) {
            try {
                JSONObject jsonObj = JSON.parseObject((String)response);
                if (jsonObj != null) {
                    JSONObject obj = jsonObj;
                    accessToken = obj.getString("access_token");
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return !StringUtils.isEmpty((String)accessToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getMessage(HttpServletRequest httpRequest, String surl, String appid, String secret) throws Exception {
        secret = XTServiceConfig.getInstance().getAppSecret(appid);
        String response = null;
        HttpClient http = new HttpClient();
        GetMethod get = null;
        try {
            get = new GetMethod(surl);
            http.setConnectionTimeout(5000);
            http.setTimeout(5000);
            String headerValue = AppAuth2.appAuth2Treaty(httpRequest, appid, secret);
            get.setRequestHeader("authorization", headerValue);
            http.executeMethod((HttpMethod)get);
            response = new String(get.getResponseBodyAsString().getBytes("UTF-8"));
        }
        finally {
            get.releaseConnection();
        }
        return response;
    }

    private static String checkTime() {
        Date date = new Date();
        DateFormat d = DateFormat.getDateInstance();
        String str = d.format(date);
        return str;
    }
}

