/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.xt;

import com.kingdee.bos.Context;
import com.kingdee.lightapp.pa.PubAcctController;
import com.kingdee.lightapp.pa.api.IMessageAdapter;
import com.kingdee.lightapp.util.StringUtil;
import com.kingdee.lightapp.xt.XTServiceConfig;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class XTServiceFacade {
    protected static XTServiceFacade instance = new XTServiceFacade();

    protected XTServiceFacade() {
        System.setProperty("xt.properties.dir", System.getProperty("eas.properties.dir") + "/mobile");
    }

    public static XTServiceFacade getInstance() {
        return instance;
    }

    public static Map pushMessageNew(Context ctx, IMessageAdapter adapter, String pubAcctName) {
        return XTServiceFacade.pushMessage(ctx, adapter, pubAcctName, false);
    }

    public static boolean pushMessage(Context ctx, IMessageAdapter adapter, String pubAcctName) {
        Map map = XTServiceFacade.pushMessage(ctx, adapter, pubAcctName, false);
        return (Boolean)map.get("bResult");
    }

    private static Map pushMessage(Context ctx, IMessageAdapter adapter, String pubAcctName, boolean toAllUser) {
        String refrenceInfo = "";
        Map<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("bResult", false);
        System.out.println("XTServiceFacade == pushMessage single message");
        if (!XTServiceFacade.isPubEnabled(ctx, pubAcctName)) {
            refrenceInfo = "Pub Enabled is disabled!";
            System.out.println("XTServiceFacade == pushMessage single message refrenceInfo===" + refrenceInfo);
            return map;
        }
        String pubAcctCode = XTServiceFacade.getPubAcctCode(ctx, pubAcctName);
        if (!StringUtil.isEmpty(pubAcctCode)) {
            map = PubAcctController.pushNew(ctx, adapter, pubAcctCode, XTServiceFacade.getPubKey(ctx, pubAcctName), "0", toAllUser);
            refrenceInfo = PubAcctController.getRefrenceInfo();
        } else {
            refrenceInfo = "public account[" + pubAcctName + "] push function was disabled";
        }
        System.out.println("XTServiceFacade == pushMessage single message refrenceInfo2===" + refrenceInfo);
        return map;
    }

    public static Map pushMessageToAll(Context ctx, IMessageAdapter adapter, String pubAcctName) {
        return XTServiceFacade.pushMessage(ctx, adapter, pubAcctName, true);
    }

    public static Map<String, Object> pushMessage(Context ctx, List<IMessageAdapter> list, String pubAcctName) {
        return XTServiceFacade.pushMessage(ctx, list, pubAcctName, false);
    }

    public static Map<String, Object> pushWithToken(Context ctx, List<IMessageAdapter> list, String pubAcctName) {
        return XTServiceFacade.pushWithToken(ctx, list, pubAcctName, false);
    }

    private static Map<String, Object> pushWithToken(Context ctx, List<IMessageAdapter> list, String pubAcctName, boolean toAllUser) {
        boolean bResult = false;
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("bResult", false);
        if (!XTServiceFacade.isPubEnabled(ctx, pubAcctName)) {
            map.put("errorcode", "1");
            map.put("errormsg", "PubEnabled");
            return map;
        }
        String pubCode = XTServiceFacade.getPubAcctCode(ctx, pubAcctName);
        String pubKey = XTServiceFacade.getPubKey(ctx, pubAcctName);
        if (!StringUtil.isEmpty(pubCode) && !StringUtil.isEmpty(pubKey)) {
            map = PubAcctController.pushWithToken(ctx, list, pubCode, pubKey, "0", toAllUser);
            if (Boolean.parseBoolean(XTServiceConfig.getInstance().getPubClean(XTServiceFacade.getDbMapProperty(ctx), pubAcctName))) {
                Iterator<IMessageAdapter> iterator = list.iterator();
                while (iterator.hasNext()) {
                    iterator.next().clearTemporary();
                }
            }
            return map;
        }
        map.put("errorcode", "2");
        map.put("errormsg", pubAcctName + "disabled");
        return map;
    }

    private static Map<String, Object> pushMessage(Context ctx, List<IMessageAdapter> list, String pubAcctName, boolean toAllUser) {
        String refrenceInfo = "";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bResult", false);
        System.out.println("XTServiceFacade == pushMessage  message list");
        if (!XTServiceFacade.isPubEnabled(ctx, pubAcctName)) {
            map.put("errorcode", "1");
            map.put("errormsg", "PubEnabled");
            refrenceInfo = "Pub Enabled is disabled!";
            System.out.println("XTServiceFacade == pushMessage  message list refrenceInfo==" + refrenceInfo);
            return map;
        }
        String pubAcctCode = XTServiceFacade.getPubAcctCode(ctx, pubAcctName);
        if (!StringUtil.isEmpty(pubAcctCode)) {
            map = PubAcctController.pushNew(ctx, list, pubAcctCode, XTServiceFacade.getPubKey(ctx, pubAcctName), "0", toAllUser);
            refrenceInfo = PubAcctController.getRefrenceInfo();
            if (Boolean.parseBoolean(XTServiceConfig.getInstance().getPubClean(XTServiceFacade.getDbMapProperty(ctx), pubAcctName))) {
                Iterator<IMessageAdapter> iterator = list.iterator();
                while (iterator.hasNext()) {
                    iterator.next().clearTemporary();
                }
            }
        } else {
            map.put("errorcode", "2");
            map.put("errormsg", pubAcctName + "disabled");
            refrenceInfo = "public account[" + pubAcctName + "] push function was disabled";
        }
        System.out.println("XTServiceFacade == pushMessage  message list refrenceInfo2==" + refrenceInfo);
        return map;
    }

    public static Map pushMessageToAll(Context ctx, List<IMessageAdapter> list, String pubAcctName) {
        return XTServiceFacade.pushMessage(ctx, list, pubAcctName, true);
    }

    public static Map<String, Object> pushFlowCenterMessage(Context ctx, List<IMessageAdapter> list, String pubAcctName) {
        return PubAcctController.pushFlowCenterMessage(ctx, list);
    }

    public static Map<String, Object> pushflowcenterReadNotice(Context ctx, IMessageAdapter adapter, String pubAcctName) {
        return PubAcctController.pushflowcenterReadNotice(ctx, adapter);
    }

    private static String getPubAcctCode(Context ctx, String pubAcctName) {
        String pubAcctCode = "";
        if (XTServiceFacade.isPubEnabled(ctx, pubAcctName)) {
            pubAcctCode = XTServiceConfig.getInstance().getPubCode(XTServiceFacade.getDbMapProperty(ctx), pubAcctName);
        }
        return pubAcctCode;
    }

    private static String getDbMapProperty(Context ctx) {
        String ais = ctx.getAIS();
        return XTServiceConfig.getInstance().getEidByDbCode(ais);
    }

    public static String getPubKey(Context ctx, String pubAcctName) {
        return XTServiceConfig.getInstance().getPubKey(XTServiceFacade.getDbMapProperty(ctx), pubAcctName);
    }

    private static boolean isPubEnabled(Context ctx, String pubAcctName) {
        return XTServiceConfig.getInstance().getPubEnabled(XTServiceFacade.getDbMapProperty(ctx), pubAcctName);
    }
}

