/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.xt;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.lightapp.pa.IMessagePusher;
import com.kingdee.lightapp.pa.MessageModelEnum;
import com.kingdee.lightapp.pa.api.IMessageAdapter;
import com.kingdee.lightapp.xt.XTServiceFacade;
import com.kingdee.lightapp.xt.YZJFlowCenterMouldHandler;
import com.kingdee.util.StringUtils;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class YZJFlowCenterPusher
implements IMessagePusher {
    private final Logger logger = Logger.getLogger(YZJFlowCenterPusher.class);
    private String messageType;

    public YZJFlowCenterPusher(String messageType) {
        this.messageType = messageType;
    }

    @Override
    public Map<String, Object> pushMessage(Context ctx, List<IMessageAdapter> messageList) {
        Map<String, Object> reMap;
        MessageModelEnum model;
        boolean pushToFlowCenter = false;
        if (messageList != null && messageList.size() > 0 && MessageModelEnum.FLOWCENTERTODO.equals((Object)(model = messageList.get(0).getModel()))) {
            pushToFlowCenter = true;
        }
        if (pushToFlowCenter) {
            reMap = XTServiceFacade.pushFlowCenterMessage(ctx, messageList, "WFMessage");
            reMap = this.checkShouldInitAndReSend(ctx, messageList, reMap);
            this.saveResult(ctx, "1", messageList, reMap);
        } else {
            reMap = XTServiceFacade.pushWithToken(ctx, messageList, "WFMessage");
            this.saveResult(ctx, "0", messageList, reMap);
        }
        return null;
    }

    private Map<String, Object> checkShouldInitAndReSend(Context ctx, List<IMessageAdapter> messageList, Map<String, Object> reMap) {
        try {
            if ("1101030".equals(reMap.get("errorCode")) || reMap.get("errormsg") != null && reMap.get("errormsg").toString().indexOf("\u4e1a\u52a1\u6a21\u677f\u8fd8\u672a\u521d\u59cb\u5316") > -1) {
                String billID = (String)messageList.get(0).getContent().get("billID");
                YZJFlowCenterMouldHandler.getInstance().makeReinitMouldFlag(ctx, billID);
                reMap = XTServiceFacade.pushFlowCenterMessage(ctx, messageList, "WFMessage");
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("reinit lowCenterMould failed" + e.getMessage()));
        }
        return reMap;
    }

    @Override
    public Map<String, Object> pushNoitceMessage(Context ctx, List<IMessageAdapter> messageList) {
        Map<String, Object> re = null;
        for (IMessageAdapter messageAdapter : messageList) {
            if (MessageModelEnum.FLOWCENTERREAD.equals((Object)messageAdapter.getModel())) {
                re = XTServiceFacade.pushflowcenterReadNotice(ctx, messageAdapter, "WFMessage");
                this.saveResult(ctx, "2", messageList, re);
                continue;
            }
            if (MessageModelEnum.FLOWCENTERNOTICE.equals((Object)messageAdapter.getModel())) {
                re = XTServiceFacade.pushWithToken(ctx, messageList, "WFMessage");
                this.saveResult(ctx, "3", messageList, re);
                continue;
            }
            re = XTServiceFacade.pushMessage(ctx, messageList, "WFMessage");
        }
        return null;
    }

    private void saveResult(Context ctx, String pushType, List<IMessageAdapter> messageList, Map<String, Object> reMap) {
        IMessageAdapter todoMessage = messageList.get(0);
        Map<String, Object> content = todoMessage.getContent();
        String receiver = (String)content.get("receiver");
        String userid = "";
        try {
            IUser user = UserFactory.getLocalInstance((Context)ctx);
            UserInfo userInfo = (UserInfo)user.getValue((IObjectPK)new ObjectStringPK(receiver));
            userid = userInfo.getId().toString();
        }
        catch (Exception e) {
            this.logger.error((Object)"XT Messages UserInfo get failed!", (Throwable)e);
        }
        String success = "";
        if (reMap.get("success") != null) {
            success = String.valueOf(reMap.get("success"));
        }
        String msg = (String)reMap.get("remessage");
        String msgId = (String)reMap.get("sourceMsgId");
        String assignid = (String)content.get("assignId");
        msg = StringUtils.isEmpty((String)msg) ? (String)reMap.get("errormsg") : msg;
        String errorcode = reMap.get("errorCode") != null ? String.valueOf(reMap.get("errorCode")) : "";
        errorcode = errorcode != null && errorcode.length() > 2000 ? errorcode.substring(0, 1900) : errorcode;
        try {
            String procinstid = (String)reMap.get("procinstid");
            if (!StringUtils.isEmpty((String)msgId) && !"".equals(assignid) && "true".equals(success)) {
                String sql = " insert into t_assign_xtmsg(msgid,fassignid,fuserid,procinstid,pushtype) values(?,?,?,?,?)";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{msgId, assignid, userid, procinstid, pushType});
            } else if (!"true".equals(success) && !"".equals(assignid)) {
                String sql = " insert into t_assign_xtmsgerror(msgid,fassignid,fuserid,errorcode,errormsg,pushtype,sendtime) values(?,?,?,?,?,?,getdate())";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{assignid, assignid, userid, errorcode, msg, pushType});
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("save xtmsg2 error:" + e.getMessage()));
        }
    }
}

