/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.base.license;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.LicenseUserInfo;
import com.kingdee.eas.base.license.agent.LicenseSrvAgent;
import com.kingdee.eas.base.reportmeta.base.license.EXTLicenseException;
import com.kingdee.eas.base.reportmeta.base.license.ILicenseChecker;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.Date;
import org.apache.log4j.Logger;

public class ReportCenterLicenseSrvChecker
implements ILicenseChecker {
    private String _module;
    private Context _ctx;
    private static Logger _log = Logger.getLogger(ReportCenterLicenseSrvChecker.class);
    private static ILicenseSrvAgent _agent;
    private LicenseUserInfo _userInfo;

    public ReportCenterLicenseSrvChecker(String module, Context ctx) {
        this._module = module;
        this._ctx = ctx;
        this._userInfo = this.getLicenseUserInfo();
    }

    private static ILicenseSrvAgent getLicenseAgent() throws EXTLicenseException {
        if (_agent == null) {
            try {
                _agent = LicenseSrvAgent.getLocalInstance();
            }
            catch (LicenseException e) {
                _log.error((Object)"\u670d\u52a1\u7aef\u5c1d\u8bd5\u83b7\u5f97License\u4ee3\u7406\u5931\u8d25", (Throwable)e);
                throw EXTLicenseException.wrap((Exception)((Object)e));
            }
        }
        return _agent;
    }

    public boolean checkLicense() throws EXTLicenseException {
        try {
            int flag = ReportCenterLicenseSrvChecker.getLicenseAgent().requestLicense(this._userInfo, this._module);
            switch (flag) {
                case 4: {
                    throw EXTLicenseException.REQUEST_INVALID_EXCEPTION;
                }
                case 2: {
                    throw EXTLicenseException.REQUEST_NO_SURPLUS_EXCEPTION;
                }
                case 1: {
                    return true;
                }
            }
        }
        catch (LicenseException e) {
            _log.error((Object)"EXT: \u670d\u52a1\u7aefCheck License\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            EXTLicenseException.wrap((Exception)((Object)e));
        }
        return false;
    }

    public boolean releaseLicense() throws EXTLicenseException {
        try {
            ReportCenterLicenseSrvChecker.getLicenseAgent().releaseLicense(this._ctx.getContextID(), this._module);
            return true;
        }
        catch (LicenseException e) {
            _log.error((Object)"EXT:\u670d\u52a1\u7aef\u91ca\u653eLicense\u5931\u8d25", (Throwable)e);
            throw EXTLicenseException.wrap((Exception)((Object)e));
        }
    }

    public void setContext(Context ctx) {
        this._ctx = ctx;
        this._userInfo = this.getLicenseUserInfo();
    }

    private LicenseUserInfo getLicenseUserInfo() {
        LicenseUserInfo info = new LicenseUserInfo();
        info.setSessionID(this._ctx.getContextID());
        info.setUserID(this._ctx.getCaller().toString());
        info.setUserIP(this._ctx.getClientHostIP());
        info.setUserLoginAis(this._ctx.getAIS());
        info.setUserName(this._ctx.getUserName());
        info.setUserLoginTime(new Date());
        OrgUnitInfo info2 = ContextUtil.getCurrentOrgUnit((Context)this._ctx);
        if (info2 != null) {
            info.setUserCompany(info2.getName());
        }
        return info;
    }

    public String getModule() {
        return this._module;
    }

    public void setModule(String module) {
        this._module = module;
    }
}

