/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlreport.adapter;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.reportmeta.ctrlreport.adapter.IFilter;
import com.kingdee.eas.base.reportmeta.ctrlreport.adapter.TreeManager;
import com.kingdee.eas.base.reportmeta.ctrlreport.client.CtrlReportDiscreteDataSelector;
import com.kingdee.eas.base.reportmeta.ctrlreport.client.DeployBatchUI;
import com.kingdee.eas.base.reportmeta.ctrlreport.client.DeploySelectedUI;
import com.kingdee.eas.base.reportmeta.ctrlreport.client.EditBatchUI;
import com.kingdee.eas.base.reportmeta.ctrlreport.client.EnumFilterUI;
import com.kingdee.eas.base.reportmeta.ctrlreport.client.ExtReportFilterUI;
import com.kingdee.eas.base.reportmeta.ctrlreport.client.ExtReportLicenseListUI;
import com.kingdee.eas.base.reportmeta.ctrlreport.client.ReportAttemperFilterUI;
import com.kingdee.eas.base.reportmeta.ctrlreport.client.ReportAttemperListUI;
import com.kingdee.eas.base.reportmeta.ctrlreport.client.ReportAttemperSetupUI;
import com.kingdee.eas.base.reportmeta.ctrlreport.client.ReportDialog;
import com.kingdee.eas.base.reportmeta.ctrlreport.client.ReportSanpFilterUI;
import com.kingdee.eas.base.reportmeta.ctrlreport.client.SQLFilterUI;
import com.kingdee.eas.base.reportmeta.ctrlreport.client.SelectedReportSingleUI;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.ExtCallbackImpl;
import com.kingdee.eas.base.reportmeta.ctrlreport.sql.CollectWhere;
import com.kingdee.eas.base.reportmeta.ctrlreport.util.MessageUtil;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.factory.FacadeFactory;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.CtrlDesignUtil;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.ExtDBUtil;
import com.kingdee.eas.base.reportmeta.snapshot.dispatch.client.SelectPermTemplateUI;
import com.kingdee.eas.base.reportmeta.sumreport.util.EASUtil;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptParams;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class ExtReportFilterManager {
    private static Logger logger = LogUtil.getPackageLogger(ExtReportFilterManager.class);
    IFilter reportUI;
    String tableFlagOld;
    private ExtReportFilterUI reportFilterUI = null;
    private SQLFilterUI sQLFilterUI = null;
    private EnumFilterUI enumFilterUI = null;
    private ReportSanpFilterUI snapFilterUI = null;
    private ReportAttemperFilterUI reportAttemperFilterUI = null;
    private HashMap params;
    private String node;
    private boolean isSys = true;

    public void setNode(String node) {
        this.node = node;
    }

    public void setSys(boolean isSys) {
        this.isSys = isSys;
    }

    public ExtReportFilterManager(IFilter reportUI) {
        this.reportUI = reportUI;
    }

    public ExtReportFilterManager(IFilter reportUI, boolean isSys, String node) {
        this.reportUI = reportUI;
        this.isSys = isSys;
        this.node = node;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean filte(boolean isRefresh) {
        try {
            if (this.reportUI instanceof ExtReportLicenseListUI) {
                return this.filteLicenseReport(isRefresh);
            }
            if (this.reportUI instanceof ReportAttemperListUI) {
                return this.filteAttemperReport(isRefresh);
            }
            String tableFlag = this.reportUI.getTableFlag();
            if (tableFlag.equals("1")) {
                if (this.reportUI instanceof DeploySelectedUI) {
                    DeploySelectedUI ds = (DeploySelectedUI)this.reportUI;
                    if (ds.getUiFlag().equals(EditBatchUI.class.getName())) {
                        return this.filteReport(isRefresh);
                    }
                    if (ds.getUiFlag().equals(DeployBatchUI.class.getName())) {
                        this.filteDeployReport(isRefresh);
                        return true;
                    }
                    if (ds.getUiFlag().equals(CtrlReportDiscreteDataSelector.class.getName())) {
                        this.filteDiscreteReport(isRefresh);
                        return true;
                    }
                    if (!ds.getUiFlag().equals("StdProductF7UI")) return true;
                    this.filteStdReport(isRefresh);
                    return true;
                }
                if (!(this.reportUI instanceof SelectedReportSingleUI)) {
                    if (!(this.reportUI instanceof SelectPermTemplateUI)) return this.filteReport(isRefresh);
                    return this.filteReportForDispatch(isRefresh);
                }
                SelectedReportSingleUI ds = (SelectedReportSingleUI)this.reportUI;
                if (ds.getUiFlag().equals(ReportAttemperSetupUI.class.getName())) {
                    this.filteSelectedAttemperReport(isRefresh);
                    return true;
                }
                if (!ds.getUiFlag().equals(ExtCallbackImpl.class.getName())) {
                    if (!ds.getUiFlag().equals("SnapF7UI")) return true;
                }
                this.filteReport(isRefresh);
                return true;
            }
            if (tableFlag.equals("2")) {
                this.filteSQL(isRefresh);
                return true;
            }
            if (tableFlag.equals("6")) {
                this.filteEnum(isRefresh);
                return true;
            }
            if (tableFlag.equals("3")) {
                this.filteQuery(isRefresh);
                return true;
            }
            if (!tableFlag.equals("8")) return true;
            return this.filteSnap(isRefresh);
        }
        catch (Exception e) {
            logger.error((Object)e);
            MessageUtil.showDetailAndOK(null, "\u67e5\u627e\u9519\u8bef", e);
            return false;
        }
    }

    private boolean filteReportForDispatch(boolean isRefresh) throws Exception {
        if (isRefresh) {
            this.fillReportDataForDispatch();
            return true;
        }
        if (null == this.reportFilterUI || null == this.tableFlagOld || null == this.params || !this.tableFlagOld.equals(this.reportUI.getTableFlag())) {
            this.reportFilterUI = new ExtReportFilterUI();
            this.tableFlagOld = this.reportUI.getTableFlag();
        }
        if (null != this.params) {
            this.reportFilterUI.setParmas(this.params);
        }
        ReportDialog.showDialog((CoreUIObject)this.reportFilterUI, (String)"\u62a5\u8868\u67e5\u627e", (boolean)true);
        if (this.reportFilterUI.isOk()) {
            this.params = this.reportFilterUI.getParmas();
            this.fillReportDataForDispatch();
            return true;
        }
        return false;
    }

    private void fillReportDataForDispatch() throws Exception {
        String biMenuID;
        String strLocal = SysContext.getSysContext().getLocale().toString();
        ArrayList<String> queryValue = new ArrayList<String>();
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select d.fid, d.forgtype, d.fsnaptype, d.FOrgID, d.FFilterType, d.FBIPath, d.FIsStdProduct, d.FSystemID, d.ftemplettype, flicenseStrategy, ");
        sbSQL.append("org.Fname_").append(strLocal).append(" as orgname, ");
        sbSQL.append("d.Fname_").append(strLocal).append(" as fname, ");
        sbSQL.append("u.Fname_").append(strLocal).append(" as user_name, ");
        sbSQL.append("d.fcreatorid, d.flastupdatetime, d.fisdeploy, d.fdeploypath, d.fmenuid, d.FMenuUi ");
        sbSQL.append("from T_RM_DefineReport d LEFT OUTER JOIN t_pm_user u on d.FCreatorID=u.fid ");
        sbSQL.append("LEFT OUTER JOIN T_ORG_BaseUnit org on d.FOrgID=org.fid ");
        sbSQL.append("where 1 = 1 ");
        String field = "d.FName_" + strLocal;
        CollectWhere.setWhere(sbSQL, this.params, "reportName", field, "like", "String");
        field = "u.fnumber";
        CollectWhere.setWhere(sbSQL, this.params, "account", field, "like", "String");
        field = "u.Fname_" + strLocal;
        CollectWhere.setWhere(sbSQL, this.params, "name", field, "like", "String");
        field = "d.FCreateTime";
        CollectWhere.setWhere(sbSQL, this.params, "CreateDateFrom", field, ">=", "date");
        CollectWhere.setWhere(sbSQL, this.params, "CreateDateTo", field, "<=", "date");
        field = "d.FLastUpdateTime";
        CollectWhere.setWhere(sbSQL, this.params, "UpdateDateFrom", field, ">=", "date");
        CollectWhere.setWhere(sbSQL, this.params, "UpdateDateTo", field, "<=", "date");
        String orgTypeString = CtrlReportUtil.getObjectString(this.params.get("orgTypeString"));
        if (orgTypeString.equals("9999")) {
            sbSQL.append(" and d.FOrgtype is null ");
        } else {
            field = "d.FOrgtype";
            CollectWhere.setWhere(sbSQL, this.params, "orgTypeString", field, "=", "String");
        }
        this.setOrgWhere(sbSQL, queryValue);
        boolean deployYes = new Boolean(CtrlReportUtil.getObjectString(this.params.get("rbDeployYes")));
        boolean deployNo = new Boolean(CtrlReportUtil.getObjectString(this.params.get("rbDeployNo")));
        if (deployYes) {
            sbSQL.append(" and (d.fmenuid is not null or d.FBIPath is not null)");
        } else if (deployNo) {
            sbSQL.append(" and (d.fmenuid is null and d.FBIPath is null) ");
        }
        String easMenuID = CtrlReportUtil.getObjectString(this.params.get("easMenuID"));
        if (easMenuID.length() > 0 && !deployNo) {
            sbSQL.append(" and d.fmenuid in (select fid from t_pm_mainMenuItem where fparent = '").append(easMenuID).append("') ");
        }
        if ((biMenuID = CtrlReportUtil.getObjectString(this.params.get("biMenuID"))).length() > 0 && !deployNo) {
            sbSQL.append(" and d.FBIPath like '").append(biMenuID).append("%' ");
        }
        boolean paramCommon = new Boolean(CtrlReportUtil.getObjectString(this.params.get("rbParamCommon")));
        boolean paramCustom = new Boolean(CtrlReportUtil.getObjectString(this.params.get("rbParamCustom")));
        if (paramCommon) {
            sbSQL.append(" and (d.FFilterType is null or d.FFilterType = '1') ");
        } else if (paramCustom) {
            sbSQL.append(" and d.FFilterType = '2' ");
        }
        boolean systemCurrent = new Boolean(CtrlReportUtil.getObjectString(this.params.get("rbSystemCurrent")));
        if (systemCurrent) {
            sbSQL.append(" and d.FSystemID = '").append(this.reportUI.getSystemID()).append("' ");
        }
        String curOrgId = EASUtil.getCurrentOrgID();
        sbSQL.append(" and d.fmenuid is not null and d.fid in ( ");
        sbSQL.append(" select p.FReportID from T_EXT_Permission p INNER JOIN T_RM_DefineReport r ");
        sbSQL.append(" on p.FReportID = r.fid where p.FOrgID = ?");
        sbSQL.append(" union all select p.FReportID from T_EXT_Permission p");
        sbSQL.append(" INNER JOIN T_RM_DefineReport r on p.FReportID = r.fid where");
        sbSQL.append(" p.FOrgID is null ");
        sbSQL.append(" union all select p.FReportID ");
        sbSQL.append(" from T_EXT_Permission p INNER JOIN T_RM_DefineReport r ");
        sbSQL.append(" on p.FReportID = r.fid INNER JOIN t_pm_userroleorg uro ON p.froleid = uro.froleid");
        sbSQL.append(" where uro.FOrgID = ?").append(" )");
        sbSQL.append("\tAnd ( FTempletType = ").append(-1);
        sbSQL.append(" Or FTempletType is NULL)");
        queryValue.add(curOrgId);
        queryValue.add(curOrgId);
        this.fillData(sbSQL.toString(), queryValue);
    }

    private boolean filteReport(boolean isRefresh) throws Exception {
        if (isRefresh) {
            this.fillReportData();
            return true;
        }
        if (null == this.reportFilterUI || null == this.tableFlagOld || null == this.params || !this.tableFlagOld.equals(this.reportUI.getTableFlag())) {
            this.reportFilterUI = new ExtReportFilterUI();
            this.tableFlagOld = this.reportUI.getTableFlag();
        }
        if (null != this.params) {
            this.reportFilterUI.setParmas(this.params);
        }
        ReportDialog.showDialog((CoreUIObject)this.reportFilterUI, (String)"\u62a5\u8868\u67e5\u627e", (boolean)true);
        if (this.reportFilterUI.isOk()) {
            this.params = this.reportFilterUI.getParmas();
            this.fillReportData();
            return true;
        }
        return false;
    }

    private void filteDeployReport(boolean isRefresh) throws Exception {
        if (isRefresh) {
            this.fillDeployReportData();
            return;
        }
        if (null == this.reportFilterUI || null == this.tableFlagOld || null == this.params || !this.tableFlagOld.equals(this.reportUI.getTableFlag())) {
            this.reportFilterUI = new ExtReportFilterUI();
            this.tableFlagOld = this.reportUI.getTableFlag();
        }
        if (null != this.params) {
            this.reportFilterUI.setParmas(this.params);
        }
        this.reportFilterUI.setDeployProperty();
        ReportDialog.showDialog((CoreUIObject)this.reportFilterUI, (String)"\u62a5\u8868\u67e5\u627e", (boolean)true);
        if (this.reportFilterUI.isOk()) {
            this.params = this.reportFilterUI.getParmas();
            this.fillDeployReportData();
        }
    }

    private void filteDiscreteReport(boolean isRefresh) throws Exception {
        if (isRefresh) {
            this.fillDiscreteReportData();
            return;
        }
        if (null == this.reportFilterUI || null == this.tableFlagOld || null == this.params || !this.tableFlagOld.equals(this.reportUI.getTableFlag())) {
            this.reportFilterUI = new ExtReportFilterUI();
            this.tableFlagOld = this.reportUI.getTableFlag();
        }
        if (null != this.params) {
            this.reportFilterUI.setParmas(this.params);
        }
        this.reportFilterUI.setDiscreteProperty();
        ReportDialog.showDialog((CoreUIObject)this.reportFilterUI, (String)"\u62a5\u8868\u67e5\u627e", (boolean)true);
        if (this.reportFilterUI.isOk()) {
            this.params = this.reportFilterUI.getParmas();
            this.fillDiscreteReportData();
        }
    }

    private void filteStdReport(boolean isRefresh) throws Exception {
        if (isRefresh) {
            this.fillDiscreteReportData();
            return;
        }
        if (null == this.reportFilterUI || null == this.tableFlagOld || null == this.params || !this.tableFlagOld.equals(this.reportUI.getTableFlag())) {
            this.reportFilterUI = new ExtReportFilterUI();
            this.tableFlagOld = this.reportUI.getTableFlag();
        }
        if (null != this.params) {
            this.reportFilterUI.setParmas(this.params);
        }
        this.reportFilterUI.setStdProperty();
        ReportDialog.showDialog((CoreUIObject)this.reportFilterUI, (String)"\u62a5\u8868\u67e5\u627e", (boolean)true);
        if (this.reportFilterUI.isOk()) {
            this.params = this.reportFilterUI.getParmas();
            this.fillDiscreteReportData();
        }
    }

    private void filteSelectedAttemperReport(boolean isRefresh) throws Exception {
        if (isRefresh) {
            this.fillDiscreteReportData();
            return;
        }
        if (null == this.reportFilterUI || null == this.tableFlagOld || null == this.params || !this.tableFlagOld.equals(this.reportUI.getTableFlag())) {
            this.reportFilterUI = new ExtReportFilterUI();
            this.tableFlagOld = this.reportUI.getTableFlag();
        }
        if (null != this.params) {
            this.reportFilterUI.setParmas(this.params);
        }
        this.reportFilterUI.setSelectedAttemperProperty();
        ReportDialog.showDialog((CoreUIObject)this.reportFilterUI, (String)"\u62a5\u8868\u67e5\u627e", (boolean)true);
        if (this.reportFilterUI.isOk()) {
            this.params = this.reportFilterUI.getParmas();
            this.fillDiscreteReportData();
        }
    }

    private boolean filteLicenseReport(boolean isRefresh) throws Exception {
        if (isRefresh) {
            this.fillLicenseReportData();
            return true;
        }
        if (null == this.reportFilterUI) {
            this.reportFilterUI = new ExtReportFilterUI();
        }
        if (null != this.params) {
            this.reportFilterUI.setParmas(this.params);
        }
        this.reportFilterUI.setLicenseProperty();
        ReportDialog.showDialog((CoreUIObject)this.reportFilterUI, (String)"license\u8be6\u60c5\u67e5\u627e", (boolean)true);
        if (this.reportFilterUI.isOk()) {
            this.params = this.reportFilterUI.getParmas();
            this.fillLicenseReportData();
            return true;
        }
        return false;
    }

    private boolean filteAttemperReport(boolean isRefresh) throws Exception {
        if (isRefresh) {
            this.fillAttemperReportData();
            return true;
        }
        if (null == this.reportAttemperFilterUI) {
            this.reportAttemperFilterUI = new ReportAttemperFilterUI();
        }
        if (null != this.params) {
            this.reportAttemperFilterUI.setParmas(this.params);
        }
        ReportDialog.showDialog((CoreUIObject)this.reportAttemperFilterUI, (String)"\u8c03\u5ea6\u67e5\u627e", (boolean)true);
        if (this.reportAttemperFilterUI.isOk()) {
            this.params = this.reportAttemperFilterUI.getParmas();
            this.fillAttemperReportData();
            return true;
        }
        return false;
    }

    private boolean filteSnap(boolean isRefresh) throws Exception {
        if (isRefresh) {
            this.fillSnapData();
            return true;
        }
        if (null == this.snapFilterUI || null == this.tableFlagOld || null == this.params || !this.tableFlagOld.equals(this.reportUI.getTableFlag())) {
            this.snapFilterUI = new ReportSanpFilterUI();
            this.tableFlagOld = this.reportUI.getTableFlag();
        }
        if (null != this.params) {
            this.snapFilterUI.setParmas(this.params);
        }
        if (CtrlReportUtil.getObjectString(this.reportUI.getSystemID()).equals("")) {
            this.snapFilterUI.setCurrentSystemEnable(false);
        } else {
            this.snapFilterUI.setCurrentSystemEnable(true);
        }
        ReportDialog.showDialog((CoreUIObject)this.snapFilterUI, (String)"\u5feb\u7167\u67e5\u627e", (boolean)true);
        if (this.snapFilterUI.isOk()) {
            this.params = this.snapFilterUI.getParmas();
            this.fillSnapData();
            return true;
        }
        return false;
    }

    private void filteSQL(boolean isRefresh) throws Exception {
        if (isRefresh) {
            if (this.isSys) {
                this.fillSQLData();
            } else {
                this.fillCustSQLData();
            }
            return;
        }
        if (null == this.sQLFilterUI || null == this.tableFlagOld || null == this.params || !this.tableFlagOld.equals(this.reportUI.getTableFlag())) {
            this.sQLFilterUI = new SQLFilterUI();
            this.tableFlagOld = this.reportUI.getTableFlag();
        }
        if (null != this.params) {
            this.sQLFilterUI.setParmas(this.params);
        }
        ReportDialog.showDialog((CoreUIObject)this.sQLFilterUI, (String)"SQL\u6570\u636e\u96c6\u67e5\u627e", (boolean)true);
        if (this.sQLFilterUI.isOk()) {
            this.params = this.sQLFilterUI.getParmas();
            if (this.isSys) {
                this.fillSQLData();
            } else {
                this.fillCustSQLData();
            }
        }
    }

    private void filteEnum(boolean isRefresh) throws Exception {
        if (null == this.enumFilterUI || null == this.tableFlagOld || null == this.params || !this.tableFlagOld.equals(this.reportUI.getTableFlag())) {
            this.enumFilterUI = new EnumFilterUI();
            this.tableFlagOld = this.reportUI.getTableFlag();
        }
        if (null != this.params) {
            this.enumFilterUI.setParmas(this.params);
        }
        ReportDialog.showDialog((CoreUIObject)this.enumFilterUI, (String)"\u679a\u4e3e\u6570\u636e\u96c6\u67e5\u627e", (boolean)true);
        if (this.enumFilterUI.isOk()) {
            this.params = this.enumFilterUI.getParmas();
            HashMap<String, String> mapFilter = new HashMap<String, String>();
            mapFilter.put(TreeManager.filter_name, "");
            mapFilter.put(TreeManager.filter_alias, CtrlReportUtil.getObjectString(this.params.get("enumName")));
            mapFilter.put(TreeManager.filter_f7, "false");
            boolean systemCurrent = new Boolean(CtrlReportUtil.getObjectString(this.params.get("rbSystemCurrent")));
            if (systemCurrent) {
                mapFilter.put(TreeManager.filter_systemID, this.reportUI.getSystemID());
            } else {
                mapFilter.put(TreeManager.filter_systemID, "");
            }
            ArrayList dataList = new ArrayList();
            TreeManager.filterTree(dataList, CtrlDesignUtil.getEnumroot(), mapFilter);
            this.reportUI.fillData(dataList);
        }
    }

    private void filteQuery(boolean isRefresh) throws Exception {
        if (null == this.enumFilterUI || null == this.tableFlagOld || null == this.params || !this.tableFlagOld.equals(this.reportUI.getTableFlag())) {
            this.enumFilterUI = new EnumFilterUI();
            this.tableFlagOld = this.reportUI.getTableFlag();
        }
        if (null != this.params) {
            this.enumFilterUI.setParmas(this.params);
        }
        ReportDialog.showDialog((CoreUIObject)this.enumFilterUI, (String)"Query\u6570\u636e\u96c6\u67e5\u627e", (boolean)true);
        if (this.enumFilterUI.isOk()) {
            this.params = this.enumFilterUI.getParmas();
            HashMap<String, String> mapFilter = new HashMap<String, String>();
            mapFilter.put(TreeManager.filter_name, "");
            mapFilter.put(TreeManager.filter_alias, CtrlReportUtil.getObjectString(this.params.get("enumName")));
            mapFilter.put(TreeManager.filter_f7, "false");
            boolean systemCurrent = new Boolean(CtrlReportUtil.getObjectString(this.params.get("rbSystemCurrent")));
            if (systemCurrent) {
                mapFilter.put(TreeManager.filter_systemID, this.reportUI.getSystemID());
            } else {
                mapFilter.put(TreeManager.filter_systemID, "");
            }
            ArrayList dataList = new ArrayList();
            TreeManager.filterTree(dataList, CtrlDesignUtil.getQueryroot(), mapFilter);
            this.reportUI.fillData(dataList);
        }
    }

    private void setOrgWhere(StringBuffer sbSQL, ArrayList queryValue) {
        String strOrgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        boolean stdNoLimit = new Boolean(CtrlReportUtil.getObjectString(this.params.get("rbStdAll")));
        boolean stdYes = new Boolean(CtrlReportUtil.getObjectString(this.params.get("rbStdYes")));
        boolean stdNo = new Boolean(CtrlReportUtil.getObjectString(this.params.get("rbStdNo")));
        if (stdNoLimit) {
            sbSQL.append(" and (d.FOrgID = ? or d.FOrgID = ?)");
            queryValue.add(strOrgID);
            queryValue.add("qUvvbL4yQsyQYFIDSlvngID2+FI=");
        } else if (stdYes) {
            sbSQL.append(" and (d.FOrgID = ?)");
            queryValue.add("qUvvbL4yQsyQYFIDSlvngID2+FI=");
        } else if (stdNo) {
            sbSQL.append(" and (d.FOrgID = ?)");
            queryValue.add(strOrgID);
        }
    }

    private void fillReportData() throws Exception {
        String biMenuID;
        String strLocal = SysContext.getSysContext().getLocale().toString();
        ArrayList queryValue = new ArrayList();
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select d.fid, d.forgtype, d.fsnaptype, d.FOrgID, d.FFilterType, d.FBIPath, d.FIsStdProduct, d.FSystemID, d.ftemplettype, flicenseStrategy, ");
        sbSQL.append("org.Fname_").append(strLocal).append(" as orgname, ");
        sbSQL.append("d.Fname_").append(strLocal).append(" as fname, ");
        sbSQL.append("u.Fname_").append(strLocal).append(" as user_name, ");
        sbSQL.append("d.fcreatorid, d.flastupdatetime, d.fisdeploy, d.fdeploypath, d.fmenuid, d.FMenuUi ");
        sbSQL.append("from T_RM_DefineReport d LEFT OUTER JOIN t_pm_user u on d.FCreatorID=u.fid ");
        sbSQL.append("LEFT OUTER JOIN T_ORG_BaseUnit org on d.FOrgID=org.fid ");
        sbSQL.append("where 1 = 1 ");
        String field = "d.FName_" + strLocal;
        CollectWhere.setWhere(sbSQL, this.params, "reportName", field, "like", "String");
        field = "u.fnumber";
        CollectWhere.setWhere(sbSQL, this.params, "account", field, "like", "String");
        field = "u.Fname_" + strLocal;
        CollectWhere.setWhere(sbSQL, this.params, "name", field, "like", "String");
        field = "d.FCreateTime";
        CollectWhere.setWhere(sbSQL, this.params, "CreateDateFrom", field, ">=", "date");
        CollectWhere.setWhere(sbSQL, this.params, "CreateDateTo", field, "<=", "date");
        field = "d.FLastUpdateTime";
        CollectWhere.setWhere(sbSQL, this.params, "UpdateDateFrom", field, ">=", "date");
        CollectWhere.setWhere(sbSQL, this.params, "UpdateDateTo", field, "<=", "date");
        String orgTypeString = CtrlReportUtil.getObjectString(this.params.get("orgTypeString"));
        if (orgTypeString.equals("9999")) {
            sbSQL.append(" and d.FOrgtype is null ");
        } else {
            field = "d.FOrgtype";
            CollectWhere.setWhere(sbSQL, this.params, "orgTypeString", field, "=", "String");
        }
        this.setOrgWhere(sbSQL, queryValue);
        boolean deployYes = new Boolean(CtrlReportUtil.getObjectString(this.params.get("rbDeployYes")));
        boolean deployNo = new Boolean(CtrlReportUtil.getObjectString(this.params.get("rbDeployNo")));
        if (deployYes) {
            sbSQL.append(" and (d.fmenuid is not null or d.FBIPath is not null)");
        } else if (deployNo) {
            sbSQL.append(" and (d.fmenuid is null and d.FBIPath is null) ");
        }
        String easMenuID = CtrlReportUtil.getObjectString(this.params.get("easMenuID"));
        if (easMenuID.length() > 0 && !deployNo) {
            sbSQL.append(" and d.fmenuid in (select fid from t_pm_mainMenuItem where fparent = '").append(easMenuID).append("') ");
        }
        if ((biMenuID = CtrlReportUtil.getObjectString(this.params.get("biMenuID"))).length() > 0 && !deployNo) {
            sbSQL.append(" and d.FBIPath like '").append(biMenuID).append("%' ");
        }
        boolean paramCommon = new Boolean(CtrlReportUtil.getObjectString(this.params.get("rbParamCommon")));
        boolean paramCustom = new Boolean(CtrlReportUtil.getObjectString(this.params.get("rbParamCustom")));
        if (paramCommon) {
            sbSQL.append(" and (d.FFilterType is null or d.FFilterType = '1') ");
        } else if (paramCustom) {
            sbSQL.append(" and d.FFilterType = '2' ");
        }
        boolean systemCurrent = new Boolean(CtrlReportUtil.getObjectString(this.params.get("rbSystemCurrent")));
        if (systemCurrent) {
            sbSQL.append(" and d.FSystemID = '").append(this.reportUI.getSystemID()).append("' ");
        }
        logger.debug((Object)("filter sql = " + sbSQL.toString()));
        this.fillData(sbSQL.toString(), queryValue);
    }

    private void fillDeployReportData() throws Exception {
        String strLocal = SysContext.getSysContext().getLocale().toString();
        ArrayList queryValue = new ArrayList();
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select d.fid, d.forgtype, d.fsnaptype, d.FOrgID, d.FFilterType, d.FBIPath, d.FIsStdProduct, d.FSystemID, d.ftemplettype,  ");
        sbSQL.append("org.Fname_").append(strLocal).append(" as orgname, ");
        sbSQL.append("d.Fname_").append(strLocal).append(" as fname, ");
        sbSQL.append("u.Fname_").append(strLocal).append(" as user_name, ");
        sbSQL.append("d.fcreatorid, d.flastupdatetime, d.fisdeploy, d.fdeploypath, d.fmenuid, d.FMenuUi ");
        sbSQL.append("from T_RM_DefineReport d LEFT OUTER JOIN t_pm_user u on d.FCreatorID=u.fid ");
        sbSQL.append("LEFT OUTER JOIN T_ORG_BaseUnit org on d.FOrgID=org.fid ");
        sbSQL.append("where d.fmenuid is null ");
        String field = "d.FName_" + strLocal;
        CollectWhere.setWhere(sbSQL, this.params, "reportName", field, "like", "String");
        field = "u.fnumber";
        CollectWhere.setWhere(sbSQL, this.params, "account", field, "like", "String");
        field = "u.Fname_" + strLocal;
        CollectWhere.setWhere(sbSQL, this.params, "name", field, "like", "String");
        field = "d.FCreateTime";
        CollectWhere.setWhere(sbSQL, this.params, "CreateDateFrom", field, ">=", "date");
        CollectWhere.setWhere(sbSQL, this.params, "CreateDateTo", field, "<=", "date");
        field = "d.FLastUpdateTime";
        CollectWhere.setWhere(sbSQL, this.params, "UpdateDateFrom", field, ">=", "date");
        CollectWhere.setWhere(sbSQL, this.params, "UpdateDateTo", field, "<=", "date");
        String orgTypeString = CtrlReportUtil.getObjectString(this.params.get("orgTypeString"));
        if (orgTypeString.equals("9999")) {
            sbSQL.append(" and d.FOrgtype is null ");
        } else {
            field = "d.FOrgtype";
            CollectWhere.setWhere(sbSQL, this.params, "orgTypeString", field, "=", "String");
        }
        this.setOrgWhere(sbSQL, queryValue);
        boolean paramCommon = new Boolean(CtrlReportUtil.getObjectString(this.params.get("rbParamCommon")));
        boolean paramCustom = new Boolean(CtrlReportUtil.getObjectString(this.params.get("rbParamCustom")));
        if (paramCommon) {
            sbSQL.append(" and (d.FFilterType is null or d.FFilterType = '1') ");
        } else if (paramCustom) {
            sbSQL.append(" and d.FFilterType = '2' ");
        }
        boolean systemCurrent = new Boolean(CtrlReportUtil.getObjectString(this.params.get("rbSystemCurrent")));
        if (systemCurrent) {
            sbSQL.append(" and d.FSystemID = '").append(this.reportUI.getSystemID()).append("' ");
        }
        logger.debug((Object)("filter sql = " + sbSQL.toString()));
        this.fillData(sbSQL.toString(), queryValue);
    }

    private void fillDiscreteReportData() throws Exception {
        String biMenuID;
        String strLocal = SysContext.getSysContext().getLocale().toString();
        ArrayList queryValue = new ArrayList();
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select d.fid, d.forgtype, d.fsnaptype, d.FOrgID, d.FFilterType, d.FBIPath, d.FIsStdProduct, d.FSystemID, d.ftemplettype,  ");
        sbSQL.append("org.Fname_").append(strLocal).append(" as orgname, ");
        sbSQL.append("d.Fname_").append(strLocal).append(" as fname, ");
        sbSQL.append("u.Fname_").append(strLocal).append(" as user_name, ");
        sbSQL.append("d.fcreatorid, d.flastupdatetime, d.fisdeploy, d.fdeploypath, d.fmenuid ");
        sbSQL.append("from T_RM_DefineReport d LEFT OUTER JOIN t_pm_user u on d.FCreatorID=u.fid ");
        sbSQL.append("LEFT OUTER JOIN T_ORG_BaseUnit org on d.FOrgID=org.fid ");
        sbSQL.append("where 1 = 1 ");
        String field = "d.FName_" + strLocal;
        CollectWhere.setWhere(sbSQL, this.params, "reportName", field, "like", "String");
        field = "u.fnumber";
        CollectWhere.setWhere(sbSQL, this.params, "account", field, "like", "String");
        field = "u.Fname_" + strLocal;
        CollectWhere.setWhere(sbSQL, this.params, "name", field, "like", "String");
        field = "d.FCreateTime";
        CollectWhere.setWhere(sbSQL, this.params, "CreateDateFrom", field, ">=", "date");
        CollectWhere.setWhere(sbSQL, this.params, "CreateDateTo", field, "<=", "date");
        field = "d.FLastUpdateTime";
        CollectWhere.setWhere(sbSQL, this.params, "UpdateDateFrom", field, ">=", "date");
        CollectWhere.setWhere(sbSQL, this.params, "UpdateDateTo", field, "<=", "date");
        String orgTypeString = CtrlReportUtil.getObjectString(this.params.get("orgTypeString"));
        if (orgTypeString.equals("9999")) {
            sbSQL.append(" and d.FOrgtype is null ");
        } else {
            field = "d.FOrgtype";
            CollectWhere.setWhere(sbSQL, this.params, "orgTypeString", field, "=", "String");
        }
        this.setOrgWhere(sbSQL, queryValue);
        boolean deployYes = new Boolean(CtrlReportUtil.getObjectString(this.params.get("rbDeployYes")));
        boolean deployNo = new Boolean(CtrlReportUtil.getObjectString(this.params.get("rbDeployNo")));
        if (deployYes) {
            sbSQL.append(" and (d.fmenuid is not null or d.FBIPath is not null)");
        } else if (deployNo) {
            sbSQL.append(" and (d.fmenuid is null and d.FBIPath is null) ");
        }
        String easMenuID = CtrlReportUtil.getObjectString(this.params.get("easMenuID"));
        if (easMenuID.length() > 0 && !deployNo) {
            sbSQL.append(" and d.fmenuid in (select fid from t_pm_mainMenuItem where fparent = '").append(easMenuID).append("') ");
        }
        if ((biMenuID = CtrlReportUtil.getObjectString(this.params.get("biMenuID"))).length() > 0 && !deployNo) {
            sbSQL.append(" and d.FBIPath like '").append(biMenuID).append("%' ");
        }
        boolean paramCommon = new Boolean(CtrlReportUtil.getObjectString(this.params.get("rbParamCommon")));
        boolean paramCustom = new Boolean(CtrlReportUtil.getObjectString(this.params.get("rbParamCustom")));
        if (paramCommon) {
            sbSQL.append(" and (d.FFilterType is null or d.FFilterType = '1') ");
        } else if (paramCustom) {
            sbSQL.append(" and d.FFilterType = '2' ");
        }
        boolean systemCurrent = new Boolean(CtrlReportUtil.getObjectString(this.params.get("rbSystemCurrent")));
        if (systemCurrent) {
            sbSQL.append(" and d.FSystemID = '").append(this.reportUI.getSystemID()).append("' ");
        }
        logger.debug((Object)("filter sql = " + sbSQL.toString()));
        this.fillData(sbSQL.toString(), queryValue);
    }

    private void fillLicenseReportData() throws Exception {
        String biMenuID;
        String strLocal = SysContext.getSysContext().getLocale().toString();
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("SELECT d.FID, d.FSystemID, d.FOrgID, d.FDeployPath, d.FBIPath, d.FIsStdProduct, d.fmenuid, ");
        sbSQL.append("d.Fname_").append(strLocal).append(" as reportName, ");
        sbSQL.append("org.Fname_").append(strLocal).append(" as orgname ");
        sbSQL.append("from T_RM_DefineReport d LEFT OUTER JOIN t_pm_user u on d.FCreatorID=u.fid ");
        sbSQL.append("LEFT OUTER JOIN T_ORG_BaseUnit org on d.FOrgID=org.fid ");
        sbSQL.append("where 1 = 1 and FLicenseStrategy <> 2 ");
        String field = "d.FName_" + strLocal;
        CollectWhere.setWhere(sbSQL, this.params, "reportName", field, "like", "String");
        field = "u.fnumber";
        CollectWhere.setWhere(sbSQL, this.params, "account", field, "like", "String");
        field = "u.Fname_" + strLocal;
        CollectWhere.setWhere(sbSQL, this.params, "name", field, "like", "String");
        field = "d.FCreateTime";
        CollectWhere.setWhere(sbSQL, this.params, "CreateDateFrom", field, ">=", "date");
        CollectWhere.setWhere(sbSQL, this.params, "CreateDateTo", field, "<=", "date");
        field = "d.FLastUpdateTime";
        CollectWhere.setWhere(sbSQL, this.params, "UpdateDateFrom", field, ">=", "date");
        CollectWhere.setWhere(sbSQL, this.params, "UpdateDateTo", field, "<=", "date");
        String orgTypeString = CtrlReportUtil.getObjectString(this.params.get("orgTypeString"));
        if (orgTypeString.equals("9999")) {
            sbSQL.append(" and d.FOrgtype is null ");
        } else {
            field = "d.FOrgtype";
            CollectWhere.setWhere(sbSQL, this.params, "orgTypeString", field, "=", "String");
        }
        ArrayList queryValue = new ArrayList();
        this.setOrgWhere(sbSQL, queryValue);
        String easMenuID = CtrlReportUtil.getObjectString(this.params.get("easMenuID"));
        if (easMenuID.length() > 0) {
            sbSQL.append(" and d.fmenuid in (select fid from t_pm_mainMenuItem where fparent = '").append(easMenuID).append("') ");
        }
        if ((biMenuID = CtrlReportUtil.getObjectString(this.params.get("biMenuID"))).length() > 0) {
            sbSQL.append(" and d.FBIPath like '").append(biMenuID).append("%' ");
        }
        boolean paramCommon = new Boolean(CtrlReportUtil.getObjectString(this.params.get("rbParamCommon")));
        boolean paramCustom = new Boolean(CtrlReportUtil.getObjectString(this.params.get("rbParamCustom")));
        if (paramCommon) {
            sbSQL.append(" and (d.FFilterType is null or d.FFilterType = '1') ");
        } else if (paramCustom) {
            sbSQL.append(" and d.FFilterType = '2' ");
        }
        boolean systemCurrent = new Boolean(CtrlReportUtil.getObjectString(this.params.get("rbSystemCurrent")));
        if (systemCurrent) {
            sbSQL.append(" and d.FSystemID = '").append(this.reportUI.getSystemID()).append("' ");
        }
        logger.debug((Object)("filter sql = " + sbSQL.toString()));
        ArrayList dataList = ExtDBUtil.getResultListBySql(null, sbSQL.toString(), queryValue);
        Iterator it = dataList.iterator();
        while (it.hasNext()) {
            HashMap map = (HashMap)it.next();
            String fmenuid = CtrlReportUtil.getObjectString(map.get("fmenuid"));
            String fbipath = CtrlReportUtil.getObjectString(map.get("fbipath"));
            if (!fmenuid.equals("") || !fbipath.equals("")) continue;
            it.remove();
        }
        this.reportUI.fillData(dataList);
    }

    private void fillAttemperReportData() throws Exception {
        String strLocal = SysContext.getSysContext().getLocale().toString();
        String strOrgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(strOrgID);
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select s.FID, s.FReportID, d.FDeployPath, FJobProcessDefID, j.ftitle, ");
        sbSQL.append("s.Fname_").append(strLocal).append(" as attempername, ");
        sbSQL.append("s.FMemo_").append(strLocal).append(" as memo, ");
        sbSQL.append("d.Fname_").append(strLocal).append(" as reportname, ");
        sbSQL.append("u.Fname_").append(strLocal).append(" as user_name, ");
        sbSQL.append("s.fcreatorid, s.FCreateTime, s.FLastUpdateUserID, s.flastupdatetime ");
        sbSQL.append("from T_RM_RptAttemper s ");
        sbSQL.append("LEFT OUTER JOIN T_RM_DefineReport d on s.freportid = d.fid ");
        sbSQL.append("LEFT OUTER JOIN t_pm_user u on s.FCreatorID = u.fid ");
        sbSQL.append("LEFT OUTER JOIN T_JOB_DEF j on s.FJobProcessDefID = j.fjobdefid ");
        sbSQL.append("where s.FOrgID = ? ");
        String field = "s.FName_" + strLocal;
        CollectWhere.setWhere(sbSQL, this.params, "attemperName", field, "like", "String");
        field = "d.FName_" + strLocal;
        CollectWhere.setWhere(sbSQL, this.params, "reportName", field, "like", "String");
        field = "u.fnumber";
        CollectWhere.setWhere(sbSQL, this.params, "createrAccount", field, "like", "String");
        field = "u.Fname_" + strLocal;
        CollectWhere.setWhere(sbSQL, this.params, "createrName", field, "like", "String");
        field = "s.FLastUpdateTime";
        CollectWhere.setWhere(sbSQL, this.params, "UpdateDateFrom", field, ">=", "date");
        CollectWhere.setWhere(sbSQL, this.params, "UpdateDateTo", field, "<=", "date");
        boolean filterYes = new Boolean(CtrlReportUtil.getObjectString(this.params.get("rbFilterYes")));
        boolean filterNo = new Boolean(CtrlReportUtil.getObjectString(this.params.get("rbFilterNo")));
        if (filterYes) {
            sbSQL.append(" and s.FFilterXml is not null ");
        } else if (filterNo) {
            sbSQL.append(" and s.FFilterXml is null ");
        }
        boolean scheduleYes = new Boolean(CtrlReportUtil.getObjectString(this.params.get("rbScheduleYes")));
        boolean scheduleNo = new Boolean(CtrlReportUtil.getObjectString(this.params.get("rbScheduleNo")));
        if (scheduleYes) {
            sbSQL.append(" and s.FScheduleXml is not null ");
        } else if (scheduleNo) {
            sbSQL.append(" and s.FScheduleXml is null ");
        }
        boolean releaseYes = new Boolean(CtrlReportUtil.getObjectString(this.params.get("rbReleaseYes")));
        boolean releaseNo = new Boolean(CtrlReportUtil.getObjectString(this.params.get("rbReleaseNo")));
        if (releaseYes) {
            sbSQL.append(" and s.FJobProcessDefID is not null ");
        } else if (releaseNo) {
            sbSQL.append(" and s.FJobProcessDefID is null ");
        }
        logger.debug((Object)("filter sql = " + sbSQL.toString()));
        this.fillData(sbSQL.toString(), queryValue);
    }

    private void fillSQLData() throws Exception {
        String strLocal = SysContext.getSysContext().getLocale().toString();
        String strOrgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        ArrayList<String> queryValue = new ArrayList<String>();
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select d.fid, d.FOrgID, d.FIsDynamicSQL, d.FSystemID, d.FCustomType,");
        sbSQL.append("org.Fname_").append(strLocal).append(" as orgname, ");
        sbSQL.append("d.Fname_").append(strLocal).append(" as fname, ");
        sbSQL.append("u.Fname_").append(strLocal).append(" as user_name, ");
        sbSQL.append("d.fcreatorid, d.flastupdatetime ");
        sbSQL.append("from T_RM_KSQLReport d LEFT OUTER JOIN t_pm_user u on d.FCreatorID=u.fid ");
        sbSQL.append("LEFT OUTER JOIN T_ORG_BaseUnit org on d.FOrgID=org.fid ");
        sbSQL.append("where d.Fsystemid = ? ");
        queryValue.add(this.node);
        String field = "d.FName_" + strLocal;
        CollectWhere.setWhere(sbSQL, this.params, "sqlName", field, "like", "String");
        field = "u.fnumber";
        CollectWhere.setWhere(sbSQL, this.params, "account", field, "like", "String");
        field = "u.Fname_" + strLocal;
        CollectWhere.setWhere(sbSQL, this.params, "name", field, "like", "String");
        field = "d.FCreateTime";
        CollectWhere.setWhere(sbSQL, this.params, "CreateDateFrom", field, ">=", "date");
        CollectWhere.setWhere(sbSQL, this.params, "CreateDateTo", field, "<=", "date");
        field = "d.FLastUpdateTime";
        CollectWhere.setWhere(sbSQL, this.params, "UpdateDateFrom", field, ">=", "date");
        CollectWhere.setWhere(sbSQL, this.params, "UpdateDateTo", field, "<=", "date");
        field = "d.FCustomType";
        CollectWhere.setWhere(sbSQL, this.params, "customTypeString", field, "=", "number");
        boolean paramYes = new Boolean(CtrlReportUtil.getObjectString(this.params.get("rbParamYes")));
        boolean paramNo = new Boolean(CtrlReportUtil.getObjectString(this.params.get("rbParamNo")));
        if (paramNo) {
            sbSQL.append(" and d.FIsDynamicSQL <> 1 ");
        } else if (paramYes) {
            sbSQL.append(" and d.FIsDynamicSQL = 1 ");
        }
        boolean systemCurrent = new Boolean(CtrlReportUtil.getObjectString(this.params.get("rbSystemCurrent")));
        if (systemCurrent) {
            sbSQL.append(" and d.FSystemID = '").append(this.reportUI.getSystemID()).append("' ");
        }
        logger.debug((Object)("filter sql = " + sbSQL.toString()));
        this.fillData(sbSQL.toString(), queryValue);
    }

    private void fillCustSQLData() throws Exception {
        String strLocal = SysContext.getSysContext().getLocale().toString();
        String strOrgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        ArrayList<String> queryValue = new ArrayList<String>();
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        boolean isSuper = Administrator.isSuperCUAdmin((IObjectPK)new ObjectUuidPK(userInfo.getId())) || "00000000-0000-0000-0000-00000000000013B7DE7F".equals(userInfo.getId().toString());
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select d.fid, d.ForgUnitID, d.FIsDynamicSQL, d.FtreeNodeID, d.FCustomType,");
        sbSQL.append("org.Fname_").append(strLocal).append(" as orgname, ");
        sbSQL.append("d.Fname_").append(strLocal).append(" as fname, ");
        sbSQL.append("u.Fname_").append(strLocal).append(" as user_name, ");
        sbSQL.append("d.fcreatorid, d.flastupdatetime ");
        sbSQL.append("from T_RM_CustKSQLRpt d LEFT OUTER JOIN t_pm_user u on d.FCreatorID=u.fid ");
        sbSQL.append("LEFT OUTER JOIN T_ORG_BaseUnit org on d.ForgUnitID=org.fid ");
        if (!isSuper) {
            sbSQL.append("where  d.FTreeNodeId =? ");
            sbSQL.append("and (d.fid in (select p.FReportID \n");
            sbSQL.append("from T_RM_Permission p INNER JOIN T_RM_CustKSQLRpt r on p.FReportID=r.fid \n");
            sbSQL.append("where p.FUserID = ? and p.FOrgID = ? and p.fpermission like ?\n");
            sbSQL.append("union all \n");
            sbSQL.append("select  p.FReportID \n");
            sbSQL.append("from T_RM_Permission p INNER JOIN T_RM_CustKSQLRpt r on p.FReportID=r.fid \n");
            sbSQL.append("where p.FUserID = ? and p.FOrgID is null and p.fpermission like ?\n");
            sbSQL.append("union all \n");
            sbSQL.append("select p.FReportID \n");
            sbSQL.append("from T_RM_Permission p INNER JOIN T_RM_CustKSQLRpt r on p.FReportID=r.fid \n");
            sbSQL.append("INNER JOIN t_pm_userroleorg uro ON p.froleid = uro.froleid \n");
            sbSQL.append("where uro.FUserID = ? and uro.FOrgID = ? and p.fpermission like ?) or d.fcreatorid =?) ");
            queryValue.add(this.node);
            queryValue.add(userInfo.getId().toString());
            queryValue.add(strOrgID);
            queryValue.add("1;_;_");
            queryValue.add(userInfo.getId().toString());
            queryValue.add("1;_;_");
            queryValue.add(userInfo.getId().toString());
            queryValue.add(strOrgID);
            queryValue.add("1;_;_");
            queryValue.add(userInfo.getId().toString());
        } else {
            sbSQL.append("where  d.FTreeNodeId = ? ");
            queryValue.add(this.node);
        }
        String field = "d.FName_" + strLocal;
        CollectWhere.setWhere(sbSQL, this.params, "sqlName", field, "like", "String");
        field = "u.fnumber";
        CollectWhere.setWhere(sbSQL, this.params, "account", field, "like", "String");
        field = "u.Fname_" + strLocal;
        CollectWhere.setWhere(sbSQL, this.params, "name", field, "like", "String");
        field = "d.FCreateTime";
        CollectWhere.setWhere(sbSQL, this.params, "CreateDateFrom", field, ">=", "date");
        CollectWhere.setWhere(sbSQL, this.params, "CreateDateTo", field, "<=", "date");
        field = "d.FLastUpdateTime";
        CollectWhere.setWhere(sbSQL, this.params, "UpdateDateFrom", field, ">=", "date");
        CollectWhere.setWhere(sbSQL, this.params, "UpdateDateTo", field, "<=", "date");
        field = "d.FCustomType";
        CollectWhere.setWhere(sbSQL, this.params, "customTypeString", field, "=", "number");
        boolean paramYes = new Boolean(CtrlReportUtil.getObjectString(this.params.get("rbParamYes")));
        boolean paramNo = new Boolean(CtrlReportUtil.getObjectString(this.params.get("rbParamNo")));
        if (paramNo) {
            sbSQL.append(" and d.FIsDynamicSQL <> 1 ");
        } else if (paramYes) {
            sbSQL.append(" and d.FIsDynamicSQL = 1 ");
        }
        boolean systemCurrent = new Boolean(CtrlReportUtil.getObjectString(this.params.get("rbSystemCurrent")));
        if (systemCurrent) {
            sbSQL.append(" and d.FtreeNodeID = '").append(this.reportUI.getCustTreeID()).append("' ");
        }
        logger.debug((Object)("filter sql = " + sbSQL.toString()));
        this.fillData(sbSQL.toString(), queryValue);
    }

    private void fillSnapData() throws Exception {
        String strLocal = SysContext.getSysContext().getLocale().toString();
        String strOrgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(strOrgID);
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select s.fid, s.FSystemID, s.FOrgID, s.FReportID, d.fsnaptype, s.FReportTime, d.FCreatorID as reportCreatorID, d.ftemplettype,  ");
        sbSQL.append("s.Fname_").append(strLocal).append(" as snapname, ");
        sbSQL.append("s.FMemo_").append(strLocal).append(" as memo, ");
        sbSQL.append("org.Fname_").append(strLocal).append(" as orgname, ");
        sbSQL.append("d.Fname_").append(strLocal).append(" as reportname, ");
        sbSQL.append("u.Fname_").append(strLocal).append(" as user_name, ");
        sbSQL.append("up.Fname_").append(strLocal).append(" as update_user_name, ");
        sbSQL.append("s.fcreatorid, s.FCreateTime, s.FLastUpdateUserID, s.flastupdatetime ");
        sbSQL.append("from T_RM_ReportSnap s ");
        sbSQL.append("LEFT OUTER JOIN T_RM_DefineReport d on s.freportid = d.fid ");
        sbSQL.append("LEFT OUTER JOIN t_pm_user u on s.FCreatorID=u.fid ");
        sbSQL.append("LEFT OUTER JOIN t_pm_user up on s.FLastUpdateUserID=up.fid ");
        sbSQL.append("LEFT OUTER JOIN T_ORG_BaseUnit org on s.FOrgID=org.fid ");
        sbSQL.append("where s.FOrgID = ? ");
        String field = "s.FName_" + strLocal;
        CollectWhere.setWhere(sbSQL, this.params, "snapName", field, "like", "String");
        field = "d.FName_" + strLocal;
        CollectWhere.setWhere(sbSQL, this.params, "reportName", field, "like", "String");
        field = "u.fnumber";
        CollectWhere.setWhere(sbSQL, this.params, "createrAccount", field, "like", "String");
        field = "u.Fname_" + strLocal;
        CollectWhere.setWhere(sbSQL, this.params, "createrName", field, "like", "String");
        field = "s.FLastUpdateTime";
        CollectWhere.setWhere(sbSQL, this.params, "UpdateDateFrom", field, ">=", "date");
        CollectWhere.setWhere(sbSQL, this.params, "UpdateDateTo", field, "<=", "date");
        field = "s.FReportTime";
        CollectWhere.setWhere(sbSQL, this.params, "reportTimeFrom", field, ">=", "date");
        CollectWhere.setWhere(sbSQL, this.params, "reportTimeTo", field, "<=", "date");
        field = "d.FSnapType";
        CollectWhere.setWhere(sbSQL, this.params, "reportTypeString", field, "=", "number");
        field = "s.FMemo_" + strLocal;
        CollectWhere.setWhere(sbSQL, this.params, "memo", field, "like", "String");
        boolean systemCurrent = new Boolean(CtrlReportUtil.getObjectString(this.params.get("rbSystemCurrent")));
        if (systemCurrent) {
            sbSQL.append(" and s.FSystemID = '").append(this.reportUI.getSystemID()).append("' ");
        }
        logger.debug((Object)("filter sql = " + sbSQL.toString()));
        this.fillData(sbSQL.toString(), queryValue);
    }

    private void fillData(String sql, ArrayList queryValue) throws Exception {
        RptParams pr = new RptParams();
        pr.setString("MethodName", "getDBPageSizeList");
        pr.setString("sql", sql);
        pr.setObject("lstValue", (Object)queryValue);
        pr.setInt("start", 0);
        pr.setInt("rows", -1);
        RptParams ps_r = null;
        ps_r = FacadeFactory.commonExecuteNever(null, pr);
        ArrayList dataList = (ArrayList)ps_r.getObject("object");
        this.reportUI.fillData(dataList);
    }
}

