/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlreport.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.datacenter.DataCenterConnUtil;
import com.kingdee.bos.ctrl.common.datacenter.DataCenterInfo;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.data.InOutputParamVO;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.data.ProcedureDataType;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.ExtDBUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class CtrlDBUtil
extends DbUtil {
    private static Logger logger = Logger.getLogger(CtrlDBUtil.class);

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ArrayList executeQuery(Context ctx, String sql, ArrayList params) throws BOSException {
        ArrayList lst = new ArrayList();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException exc) {
            SQLUtils.cleanup((Connection)conn);
            throw new BOSException("CONFIG_EXCEPTION", (Throwable)exc);
        }
        try {
            ps = conn.prepareStatement(sql);
            if (params != null) {
                for (int i = 0; i < params.size(); ++i) {
                    Object obj = params.get(i);
                    if (obj instanceof HashMap) {
                        HashMap map = (HashMap)obj;
                        byte[] bContent = (byte[])map.get("Blob");
                        int length = Integer.parseInt(String.valueOf(map.get("Length")));
                        ps.setBinaryStream(i + 1, (InputStream)new ByteArrayInputStream(bContent, 0, length), length);
                        continue;
                    }
                    ps.setObject(i + 1, obj);
                }
            }
            rs = ps.executeQuery();
            lst = ExtDBUtil.setDataToList(rs);
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + sql, (Throwable)exc);
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return lst;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ArrayList executeQueryList(Context ctx, String sql, ArrayList params, int start, int rows) throws BOSException {
        ResultSet rs;
        PreparedStatement ps;
        Connection conn;
        ArrayList lst;
        block12: {
            lst = new ArrayList();
            conn = null;
            ps = null;
            rs = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
            }
            catch (SQLException exc) {
                SQLUtils.cleanup((Connection)conn);
                throw new BOSException("CONFIG_EXCEPTION", (Throwable)exc);
            }
            try {
                ps = conn.prepareStatement(sql);
                if (params != null) {
                    for (int i = 0; i < params.size(); ++i) {
                        Object obj = params.get(i);
                        if (obj instanceof HashMap) {
                            HashMap map = (HashMap)obj;
                            byte[] bContent = (byte[])map.get("Blob");
                            int length = Integer.parseInt(String.valueOf(map.get("Length")));
                            ps.setBinaryStream(i + 1, (InputStream)new ByteArrayInputStream(bContent, 0, length), length);
                            continue;
                        }
                        ps.setObject(i + 1, obj);
                    }
                }
                rs = ps.executeQuery();
                JdbcRowSet rowset = new JdbcRowSet();
                rowset.populate(rs, start, rows, true);
                lst = ExtDBUtil.setDataToList((ResultSet)rowset);
                if (rowset == null) break block12;
                try {
                    rowset.close();
                }
                catch (Exception _) {
                    // empty catch block
                }
                rowset = null;
            }
            catch (SQLException exc) {
                try {
                    throw new BOSException("Sql execute exception : " + sql, (Throwable)exc);
                    catch (Exception e) {
                        throw new BOSException((Throwable)e);
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, (Statement)ps, (Connection)conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return lst;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IRowSet executeQuerySet(Context ctx, String sql, ArrayList params) throws BOSException {
        JdbcRowSet jdbcRowSet;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException exc) {
            SQLUtils.cleanup((Connection)conn);
            throw new BOSException("CONFIG_EXCEPTION", (Throwable)exc);
        }
        try {
            ps = conn.prepareStatement(sql);
            if (params != null) {
                for (int i = 0; i < params.size(); ++i) {
                    Object obj = params.get(i);
                    if (obj instanceof HashMap) {
                        HashMap map = (HashMap)obj;
                        byte[] bContent = (byte[])map.get("Blob");
                        int length = Integer.parseInt(String.valueOf(map.get("Length")));
                        ps.setBinaryStream(i + 1, (InputStream)new ByteArrayInputStream(bContent, 0, length), length);
                        continue;
                    }
                    ps.setObject(i + 1, obj);
                }
            }
            rs = ps.executeQuery();
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            jdbcRowSet = rowset;
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + sql, (Throwable)exc);
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return jdbcRowSet;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IRowSet executeQuerySet(Context ctx, String sql, ArrayList params, int start, int rows) throws BOSException {
        JdbcRowSet jdbcRowSet;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException exc) {
            SQLUtils.cleanup((Connection)conn);
            throw new BOSException("CONFIG_EXCEPTION", (Throwable)exc);
        }
        try {
            ps = conn.prepareStatement(sql);
            if (params != null) {
                for (int i = 0; i < params.size(); ++i) {
                    Object obj = params.get(i);
                    if (obj instanceof HashMap) {
                        HashMap map = (HashMap)obj;
                        byte[] bContent = (byte[])map.get("Blob");
                        int length = Integer.parseInt(String.valueOf(map.get("Length")));
                        ps.setBinaryStream(i + 1, (InputStream)new ByteArrayInputStream(bContent, 0, length), length);
                        continue;
                    }
                    ps.setObject(i + 1, obj);
                }
            }
            rs = ps.executeQuery();
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs, start, rows, true);
            jdbcRowSet = rowset;
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Error Message : " + exc.getMessage(), (Throwable)exc);
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return jdbcRowSet;
    }

    public static IRowSet executeQuerySet(DataCenterInfo vo, String sql, ArrayList params) throws BOSException {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = DataCenterConnUtil.openConnection((DataCenterInfo)vo);
        }
        catch (Exception e) {
            DataCenterConnUtil.closeConnection((Connection)conn);
            throw new BOSException("open out database error, the database name is: " + vo.getDbCenterName(), (Throwable)e);
        }
        try {
            ps = conn.prepareStatement(sql);
            if (params != null) {
                for (int i = 0; i < params.size(); ++i) {
                    Object obj = params.get(i);
                    if (obj instanceof HashMap) {
                        HashMap map = (HashMap)obj;
                        byte[] bContent = (byte[])map.get("Blob");
                        int length = Integer.parseInt(String.valueOf(map.get("Length")));
                        ps.setBinaryStream(i + 1, (InputStream)new ByteArrayInputStream(bContent, 0, length), length);
                        continue;
                    }
                    ps.setObject(i + 1, obj);
                }
            }
            rs = ps.executeQuery();
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            JdbcRowSet jdbcRowSet = rowset;
            return jdbcRowSet;
        }
        catch (SQLException exc) {
            throw new BOSException("Sql execute exception : " + sql, (Throwable)exc);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception _) {}
                rs = null;
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Exception _) {}
                ps = null;
            }
            DataCenterConnUtil.closeConnection((Connection)conn);
        }
    }

    public static HashMap callProcedureLocal(Context ctx, String procedureName, int dbType, String resultNumberName, ArrayList paramList, int start, int rows) throws BOSException {
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException exc) {
            SQLUtils.cleanup((Connection)conn);
            throw new BOSException("CONFIG_EXCEPTION", (Throwable)exc);
        }
        try {
            HashMap exc = CtrlDBUtil.callProcedure(conn, procedureName, dbType, resultNumberName, paramList, start, rows);
            return exc;
        }
        catch (BOSException exc) {
            throw exc;
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    public static HashMap callProcedureOutBD(DataCenterInfo vo, String procedureName, int dbType, String resultNumberName, ArrayList paramList, int start, int rows) throws BOSException {
        Connection conn = null;
        try {
            conn = DataCenterConnUtil.openConnection((DataCenterInfo)vo);
        }
        catch (Exception e) {
            DataCenterConnUtil.closeConnection((Connection)conn);
            throw new BOSException("open out database error, the database name is: " + vo.getDbCenterName(), (Throwable)e);
        }
        try {
            HashMap e = CtrlDBUtil.callProcedure(conn, procedureName, dbType, resultNumberName, paramList, start, rows);
            return e;
        }
        catch (BOSException exc) {
            throw exc;
        }
        finally {
            DataCenterConnUtil.closeConnection((Connection)conn);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static HashMap callProcedure(Connection conn, String procedureName, int dbType, String resultNumberName, ArrayList paramList, int start, int rows) throws BOSException {
        HashMap<String, InOutputParamVO> outputParamInMap = new HashMap<String, InOutputParamVO>();
        HashMap<String, Object> outputParamReturnMap = new HashMap<String, Object>();
        Statement cstmt = null;
        ResultSet rs = null;
        String callSQL = null;
        try {
            int n;
            int size;
            StringBuffer sb = new StringBuffer();
            sb.append("{call ").append(procedureName);
            if (paramList.isEmpty()) {
                sb.append("()}");
                callSQL = sb.toString();
            } else {
                sb.append("(");
                size = paramList.size();
                for (n = 0; n < size; ++n) {
                    sb.append("?,");
                }
                callSQL = sb.toString();
                callSQL = callSQL.substring(0, callSQL.length() - 1);
                callSQL = callSQL + ")}";
            }
            cstmt = conn.prepareCall(callSQL);
            if (!paramList.isEmpty()) {
                size = paramList.size();
                for (n = 0; n < size; ++n) {
                    InOutputParamVO vo = (InOutputParamVO)paramList.get(n);
                    int ioType = vo.getIoType();
                    int dataType = vo.getDataType();
                    if (ioType == 0) {
                        Object valueObj = vo.getValue();
                        CtrlDBUtil.setColumnValue(n + 1, valueObj, (PreparedStatement)cstmt);
                        continue;
                    }
                    if (dataType == ProcedureDataType.CURSOR.intValue()) {
                        cstmt.registerOutParameter(n + 1, -10);
                    } else {
                        switch (dataType) {
                            case 0: {
                                cstmt.registerOutParameter(n + 1, 12);
                                break;
                            }
                            case 1: {
                                cstmt.registerOutParameter(n + 1, 4);
                                break;
                            }
                            case 2: {
                                cstmt.registerOutParameter(n + 1, 8);
                                break;
                            }
                            case 3: {
                                cstmt.registerOutParameter(n + 1, 91);
                                break;
                            }
                            case 4: {
                                cstmt.registerOutParameter(n + 1, 93);
                                break;
                            }
                            case 5: {
                                cstmt.registerOutParameter(n + 1, 92);
                                break;
                            }
                            default: {
                                throw new BOSException("no found the out param type : " + vo.getDataType());
                            }
                        }
                    }
                    InOutputParamVO iov = new InOutputParamVO();
                    iov.setName(vo.getName());
                    iov.setIoType(1);
                    iov.setDataType(dataType);
                    iov.setValue(new Integer(n + 1));
                    outputParamInMap.put(vo.getName(), iov);
                }
            }
            boolean isFind = true;
            int point = 1;
            int resultNumber = -1;
            if (dbType != 2) {
                isFind = false;
                resultNumber = Integer.parseInt(resultNumberName);
            }
            int updateCount = -1;
            boolean flag = cstmt.execute();
            while (true) {
                if (flag) {
                    rs = cstmt.getResultSet();
                    if (rs != null) {
                        if (dbType != 2 && point == resultNumber) {
                            JdbcRowSet rowset = new JdbcRowSet();
                            if (rows == -1) {
                                rowset.populate(rs);
                            } else {
                                rowset.populate(rs, start, rows, true);
                            }
                            outputParamReturnMap.put("6xx8xxRowset", rowset);
                            isFind = true;
                        }
                        CtrlDBUtil.closeRs(rs);
                    }
                    ++point;
                    flag = cstmt.getMoreResults();
                    continue;
                }
                if (flag) continue;
                updateCount = cstmt.getUpdateCount();
                if (updateCount == -1) break;
                flag = cstmt.getMoreResults();
            }
            if (!isFind) {
                throw new BOSException("\u627e\u4e0d\u5230\u6307\u5b9a\u7684\u7ed3\u679c\u96c6: " + resultNumber);
            }
            Iterator it = outputParamInMap.keySet().iterator();
            while (it.hasNext()) {
                String key = it.next().toString();
                if (key.equals("6xx8xxRowset")) continue;
                InOutputParamVO iov = (InOutputParamVO)outputParamInMap.get(key);
                Integer ie = (Integer)iov.getValue();
                int int_ie = ie;
                Object objValue = cstmt.getObject(int_ie);
                if (objValue instanceof ResultSet) {
                    ResultSet oracleRs = (ResultSet)objValue;
                    JdbcRowSet rowset = new JdbcRowSet();
                    if (rows == -1) {
                        rowset.populate(oracleRs);
                    } else {
                        rowset.populate(oracleRs, start, rows, true);
                    }
                    iov.setValue(rowset);
                    if (key.equals(resultNumberName)) {
                        outputParamReturnMap.put("6xx8xxRowset", rowset);
                    }
                    if (oracleRs == null) continue;
                    try {
                        oracleRs.close();
                    }
                    catch (SQLException e) {}
                    continue;
                }
                iov.setValue(objValue);
                outputParamReturnMap.put(key, iov);
            }
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("error procedure: " + procedureName + ", " + exc.getMessage(), (Throwable)exc);
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                CtrlDBUtil.closeRs(rs);
                if (cstmt == null) throw throwable;
                try {
                    cstmt.close();
                    throw throwable;
                }
                catch (SQLException e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        CtrlDBUtil.closeRs(rs);
        if (cstmt == null) return outputParamReturnMap;
        try {
            cstmt.close();
            return outputParamReturnMap;
        }
        catch (SQLException e) {
            return outputParamReturnMap;
        }
    }

    private static void closeRs(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static IRowSet executeQuerySet(DataCenterInfo vo, String sql, ArrayList params, int start, int rows) throws BOSException {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = DataCenterConnUtil.openConnection((DataCenterInfo)vo);
        }
        catch (Exception e) {
            DataCenterConnUtil.closeConnection((Connection)conn);
            throw new BOSException("open out database error, the database name is: " + vo.getDbCenterName(), (Throwable)e);
        }
        try {
            ps = conn.prepareStatement(sql);
            if (params != null) {
                for (int i = 0; i < params.size(); ++i) {
                    Object obj = params.get(i);
                    if (obj instanceof HashMap) {
                        HashMap map = (HashMap)obj;
                        byte[] bContent = (byte[])map.get("Blob");
                        int length = Integer.parseInt(String.valueOf(map.get("Length")));
                        ps.setBinaryStream(i + 1, (InputStream)new ByteArrayInputStream(bContent, 0, length), length);
                        continue;
                    }
                    ps.setObject(i + 1, obj);
                }
            }
            rs = ps.executeQuery();
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs, start, rows, true);
            JdbcRowSet jdbcRowSet = rowset;
            return jdbcRowSet;
        }
        catch (SQLException exc) {
            throw new BOSException("Sql execute exception : " + sql, (Throwable)exc);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception _) {}
                rs = null;
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Exception _) {}
                ps = null;
            }
            DataCenterConnUtil.closeConnection((Connection)conn);
        }
    }

    public static boolean maintainRecord(Context ctx, String sql, ArrayList params) throws BOSException {
        boolean breturn = false;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException exc) {
            SQLUtils.cleanup((Connection)conn);
            throw new BOSException("CONFIG_EXCEPTION", (Throwable)exc);
        }
        try {
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < params.size(); ++i) {
                Object obj = params.get(i);
                if (obj instanceof HashMap) {
                    HashMap map = (HashMap)obj;
                    byte[] bContent = (byte[])map.get("Blob");
                    int length = Integer.parseInt(String.valueOf(map.get("Length")));
                    ps.setBinaryStream(i + 1, (InputStream)new ByteArrayInputStream(bContent, 0, length), length);
                    continue;
                }
                ps.setObject(i + 1, obj);
            }
            ps.execute();
            breturn = true;
        }
        catch (SQLException sqle) {
            throw new BOSException((Throwable)sqle);
        }
        finally {
            SQLUtils.cleanup(rs, (Statement)ps, (Connection)conn);
        }
        return breturn;
    }

    public static boolean maintainRecord(DataCenterInfo vo, String sql, ArrayList params) throws BOSException {
        boolean breturn = false;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = DataCenterConnUtil.openConnection((DataCenterInfo)vo);
        }
        catch (Exception e) {
            DataCenterConnUtil.closeConnection((Connection)conn);
            throw new BOSException("open out database error, the database name is: " + vo.getDbCenterName(), (Throwable)e);
        }
        try {
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < params.size(); ++i) {
                Object obj = params.get(i);
                if (obj instanceof HashMap) {
                    HashMap map = (HashMap)obj;
                    byte[] bContent = (byte[])map.get("Blob");
                    int length = Integer.parseInt(String.valueOf(map.get("Length")));
                    ps.setBinaryStream(i + 1, (InputStream)new ByteArrayInputStream(bContent, 0, length), length);
                    continue;
                }
                ps.setObject(i + 1, obj);
            }
            ps.execute();
            breturn = true;
        }
        catch (SQLException sqle) {
            throw new BOSException((Throwable)sqle);
        }
        finally {
            SQLUtils.cleanup(rs, (Statement)ps, (Connection)conn);
        }
        return breturn;
    }

    public static boolean executeBatch(Context ctx, ArrayList lstSQL) throws BOSException {
        boolean breturn = false;
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            conn.setAutoCommit(false);
        }
        catch (SQLException exc) {
            SQLUtils.cleanup((Connection)conn);
            throw new BOSException("CONFIG_EXCEPTION", (Throwable)exc);
        }
        try {
            stmt = conn.createStatement();
            Iterator it = lstSQL.iterator();
            while (it.hasNext()) {
                String strsql = String.valueOf(it.next());
                if (strsql.equals("null") || strsql.equals("")) continue;
                stmt.addBatch(strsql);
            }
            stmt.executeBatch();
            conn.commit();
            breturn = true;
        }
        catch (SQLException sqle) {
            try {
                conn.rollback();
            }
            catch (SQLException e) {
                // empty catch block
            }
            throw new BOSException((Throwable)sqle);
        }
        finally {
            SQLUtils.cleanup(null, (Statement)stmt, (Connection)conn);
        }
        return breturn;
    }

    private static void setColumnValue(int i, Object valueObj, PreparedStatement preparedStatement) throws BOSException {
        try {
            if (valueObj instanceof String) {
                preparedStatement.setString(i, (String)valueObj);
            } else if (valueObj instanceof Boolean) {
                preparedStatement.setBoolean(i, (Boolean)valueObj);
            } else if (valueObj instanceof Byte) {
                preparedStatement.setByte(i, (Byte)valueObj);
            } else if (valueObj instanceof Short) {
                preparedStatement.setShort(i, (Short)valueObj);
            } else if (valueObj instanceof Integer) {
                preparedStatement.setInt(i, (Integer)valueObj);
            } else if (valueObj instanceof Long) {
                preparedStatement.setLong(i, (Long)valueObj);
            } else if (valueObj instanceof Float) {
                preparedStatement.setFloat(i, ((Float)valueObj).floatValue());
            } else if (valueObj instanceof Double) {
                preparedStatement.setDouble(i, (Double)valueObj);
            } else if (valueObj instanceof BigDecimal) {
                preparedStatement.setBigDecimal(i, (BigDecimal)valueObj);
            } else if (valueObj instanceof Date) {
                preparedStatement.setDate(i, (Date)valueObj);
            } else if (valueObj instanceof Time) {
                preparedStatement.setTime(i, (Time)valueObj);
            } else if (valueObj instanceof Timestamp) {
                preparedStatement.setTimestamp(i, (Timestamp)valueObj);
            } else if (valueObj instanceof HashMap) {
                HashMap map = (HashMap)valueObj;
                byte[] bContent = (byte[])map.get("Blob");
                int length = Integer.parseInt(String.valueOf(map.get("Length")));
                preparedStatement.setBinaryStream(i, (InputStream)new ByteArrayInputStream(bContent, 0, length), length);
            } else {
                preparedStatement.setObject(i, valueObj);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readBlob(Context ctx, String sql, ArrayList params, int length) throws BOSException {
        PreparedStatement ps;
        ResultSet rs;
        Connection conn;
        byte[] bContent;
        block14: {
            bContent = new byte[length];
            conn = null;
            rs = null;
            ps = null;
            InputStream stream = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
            }
            catch (SQLException exc) {
                SQLUtils.cleanup((Connection)conn);
                throw new BOSException("CONFIG_EXCEPTION", (Throwable)exc);
            }
            try {
                ps = conn.prepareStatement(sql);
                for (int i = 0; i < params.size(); ++i) {
                    ps.setObject(i + 1, params.get(i));
                }
                rs = ps.executeQuery();
                if (rs.next() && (stream = rs.getBinaryStream(1)) != null) {
                    stream.read(bContent);
                }
                if (stream == null) break block14;
            }
            catch (SQLException sqle) {
                try {
                    throw new BOSException((Throwable)sqle);
                    catch (IOException ioe) {
                        throw new BOSException((Throwable)ioe);
                    }
                }
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Exception ex) {
                            logger.error((Object)"", (Throwable)ex);
                        }
                    }
                    SQLUtils.cleanup(rs, (Statement)ps, (Connection)conn);
                    throw throwable;
                }
            }
            try {
                stream.close();
            }
            catch (Exception ex) {
                logger.error((Object)"", (Throwable)ex);
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return bContent;
    }
}

