/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlreport.email;

import com.kingdee.eas.base.reportmeta.ctrlreport.email.Attachment;
import com.kingdee.eas.base.reportmeta.ctrlreport.email.MailInfo;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.SocketAddress;
import java.security.AccessController;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;
import sun.security.action.GetPropertyAction;

public class SmtpSender {
    Logger log = Logger.getLogger(SmtpSender.class);
    public static final byte LOCATION_TO_NULL = 0;
    public static final byte LOCATION_TO_SCREEN = 1;
    private static final DateFormat dateformat = new SimpleDateFormat("yyyy-mm-dd hh:mm:ss");
    private static final String end_flag = "\r\n";
    private static final String email_attach_sign = "Boundary-=_hMbeqwnGNoWeLsRMeKTIPeofyStu";
    Socket clientmailsocket;
    InputStream indata;
    OutputStream outdata;
    MailInfo mailInfo;
    private int logLocation = 0;
    static String defaultCharset = null;

    public SmtpSender(MailInfo mailInfo) {
        this.mailInfo = mailInfo;
    }

    public int getLogLocation() {
        return this.logLocation;
    }

    public void setLogLocation(int logLocation) {
        this.logLocation = logLocation;
    }

    public static void printlogger(String _log, int _locaton) {
        switch (_locaton) {
            case 0: {
                break;
            }
            case 1: {
                System.out.println("[" + dateformat.format(new Date()) + "] " + _log);
                break;
            }
            default: {
                System.out.println("[" + dateformat.format(new Date()) + "] " + _log);
            }
        }
    }

    public boolean createconnection() throws IOException {
        this.freeall();
        this.clientmailsocket = new Socket(this.mailInfo.getSmtpServer(), this.mailInfo.getSmtpPort()){

            public void connect(SocketAddress endpoint) throws IOException {
                this.connect(endpoint, 5000);
            }
        };
        SmtpSender.printlogger("connect to email server " + this.mailInfo.getSmtpServer() + " on port " + this.mailInfo.getSmtpPort(), this.logLocation);
        this.indata = this.clientmailsocket.getInputStream();
        this.outdata = this.clientmailsocket.getOutputStream();
        this.fetchcmdresult();
        return true;
    }

    public String response(InputStream in) throws IOException {
        byte[] buffer = new byte[1024];
        StringBuffer indata = new StringBuffer();
        int n = 0;
        n = in.read(buffer);
        indata.append(new String(buffer, 0, n));
        this.log.error((Object)indata.toString());
        SmtpSender.printlogger("cmdresult=" + indata.toString(), this.logLocation);
        return indata.toString();
    }

    public static void send(String s, OutputStream out) throws IOException {
        byte[] buffer = s.getBytes();
        out.write(buffer);
        out.flush();
    }

    public void sendbyte(byte[] date, int off, int len) throws IOException {
        SmtpSender.send(date, off, len, this.outdata);
    }

    public static void send(byte[] date, int off, int len, OutputStream out) throws IOException {
        out.write(date, off, len);
        out.flush();
    }

    public String fetchcmdresult() throws IOException {
        return this.response(this.indata);
    }

    public boolean sendcmd(String _cmd) throws IOException {
        if (_cmd != null) {
            SmtpSender.send(_cmd, this.outdata);
            SmtpSender.printlogger("cmd=" + _cmd, this.logLocation);
        }
        return true;
    }

    public boolean sendmail() throws Exception {
        this.createconnection();
        StringBuffer thecontent = null;
        try {
            int i;
            int count;
            thecontent = new StringBuffer();
            thecontent.append("ehlo ");
            thecontent.append(this.mailInfo.getSmtpServer());
            thecontent.append(end_flag);
            this.sendcmd(thecontent.toString());
            if (this.fetchcmdresult().indexOf("250") == -1) {
                boolean bl = false;
                return bl;
            }
            thecontent = new StringBuffer();
            thecontent.append("auth login");
            thecontent.append(end_flag);
            this.sendcmd(thecontent.toString());
            if (this.fetchcmdresult().indexOf("334") == -1) {
                boolean bl = false;
                return bl;
            }
            thecontent = new StringBuffer();
            thecontent.append(SmtpSender.base64encode(this.mailInfo.getMailUserName()));
            thecontent.append(end_flag);
            this.sendcmd(thecontent.toString());
            if (this.fetchcmdresult().indexOf("334") == -1) {
                boolean bl = false;
                return bl;
            }
            thecontent = new StringBuffer();
            thecontent.append(SmtpSender.base64encode(this.mailInfo.getMailPassword()));
            thecontent.append(end_flag);
            this.sendcmd(thecontent.toString());
            if (this.fetchcmdresult().indexOf("235") == -1) {
                boolean bl = false;
                return bl;
            }
            thecontent = new StringBuffer();
            thecontent.append("mail from:");
            thecontent.append("<");
            thecontent.append(this.mailInfo.getMailFrom());
            thecontent.append(">");
            thecontent.append(end_flag);
            this.sendcmd(thecontent.toString());
            if (this.fetchcmdresult().indexOf("250") == -1) {
                boolean bl = false;
                return bl;
            }
            String[] mailto = this.mailInfo.getMailTo();
            if (mailto != null) {
                count = mailto.length;
                for (i = 0; i < count; ++i) {
                    thecontent = new StringBuffer();
                    thecontent.append("rcpt to:");
                    thecontent.append("<");
                    thecontent.append(mailto[i]);
                    thecontent.append(">");
                    thecontent.append(end_flag);
                    this.sendcmd(thecontent.toString());
                    if (this.fetchcmdresult().indexOf("250") != -1) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            thecontent = new StringBuffer();
            thecontent.append("data");
            thecontent.append(end_flag);
            this.sendcmd(thecontent.toString());
            if (this.fetchcmdresult().indexOf("354") == -1) {
                count = 0;
                return count != 0;
            }
            thecontent = new StringBuffer();
            thecontent.append("from:");
            thecontent.append(this.mailInfo.getMailShowFrom());
            thecontent.append(end_flag);
            thecontent.append("to:");
            thecontent.append(this.mailInfo.getMailShowTo());
            thecontent.append(end_flag);
            thecontent.append("subject:");
            thecontent.append(this.getGBKString(this.mailInfo.getMailSubject()));
            thecontent.append(end_flag);
            thecontent.append("mime-version: 1.0");
            thecontent.append(end_flag);
            thecontent.append("content-type: multipart/mixed;boundary=\"");
            thecontent.append(email_attach_sign);
            thecontent.append("\"");
            thecontent.append(end_flag);
            thecontent.append(end_flag);
            this.sendcmd(thecontent.toString());
            thecontent = new StringBuffer();
            thecontent.append("--");
            thecontent.append(email_attach_sign);
            thecontent.append(end_flag);
            thecontent.append("content-type:text/plain;charset=\"" + SmtpSender.defaultCharset() + "\"");
            thecontent.append(end_flag);
            thecontent.append("content-transfer-encoding: base64");
            thecontent.append(end_flag);
            thecontent.append(end_flag);
            thecontent.append(SmtpSender.base64encode(this.mailInfo.getMailBody(), "UTF-8"));
            thecontent.append(end_flag);
            this.sendcmd(thecontent.toString());
            Attachment[] attachment = this.mailInfo.getAttachments();
            if (attachment != null && attachment.length > 0) {
                for (i = 0; i < attachment.length; ++i) {
                    thecontent = new StringBuffer();
                    thecontent.append("--");
                    thecontent.append(email_attach_sign);
                    thecontent.append(end_flag);
                    thecontent.append("content-type:" + attachment[i].getContentType() + ";charset=\"" + SmtpSender.defaultCharset() + "\";name=\"" + this.getGBKString(attachment[i].getName()) + "\"");
                    thecontent.append(end_flag);
                    thecontent.append("content-transfer-encoding: base64");
                    thecontent.append(end_flag);
                    thecontent.append("content-disposition:attachment;name=\"" + attachment[i].getName() + "\"");
                    thecontent.append(end_flag);
                    thecontent.append(end_flag);
                    this.sendcmd(thecontent.toString());
                    this.sendAttachment(attachment[i].getContent());
                }
            }
            thecontent = new StringBuffer();
            thecontent.append(end_flag);
            thecontent.append("--");
            thecontent.append(email_attach_sign);
            thecontent.append("--");
            thecontent.append(end_flag);
            this.sendcmd(thecontent.toString());
            thecontent = new StringBuffer();
            thecontent.append(end_flag);
            thecontent.append(".");
            thecontent.append(end_flag);
            this.sendcmd(thecontent.toString());
            if (this.fetchcmdresult().indexOf("250") == -1) {
                boolean bl = false;
                return bl;
            }
            thecontent = new StringBuffer();
            thecontent.append("quit");
            thecontent.append(end_flag);
            this.sendcmd(thecontent.toString());
            this.fetchcmdresult();
        }
        catch (Exception e) {
            this.log.error((Object)"code line361  \u629b\u51fa\u5f02\u5e38\ne");
            throw e;
        }
        finally {
            this.freeall();
            thecontent = null;
        }
        return true;
    }

    public void sendBase64Data(StringBuffer srcdata) throws IOException {
        int len_cmd_data = 76;
        int startindex = 0;
        int totallength = 0;
        if (srcdata != null && srcdata.length() > 0) {
            totallength = srcdata.length();
            while (true) {
                if (startindex + len_cmd_data >= totallength) {
                    this.sendcmd(srcdata.substring(startindex, totallength));
                    this.sendcmd(end_flag);
                    break;
                }
                this.sendcmd(srcdata.substring(startindex, startindex + len_cmd_data));
                this.sendcmd(end_flag);
                startindex += len_cmd_data;
            }
        }
    }

    public void freeall() {
        if (this.indata != null) {
            try {
                this.indata.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.indata = null;
        }
        if (this.outdata != null) {
            try {
                this.outdata.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.outdata = null;
        }
        if (this.clientmailsocket != null) {
            try {
                this.clientmailsocket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.clientmailsocket = null;
        }
    }

    public String readfile(String filename) throws IOException {
        byte[] filebuffer = new byte[131072];
        int realsize = 0;
        StringBuffer readcontent = new StringBuffer();
        FileInputStream infile = new FileInputStream(new File(filename));
        while (-1 != (realsize = ((InputStream)infile).read(filebuffer))) {
            readcontent.append(new String(filebuffer, 0, realsize));
        }
        return readcontent.toString();
    }

    public String sendAttachment(byte[] attachment) throws Exception {
        if (attachment == null || attachment.length == 0) {
            return "";
        }
        int len_cmd_data = 54;
        int realsize = 0;
        StringBuffer readcontent = new StringBuffer();
        ByteArrayInputStream infile = new ByteArrayInputStream(attachment);
        do {
            byte[] filebuffer = new byte[len_cmd_data];
            try {
                realsize = ((InputStream)infile).read(filebuffer, 0, len_cmd_data);
            }
            catch (IOException e) {
                e.printStackTrace();
                realsize = -1;
            }
            if (realsize == -1) break;
            String res = SmtpSender.base64encode2(filebuffer);
            this.sendBase64Data(new StringBuffer(res));
            this.sendcmd(end_flag);
        } while (realsize == len_cmd_data);
        return readcontent.toString();
    }

    public String readfileAndSend(String filename) throws Exception {
        byte[] filebuffer;
        int len_cmd_data = 54;
        int realsize = 0;
        StringBuffer readcontent = new StringBuffer();
        FileInputStream infile = new FileInputStream(new File(filename));
        FileOutputStream outfile = new FileOutputStream(new File("L:/backup.xls"));
        while ((realsize = ((InputStream)infile).read(filebuffer = new byte[len_cmd_data], 0, len_cmd_data)) != -1) {
            String res = SmtpSender.base64encode2(filebuffer);
            this.sendBase64Data(new StringBuffer(res));
            ((OutputStream)outfile).write(filebuffer, 0, realsize);
            this.sendcmd(end_flag);
            if (realsize == len_cmd_data) continue;
        }
        outfile.flush();
        ((OutputStream)outfile).close();
        ((InputStream)infile).close();
        return readcontent.toString();
    }

    public static String base64encode2(byte[] src) throws Exception {
        int i;
        if (src == null || src.length == 0) {
            return "";
        }
        String encodingtable = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
        byte[] buffer = src;
        char[] writebuf = new char[4];
        char[] buf = new char[3];
        String encodedstr = "";
        int readindex = 0;
        int len = buffer.length;
        int byteswritten = 0;
        int readnow = 0;
        do {
            boolean isend = false;
            for (i = 0; i < 3; ++i) {
                if (readindex >= len) {
                    isend = true;
                    readnow = i;
                    break;
                }
                buf[i] = (char)(buffer[readindex] & 0xFF);
                ++readindex;
            }
            if (isend) break;
            writebuf[0] = encodingtable.charAt(buf[0] >> 2 & 0x3F);
            writebuf[1] = encodingtable.charAt(((buf[0] & 3) << 4 | buf[1] >> 4) & 0x3F);
            writebuf[2] = encodingtable.charAt(((buf[1] & 0xF) << 2 | buf[2] >> 6) & 0x3F);
            writebuf[3] = encodingtable.charAt(buf[2] & 0x3F & 0x3F);
            for (i = 0; i < 4; ++i) {
                encodedstr = encodedstr + writebuf[i];
            }
            if ((byteswritten += 4) % 76 != 0) continue;
            encodedstr = encodedstr + "";
        } while (readnow != 3);
        if (readnow < 3) {
            switch (readnow) {
                case 1: {
                    writebuf[0] = encodingtable.charAt(buf[0] >> 2 & 0x3F);
                    writebuf[1] = encodingtable.charAt((buf[0] & 3) << 4 & 0x3F);
                    writebuf[2] = 61;
                    writebuf[3] = 61;
                    for (i = 0; i < 4; ++i) {
                        encodedstr = encodedstr + writebuf[i];
                    }
                    break;
                }
                case 2: {
                    writebuf[0] = encodingtable.charAt(buf[0] >> 2 & 0x3F);
                    writebuf[1] = encodingtable.charAt(((buf[0] & 3) << 4 | buf[1] >> 4) & 0x3F);
                    writebuf[2] = encodingtable.charAt((buf[1] & 0xF) << 2 & 0x3F);
                    writebuf[3] = 61;
                    for (i = 0; i < 4; ++i) {
                        encodedstr = encodedstr + writebuf[i];
                    }
                    break;
                }
            }
        }
        return encodedstr;
    }

    public static String base64encode(String src) throws Exception {
        return SmtpSender.base64encode(src, null);
    }

    public static String base64encode(String src, String encoding) throws Exception {
        int i;
        if (src == null || src.length() == 0) {
            return "";
        }
        String encodingtable = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
        byte[] buffer = encoding == null ? src.getBytes() : src.getBytes(encoding);
        char[] writebuf = new char[4];
        char[] buf = new char[3];
        String encodedstr = "";
        int readindex = 0;
        int len = buffer.length;
        int byteswritten = 0;
        int readnow = 0;
        do {
            boolean isend = false;
            for (i = 0; i < 3; ++i) {
                if (readindex >= len) {
                    isend = true;
                    readnow = i;
                    break;
                }
                buf[i] = (char)(buffer[readindex] & 0xFF);
                ++readindex;
            }
            if (isend) break;
            writebuf[0] = encodingtable.charAt(buf[0] >> 2 & 0x3F);
            writebuf[1] = encodingtable.charAt(((buf[0] & 3) << 4 | buf[1] >> 4) & 0x3F);
            writebuf[2] = encodingtable.charAt(((buf[1] & 0xF) << 2 | buf[2] >> 6) & 0x3F);
            writebuf[3] = encodingtable.charAt(buf[2] & 0x3F & 0x3F);
            for (i = 0; i < 4; ++i) {
                encodedstr = encodedstr + writebuf[i];
            }
            if ((byteswritten += 4) % 76 != 0) continue;
            encodedstr = encodedstr + "";
        } while (readnow != 3);
        if (readnow < 3) {
            switch (readnow) {
                case 1: {
                    writebuf[0] = encodingtable.charAt(buf[0] >> 2 & 0x3F);
                    writebuf[1] = encodingtable.charAt((buf[0] & 3) << 4 & 0x3F);
                    writebuf[2] = 61;
                    writebuf[3] = 61;
                    for (i = 0; i < 4; ++i) {
                        encodedstr = encodedstr + writebuf[i];
                    }
                    break;
                }
                case 2: {
                    writebuf[0] = encodingtable.charAt(buf[0] >> 2 & 0x3F);
                    writebuf[1] = encodingtable.charAt(((buf[0] & 3) << 4 | buf[1] >> 4) & 0x3F);
                    writebuf[2] = encodingtable.charAt((buf[1] & 0xF) << 2 & 0x3F);
                    writebuf[3] = 61;
                    for (i = 0; i < 4; ++i) {
                        encodedstr = encodedstr + writebuf[i];
                    }
                    break;
                }
            }
        }
        return encodedstr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String defaultCharset() {
        Class<SmtpSender> clazz = SmtpSender.class;
        synchronized (SmtpSender.class) {
            if (defaultCharset == null) {
                GetPropertyAction pa = new GetPropertyAction("file.encoding");
                String csn = AccessController.doPrivileged(pa);
                System.out.println("aaaaaaaaaaaaaaaaaaaaaaaaaaa = " + csn);
                if (csn != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return csn;
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return "UTF-8";
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultCharset;
        }
    }

    private String getGBKString(String src) throws Exception {
        if (src == null) {
            return null;
        }
        StringBuffer thecontent = new StringBuffer();
        thecontent.append("=?gbk?B?");
        try {
            thecontent.append(SmtpSender.base64encode(src, "GBK"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        thecontent.append("?=");
        return thecontent.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        MailInfo mailInfo = new MailInfo();
        mailInfo.setSmtpServer("127.0.0.1");
        mailInfo.setSmtpPort(25);
        mailInfo.setMailUserName("fuxiuhu");
        mailInfo.setMailPassword("****");
        mailInfo.setMailTo(new String[]{"junwu_qin@kingdee.com", "fuxiuhu@kingdee.com"});
        mailInfo.setMailFrom("fuxiuhu@kingdee.com");
        mailInfo.setMailShowTo("junwu_qin@kingdee.com;fuxiuhu@kingdee.com");
        mailInfo.setMailShowFrom("fuxiuhu@kingdee.com");
        mailInfo.setMailSubject("\u6269\u5c55\u62a5\u8868\u90ae\u4ef6 \u6d4b\u8bd5\u6d88\u606f");
        mailInfo.setMailBody("\u7814\u53d1\u4ea7\u54c1\u5f00\u53d1\u6d4b\u8bd5\uff1awelcome for you. mmm.\u4e2d\u6587\u5440.aaa \r\n\u8f7d\u6765\u4e00\u884c");
        RandomAccessFile rfile = null;
        byte[] classBytes = null;
        try {
            rfile = new RandomAccessFile("d:\\d001_tmpl_.xls", "r");
            classBytes = new byte[(int)rfile.length()];
            rfile.read(classBytes);
            rfile.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (rfile != null) {
                try {
                    rfile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        Attachment attach1 = new Attachment("gogogo.xls", "application/vnd.ms-excel", classBytes);
        Attachment attach2 = new Attachment("\u5f88\u597d.txt", "text/plain", "\u5f88\u597d\u5f88\u5f3a\u5927".getBytes());
        mailInfo.setAttachments(new Attachment[]{attach1, attach2});
        try {
            if (SmtpSender.sendMail(mailInfo, 0)) {
                System.out.println("ok============");
            } else {
                System.out.println("faild============");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean sendMail(MailInfo mailInfo, int logLocation) throws Exception {
        SmtpSender foxmail = new SmtpSender(mailInfo);
        return foxmail.sendmail();
    }
}

