/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlreport.model;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSetManager;
import com.kingdee.bos.ctrl.kds.io.kds.AuthorizationFailedException;
import com.kingdee.bos.ctrl.kds.io.kds.HighVersionException;
import com.kingdee.bos.ctrl.kds.io.kds.InvalidCouponException;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.eas.base.reportmeta.ctrlreport.bo.DefineReportBO;
import com.kingdee.eas.base.reportmeta.ctrlreport.bo.KSQLReportBO;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.CheckJavaDataSetException;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.KSQLReportInfo;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.CtrlDesignUtil;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.RunReportParam;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.SqlDSModelDrill;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.param.IJavaDataSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CheckJavaDataSet {
    public static boolean checkUIType(Context ctx, String id) throws CheckJavaDataSetException {
        try {
            Book _book = MiscUtil.unpack((byte[])DefineReportBO.getReportInfo(ctx, id).getContent());
            ExtDataSetManager dataSetManager = _book.getDataSetManager();
            int size = dataSetManager.size();
            for (int i = 0; i < size; ++i) {
                ExtDataSet dataSet = dataSetManager.getAt(i);
                int customType = 0;
                String meta = dataSet.getMeta();
                if (StringUtil.isEmptyString((String)meta)) {
                    String define = dataSet.getDefine();
                    HashMap mapDefine = RunReportParam.splitDefineToMap(define);
                    if ("sql_ksql".endsWith((String)mapDefine.get("DataSetType"))) {
                        String dbsourceid = CtrlReportUtil.getObjectString(mapDefine.get("DbSourceID"));
                        String orgID = CtrlReportUtil.getObjectString(mapDefine.get("OrgID"));
                        String systemid = CtrlReportUtil.getObjectString(mapDefine.get("SystemID"));
                        String dbsourcename = CtrlReportUtil.getObjectString(mapDefine.get("DbSourceName"));
                        KSQLReportInfo info = KSQLReportBO.getKSQLReportInfo(ctx, systemid, dbsourcename, orgID, dbsourceid);
                        customType = info.getCustomType();
                        meta = new String(info.getContent());
                    }
                } else {
                    String innerLinkXmlString = SqlDSModelDrill.split2(meta);
                    if (innerLinkXmlString.indexOf(CtrlDesignUtil.CustomType + "=\"3\"") != -1) {
                        customType = 3;
                    }
                }
                if (3 != customType) continue;
                ArrayList className = CheckJavaDataSet.getClassName(meta);
                for (int j = 0; j < className.size(); ++j) {
                    IJavaDataSet iJavaDataSet = (IJavaDataSet)Class.forName(className.get(j).toString()).newInstance();
                    if (!iJavaDataSet.isUIType()) continue;
                    return false;
                }
            }
        }
        catch (HighVersionException e) {
            throw new CheckJavaDataSetException(e);
        }
        catch (InvalidCouponException e) {
            throw new CheckJavaDataSetException(e);
        }
        catch (AuthorizationFailedException e) {
            throw new CheckJavaDataSetException(e);
        }
        catch (InstantiationException e) {
            throw new CheckJavaDataSetException(e);
        }
        catch (IllegalAccessException e) {
            throw new CheckJavaDataSetException(e);
        }
        catch (ClassNotFoundException e) {
            throw new CheckJavaDataSetException(e);
        }
        catch (BOSException e) {
            throw new CheckJavaDataSetException(e);
        }
        return true;
    }

    private static ArrayList getClassName(String xml) {
        ArrayList<String> javaNodes = new ArrayList<String>();
        String regEx = ".+(<Java(.*?)</Java>)";
        Pattern p = Pattern.compile(regEx, 32);
        Matcher m = p.matcher(xml);
        while (m.find()) {
            javaNodes.add(m.group(1));
        }
        regEx = ".+fullname=\"(.*?)\"";
        p = Pattern.compile(regEx, 32);
        ArrayList<String> className = new ArrayList<String>();
        for (int i = 0; i < javaNodes.size(); ++i) {
            m = p.matcher(javaNodes.get(i).toString());
            while (m.find()) {
                className.add(m.group(1));
            }
        }
        return className;
    }
}

