/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlreport.portlet;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.ORMRPCServiceLocator;
import com.kingdee.bos.ctrl.common.util.DBUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extcommon.server.DbUtil;
import com.kingdee.bos.ctrl.extcommon.server.ServerUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.reportmeta.ctrlreport.portlet.IPortletPublisher;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.factory.FacadeFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.portal.IPortalServiceFacade;
import com.kingdee.eas.portal.IPortlet;
import com.kingdee.eas.portal.PortalServiceFacadeFactory;
import com.kingdee.eas.portal.PortletFactory;
import com.kingdee.eas.portal.PortletInfo;
import com.kingdee.eas.portal.PortletParameterInfo;
import com.kingdee.eas.portal.PortletStateEnum;
import com.kingdee.eas.portal.web.configuration.PortletDefinitionsFactoryWrapper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;

public class PortletPublisher
implements IPortletPublisher {
    public static IPortletPublisher getPublisher() throws BOSException {
        return (IPortletPublisher)BOSObjectFactory.createRemoteObject((String)ORMRPCServiceLocator.getCurrentServiceURL(), (String)PortletPublisher.class.getName(), IPortletPublisher.class);
    }

    public String publishPortlet(String reportID, String name, int licenseStrategy, Map descriptionMap) throws BOSException {
        RptParams params = new RptParams();
        params.setString("FullName", this.getClass().getName());
        params.setString("MethodName", "_publishPortlet");
        params.setObject("PARAMS_ARRAY", (Object)new Object[]{name, reportID, new Integer(licenseStrategy), descriptionMap});
        RptParams rp = FacadeFactory.commonExecuteRequired(ServerUtil.getContext(), params);
        BOSException ex = (BOSException)((Object)rp.getObject("EXCEPTION"));
        if (ex != null) {
            throw ex;
        }
        return (String)rp.getObject("PORTLET");
    }

    public RptParams _publishPortlet(Context ctx, RptParams pr) {
        Object[] params = (Object[])pr.getObject("PARAMS_ARRAY");
        String name = (String)params[0];
        String reportID = (String)params[1];
        Integer licenseStrategy = (Integer)params[2];
        Map descriptions = (Map)params[3];
        String description = (String)descriptions.get("l2");
        if (StringUtil.isEmptyString((String)description)) {
            description = "";
        }
        PortletInfo portletInfo = new PortletInfo();
        portletInfo.setId(BOSUuid.create((BOSObjectType)portletInfo.getBOSType()));
        portletInfo.setPortletDefineId("106");
        portletInfo.setPortletNumber("PN-106");
        portletInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        portletInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        portletInfo.setCreateTime(new Timestamp(new Date().getTime()));
        portletInfo.setPortletName(name);
        portletInfo.setDescription("");
        PortletParameterInfo paramInfo = new PortletParameterInfo();
        paramInfo.setCU(portletInfo.getCU());
        paramInfo.setCreator(portletInfo.getCreator());
        paramInfo.setCreateTime(portletInfo.getCreateTime());
        paramInfo.setParamName("ReportId");
        paramInfo.setParamValue(reportID);
        paramInfo.setPortlet(portletInfo);
        portletInfo.getParams().add(paramInfo);
        portletInfo.setEnable(PortletStateEnum.PORTLET_RUN);
        RptParams rp = new RptParams();
        try {
            IPortlet portletService = PortletFactory.getLocalInstance((Context)ctx);
            IObjectPK pk = portletService.addnew((CoreBaseInfo)portletInfo);
            String updateSQL = "Update T_RM_DefineReport Set FPortletId=? , FPortletName=?,FLicenseStrategy=? Where Fid=?";
            DbUtil.executeUpdate((Context)ctx, (String)updateSQL, (Object[])new Object[]{pk.toString(), name, licenseStrategy, reportID});
            updateSQL = "Update T_PORTAL_PORTLET Set FPortletName_l2 = ?, FPortletName_l3=?,FDescription_l2=?, FDescription_l3=? Where fid=?";
            DbUtil.executeUpdate((Context)ctx, (String)updateSQL, (Object[])new Object[]{name, name, description, description, pk.toString()});
            rp.setObject("PORTLET", (Object)pk.toString());
            PortletDefinitionsFactoryWrapper.refreshPortletDefinitions((Context)ctx);
        }
        catch (Exception e) {
            rp.setObject("EXCEPTION", (Object)new BOSException((Throwable)e));
        }
        return rp;
    }

    public void unpublishPortlet(String reportID, String portletPk) throws BOSException {
        String updateSQL = "Update T_RM_DefineReport Set FLicenseStrategy = 0 Where fbipath is null and fmenuid is null and fid='" + reportID + "'";
        String updateSQL2 = "Update T_RM_DefineReport Set FPortletID = null, FPortletName= null Where FID='" + reportID + "'";
        try {
            IPortalServiceFacade portalService = PortalServiceFacadeFactory.getLocalInstance((Context)ServerUtil.getContext());
            portalService.deletePortlet(portletPk);
            DbUtil.executeBatchUpdate((String[])new String[]{updateSQL, updateSQL2});
            portalService.refreshPortletCache();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public IORMModel queryInterface(Class type) throws ORMCoreException {
        throw new UnsupportedOperationException("Unsupported");
    }

    public boolean checkPortletName(String name) throws BOSException {
        boolean bl;
        String querySQL = "Select 1 From T_PORTAL_PORTLET Where FPortletName_l2 = ? And FEnable < 3";
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((String)querySQL, (Object[])new Object[]{name});
            bl = rs.first();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSet(rs);
                throw throwable;
            }
        }
        DBUtil.closeResultSet((ResultSet)rs);
        return bl;
    }
}

