/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlsqldesign.data;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.ctrl.common.FullPath;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.DataDefType;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.data.meta.MetaLibrary;
import com.kingdee.bos.ctrl.data.meta.MetaPackage;
import com.kingdee.bos.ctrl.data.modal.IDefObj;
import com.kingdee.bos.ctrl.data.modal.Parameter;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.AbstractMetaDataCtrl;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.query.PropertyUnitCollection;
import com.kingdee.bos.metadata.query.PropertyUnitInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.ConstDataType;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.base.reportmeta.ctrlreport.util.MessageUtil;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.CtrlDesignFinal;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.ExtContextUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import org.apache.log4j.Logger;

public class DesignBmd2Meta {
    private static Logger log = LogUtil.getPackageLogger(DesignBmd2Meta.class);
    public static final String COMMON_DATA_VIEW = "COMMON_DATA_VIEW";
    public static final String CUSTOM_DATA_VIEW = "CUSTOM_DATA_VIEW";
    public static final String V_FORMULA_REF = "#0";
    public static final String A_DATA_TYPE = "dataType";
    public static final String A_REF_PROPERTY = "refProperty";
    public static final HashMap bos2meta = new HashMap();
    public static final HashMap meta2bmdMap;
    public static final HashMap dataTypeMap;
    public static final HashMap constDataTypeMap;
    private static String EAS_FILTER;
    private static String BAK_FILTER;
    private static String EAS_SORTER;
    private static String BAK_SORTER;
    private static final HashMap fp2bos;

    public static BOSObjectType toBOSObjectType(String metaType) {
        return (BOSObjectType)meta2bmdMap.get(metaType);
    }

    public static BOSObjectType toBOSObjectType(DataDefType metaType) {
        return (BOSObjectType)meta2bmdMap.get(metaType);
    }

    public static DataDefType toDataDefType(BOSObjectType bosObjType) {
        return (DataDefType)bos2meta.get(bosObjType);
    }

    public static com.kingdee.bos.ctrl.common.DataType toDataType(String bosTypeName) {
        return (com.kingdee.bos.ctrl.common.DataType)dataTypeMap.get(bosTypeName);
    }

    public static com.kingdee.bos.ctrl.common.DataType toConstDataType(ConstDataType bosTypeName) {
        return (com.kingdee.bos.ctrl.common.DataType)constDataTypeMap.get(bosTypeName);
    }

    public static void addDataViewParameters(MetaClass mc) {
        ArrayList<Parameter> ps = mc.getParameters();
        if (ps == null) {
            ps = new ArrayList<Parameter>();
            mc.setParameters(ps);
        }
        Parameter p1 = new Parameter();
        p1.setDataType(com.kingdee.bos.ctrl.common.DataType.STRING);
        p1.setAllowNull(true);
        p1.setName(COMMON_DATA_VIEW);
        p1.setAlias(mc.getAliasName() + "\uff08\u901a\u7528\u6570\u636e\u89c6\u56fe\uff09");
        p1.setProperty(Parameter.P_isDataView.getName(), (Object)"true");
        Parameter p2 = new Parameter();
        p2.setDataType(com.kingdee.bos.ctrl.common.DataType.STRING);
        p1.setAllowNull(true);
        p2.setName(CUSTOM_DATA_VIEW);
        p2.setAlias("\u5b9a\u5236\u6570\u636e\u89c6\u56fe");
        p2.setProperty(Parameter.P_isDataView.getName(), (Object)"true");
        p2.setProperty(Parameter.P_isVisible.getName(), (Object)"false");
        ps.add(p1);
        ps.add(p2);
    }

    public static MetaClass parseBmdObject(Object bosObj) {
        if (bosObj instanceof QueryInfo) {
            return DesignBmd2Meta.parseQuery((QueryInfo)bosObj);
        }
        if (bosObj instanceof EntityObjectInfo) {
            return DesignBmd2Meta.parseEntitySelectors((EntityObjectInfo)bosObj);
        }
        if (bosObj instanceof DataTableInfo) {
            return DesignBmd2Meta.parseDataTable((DataTableInfo)bosObj);
        }
        return null;
    }

    public static void parseEntities(MetaLibrary ml, Iterator eoiItr) {
        MetaPackage mpRoot = ml.getRootPackage();
        while (eoiItr.hasNext()) {
            EntityObjectInfo eoi = (EntityObjectInfo)eoiItr.next();
            MetaClass cls = DesignBmd2Meta.parseEntitySelectors(eoi);
            if (cls == null) continue;
            mpRoot.createPackage(eoi.getPackage()).addClass(cls);
        }
    }

    public static MetaClass parseEntity(EntityObjectInfo eoi) {
        String desc;
        if (log.isDebugEnabled()) {
            log.debug((Object)("BOS-Entity: " + eoi.getFullName()));
        }
        MetaClass mc = new MetaClass();
        String name = eoi.getName();
        mc.setNamex(name, DataDefType.BOS_ENTITY.getName());
        String alias = eoi.getAlias();
        if (!StringUtil.isEmptyString((String)alias)) {
            mc.setAlias(alias);
        }
        if (!StringUtil.isEmptyString((String)(desc = eoi.getDescription()))) {
            mc.setDesc(desc);
        }
        mc.setExpr(eoi.getFullName());
        for (PropertyInfo pi : eoi.getProperties()) {
            DesignBmd2Meta.parseEntityProperty(mc, pi);
        }
        DesignBmd2Meta.addDataViewParameters(mc);
        return mc;
    }

    public static MetaClass parseEntitySelectors(EntityObjectInfo eoi) {
        EntityViewInfo evi = eoi.getDefaultView();
        if (evi == null) {
            return null;
        }
        MetaClass mc = new MetaClass();
        mc.setNamex(eoi.getName(), DataDefType.BOS_ENTITY.getName());
        String s = eoi.getAlias();
        if (!StringUtil.isEmptyString((String)s)) {
            mc.setAlias(s);
        }
        if (!StringUtil.isEmptyString((String)(s = eoi.getDescription()))) {
            mc.setDesc(s);
        }
        mc.setExpr(eoi.getFullName());
        for (SelectorItemInfo pi : evi.getSelector()) {
            DesignBmd2Meta.parseSelectorItem(mc, eoi, pi);
        }
        return mc;
    }

    public static void parseSelectorItem(MetaClass mc, EntityObjectInfo eoi, SelectorItemInfo sii) {
        MetaField mf = DesignBmd2Meta.parseSelectorItem(eoi, sii);
        mc.addField(mf);
    }

    public static MetaField parseSelectorItem(EntityObjectInfo eoi, SelectorItemInfo sii) {
        PropertyInfo pi = eoi.getPropertyByName(sii.getPropertyName());
        return DesignBmd2Meta.parseEntityProperty(pi);
    }

    public static MetaField parseEntityProperty(PropertyInfo pi) {
        if (pi == null) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("BOS-Entity-Property: " + pi.getName()));
        }
        MetaField mf = new MetaField();
        mf.setName(pi.getName());
        String s = pi.getAlias();
        if (!StringUtil.isEmptyString((String)s)) {
            mf.setAlias(s);
        }
        if (!StringUtil.isEmptyString((String)(s = pi.getDescription()))) {
            mf.setDesc(s);
        }
        mf.setExpr(mf.getName());
        mf.setType(DesignBmd2Meta.toDataType((String)pi.get(A_DATA_TYPE)));
        return mf;
    }

    public static void parseEntityProperty(MetaClass mc, PropertyInfo pi) {
        if (!(pi instanceof LinkPropertyInfo)) {
            MetaField mf = DesignBmd2Meta.parseEntityProperty(pi);
            mc.addField(mf);
        }
    }

    public static void parseQueries(MetaLibrary ml, Iterator qiItr) {
        MetaPackage mpRoot = ml.getRootPackage();
        while (qiItr.hasNext()) {
            QueryInfo qi = (QueryInfo)qiItr.next();
            MetaClass cls = DesignBmd2Meta.parseQuery(qi);
            mpRoot.createPackage(qi.getPackage()).addClass(cls);
        }
    }

    public static MetaClass parseQuery(QueryInfo qi) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("BOS-Query: " + qi.getFullName()));
        }
        MetaClass mc = new MetaClass();
        mc.setNamex(qi.getName(), DataDefType.BOS_QUERY.getName());
        String s = qi.getAlias();
        if (!StringUtil.isEmptyString((String)s)) {
            mc.setAlias(s);
        }
        if (!StringUtil.isEmptyString((String)(s = qi.getDescription()))) {
            mc.setDesc(s);
        }
        mc.setExpr(qi.getFullName());
        for (QueryFieldInfo qfi : qi.getSelector().getFields()) {
            MetaField mf = DesignBmd2Meta.parseQueryField(qfi);
            mc.addField(mf);
        }
        DesignBmd2Meta.addDataViewParameters(mc);
        return mc;
    }

    public static MetaField parseQueryField(QueryFieldInfo qfi) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("BOS-Query-Field: " + qfi.getName()));
        }
        MetaField mf = new MetaField();
        mf.setName(qfi.getName());
        LanguageCollection lc = ExtContextUtils.getMetaDataLoader().getSolution().getLanguages();
        int size = lc.size();
        for (int i = 0; i < size; ++i) {
            LanguageInfo li = lc.get(i);
            Locale locale = li.getLocale();
            String name = qfi.getDisplayName(locale);
            if (StringUtil.isEmptyString((String)name)) {
                name = qfi.getName();
            }
            String localString = li.getLocaleString();
            mf.setProperty("alias." + localString, (Object)name);
        }
        mf.setProperty("alias", (Object)"#1");
        String expr = CtrlReportUtil.getObjectString(qfi.getFormulaString());
        try {
            if (V_FORMULA_REF.equals(expr)) {
                PropertyInfo pi = (PropertyInfo)qfi.getPropertyRefs().get(0).get(A_REF_PROPERTY);
                if (pi != null) {
                    com.kingdee.bos.ctrl.common.DataType dataType = DesignBmd2Meta.toDataType((String)pi.get(A_DATA_TYPE));
                    if (com.kingdee.bos.ctrl.common.DataType.NULL.equals(dataType)) {
                        dataType = DesignBmd2Meta.toConstDataType(qfi.getReturnType());
                    }
                    mf.setType(dataType);
                    mf.setExpr(pi.getName());
                } else {
                    mf.setType(DesignBmd2Meta.toConstDataType(qfi.getReturnType()));
                }
            } else {
                mf.setType(DesignBmd2Meta.toConstDataType(qfi.getReturnType()));
                mf.setExpr(expr);
            }
        }
        catch (BOSException e) {
            MessageUtil.showDetailAndOK(null, "query Entity error", (Exception)((Object)e));
            log.error((Object)e);
            mf.setType(com.kingdee.bos.ctrl.common.DataType.NULL);
        }
        return mf;
    }

    public static MetaClass parseDataTable(DataTableInfo dti) {
        MetaClass mc = new MetaClass();
        mc.setNamex(dti.getName(), DataDefType.BOS_TABLE.getName());
        String s = dti.getAlias();
        if (!StringUtil.isEmptyString((String)s)) {
            mc.setAlias(s);
        }
        if (!StringUtil.isEmptyString((String)(s = dti.getDescription()))) {
            mc.setDesc(s);
        }
        mc.setExpr(dti.getName());
        for (ColumnInfo ci : dti.getColumns()) {
            MetaField mf = DesignBmd2Meta.parseColumn(ci);
            if (mf == null) continue;
            mc.addField(mf);
        }
        return mc;
    }

    public static MetaField parseColumn(ColumnInfo ci) {
        MetaField mf = new MetaField();
        mf.setName(ci.getName());
        LanguageCollection lc = ExtContextUtils.getMetaDataLoader().getSolution().getLanguages();
        int size = lc.size();
        for (int i = 0; i < size; ++i) {
            LanguageInfo li = lc.get(i);
            String name = ci.getAlias();
            if (StringUtil.isEmptyString((String)name)) {
                name = ci.getName();
            }
            String localString = li.getLocaleString();
            mf.setProperty("alias." + localString, (Object)name);
        }
        mf.setProperty("alias", (Object)"#1");
        if (ci.isMultilingual()) {
            mf.setExpr("@" + ci.getName());
        } else {
            mf.setExpr(ci.getName());
        }
        mf.setType(com.kingdee.bos.ctrl.common.DataType.fromJdbcType((int)ci.getSQLType()));
        return mf;
    }

    public static Object loadMetaData(Context ctx, BOSObjectType bmdType, InputStream in) throws BOSException, DataAccessException {
        IBOSObject bmdCtrl = BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bmdType);
        IObjectValue bmdObj = ((AbstractMetaDataCtrl)bmdCtrl).load(in);
        bmdObj.setDefaultLocale(ctx.getLocale());
        return bmdObj;
    }

    public static void saveMetaData(Context ctx, IObjectValue bmdObj, OutputStream out) throws BOSException, DataAccessException {
        IBOSObject bosObj = BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bmdObj.getBOSType());
        ((AbstractMetaDataCtrl)bosObj).store(bmdObj, out);
    }

    private static void parseBreif(IBriefViewTreeNode node, IDefObj defObj) {
        String name = node.getName();
        DataDefType ddType = DesignBmd2Meta.toDataDefType(node.getMetaDataType());
        if (ddType != null) {
            name = FullPath.addCategory((String)name, (String)ddType.getName());
        }
        defObj.setName(name);
        defObj.setAlias(node.getAlias());
        defObj.setDesc(node.getDescription());
    }

    public static MetaClass parseBriefClass(IBriefViewTreeNode node) {
        MetaClass mc = new MetaClass();
        DesignBmd2Meta.parseBriefClass(node, mc);
        return mc;
    }

    public static void parseBriefClass(IBriefViewTreeNode node, MetaClass mc) {
        DesignBmd2Meta.parseBreif(node, (IDefObj)mc);
        mc.setType(DesignBmd2Meta.toDataDefType(node.getMetaDataType()).getName());
        mc.setExpr(node.getFullName());
    }

    public static MetaPackage parseBriefPackage(IBriefViewTreeNode node) {
        MetaPackage mp = new MetaPackage();
        DesignBmd2Meta.parseBreif(node, (IDefObj)mp);
        int z = node.getChildCount();
        for (int i = 0; i < z; ++i) {
            IBriefViewTreeNode childNode = (IBriefViewTreeNode)node.getChildAt(i);
            BOSObjectType bosObjType = childNode.getMetaDataType();
            if (childNode.isPackage()) {
                mp.addPackage(DesignBmd2Meta.parseBriefPackage(childNode));
                continue;
            }
            if (bosObjType != MetaDataTypeList.JOINQUERY && bosObjType != MetaDataTypeList.UNIONQUERY && bosObjType != MetaDataTypeList.DATATABLE) continue;
            mp.addClass(DesignBmd2Meta.parseBriefClass(childNode));
        }
        return mp;
    }

    public static MetaDataPK parseFullPath(String fpText) {
        FullPath fp = FullPath.parse((String)fpText);
        return new MetaDataPK(fp.getDots());
    }

    public static boolean toEasDesigntime(PropertyUnitCollection props) {
        if (props == null) {
            return false;
        }
        boolean isChanged = false;
        int z = props.size();
        for (int i = 0; i < z; ++i) {
            PropertyUnitInfo pui = props.get(i);
            if (pui.isIsFilter()) {
                pui.setExtendedProperty(BAK_FILTER, pui.getExtendedProperty(EAS_FILTER));
                pui.setExtendedProperty(EAS_FILTER, Boolean.TRUE.toString());
                isChanged = true;
            }
            if (!pui.isIsSorter()) continue;
            pui.setExtendedProperty(BAK_SORTER, pui.getExtendedProperty(EAS_SORTER));
            pui.setExtendedProperty(EAS_SORTER, Boolean.TRUE.toString());
            isChanged = true;
        }
        return isChanged;
    }

    public static void toEasRuntime(PropertyUnitCollection props) {
        int z = props.size();
        for (int i = 0; i < z; ++i) {
            String bak;
            PropertyUnitInfo pui = props.get(i);
            if (pui.isIsFilter()) {
                bak = pui.getExtendedProperty(BAK_FILTER);
                if (bak != null) {
                    pui.setExtendedProperty(EAS_FILTER, bak);
                } else {
                    pui.removeExtendedProperty(EAS_FILTER);
                }
                pui.removeExtendedProperty(BAK_FILTER);
            }
            if (!pui.isIsSorter()) continue;
            bak = pui.getExtendedProperty(BAK_SORTER);
            if (bak != null) {
                pui.setExtendedProperty(EAS_SORTER, bak);
            } else {
                pui.removeExtendedProperty(EAS_SORTER);
            }
            pui.removeExtendedProperty(BAK_SORTER);
        }
    }

    public static IObjectValue getMetaData(String fpText, Context bosCtx) {
        FullPath fp = FullPath.parse((String)fpText);
        IObjectValue bosObj = (IObjectValue)fp2bos.get(fpText);
        if (bosObj == null) {
            IMetaDataLoader mdLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)bosCtx);
            BOSObjectType bosType = DesignBmd2Meta.toBOSObjectType(fp.getCategory());
            bosObj = mdLoader.get(bosType, (IMetaDataPK)new MetaDataPK(fp.getDots()));
            fp2bos.put(fpText, bosObj);
        }
        return bosObj;
    }

    public static IObjectValue getDesignMetaData(String category, String fullName, Context bosCtx) {
        IObjectValue bosObj = (IObjectValue)fp2bos.get(fullName);
        if (bosObj == null) {
            BOSObjectType bosType = CtrlDesignFinal.getMetaDataType(category);
            IMetaDataLoader mdLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)bosCtx);
            bosObj = mdLoader.get(bosType, (IMetaDataPK)new MetaDataPK(fullName));
            fp2bos.put(fullName, bosObj);
        }
        return bosObj;
    }

    static {
        bos2meta.put(MetaDataTypeList.JOINQUERY, DataDefType.BOS_QUERY);
        bos2meta.put(MetaDataTypeList.UNIONQUERY, DataDefType.BOS_QUERY);
        bos2meta.put(MetaDataTypeList.BASEQUERY, DataDefType.BOS_QUERY);
        bos2meta.put(MetaDataTypeList.DATATABLE, DataDefType.BOS_TABLE);
        bos2meta.put(MetaDataTypeList.ENTITY, DataDefType.BOS_ENTITY);
        meta2bmdMap = new HashMap();
        meta2bmdMap.put(DataDefType.BOS_QUERY, MetaDataTypeList.BASEQUERY);
        meta2bmdMap.put(DataDefType.BOS_TABLE, MetaDataTypeList.DATATABLE);
        meta2bmdMap.put(DataDefType.BOS_ENTITY, MetaDataTypeList.ENTITY);
        meta2bmdMap.put(DataDefType.BOS_QUERY.getName(), MetaDataTypeList.BASEQUERY);
        meta2bmdMap.put(DataDefType.BOS_TABLE.getName(), MetaDataTypeList.DATATABLE);
        meta2bmdMap.put(DataDefType.BOS_ENTITY.getName(), MetaDataTypeList.ENTITY);
        dataTypeMap = new HashMap();
        dataTypeMap.put(DataType.SHORT.getName(), com.kingdee.bos.ctrl.common.DataType.SHORT);
        dataTypeMap.put(DataType.INTEGER.getName(), com.kingdee.bos.ctrl.common.DataType.INTEGER);
        dataTypeMap.put(DataType.LONG.getName(), com.kingdee.bos.ctrl.common.DataType.LONG);
        dataTypeMap.put(DataType.FLOAT.getName(), com.kingdee.bos.ctrl.common.DataType.FLOAT);
        dataTypeMap.put(DataType.DOUBLE.getName(), com.kingdee.bos.ctrl.common.DataType.DOUBLE);
        dataTypeMap.put(DataType.DECIMAL.getName(), com.kingdee.bos.ctrl.common.DataType.DECIMAL);
        dataTypeMap.put(DataType.DATE.getName(), com.kingdee.bos.ctrl.common.DataType.DATETIME);
        dataTypeMap.put(DataType.TIME.getName(), com.kingdee.bos.ctrl.common.DataType.DATETIME);
        dataTypeMap.put(DataType.TIMESTAMP.getName(), com.kingdee.bos.ctrl.common.DataType.DATETIME);
        dataTypeMap.put(DataType.CHAR.getName(), com.kingdee.bos.ctrl.common.DataType.STRING);
        dataTypeMap.put(DataType.BOOLEAN.getName(), com.kingdee.bos.ctrl.common.DataType.BOOLEAN);
        dataTypeMap.put(DataType.BYTE.getName(), com.kingdee.bos.ctrl.common.DataType.BYTE);
        dataTypeMap.put(DataType.STRING.getName(), com.kingdee.bos.ctrl.common.DataType.STRING);
        dataTypeMap.put(DataType.BYTEARRAY.getName(), com.kingdee.bos.ctrl.common.DataType.BINARY);
        dataTypeMap.put(DataType.OBJECTPK.getName(), com.kingdee.bos.ctrl.common.DataType.NULL);
        dataTypeMap.put(DataType.ROWSET.getName(), com.kingdee.bos.ctrl.common.DataType.NULL);
        dataTypeMap.put(DataType.BOSUUID.getName(), com.kingdee.bos.ctrl.common.DataType.BINARY);
        dataTypeMap.put(DataType.UUID.getName(), com.kingdee.bos.ctrl.common.DataType.BINARY);
        dataTypeMap.put(DataType.ENUM.getName(), com.kingdee.bos.ctrl.common.DataType.NULL);
        dataTypeMap.put(DataType.OBJECTVALUE.getName(), com.kingdee.bos.ctrl.common.DataType.NULL);
        dataTypeMap.put(DataType.OBJECTCOLLECTION.getName(), com.kingdee.bos.ctrl.common.DataType.NULL);
        dataTypeMap.put(null, com.kingdee.bos.ctrl.common.DataType.NULL);
        constDataTypeMap = new HashMap();
        constDataTypeMap.put(ConstDataType.INT, com.kingdee.bos.ctrl.common.DataType.INTEGER);
        constDataTypeMap.put(ConstDataType.NUMBER, com.kingdee.bos.ctrl.common.DataType.DECIMAL);
        constDataTypeMap.put(ConstDataType.STRING, com.kingdee.bos.ctrl.common.DataType.STRING);
        constDataTypeMap.put(ConstDataType.DATE, com.kingdee.bos.ctrl.common.DataType.DATETIME);
        constDataTypeMap.put(ConstDataType.TIME, com.kingdee.bos.ctrl.common.DataType.DATETIME);
        constDataTypeMap.put(ConstDataType.TIMESTAMP, com.kingdee.bos.ctrl.common.DataType.DATETIME);
        constDataTypeMap.put(ConstDataType.BOOLEAN, com.kingdee.bos.ctrl.common.DataType.BOOLEAN);
        constDataTypeMap.put(ConstDataType.ENUM, com.kingdee.bos.ctrl.common.DataType.SHORT);
        constDataTypeMap.put(ConstDataType.OBJECT, com.kingdee.bos.ctrl.common.DataType.NULL);
        constDataTypeMap.put(ConstDataType.UNKNOWN, com.kingdee.bos.ctrl.common.DataType.NULL);
        constDataTypeMap.put(null, com.kingdee.bos.ctrl.common.DataType.NULL);
        EAS_FILTER = "isCommonQueryFilter";
        BAK_FILTER = "kdrsBackupFilter";
        EAS_SORTER = "isCommonQuerySorter";
        BAK_SORTER = "kdrsBackupSorter";
        fp2bos = new HashMap();
    }
}

