/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlsqldesign.model;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.sql.DbType;
import com.kingdee.eas.base.reportmeta.ctrlreport.bo.BlobBO;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.factory.FacadeFactory;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;

public class ExtDBUtil {
    public static final IRowSet executeQuery(Context ctx, String sql, String otherDataCenter) throws BOSException {
        RptParams pr = new RptParams();
        pr.setString("MethodName", "getDBPageSizeInfoBySQL");
        pr.setString("sql", sql);
        pr.setInt("start", 0);
        pr.setInt("rows", -1);
        pr.setString("outDB", otherDataCenter);
        RptParams ps_r = FacadeFactory.commonExecute(ctx, pr);
        IRowSet irs = (IRowSet)ps_r.getObject("object");
        return irs;
    }

    public static ArrayList setDataToList(ResultSet rs) throws SQLException {
        ArrayList lst = new ArrayList();
        ResultSetMetaData rsmd = rs.getMetaData();
        int len = rsmd.getColumnCount();
        while (rs.next()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (int i = 1; i <= len; ++i) {
                Object obj = rs.getObject(i);
                int type = rsmd.getColumnType(i);
                if (type == 2004) {
                    obj = BlobBO.readBlob(rs, i);
                }
                map.put(rsmd.getColumnName(i).toLowerCase(), obj);
            }
            lst.add(map);
        }
        return lst;
    }

    public static ArrayList getResultListBySql(Context ctx, String sql, ArrayList queryValue) throws BOSException {
        RptParams pr = new RptParams();
        pr.setString("MethodName", "getInfoListBySQL");
        pr.setString("sql", sql);
        pr.setObject("lstValue", (Object)queryValue);
        RptParams ps_r = FacadeFactory.commonExecuteNever(ctx, pr);
        ArrayList dataList = (ArrayList)ps_r.getObject("object");
        return dataList;
    }

    public static HashMap getResultMapBySql(Context ctx, String sql, ArrayList queryValue) throws BOSException {
        RptParams pr = new RptParams();
        pr.setString("MethodName", "getInfoMapBySQL");
        pr.setString("sql", sql);
        pr.setObject("lstValue", (Object)queryValue);
        RptParams ps_r = FacadeFactory.commonExecuteNever(ctx, pr);
        HashMap map = (HashMap)ps_r.getObject("object");
        return map;
    }

    public static final void maintainRecord(Context ctx, String sql, ArrayList queryValue) throws BOSException {
        RptParams pr = new RptParams();
        pr.setString("sql", sql);
        pr.setObject("lstValue", (Object)queryValue);
        pr.setString("MethodName", "maintainRecord");
        FacadeFactory.commonExecute(ctx, pr);
    }

    public static final void executeBatch(Context ctx, ArrayList sqlList) throws BOSException {
        RptParams pr = new RptParams();
        pr.setObject("sqlList", (Object)sqlList);
        pr.setString("MethodName", "executeBatch");
        FacadeFactory.commonExecuteNever(ctx, pr);
    }

    public static final int getDBType(Context ctx) {
        String dbTypeName = null;
        if (ctx != null) {
            if (ctx.get((Object)"dbType") != null) {
                dbTypeName = ctx.get((Object)"dbType").toString();
            }
        } else {
            RptParams pr = new RptParams();
            pr.setString("MethodName", "getInfoFromServer");
            try {
                RptParams ps_r = FacadeFactory.commonExecuteNever(ctx, pr);
                dbTypeName = ps_r.getString("dbTypeName");
            }
            catch (BOSException e) {
                return -1;
            }
        }
        int bosDbtype = DbType.getValue(dbTypeName);
        switch (bosDbtype) {
            case 3: {
                return 3;
            }
            case 2: 
            case 7: 
            case 8: {
                return 2;
            }
            case 1: {
                return 1;
            }
        }
        return -1;
    }
}

