/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlsqldesign.model;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeInfo;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class OrgRangeManage {
    private static Logger log = LogUtil.getPackageLogger(OrgRangeManage.class);

    public static final DefObj[] getOrgRangeFieldList() {
        DefObj defItem1 = OrgRangeManage.getDefObj("id", "ID");
        DefObj defItem2 = OrgRangeManage.getDefObj("number", "\u7f16\u7801");
        DefObj defItem3 = OrgRangeManage.getDefObj("name", "\u540d\u79f0");
        DefObj[] defObjs = new DefObj[]{defItem1, defItem2, defItem3};
        return defObjs;
    }

    public static final DefObj getDefObj(String name, String alias) {
        DefObj defItem = new DefObj(){

            public String toString() {
                StringBuffer sb = new StringBuffer();
                sb.append(this.getName()).append("  [").append(this.getAlias()).append("]");
                return sb.toString();
            }
        };
        defItem.setName(name);
        defItem.setAlias(alias);
        return defItem;
    }

    public static final ArrayList getOrgRangeDataList(Context ctx, String userPK) {
        ArrayList<Object> dataList = new ArrayList();
        UserInfo userInfo = null;
        try {
            OrgRangeCollection orc;
            System.out.println("---------------------------------\u6269\u5c55\u62a5\u8868\u6267\u884c:\u83b7\u53d6\u5f53\u524d\u4e1a\u52a1\u7ec4\u7ec7\u8303\u56f4\u3010\u5f00\u59cb\u3011------------------------------");
            long startTime = System.currentTimeMillis();
            userInfo = ToolUtils.getUserAllInfo((Context)ctx, (String)userPK);
            System.out.println("\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime) + "(\u6beb\u79d2)");
            System.out.println("---------------------------------\u6269\u5c55\u62a5\u8868\u6267\u884c:\u83b7\u53d6\u5f53\u524d\u4e1a\u52a1\u7ec4\u7ec7\u8303\u56f4\u3010\u7ed3\u675f\u3011------------------------------");
            if (null != userInfo && null != (orc = userInfo.getOrgRange()) && orc.size() > 0) {
                for (int i = 0; i < orc.size(); ++i) {
                    FullOrgUnitInfo org;
                    OrgRangeInfo orgRangeInfo = orc.get(i);
                    if (!orgRangeInfo.getType().equals((Object)OrgRangeType.BIZ_ORG_TYPE) || (org = orgRangeInfo.getOrg()).isIsUnion()) continue;
                    String orgID = org.getId().toString();
                    String orgNumber = org.getNumber();
                    String orgName = org.getName().toString();
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("id", CtrlReportUtil.getObjectString(orgID));
                    map.put("number", CtrlReportUtil.getObjectString(orgNumber));
                    map.put("name", CtrlReportUtil.getObjectString(orgName));
                    dataList.add(map);
                }
                Comparator mapCp = new Comparator(){

                    public int compare(Object oObj, Object tObj) {
                        Map oneM = (Map)oObj;
                        Map twoM = (Map)tObj;
                        String oneNum = (String)oneM.get("number");
                        oneNum = StringUtil.isEmptyString((String)oneNum) ? "" : oneNum;
                        return oneNum.compareTo((String)twoM.get("number"));
                    }
                };
                Object[] orgs = dataList.toArray();
                Arrays.sort(orgs, mapCp);
                dataList = new ArrayList<Object>(Arrays.asList(orgs));
            }
        }
        catch (Exception e) {
            log.error((Object)"\u83b7\u53d6\u7528\u6237\u7ec4\u7ec7\u8303\u56f4\u9519\u8bef", (Throwable)e);
        }
        return dataList;
    }
}

