/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlsqldesign.model;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.common.GlobalLocator;
import com.kingdee.bos.ctrl.kds.io.BookIOUtil;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.base.reportmeta.ctrlreport.util.ExtStringUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.tree.MutableTreeNode;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class ZipProvider
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final int BUFFER = 1024;
    public static final String Fileroot = "root/";
    public static final String SystemRoot = "com.kingdee.eas.";
    public static final String ReName = "rename";
    public static final String Delete = "delete";
    public static final String STD_ = "std_";

    private static void zip(String name_string, File file, ZipOutputStream zipOutput) throws IOException {
        ZipEntry entry = new ZipEntry(name_string + (file.isDirectory() ? "/" : ""));
        if (file.isFile()) {
            zipOutput.putNextEntry(entry);
            FileInputStream fin = new FileInputStream(file);
            byte[] data = CtrlUtil.Stream.readInputStream((InputStream)fin);
            ((InputStream)fin).close();
            zipOutput.write(data, 0, data.length);
            zipOutput.closeEntry();
        } else {
            zipOutput.putNextEntry(entry);
            zipOutput.closeEntry();
            File[] files = file.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    ZipProvider.zip(name_string + "/" + files[i].getName(), files[i], zipOutput);
                }
            }
        }
    }

    public static void zip(String sourceFilePath, String zipFilePath, boolean onlyContent) throws IOException {
        File file = new File(sourceFilePath);
        FileOutputStream fout = new FileOutputStream(zipFilePath);
        ZipOutputStream zipOutput = new ZipOutputStream(fout);
        File[] files = new File[]{file};
        if (onlyContent) {
            files = file.listFiles();
        }
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                ZipProvider.zip(files[i].getName(), files[i], zipOutput);
            }
        }
        zipOutput.close();
        fout.close();
    }

    public static List unZipKSQL(String zipPath, String name) throws Exception {
        ArrayList lst = new ArrayList();
        try {
            ZipFile zip = new ZipFile(zipPath);
            zip.close();
            int pl = name.lastIndexOf(".");
            name = name.substring(0, pl);
            File fileTar = new File(zipPath);
            String lastModified = String.valueOf(fileTar.lastModified());
            FileInputStream fis = new FileInputStream(zipPath);
            ZipInputStream zipIn = new ZipInputStream(new BufferedInputStream(fis));
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("flastupdatetime", null);
            map.put("isUseFilterUI", new Boolean(false));
            map.put("customType", String.valueOf(1));
            map.put("name", name);
            map.put("flastupdatetime", lastModified);
            BufferedReader br = null;
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null && !entry.isDirectory()) {
                String currentName = entry.getName().toLowerCase();
                byte[] temp = null;
                if (currentName.equals("field.properties")) {
                    String lineStr;
                    br = new BufferedReader(new InputStreamReader((InputStream)zipIn, "utf-8"));
                    boolean isStart = true;
                    while ((lineStr = br.readLine()) != null) {
                        lineStr = lineStr.trim();
                        if (isStart) {
                            isStart = false;
                            continue;
                        }
                        String[] arr = lineStr.split("=");
                        if (arr[0].equals("isUseFilterUI")) {
                            map.put("isUseFilterUI", new Boolean(arr[1]));
                            continue;
                        }
                        if (!arr[0].equals("customType")) continue;
                        String customType = CtrlReportUtil.getObjectString(arr[1]);
                        if (customType.equals("")) {
                            customType = String.valueOf(1);
                        }
                        map.put("customType", customType);
                    }
                } else if (currentName.equals("content.xml")) {
                    temp = ZipProvider.parseByte(zipIn);
                    if (temp != null) {
                        map.put("content", temp.clone());
                    }
                } else if (currentName.equals("icon.xml") && (temp = ZipProvider.parseByte(zipIn)) != null) {
                    map.put("icon", temp.clone());
                }
                entry = zipIn.getNextEntry();
            }
            lst.add(map);
            if (null != br) {
                br.close();
            }
            fis.close();
            zipIn.close();
        }
        catch (ZipException zipe) {
            zipe.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return lst;
    }

    private static byte[] parseByte(ZipInputStream zipIn) throws IOException {
        int realSize = 0;
        byte[] buffer = new byte[1024];
        byte[] data = null;
        while ((realSize = zipIn.read(buffer, 0, 1024)) != -1) {
            int capacity = realSize;
            if (data == null) {
                data = new byte[capacity];
                System.arraycopy(buffer, 0, data, 0, realSize);
            } else {
                int length = data.length;
                capacity = length + realSize;
                byte[] dataTmp = new byte[capacity];
                System.arraycopy(data, 0, dataTmp, 0, length);
                System.arraycopy(buffer, 0, dataTmp, length, realSize);
                data = (byte[])dataTmp.clone();
            }
            if (realSize != 0) continue;
        }
        return data;
    }

    public RptParams unZipStdProduct(Context ctx, RptParams param) throws Exception {
        ZipEntry entry;
        String zipPath = param.getString("path");
        HashMap mapR = new HashMap();
        ArrayList<String> lstReadme = new ArrayList<String>();
        ArrayList lstReport = new ArrayList();
        mapR.put("lstReadme", lstReadme);
        mapR.put("lstReport", lstReport);
        ZipFile zip = new ZipFile(zipPath);
        zip.close();
        FileInputStream fis = new FileInputStream(zipPath);
        ZipInputStream zipIn = new ZipInputStream(new BufferedInputStream(fis));
        StringBuffer sbSystemID = new StringBuffer();
        sbSystemID.append(SystemRoot);
        BufferedReader br = null;
        while ((entry = zipIn.getNextEntry()) != null) {
            int n;
            String sourceName = entry.getName();
            String name = entry.getName().toLowerCase();
            if (entry.isDirectory()) continue;
            if (name.equals("readme.txt")) {
                String lineStr;
                br = new BufferedReader(new InputStreamReader((InputStream)zipIn, "utf-8"));
                boolean isStart = true;
                while ((lineStr = br.readLine()) != null) {
                    lineStr = lineStr.trim();
                    if (isStart) {
                        byte[] bom = lineStr.getBytes();
                        byte[] noBom = new byte[bom.length - 1];
                        System.arraycopy(bom, 1, noBom, 0, bom.length - 1);
                        lineStr = new String(noBom);
                        isStart = false;
                    }
                    if (!lineStr.toLowerCase().startsWith(ReName) && !lineStr.toLowerCase().startsWith(Delete)) continue;
                    lstReadme.add(lineStr);
                }
                continue;
            }
            if (!name.endsWith(".kdszip") || (n = name.lastIndexOf("/")) == -1) continue;
            String systemID = sourceName.substring(0, n);
            systemID = ExtStringUtil.replace(systemID, Fileroot, SystemRoot);
            systemID = ExtStringUtil.replace(systemID, "/", ".");
            String reportName = sourceName.substring(n + 1);
            reportName = ExtStringUtil.replace(reportName, ".kdszip", "");
            byte[] realCntent = null;
            int realSize = 0;
            byte[] data = new byte[1024];
            while ((realSize = zipIn.read(data, 0, 1024)) != -1) {
                int capacity = realSize;
                if (realCntent == null) {
                    realCntent = new byte[capacity];
                    System.arraycopy(data, 0, realCntent, 0, realSize);
                } else {
                    int realCntentLength = realCntent.length;
                    capacity = realCntentLength + realSize;
                    byte[] dataTmp = new byte[capacity];
                    System.arraycopy(realCntent, 0, dataTmp, 0, realCntentLength);
                    System.arraycopy(data, 0, dataTmp, realCntentLength, realSize);
                    realCntent = (byte[])dataTmp.clone();
                }
                if (realSize != 0) continue;
            }
            HashMap<String, Object> mapReport = new HashMap<String, Object>();
            mapReport.put("name", reportName);
            mapReport.put("systemID", systemID);
            mapReport.put("data", realCntent.clone());
            Book book = BookIOUtil.unpack((byte[])((byte[])mapReport.get("data")));
            if (null == book) {
                throw new Exception("unpack byte error! reportName is " + reportName);
            }
            mapReport.put("deployPath", book.getReleaseDirector());
            String menuUiClassName = "com.kingdee.eas.base.reportmeta.ctrlreport.client.ExtReportRunUI";
            if (book.getUserObject("$MenuUiClassName$") != null && (menuUiClassName = CtrlReportUtil.getObjectString(book.getUserObject("$MenuUiClassName$").getValue())).equals("")) {
                menuUiClassName = "com.kingdee.eas.base.reportmeta.ctrlreport.client.ExtReportRunUI";
            }
            mapReport.put("menuUiClassName", menuUiClassName);
            lstReport.add(mapReport);
        }
        try {
            br.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            fis.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            zipIn.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        RptParams paramsReturn = new RptParams();
        paramsReturn.setObject("object", mapR);
        return paramsReturn;
    }

    public RptParams getExtZipTree(Context ctx, RptParams param) throws Exception {
        DefaultKingdeeTreeNode nodeRoot = new DefaultKingdeeTreeNode();
        String ctrlHome = GlobalLocator.getInstance().getHomeDir();
        String extziphome = ctrlHome + "/server/extzip";
        File rootFile = new File(extziphome);
        File[] files = rootFile.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                HashMap map = new HashMap(){
                    private static final long serialVersionUID = 1L;

                    public String toString() {
                        return (String)this.get("name");
                    }
                };
                map.put("path", file.getAbsolutePath());
                map.put("name", file.getName());
                map.put("isFile", "false");
                DefaultKingdeeTreeNode nodeDirec = new DefaultKingdeeTreeNode((Object)map);
                nodeDirec.setAllowsChildren(true);
                if (file.isDirectory()) {
                    ZipProvider.getNodeFile(nodeDirec, file);
                }
                nodeRoot.add((MutableTreeNode)nodeDirec);
            }
        }
        RptParams paramsReturn = new RptParams();
        paramsReturn.setObject("object", (Object)nodeRoot);
        return paramsReturn;
    }

    private static void getNodeFile(DefaultKingdeeTreeNode nodeDirec, File file) throws Exception {
        File[] files = file.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File temp = files[i];
                if (!temp.isFile()) continue;
                HashMap map = new HashMap(){
                    private static final long serialVersionUID = 1L;

                    public String toString() {
                        return (String)this.get("name");
                    }
                };
                map.put("path", temp.getAbsolutePath());
                map.put("name", temp.getName());
                map.put("isFile", "true");
                DefaultKingdeeTreeNode nodeLeaf = new DefaultKingdeeTreeNode((Object)map);
                nodeLeaf.setAllowsChildren(false);
                nodeDirec.add((MutableTreeNode)nodeLeaf);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        String text = new BASE64Encoder().encodeBuffer("dfdf".getBytes());
        System.out.println("\u5bc6\u6587" + text);
        System.out.println("\u660e\u6587" + new String(new BASE64Decoder().decodeBuffer(text)));
    }
}

