/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlsqldesign.xml;

import com.kingdee.eas.base.reportmeta.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.data.ProcedureDataType;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.data.ProcedureIOType;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.data.ProcedureModel;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.data.ProcedureParamData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;

public class ProcedureParameterIO {
    public static final String E_PROCEDURE = "Procedure";
    public static final String E_PARAMETER = "Parameter";
    public static final String A_NAME = "name";
    public static final String A_dbType = "dbType";
    public static final String A_resultNumber = "resultNumber";
    public static final String A_resultCursor = "resultCursor";
    public static final String A_bindFilterParamName = "bindFilterParamName";
    public static final String A_ioType = "ioType";
    public static final String A_dataType = "dataType";
    public static final String A_defaultValue = "defaultValue";

    public static final Element makeProcedure(ProcedureModel pm) {
        Element xml = new Element(E_PROCEDURE);
        xml.setAttribute(A_NAME, pm.getName());
        xml.setAttribute(A_dbType, String.valueOf(pm.getDbType()));
        xml.setAttribute(A_resultNumber, String.valueOf(pm.getResultNumber()));
        xml.setAttribute(A_resultCursor, pm.getResultCursor());
        ArrayList paramList = pm.getParamList();
        if (paramList != null) {
            Iterator it = paramList.iterator();
            while (it.hasNext()) {
                xml.addContent(ProcedureParameterIO.makeProcedureParam((ProcedureParamData)it.next()));
            }
        }
        return xml;
    }

    private static final Element makeProcedureParam(ProcedureParamData ppd) {
        Element xml = new Element(E_PARAMETER);
        if (ppd != null) {
            xml.setAttribute(A_NAME, CtrlReportUtil.getObjectString(ppd.getName()));
            xml.setAttribute(A_bindFilterParamName, CtrlReportUtil.getObjectString(ppd.getBindFilterParamName()));
            xml.setAttribute(A_ioType, String.valueOf(ppd.getIoType().intValue()));
            xml.setAttribute(A_dataType, String.valueOf(ppd.getDataType().intValue()));
            xml.setAttribute(A_defaultValue, CtrlReportUtil.getObjectString(ppd.getDefaultValue()));
        }
        return xml;
    }

    public static final ProcedureModel getProcedureModel(Element xml) {
        ProcedureModel pm = new ProcedureModel();
        pm.setName(CtrlReportUtil.getObjectString(xml.getAttributeValue(A_NAME)));
        pm.setDbType(Integer.parseInt(CtrlReportUtil.getObjectString(xml.getAttributeValue(A_dbType))));
        pm.setResultNumber(Integer.parseInt(CtrlReportUtil.getObjectString(xml.getAttributeValue(A_resultNumber))));
        pm.setResultCursor(CtrlReportUtil.getObjectString(xml.getAttributeValue(A_resultCursor)));
        ArrayList<ProcedureParamData> paramList = new ArrayList<ProcedureParamData>();
        List lst = xml.getChildren(E_PARAMETER);
        Iterator i = lst.iterator();
        while (i.hasNext()) {
            ProcedureParamData p = ProcedureParameterIO.parseParameter((Element)i.next());
            paramList.add(p);
        }
        pm.setParamList(paramList);
        return pm;
    }

    private static ProcedureParamData parseParameter(Element xml) {
        ProcedureParamData ppd = new ProcedureParamData();
        ppd.setName(CtrlReportUtil.getObjectString(xml.getAttributeValue(A_NAME)));
        ppd.setBindFilterParamName(CtrlReportUtil.getObjectString(xml.getAttributeValue(A_bindFilterParamName)));
        ppd.setIoType(ProcedureIOType.getIOType(Integer.parseInt(CtrlReportUtil.getObjectString(xml.getAttributeValue(A_ioType)))));
        ppd.setDataType(ProcedureDataType.getDataTypee(Integer.parseInt(CtrlReportUtil.getObjectString(xml.getAttributeValue(A_dataType)))));
        ppd.setDefaultValue(CtrlReportUtil.getObjectString(xml.getAttributeValue(A_defaultValue)));
        return ppd;
    }
}

