/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.snapshot.dispatch.server.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.fulfil.ExecutorUtil;
import com.kingdee.bos.ctrl.ext.fulfil.SnapReportControlModel;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.bos.service.job.core.JobLog;
import com.kingdee.eas.base.reportmeta.ctrlreport.bo.ReportAttemperBO;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.base.reportmeta.ctrlreport.util.ExtStringUtil;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.data.DesignParameter;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.DateUtil;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.RunReportParam;
import com.kingdee.eas.base.reportmeta.snapshot.dispatch.codingrule.pojo.MaxSerialInfo;
import com.kingdee.eas.base.reportmeta.snapshot.dispatch.codingrule.server.ICodingRuleDAO;
import com.kingdee.eas.base.reportmeta.snapshot.dispatch.codingrule.server.impl.CodingRuleDAOImpl;
import com.kingdee.eas.base.reportmeta.snapshot.dispatch.server.ISaveSnapShotStrategy;
import com.kingdee.eas.base.reportmeta.snapshot.dispatch.server.ISendEmailDAO;
import com.kingdee.eas.base.reportmeta.snapshot.dispatch.server.impl.SendEmailDAOImpl;
import com.kingdee.eas.base.reportmeta.snapshot.dispatch.util.DispatchCommonUtil;
import com.kingdee.eas.base.reportmeta.snapshot.manage.exception.SnapshotException;
import com.kingdee.eas.base.reportmeta.snapshot.manage.pojo.SnapshotBaseInfo;
import com.kingdee.eas.basedata.org.OrgSwitchFacadeFactory;
import com.kingdee.eas.common.EASBizException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractSaveSnapShotAdapter
implements ISaveSnapShotStrategy {
    private static final long serialVersionUID = 5135316911536501407L;
    Logger logger = Logger.getLogger(AbstractSaveSnapShotAdapter.class);
    protected List _dispList;
    protected Context _ctx;
    protected String _locale;
    protected HashMap mapSystemParam;
    protected ISendEmailDAO sendMail;
    protected ICodingRuleDAO dao;

    public AbstractSaveSnapShotAdapter() throws IOException {
        this(null, null, null);
    }

    public AbstractSaveSnapShotAdapter(Context ctx, List dispList, String locale) {
        this._dispList = dispList;
        this._ctx = ctx;
        this._locale = locale;
        this.sendMail = new SendEmailDAOImpl();
        this.dao = new CodingRuleDAOImpl();
    }

    public void saveSnapShot() throws BOSException {
        Book book = null;
        Map _dispatchMap = (Map)this._dispList.get(0);
        String userID = (String)_dispatchMap.get("dispatchupdateuserid");
        String userName = (String)_dispatchMap.get("username");
        String orgID = (String)_dispatchMap.get("dispatchcurorgid");
        String excelPath = (String)_dispatchMap.get("fexcelpath");
        int saveType = ((Number)_dispatchMap.get("fsnapshotsavetype")).intValue();
        boolean isSaveHyplink = ((Number)_dispatchMap.get("fsavehyplink")).intValue() == 1;
        String jobprocessId = (String)_dispatchMap.get("fjobprocessdefid");
        SnapshotBaseInfo snapInfo = new SnapshotBaseInfo();
        try {
            String filterXml = DispatchCommonUtil.clob2String(_dispatchMap.get("ffilterxml"));
            HashMap mapCustomParam = RunReportParam.setExecuteParam(null, filterXml);
            HashMap mapSwitchOrg = OrgSwitchFacadeFactory.getLocalInstance((Context)this._ctx).getSwitchOrgs(orgID);
            this.mapSystemParam = DispatchCommonUtil.putSystemParam(mapSwitchOrg, userID, userName);
            this.executeDateAndTimeParamValue(mapCustomParam);
            this.setSystemPresetParameter(mapCustomParam);
            String freportid = (String)_dispatchMap.get("freportid");
            book = DispatchCommonUtil.execute(this._ctx, freportid, mapCustomParam);
            SnapReportControlModel controlModel = new SnapReportControlModel();
            controlModel.setSaveHyplink(isSaveHyplink);
            byte[] data = ExecutorUtil.generateShapShot((Book)book, (SnapReportControlModel)controlModel);
            StringBuffer errorMsg = new StringBuffer();
            if (this.saveSnap(this._ctx, data, this._locale, errorMsg, snapInfo)) {
                String path = excelPath + File.separator + snapInfo.getName() + ".xls";
                if (DispatchCommonUtil.isExportXls(saveType, excelPath, snapInfo.getName(), errorMsg) && errorMsg.length() == 0) {
                    for (int sh = book.getSheetCount() - 1; sh >= 0; --sh) {
                        EmbedhLayer layer = book.getSheet(sh).getEmbedments(false);
                        if (layer == null) continue;
                        layer.selectAllEmbeds();
                        layer.removeSelectedEmbeds();
                    }
                    DispatchCommonUtil.exportToXls(path, book);
                }
            } else {
                throw new BOSException(errorMsg.toString());
            }
            this.sendMail.sendMail(this._ctx, book, _dispatchMap, true, errorMsg.toString(), snapInfo.getName());
        }
        catch (Exception ex) {
            this.logger.error((Object)ex);
            String error = null;
            error = ex.getCause() != null ? ex.getCause().toString() : ex.getMessage();
            this.writeErrorLog(this._ctx, JobLog.Type.Error, jobprocessId, error, "\u8c03\u5ea6\u5931\u8d25", "\u8c03\u5ea6\u5931\u8d25", ex);
            this.sendMail.sendMail(this._ctx, book, _dispatchMap, false, error, snapInfo.getName());
            throw new BOSException(error);
        }
    }

    protected void writeErrorLog(Context ctx, JobLog.Type type, String fjobprocessdefid, String description, String reason, String advice, Throwable e) {
        if (!StringUtil.isEmptyString((String)fjobprocessdefid)) {
            try {
                HashMap map = ReportAttemperBO.getJobInstInfo(ctx, fjobprocessdefid);
                String fjobinstid = CtrlReportUtil.getObjectString(map.get("fjobinstid"));
                if (!StringUtil.isEmptyString((String)fjobinstid)) {
                    JobLog jobLog = new JobLog(type, description, reason, advice, e, null);
                    jobLog.asyncSave(ctx, fjobinstid);
                }
            }
            catch (Exception e1) {
                this.logger.error((Object)e1);
            }
        }
    }

    protected void updateMaxSerialNum(Context ctx, MaxSerialInfo maxSeialInfo) throws BOSException {
        if (maxSeialInfo != null) {
            if (maxSeialInfo.isFirstCreate()) {
                this.dao.InsertCodingRule(ctx, maxSeialInfo);
            } else {
                this.dao.UpdateCodingRule(ctx, maxSeialInfo);
            }
        }
    }

    private void setSystemPresetParameter(HashMap paramMap) {
        Iterator keyIterator = paramMap.keySet().iterator();
        String value = null;
        while (keyIterator.hasNext()) {
            DesignParameter param = (DesignParameter)((Object)paramMap.get(keyIterator.next()));
            value = param.getCurentValue();
            String[] values = value.split("0xx1xx");
            StringBuffer result = new StringBuffer();
            String currentValue = null;
            int length = values.length;
            for (int i = 0; i < length; ++i) {
                DesignParameter parameters_Default;
                currentValue = values[i];
                if (currentValue.startsWith("@ExtRpt") && (parameters_Default = (DesignParameter)((Object)this.mapSystemParam.get(currentValue.substring(1)))) != null) {
                    currentValue = parameters_Default.getCurentValue();
                }
                result.append(currentValue);
                if (i >= length - 1) continue;
                result.append("0xx1xx");
            }
            param.setCurentValue(result.toString());
        }
    }

    private void executeDateAndTimeParamValue(Map paramMap) {
        Iterator keyIterator = paramMap.keySet().iterator();
        String defaultValue = null;
        String pattern = null;
        int dateType = 0;
        while (keyIterator.hasNext()) {
            Date date;
            DesignParameter param = (DesignParameter)((Object)paramMap.get(keyIterator.next()));
            defaultValue = param.getCurentValue();
            dateType = param.getDesignDataType().intValue();
            pattern = this.getTimePatter(dateType);
            if (dateType != 2 && dateType != 4 && dateType != 5 || (date = AbstractSaveSnapShotAdapter.getDateTimeParamValue(defaultValue, pattern, dateType)) == null) continue;
            String result = this.formatTime(date, dateType);
            param.setCurentValue(result);
        }
    }

    private String formatTime(Date date, int type) {
        String result = null;
        SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        switch (type) {
            case 2: {
                result = dateFormat.format(date);
                break;
            }
            case 4: {
                result = dateTimeFormat.format(date);
                break;
            }
            case 5: {
                result = timeFormat.format(date);
            }
        }
        return result;
    }

    private String getTimePatter(int type) {
        String datePattern = "yyyy-M-d";
        String timePattern = "H:mm:ss";
        String dateTimePattern = "yyyy-M-d ,H:mm:ss";
        if (type == 2) {
            return datePattern;
        }
        if (type == 4) {
            return dateTimePattern;
        }
        if (type == 5) {
            return timePattern;
        }
        return null;
    }

    public static Date getDateTimeParamValue(String defaultValue, String timePattern, int paramType) {
        String dateString;
        Date date = null;
        String dateValue = CtrlReportUtil.getObjectString(defaultValue);
        String timeValue = "";
        if (dateValue.indexOf("|") != -1) {
            String[] arr = dateValue.split("\\|");
            dateValue = arr[0];
            timeValue = arr[1];
        }
        if (dateValue.startsWith("getSystemDate()") || dateValue.startsWith("getSystemTime()")) {
            date = new Date();
        } else if (dateValue.startsWith("dayBegin")) {
            date = new Date();
            dateString = null;
            dateString = DateUtil.getMonthFirstDay(date);
            if (paramType == 4) {
                dateString = dateString + RunReportParam.getTimeString(timeValue);
            }
            date = AbstractSaveSnapShotAdapter.getPatternDate(timePattern, dateString);
        } else if (dateValue.startsWith("dayEnd")) {
            date = new Date();
            dateString = null;
            dateString = DateUtil.getMonthLastDay(date);
            if (paramType == 4) {
                dateString = dateString + RunReportParam.getTimeString(timeValue);
            }
            date = AbstractSaveSnapShotAdapter.getPatternDate(timePattern, dateString);
        } else if (dateValue.startsWith("dateAdd + ")) {
            date = new Date();
            dateValue = ExtStringUtil.replace(dateValue, "dateAdd + ", "");
            int lenth = dateValue.length();
            int addNumber = Integer.parseInt(dateValue.substring(0, lenth - 1));
            String dateString2 = DateUtil.tuneDate(date, addNumber);
            if (paramType == 4) {
                dateString2 = dateString2 + RunReportParam.getTimeString(timeValue);
            }
            date = AbstractSaveSnapShotAdapter.getPatternDate(timePattern, dateString2);
        } else if (dateValue.startsWith("dateSub - ")) {
            date = new Date();
            dateValue = ExtStringUtil.replace(dateValue, "dateSub - ", "");
            int lenth = dateValue.length();
            int addNumber = Integer.parseInt(dateValue.substring(0, lenth - 1));
            String dateString3 = DateUtil.tuneDate(date, 0 - addNumber);
            if (paramType == 4) {
                dateString3 = dateString3 + RunReportParam.getTimeString(timeValue);
            }
            date = AbstractSaveSnapShotAdapter.getPatternDate(timePattern, dateString3);
        } else {
            date = paramType == 2 || paramType == 4 ? AbstractSaveSnapShotAdapter.getPatternDate(timePattern, dateValue) : AbstractSaveSnapShotAdapter.getPatternTimie(timePattern, dateValue);
        }
        return date;
    }

    private static Date getPatternDate(String timePattern, String dateValue) {
        Date date = null;
        try {
            String pattern = timePattern;
            if (!dateValue.equals("") && dateValue.matches("(\\d){4}-(\\d){2}-(\\d){2}(\\s(\\d){2}:(\\d){2}:(\\d){2}(.)*)?")) {
                dateValue = dateValue.indexOf(" ") != -1 ? CtrlReportUtil.formatDate("yyyy-MM-dd HH:mm:ss", pattern, dateValue) : CtrlReportUtil.formatDate("yyyy-MM-dd", pattern, dateValue);
            }
            SimpleDateFormat sdf = new SimpleDateFormat(pattern);
            date = sdf.parse(dateValue);
        }
        catch (ParseException e) {
            date = null;
        }
        return date;
    }

    private static Date getPatternTimie(String timePattern, String dateValue) {
        Date date = null;
        try {
            String pattern = timePattern;
            if (!dateValue.equals("") && dateValue.matches("(\\d){2}:(\\d){2}:(\\d){2}")) {
                dateValue = CtrlReportUtil.formatDate("HH:mm:ss", pattern, dateValue);
            }
            SimpleDateFormat sdf = new SimpleDateFormat(pattern);
            date = sdf.parse(dateValue);
        }
        catch (ParseException e) {
            date = null;
        }
        return date;
    }

    protected abstract boolean saveSnap(Context var1, byte[] var2, String var3, StringBuffer var4, SnapshotBaseInfo var5) throws BOSException, EASBizException, SQLException, IllegalArgumentException, SecurityException, ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, SnapshotException;
}

