/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.snapshot.dispatch.server.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.UID;
import com.kingdee.bos.ctrl.extcommon.server.DbUtil;
import com.kingdee.bos.ctrl.extcommon.server.ServerUtil;
import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.ExtDBUtil;
import com.kingdee.eas.base.reportmeta.snapshot.dispatch.codingrule.pojo.CodingRuleEntryInfo;
import com.kingdee.eas.base.reportmeta.snapshot.dispatch.codingrule.pojo.CodingRuleInfo;
import com.kingdee.eas.base.reportmeta.snapshot.dispatch.pojo.ReportDispatchInfo;
import com.kingdee.eas.base.reportmeta.snapshot.dispatch.server.IReportDispatchDAO;
import com.kingdee.eas.base.reportmeta.snapshot.dispatch.util.DispatchCommonUtil;
import com.kingdee.eas.base.reportmeta.sumreport.util.MixUtil;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ReportDispatchDAOImpl
implements IReportDispatchDAO {
    private Logger log = Logger.getLogger(ReportDispatchDAOImpl.class);

    public IORMModel queryInterface(Class type) throws ORMCoreException {
        return null;
    }

    public void InsertReportDispatch(ReportDispatchInfo info) throws BOSException {
        ArrayList<String> sqlBatch = new ArrayList<String>();
        this.assembleCodingRuleHeadInsertSql(info.getCodingRuleInfo(), sqlBatch);
        StringBuffer sql = new StringBuffer();
        Timestamp curTime = new Timestamp(new Date().getTime());
        sql.append(" insert into T_RM_SSRptDispatch(");
        sql.append(" FID,FName_l1, FName_l2, FName_l3, FReportID, FExcelPath,");
        sql.append(" FFOLDPATH, FFOLDTYPE, FEmail, FSendMail, FOrgID, FJobProcessDefID,");
        sql.append(" FMsgSendType, FIsTakeAttachment, FCreatorID, FCreateTime, FLastUpdateUserID,");
        sql.append(" FLastUpdateTime, FCodingRuleID, FFilterXml, FsnapShotSaveType, FsaveHyplink, FScheduleXml )");
        sql.append(" values (");
        sql.append(" '").append(info.getId()).append("'").append(",");
        sql.append(" '").append(info.getName("l1")).append("'").append(",");
        sql.append(" '").append(info.getName("l2")).append("'").append(",");
        sql.append(" '").append(info.getName("l3")).append("'").append(",");
        sql.append(" '").append(info.getReportId()).append("'").append(",");
        sql.append(" '").append(info.getExcelPath()).append("'").append(",");
        sql.append(" '").append(info.getFoldPath()).append("'").append(",");
        sql.append(info.getFoldType()).append(",");
        sql.append(" '").append(info.getEmail()).append("'").append(",");
        sql.append(" '").append(info.getSendMail()).append("'").append(",");
        sql.append(" '").append(info.getOrgUnitId()).append("'").append(",");
        sql.append(" '").append(info.getJobProcessDefID()).append("'").append(",");
        sql.append(info.getMsgSendType()).append(",");
        if (info.isIsTakeAttachment()) {
            sql.append(1).append(",");
        } else {
            sql.append(0).append(",");
        }
        sql.append(" '").append(info.getCreatorId()).append("'").append(",");
        sql.append("{ts'").append(MixUtil.getDateFromTimestamp(curTime)).append("'},");
        sql.append(" '").append(info.getLastUpdateUserId()).append("'").append(",");
        sql.append("{ts'").append(MixUtil.getDateFromTimestamp(curTime)).append("'}, ");
        sql.append(" '").append(info.getCodingRuleInfo().getId()).append("'").append(",");
        sql.append(" '").append(info.getFilterXML()).append("'").append(",");
        sql.append(info.getSnapShotSaveType()).append(",");
        sql.append(info.isSaveHyplink() ? 1 : 0).append(",");
        sql.append(" '").append(info.getScheduleXML()).append("'").append(" )");
        sqlBatch.add(sql.toString());
        if (sqlBatch.size() > 0) {
            for (int i = 0; i < sqlBatch.size(); ++i) {
                this.log.info(sqlBatch.get(i));
            }
        }
        try {
            DbUtil.executeBatchUpdate((String[])sqlBatch.toArray(new String[3]));
        }
        catch (SQLException e) {
            throw new BOSException("\u66f4\u65b0\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    public void assembleCodingRuleHeadInsertSql(CodingRuleInfo info, ArrayList sqlBatch) {
        String codingRuleId = UID.create((int)44);
        info.setId(codingRuleId);
        Timestamp curTime = new Timestamp(new Date().getTime());
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into T_EXT_codingrule(FID,FNAME_L1,FNAME_L2,FNAME_L3,FCreatorID,");
        sql.append("  FCreateTime, FLastUpdateUserID,FLastUpdateTime) values (");
        sql.append(" '").append(codingRuleId).append("'").append(",");
        sql.append(" '").append(info.getName("l1")).append("'").append(",");
        sql.append(" '").append(info.getName("l2")).append("'").append(",");
        sql.append(" '").append(info.getName("l3")).append("'").append(",");
        sql.append(" '").append(info.getCreatorId()).append("'").append(",");
        sql.append("{ts'").append(MixUtil.getDateFromTimestamp(curTime)).append("'},");
        sql.append(" '").append(info.getLastUpdateUserId()).append("'").append(",");
        sql.append("{ts'").append(MixUtil.getDateFromTimestamp(curTime)).append("'} ) ");
        sqlBatch.add(sql.toString());
        this.assembleCodingRuleEntryInsertSql(info, sqlBatch, false);
    }

    public void assembleCodingRuleEntryInsertSql(CodingRuleInfo info, ArrayList sqlBatch, boolean isEdit) {
        Timestamp curTime = new Timestamp(new Date().getTime());
        StringBuffer sql = new StringBuffer();
        List entryList = info.getCodingRuleEntryInfoList();
        CodingRuleEntryInfo entryInfo = null;
        int size = entryList.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = (CodingRuleEntryInfo)entryList.get(i);
            sql = new StringBuffer();
            sql.append(" insert into T_EXT_codingruleentry(FID,FCodingRuleID,Ftype,Findex,FPREFIX,FSUFFIX,FSeparator,FattributeValue,");
            sql.append(" FCreatorID, FCreateTime, FLastUpdateUserID,FLastUpdateTime) values (");
            sql.append(" '").append(UID.create((int)44)).append("',");
            sql.append(" '").append(info.getId()).append("',");
            sql.append(entryInfo.getType()).append(",");
            sql.append(entryInfo.getIndex()).append(",");
            sql.append(" '").append(entryInfo.getPrefix()).append("',");
            sql.append(" '").append(entryInfo.getSuffix()).append("',");
            sql.append(" '").append(entryInfo.getSeparator()).append("',");
            sql.append(" '").append(entryInfo.getAttributeValue()).append("',");
            sql.append(" '").append(info.getCreatorId()).append("'").append(",");
            sql.append("{ts'").append(MixUtil.getDateFromTimestamp(curTime)).append("'},");
            sql.append(" '").append(info.getLastUpdateUserId()).append("'").append(",");
            sql.append("{ts'").append(MixUtil.getDateFromTimestamp(curTime)).append("'} ) ");
            sqlBatch.add(sql.toString());
        }
    }

    public void assembleCodingRuleHeadUpdateSql(CodingRuleInfo info, ArrayList sqlBatch) {
        StringBuffer sql = new StringBuffer();
        Timestamp curTime = new Timestamp(new Date().getTime());
        sql.append(" delete from T_EXT_codingruleentry where FCodingRuleID = '").append(info.getId()).append("'");
        sqlBatch.add(sql.toString());
        sql.setLength(0);
        sql.append(" update T_EXT_codingrule set FLastUpdateUserID = '").append(info.getLastUpdateUserId()).append("',");
        sql.append(" FLastUpdateTime = {ts'").append(MixUtil.getDateFromTimestamp(curTime)).append("'} ");
        this.assembleCodingRuleEntryInsertSql(info, sqlBatch, true);
    }

    public void UpdateReportDispatch(ReportDispatchInfo info) throws BOSException {
        Timestamp curTime = new Timestamp(new Date().getTime());
        String sql = "update T_RM_SSRptDispatch set FReportID = ? ,FEXCELPATH = ? ,FFOLDPATH = ? ,FFOLDTYPE = ? ,FEmail = ? ,FSendMail = ? ,FOrgID = ? ,FJobProcessDefID = ? ,FMsgSendType = ? ,FsnapShotSaveType = ? ,FIsTakeAttachment = ? ,FLastUpdateUserID = ? ,FLastUpdateTime = ? ,FFilterXml = ? ,FScheduleXml = ? where fid= ?";
        try {
            Connection connection = DbUtil.getConnection();
            PreparedStatement pstmt = connection.prepareStatement(sql);
            pstmt.setString(1, info.getReportId());
            pstmt.setString(2, info.getExcelPath());
            pstmt.setString(3, info.getFoldPath());
            pstmt.setInt(4, info.getFoldType());
            pstmt.setString(5, info.getEmail());
            pstmt.setString(6, info.getSendMail());
            pstmt.setString(7, info.getOrgUnitId());
            pstmt.setString(8, info.getJobProcessDefID());
            pstmt.setInt(9, info.getMsgSendType());
            pstmt.setInt(10, info.getSnapShotSaveType());
            if (info.isIsTakeAttachment()) {
                pstmt.setInt(11, 1);
            } else {
                pstmt.setInt(11, 0);
            }
            pstmt.setString(12, info.getLastUpdateUserId());
            pstmt.setTimestamp(13, curTime);
            pstmt.setObject(14, info.getFilterXML());
            pstmt.setObject(15, info.getScheduleXML());
            pstmt.setString(16, info.getId());
            pstmt.execute();
            DbUtil.closeConnection((Connection)connection);
        }
        catch (SQLException e1) {
            throw new BOSException("\u66f4\u65b0\u5931\u8d25\uff01", (Throwable)e1);
        }
    }

    public List getReportDispatchList(Context ctx, String curLocale, String whereSql) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select s.FID, s.FReportID, s.FJobProcessDefID, j.ftitle,s.FScheduleXml,s.FFilterXml, ");
        sql.append(" s.Fname_").append(curLocale).append(" as dispatchname, ");
        sql.append(" d.Fname_").append(curLocale).append(" as reportname, ");
        sql.append(" u.Fname_").append(curLocale).append(" as username, ");
        sql.append(" org.fname_").append(curLocale).append(" as orgname, ");
        sql.append(" s.fsendmail, s.fcreatorid, s.FCreateTime, s.FLastUpdateUserID as dispatchupdateuserId, s.flastupdatetime as dispatchupdatetime, ");
        sql.append(" s.ffoldtype as foldtype,s.FsnapShotSaveType,s.FsaveHyplink,s.forgid as dispatchCurOrgid,");
        sql.append(" coderule.fid as coderuleid,coderule.fcreatorid, coderule.flastupdateuserid as ruleupdateUserid,");
        sql.append(" ruleentry.findex,ruleentry.ftype, ruleentry.fprefix, ruleentry.fsuffix,ruleentry.FCodingRuleID as entrycoderuleid,");
        sql.append(" ruleentry.fseparator,ruleentry.fattributevalue,d.fsystemid,s.FFOLDPATH,s.FMsgSendType,s.fistakeattachment, ");
        sql.append(" ruleentry.fid as entryid,mail.fmailaddress,mail.fmailhost,mail.fmailuser,mail.fmailpassword,s.FEmail,s.FExcelPath ");
        sql.append(" from T_RM_SSRptDispatch s ");
        sql.append(" inner join t_ext_codingrule coderule on s.fcodingruleid = coderule.fid");
        sql.append(" inner join t_ext_codingruleentry ruleentry on coderule.fid = ruleentry.fcodingruleid");
        sql.append(" LEFT OUTER JOIN T_RM_DefineReport d on s.freportid = d.fid ");
        sql.append(" LEFT OUTER JOIN t_pm_user u on s.FCreatorID = u.fid ");
        sql.append(" LEFT OUTER JOIN T_JOB_DEF j on s.FJobProcessDefID = j.fjobdefid ");
        sql.append(" left join t_org_baseunit org on s.forgid = org.fid");
        sql.append(" left join t_ext_sendmailinfo mail on s.fsendmail = mail.fmailaddress");
        sql.append(" where 1 = 1 ");
        if (!StringUtil.isEmptyString((String)whereSql)) {
            sql.append(whereSql);
        }
        sql.append(" order by s.flastupdatetime desc,ruleentry.findex asc");
        if (ctx == null) {
            ctx = ServerUtil.getContext();
        }
        return ExtDBUtil.getResultListBySql(ctx, sql.toString(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDispatch(List dispatchInfoList) throws BOSException {
        block15: {
            int size = dispatchInfoList.size();
            ArrayList<String> dispatchIdList = new ArrayList<String>(size);
            ArrayList<String> jobIdList = new ArrayList<String>(size);
            ArrayList<String> codingRuleIdList = new ArrayList<String>(size);
            ArrayList maxSerialList = new ArrayList(size);
            StringBuffer dispatchIdQuesMark = new StringBuffer(" ( ");
            StringBuffer jobIdQuesMark = new StringBuffer(" ( ");
            StringBuffer maxNumBuffer = new StringBuffer();
            ReportDispatchInfo info = null;
            int j = 0;
            for (int i = 0; i < size; ++i) {
                info = (ReportDispatchInfo)dispatchInfoList.get(i);
                dispatchIdList.add(info.getId());
                this.addQuestionMark(i, dispatchIdQuesMark);
                if (!StringUtil.isEmptyString((String)info.getJobProcessDefID())) {
                    jobIdList.add(info.getJobProcessDefID());
                    this.addQuestionMark(j, jobIdQuesMark);
                    ++j;
                    this.getMaxSerialSql(info, maxSerialList, maxNumBuffer);
                }
                codingRuleIdList.add(info.getCodingRuleInfo().getId());
            }
            dispatchIdQuesMark.append(" ) ");
            jobIdQuesMark.append(" ) ");
            maxNumBuffer.append(" ) ");
            StringBuffer sql = new StringBuffer();
            sql.append(" delete from T_RM_SSRptDispatch where fid in ").append(dispatchIdQuesMark);
            Connection conn = null;
            try {
                conn = DbUtil.getConnection();
                conn.setAutoCommit(false);
                DbUtil.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])dispatchIdList.toArray());
                this.deleteWorkFlow(conn, jobIdList, jobIdQuesMark);
                this.deleteCodingRule(conn, codingRuleIdList);
                this.deleteMaxSeial(conn, maxSerialList, maxNumBuffer);
                conn.commit();
            }
            catch (SQLException e) {
                if (conn == null) break block15;
                try {
                    conn.rollback();
                }
                catch (SQLException e1) {
                    throw new BOSException((Throwable)e1);
                }
            }
            finally {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    conn = null;
                }
            }
        }
    }

    private void deleteCodingRule(Connection conn, List codingRuleIdList) throws SQLException {
        if (codingRuleIdList == null || codingRuleIdList.size() == 0) {
            return;
        }
        StringBuffer sqlEntry = new StringBuffer("delete from t_Ext_Codingruleentry where fcodingruleid in (");
        StringBuffer sql = new StringBuffer("delete from t_Ext_Codingrule where fid in (");
        ArrayList paramEntry = new ArrayList();
        int size = codingRuleIdList.size();
        for (int i = 0; i < size; ++i) {
            paramEntry.add(codingRuleIdList.get(i));
            if (i == 0) {
                sqlEntry.append("?");
                sql.append("?");
                continue;
            }
            sqlEntry.append(",?");
            sql.append(",?");
        }
        sqlEntry.append(")");
        sql.append(")");
        Object[] objs = paramEntry.toArray();
        DbUtil.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])objs);
        DbUtil.executeUpdate((Connection)conn, (String)sqlEntry.toString(), (Object[])objs);
    }

    private void deleteWorkFlow(Connection conn, List jobIdList, StringBuffer jobIdQuesMark) throws BOSException, SQLException {
        if (jobIdList == null || jobIdList.size() == 0) {
            return;
        }
        Object[] paramObj = jobIdList.toArray();
        StringBuffer sql = new StringBuffer("delete T_JOB_TRIGGER where fjobdefid in ").append(jobIdQuesMark);
        DbUtil.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])paramObj);
        sql.setLength(0);
        sql.append("delete T_JOB_DEF where fjobdefid in ").append(jobIdQuesMark);
        DbUtil.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])paramObj);
    }

    private void getMaxSerialSql(ReportDispatchInfo info, List maxSerialList, StringBuffer maxNumBuffer) {
        CodingRuleInfo codeInfo = info.getCodingRuleInfo();
        List codeEntryList = codeInfo.getCodingRuleEntryInfoList();
        if (codeEntryList != null && codeEntryList.size() > 0) {
            int size = codeEntryList.size();
            for (int i = 0; i < size; ++i) {
                CodingRuleEntryInfo entry = (CodingRuleEntryInfo)codeEntryList.get(i);
                if (entry.getType() != 3) continue;
                maxSerialList.add(entry.getId());
                if (maxNumBuffer.length() == 0) {
                    maxNumBuffer.append("( ?");
                    continue;
                }
                maxNumBuffer.append(",?");
            }
        }
    }

    private void deleteMaxSeial(Connection conn, List maxSerialList, StringBuffer maxNumBuffer) throws BOSException, SQLException {
        if (maxSerialList == null || maxSerialList.size() == 0) {
            return;
        }
        Object[] paramObj = maxSerialList.toArray();
        StringBuffer sql = new StringBuffer("delete t_ext_maxserial where fcodingruleEntryid in ").append(maxNumBuffer);
        DbUtil.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])paramObj);
    }

    private void addQuestionMark(int i, StringBuffer quesMark) {
        if (i == 0) {
            quesMark.append("?");
        } else {
            quesMark.append(",?");
        }
    }

    public boolean isExist(String dispatchName, String locale, String curOrgId) throws BOSException {
        ArrayList<String> queryValue = new ArrayList<String>();
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("SELECT FID FROM T_RM_RptAttemper WHERE fOrgID = ? And ");
        sbSQL.append("FName_").append(locale).append(" = ?");
        queryValue.add(curOrgId);
        queryValue.add(dispatchName);
        ArrayList resultList = ExtDBUtil.getResultListBySql(ServerUtil.getContext(), sbSQL.toString(), queryValue);
        return resultList != null && resultList.size() > 0;
    }

    public ReportDispatchInfo getReportDispatchInfoById(String dispatchId, String curLocale) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select s.FID, s.FReportID, d.FDeployPath, s.FJobProcessDefID, j.ftitle,fschedulexml,ffilterxml, ");
        sql.append(" s.Fname_").append(curLocale).append(" as dispatchname, ");
        sql.append(" d.Fname_").append(curLocale).append(" as reportname, ");
        sql.append(" u.Fname_").append(curLocale).append(" as username, ");
        sql.append(" s.fcreatorid, s.FCreateTime, s.FLastUpdateUserID, s.flastupdatetime ");
        sql.append(" from T_RM_SSRptDispatch s ");
        sql.append(" LEFT OUTER JOIN T_RM_DefineReport d on s.freportid = d.fid ");
        sql.append(" LEFT OUTER JOIN t_pm_user u on s.FCreatorID = u.fid ");
        sql.append(" LEFT OUTER JOIN T_JOB_DEF j on s.FJobProcessDefID = j.fjobdefid ");
        sql.append(" where s.fid = ? ");
        ArrayList<String> params = new ArrayList<String>();
        params.add(dispatchId);
        ArrayList result = ExtDBUtil.getResultListBySql(ServerUtil.getContext(), sql.toString(), params);
        ReportDispatchInfo info = null;
        if (result != null && result.size() > 0) {
            Map resultMap = (Map)result.get(0);
            info = new ReportDispatchInfo();
            info.setId((String)resultMap.get("fid"));
            info.setReportId((String)resultMap.get("freportid"));
            info.setName((String)resultMap.get("dispatchname"), curLocale);
            try {
                info.setFilterXML(DispatchCommonUtil.clob2String(resultMap.get("ffilterxml")));
                info.setScheduleXML(DispatchCommonUtil.clob2String(resultMap.get("fschedulexml")));
            }
            catch (IOException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return info;
    }

    public void updateDispatchJobProcessDefId(String dispatchId, String JobProcessDefID) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_RM_SSRptDispatch set FJobProcessDefID=?");
        sql.append(" where fid=? ");
        ArrayList<String> params = new ArrayList<String>(2);
        params.add(JobProcessDefID);
        params.add(dispatchId);
        ExtDBUtil.maintainRecord(ServerUtil.getContext(), sql.toString(), params);
    }

    public void setJobHolderNull(String jobProcessDefId) throws BOSException {
        ArrayList<String> param = new ArrayList<String>(1);
        String sql = "update T_JOB_TRIGGER set fholderid = null where fjobdefid = ?";
        param.add(jobProcessDefId);
        ExtDBUtil.maintainRecord(ServerUtil.getContext(), sql, param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undoRelease(List dispatchInfoList) throws BOSException, SQLException {
        int size = dispatchInfoList.size();
        ArrayList<String> jobIdList = new ArrayList<String>(dispatchInfoList.size());
        ArrayList<String> reportDispIdList = new ArrayList<String>(dispatchInfoList.size());
        Connection conn = null;
        try {
            conn = DbUtil.getConnection();
            conn.setAutoCommit(false);
            ReportDispatchInfo info = null;
            StringBuffer jobIdQuesMark = new StringBuffer(" ( ");
            int j = 0;
            for (int i = 0; i < size; ++i) {
                info = (ReportDispatchInfo)dispatchInfoList.get(i);
                if (StringUtil.isEmptyString((String)info.getJobProcessDefID())) continue;
                jobIdList.add(info.getJobProcessDefID());
                reportDispIdList.add(info.getId());
                this.addQuestionMark(j, jobIdQuesMark);
                ++j;
            }
            jobIdQuesMark.append(" ) ");
            this.deleteWorkFlow(conn, jobIdList, jobIdQuesMark);
            this.updateJobProcessDefIdNull(conn, reportDispIdList, jobIdQuesMark.toString());
            conn.commit();
        }
        catch (SQLException e) {
            if (conn != null) {
                conn.rollback();
            }
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                conn = null;
            }
        }
    }

    public void updateJobProcessDefIdNull(Connection conn, List reportDispIdList, String jobIdQuesMark) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_RM_SSRptDispatch set FJobProcessDefID = null ");
        sql.append(" where fid in ").append(jobIdQuesMark);
        DbUtil.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])reportDispIdList.toArray());
    }
}

