/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.snapshot.manage.server.pf.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extcommon.server.DbUtil;
import com.kingdee.bos.ctrl.extcommon.server.ServerUtil;
import com.kingdee.eas.base.reportmeta.snapshot.manage.exception.PersonalFolderException;
import com.kingdee.eas.base.reportmeta.snapshot.manage.pojo.PersonalFolder;
import com.kingdee.eas.base.reportmeta.snapshot.manage.server.pf.IPersonalFolderDAO;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class PersonalFolderDAO
implements IPersonalFolderDAO {
    public List buildTree(String userID) throws PersonalFolderException {
        StringBuffer sqlBuf = new StringBuffer("Select Fid, Fname,Flongnumber,Fparentid,Fcreatetime,Flevel,Forder From T_EXT_SSPersonFolder ");
        sqlBuf.append(" Where FUserId = ? Order by flevel asc, forder asc");
        Object[] params = new Object[]{userID};
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((String)sqlBuf.toString(), (Object[])params);
            ArrayList<PersonalFolder> rsLst = new ArrayList<PersonalFolder>(rs.size());
            while (rs.next()) {
                PersonalFolder folder = new PersonalFolder();
                folder.setId(rs.getString("Fid"));
                folder.setName(rs.getString("Fname"));
                folder.setLongNumber(rs.getString("Flongnumber"));
                folder.setParentId(rs.getString("Fparentid"));
                folder.setCreateTime(rs.getTimestamp("Fcreatetime"));
                folder.setLevel(rs.getInt("Flevel"));
                folder.setOrder(rs.getInt("Forder"));
                rsLst.add(folder);
            }
            ArrayList<PersonalFolder> arrayList = rsLst;
            return arrayList;
        }
        catch (SQLException e) {
            throw PersonalFolderException.wrap(e);
        }
        finally {
            if (rs != null) {
                SQLUtils.cleanup((ResultSet)rs);
            }
            sqlBuf = null;
            params = null;
        }
    }

    public PersonalFolder deleteBranchFolder(PersonalFolder folder) throws PersonalFolderException {
        StringBuffer sqlBuf = new StringBuffer("Delete From T_EXT_SSPersonFolder Where FUserID = ? And CharIndex('");
        sqlBuf.append(folder.getLongNumber());
        sqlBuf.append("',FlongNumber) > 0");
        try {
            DbUtil.executeUpdate((String)sqlBuf.toString(), (Object[])new Object[]{folder.getUserId()});
            PersonalFolder personalFolder = folder;
            return personalFolder;
        }
        catch (SQLException e) {
            throw PersonalFolderException.wrap(e);
        }
        finally {
            sqlBuf = null;
        }
    }

    public PersonalFolder deleteLeafFolder(PersonalFolder folder) throws PersonalFolderException {
        StringBuffer sqlBuf = new StringBuffer("Delete From T_EXT_SSPersonFolder Where FID ='");
        sqlBuf.append(folder.getId()).append('\'');
        try {
            DbUtil.executeUpdate((String)sqlBuf.toString(), null);
            PersonalFolder personalFolder = folder;
            return personalFolder;
        }
        catch (SQLException e) {
            throw PersonalFolderException.wrap(e);
        }
        finally {
            sqlBuf = null;
        }
    }

    public PersonalFolder insertFolder(PersonalFolder folder) throws PersonalFolderException {
        StringBuffer sqlBuf = new StringBuffer("Insert Into T_EXT_SSPersonFolder");
        sqlBuf.append("(FID,FNAME,FLONGNUMBER,FPARENTID,FCREATETIME,FLevel,FOrder,FUSERID)");
        sqlBuf.append(" Values( ?,?,?,?,?,?,?,? )");
        Object[] params = new Object[]{folder.getId(), folder.getName(), folder.getLongNumber(), folder.getParentId(), folder.getCreateTime(), new Integer(folder.getLevel()), new Integer(folder.getOrder()), folder.getUserId()};
        try {
            DbUtil.executeUpdate((String)sqlBuf.toString(), (Object[])params);
            PersonalFolder personalFolder = folder;
            return personalFolder;
        }
        catch (SQLException e) {
            throw PersonalFolderException.wrap(e);
        }
        finally {
            sqlBuf = null;
            params = null;
        }
    }

    public PersonalFolder updateFolder(PersonalFolder folder) throws PersonalFolderException {
        StringBuffer sqlBuf = new StringBuffer("Update T_EXT_SSPersonFolder Set Fname = ? Where ");
        sqlBuf.append(" Fid = ?");
        Object[] params = new Object[]{folder.getName(), folder.getId()};
        try {
            DbUtil.executeUpdate((String)sqlBuf.toString(), (Object[])params);
            PersonalFolder personalFolder = folder;
            return personalFolder;
        }
        catch (SQLException e) {
            throw PersonalFolderException.wrap(e);
        }
        finally {
            sqlBuf = null;
            params = null;
        }
    }

    public int getCount(String userID) throws PersonalFolderException {
        StringBuffer sqlBuf = new StringBuffer("Select count(*) as count From T_EXT_SSPersonFolder ");
        sqlBuf.append(" Where FUserId = ?");
        Object[] params = new Object[]{userID};
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((String)sqlBuf.toString(), (Object[])params);
            if (rs.next()) {
                int n = rs.getInt("count");
                return n;
            }
            int n = 0;
            return n;
        }
        catch (SQLException e) {
            throw PersonalFolderException.wrap(e);
        }
        finally {
            if (rs != null) {
                SQLUtils.cleanup((ResultSet)rs);
            }
            sqlBuf = null;
            params = null;
        }
    }

    public boolean isNameExist(String name, String parentID) throws PersonalFolderException {
        boolean bl;
        StringBuffer sqlBuf;
        block5: {
            sqlBuf = new StringBuffer("Select 1 from T_EXT_SSPersonFolder Where FUserId = ? and Fname = ? and FPARENTID = ?");
            IRowSet rs = null;
            try {
                String userID = ContextUtil.getCurrentUserInfo((Context)ServerUtil.getContext()).getId().toString();
                rs = DbUtil.executeQuery((String)sqlBuf.toString(), (Object[])new Object[]{userID, name, parentID});
                bl = rs.next();
                if (rs == null) break block5;
            }
            catch (SQLException e) {
                try {
                    throw PersonalFolderException.wrap(e);
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        SQLUtils.cleanup(rs);
                    }
                    sqlBuf = null;
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs);
        }
        sqlBuf = null;
        return bl;
    }

    public String getNamebyID(String id) throws PersonalFolderException {
        String string;
        StringBuffer sqlBuf;
        block8: {
            IRowSet rs;
            block6: {
                String string2;
                block7: {
                    sqlBuf = new StringBuffer("Select fname from T_EXT_SSPersonFolder Where Fid = ?");
                    rs = null;
                    rs = DbUtil.executeQuery((String)sqlBuf.toString(), (Object[])new Object[]{id});
                    if (!rs.next()) break block6;
                    string2 = rs.getString("fname");
                    if (rs == null) break block7;
                    SQLUtils.cleanup((ResultSet)rs);
                }
                sqlBuf = null;
                return string2;
            }
            try {
                string = null;
                if (rs == null) break block8;
            }
            catch (SQLException e) {
                try {
                    throw PersonalFolderException.wrap(e);
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        SQLUtils.cleanup(rs);
                    }
                    sqlBuf = null;
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs);
        }
        sqlBuf = null;
        return string;
    }
}

