/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.sumreport.util;

import com.kingdee.eas.base.reportmeta.sumreport.util.BaseUuid;
import com.kingdee.eas.base.reportmeta.sumreport.util.ExtUuidException;
import com.kingdee.util.Base64Encoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public final class ExtUuid
implements Serializable {
    private static final long serialVersionUID = -65533L;
    private transient BaseUuid uuid;
    private transient byte encoding;
    private static final byte MIXED_ENCODING = 0;
    private static final byte BASE64_ENCODING = 1;
    private static final int COMPATIBLE_MIXED_ENCODING_LENGTH = 40;
    private static final int MIXED_ENCODING_LENGTH = 44;
    private static final int BASE64_ENCODING_LENGTH = 28;

    public static synchronized ExtUuid create() {
        return new ExtUuid(BaseUuid.create(), 1);
    }

    private ExtUuid(BaseUuid uuid, byte encoding) {
        this.encoding = encoding;
        this.uuid = uuid;
    }

    public static ExtUuid read(String id) throws ExtUuidException {
        if (id == null || id.length() == 0) {
            throw new IllegalArgumentException("id is null or length is 0. '" + id + "'");
        }
        if (id.length() == 44 || id.length() == 40) {
            BaseUuid uuid = BaseUuid.read(id.substring(0, 36));
            return new ExtUuid(uuid, 0);
        }
        if (id.length() == 28) {
            if (id.charAt(id.length() - 1) != '=') {
                throw new IllegalArgumentException("the argument 'id' is invalid. '" + id + "'");
            }
            byte[] array = Base64Encoder.base64ToByteArray((String)id);
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(array));
            try {
                BaseUuid uuid = BaseUuid.read(in);
                return new ExtUuid(uuid, 1);
            }
            catch (IOException ioe) {
                throw new ExtUuidException(ioe);
            }
        }
        throw new IllegalArgumentException("The argument 'id' is invalid. '" + id + "'");
    }

    public String toString() {
        if (this.encoding == 1) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(28);
            DataOutputStream out = new DataOutputStream(baos);
            try {
                this.uuid.write(out);
            }
            catch (IOException ioe) {
                throw new ExtUuidException(ioe);
            }
            return Base64Encoder.byteArrayToBase64((byte[])baos.toByteArray());
        }
        if (this.encoding == 0) {
            return this.uuid.toString();
        }
        throw new AssertionError((Object)"unhandled encoding.");
    }

    public static boolean isValidLength(String bosuuid) {
        if (bosuuid == null || bosuuid.length() == 0) {
            return false;
        }
        return bosuuid.length() == 44 || bosuuid.length() == 40 || bosuuid.length() == 28;
    }

    public static boolean isValidLength(String bosuuid, boolean trim) {
        if (bosuuid == null || bosuuid.length() == 0) {
            return false;
        }
        String id = null;
        id = trim ? bosuuid.trim() : bosuuid;
        return ExtUuid.isValidLength(id);
    }

    public static boolean isValid(String bosuuid, boolean trim) {
        if (!ExtUuid.isValidLength(bosuuid, trim)) {
            return false;
        }
        try {
            ExtUuid.read(bosuuid.trim());
        }
        catch (ExtUuidException e) {
            return false;
        }
        catch (IllegalArgumentException e1) {
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ExtUuid) {
            return this.uuid.equals(((ExtUuid)obj).uuid);
        }
        return false;
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        this.uuid.write(s);
        s.writeByte(this.encoding);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.uuid = BaseUuid.read(s);
        this.encoding = s.readByte();
    }

    public void write(DataOutput out) throws IOException {
        this.uuid.write(out);
        out.writeByte(this.encoding);
    }

    public static ExtUuid read(DataInput in) throws IOException {
        return new ExtUuid(BaseUuid.read(in), in.readByte());
    }

    public static final String createUuid() {
        return ExtUuid.create().toString();
    }

    public static void main(String[] args) {
        for (int i = 0; i < 10; ++i) {
            System.out.println(ExtUuid.createUuid());
        }
    }
}

