/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.openapi.app.mq;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.openapi.OpenapiMqCollection;
import com.kingdee.bos.openapi.OpenapiMqConsumerCollection;
import com.kingdee.bos.openapi.OpenapiMqConsumerInfo;
import com.kingdee.bos.openapi.OpenapiMqFactory;
import com.kingdee.bos.openapi.OpenapiMqInfo;
import com.kingdee.bos.openapi.app.mq.MqUtils;
import com.kingdee.bos.openapi.app.mq.QueueItem;
import com.kingdee.bos.openapi.app.mq.comsumer.IMqConsumer;
import com.kingdee.bos.openapi.app.mq.comsumer.MessageConsumer;
import com.kingdee.bos.openapi.app.mq.comsumer.MqConsumerFactory;
import com.kingdee.bos.openapi.common.mq.ConnectionEntity;
import com.kingdee.bos.openapi.common.mq.IERPConsumerQueue;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class QueueManager {
    private static final Logger logger = Logger.getLogger(QueueManager.class);
    private static Map<String, QueueItem> queueMap = new ConcurrentHashMap<String, QueueItem>();

    public static void init(Context ctx) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("*"));
        sc.add(new SelectorItemInfo("treeid.*"));
        sc.add(new SelectorItemInfo("comsumer.*"));
        view.setSelector(sc);
        OpenapiMqCollection mqCollection = OpenapiMqFactory.getLocalInstance(ctx).getOpenapiMqCollection(view);
        for (int i = 0; i < mqCollection.size(); ++i) {
            OpenapiMqInfo mqInfo = mqCollection.get(i);
            try {
                ConnectionEntity mqConnection = MqUtils.generateConnetion(mqInfo);
                OpenapiMqConsumerCollection consumers = mqInfo.getComsumer();
                for (int j = 0; j < consumers.size(); ++j) {
                    OpenapiMqConsumerInfo consumer = consumers.get(j);
                    IERPConsumerQueue queue = MqUtils.convertConsumer(consumer);
                    QueueManager.handleComsumerQueue(mqConnection, queue);
                }
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("openapi mq init error! mqInfo name is " + mqInfo.getName()), (Throwable)e);
            }
        }
    }

    public static String getRealQueueName(String userName, String pwd, String queueName, boolean needCallBack, String tag) {
        return queueName;
    }

    public static synchronized void handleComsumerQueue(ConnectionEntity conn, IERPConsumerQueue consumerQueue) throws Exception {
        if (null == conn) {
            logger.error((Object)"init ierp queue,the MQ connection information is null.");
            throw new RuntimeException("init ierp queue,the MQ connection information is null.");
        }
        String queueName = QueueManager.getRealQueueName(conn.getUserName(), conn.getPassword(), consumerQueue.getQueueName(), consumerQueue.isAutoCallBack(), consumerQueue.getTag());
        QueueItem cacheQueue = queueMap.get(queueName);
        int threadCount = 0;
        threadCount = cacheQueue != null ? consumerQueue.getThreadCount() - cacheQueue.getCurrentThreadCount() : consumerQueue.getThreadCount();
        if (threadCount > 0) {
            QueueManager.addConsumerQueueThread(conn, consumerQueue, threadCount);
        } else {
            QueueManager.reduceConsumerQueueThread(conn, consumerQueue, -threadCount);
        }
    }

    public static synchronized void reduceConsumerQueueThread(ConnectionEntity conn, IERPConsumerQueue consumerQueue, int threadCount) {
        if (threadCount <= 0) {
            return;
        }
        String queueName = QueueManager.getRealQueueName(conn.getUserName(), conn.getPassword(), consumerQueue.getQueueName(), consumerQueue.isAutoCallBack(), consumerQueue.getTag());
        QueueItem item = queueMap.get(queueName);
        item.setStand(consumerQueue);
    }

    public static synchronized void checkReduceConsumer(IMqConsumer consumer) {
        IERPConsumerQueue consumerQueue;
        String queueName = consumer.getQueue();
        QueueItem item = queueMap.get(queueName);
        if (item != null && (consumerQueue = item.getStand()).getThreadCount() < item.getCurrentThreadCount()) {
            try {
                consumer.close();
                item.reduceCurrentThreadCount();
            }
            catch (Exception e) {
                logger.error((Object)"openapi mq close consumer error,", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void addConsumerQueueThread(ConnectionEntity conn, IERPConsumerQueue consumerQueue, int threadCount) {
        int i;
        if (threadCount <= 0) {
            return;
        }
        String queueName = QueueManager.getRealQueueName(conn.getUserName(), conn.getPassword(), consumerQueue.getQueueName(), consumerQueue.isAutoCallBack(), consumerQueue.getTag());
        try {
            for (i = 0; i < threadCount; ++i) {
                MessageConsumer consumer = QueueManager.checkConsumerClazz(consumerQueue);
                try {
                    IMqConsumer rabbitMqConsumer = MqConsumerFactory.getMqConsumer(conn, consumer, consumerQueue);
                    rabbitMqConsumer.start();
                    continue;
                }
                catch (IOException e) {
                    logger.error((Object)e);
                    throw new RuntimeException("fail to start consumer", e);
                }
            }
        }
        finally {
            QueueItem queue1 = queueMap.get(queueName);
            if (queue1 == null) {
                queue1 = new QueueItem(consumerQueue);
                queue1.setCurrentThreadCount(i);
                queueMap.put(queueName, queue1);
            } else {
                queue1.setStand(consumerQueue);
                queue1.addCurrentThreadCount(i);
            }
        }
    }

    private static MessageConsumer checkConsumerClazz(IERPConsumerQueue consumerQueue) {
        String ClazzName = consumerQueue.getConsumerClass();
        if (StringUtils.isEmpty((String)ClazzName)) {
            logger.error((Object)"the consumer deal with MQ message the consumer class is not exist.");
            throw new RuntimeException("the consumer deal with MQ message the consumer class is not exist.");
        }
        MessageConsumer consumer = null;
        try {
            Class<?> clazz = Class.forName(ClazzName);
            if (MessageConsumer.class.isAssignableFrom(clazz)) {
                consumer = (MessageConsumer)clazz.newInstance();
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (consumer == null) {
            throw new RuntimeException("the consumer deal with MQ message the consumer class is invailed " + ClazzName);
        }
        return consumer;
    }
}

