/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.openapi.third.ctx;

import com.kingdee.bos.openapi.third.ctx.IloginContext;
import com.kingdee.bos.openapi.third.utils.OpenApiTools;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class LTPALogin
implements IloginContext {
    private static String URL = "/easportal/openapi/login/ltpa";
    protected SortedMap<String, String> map = new TreeMap<String, String>();
    private final String appid;
    private final String secret;
    private final String dcname;
    private final long timestamp;
    private final String userName;
    private final String language;

    private LTPALogin(Builder builder) {
        this.appid = builder.appid;
        this.secret = builder.secret;
        this.dcname = builder.dcname;
        this.language = builder.language;
        this.timestamp = builder.timestamp;
        this.userName = builder.userName;
        try {
            this.init();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void init() throws Exception {
        StringBuffer signBf = new StringBuffer(this.appid).append(this.secret).append(this.dcname).append(this.userName).append(this.language).append(this.timestamp);
        String signiture = OpenApiTools.sha1(signBf.toString());
        this.map.put("appid", this.appid);
        this.map.put("dcName", this.dcname);
        this.map.put("timestamp", String.valueOf(this.timestamp));
        this.map.put("signiture", signiture);
        this.map.put("username", this.userName);
        this.map.put("language", this.language);
    }

    @Override
    public Map<String, String> getMap() {
        return this.map;
    }

    @Override
    public String getURL() {
        return URL;
    }

    public static class Builder {
        private final String appid;
        private final String secret;
        private final String dcname;
        private final long timestamp;
        private final String userName;
        private final String language;

        public Builder(String appid, String easSecret, String dcname, long timestamp, String userName, String language) {
            this.appid = appid;
            this.secret = easSecret;
            this.dcname = dcname;
            this.timestamp = timestamp;
            this.userName = userName;
            this.language = language;
        }

        public IloginContext build() {
            this.check();
            return new LTPALogin(this);
        }

        public void check() throws IllegalArgumentException {
            if (OpenApiTools.isEmpty(this.appid)) {
                throw new IllegalArgumentException("Invalid parameters appid");
            }
            if (OpenApiTools.isEmpty(this.secret)) {
                throw new IllegalArgumentException("Invalid parameters secret");
            }
            if (OpenApiTools.isEmpty(this.dcname)) {
                throw new IllegalArgumentException("Invalid parameters dcname");
            }
            if (OpenApiTools.isEmpty(this.userName)) {
                throw new IllegalArgumentException("Invalid parameters userName");
            }
            if (OpenApiTools.isEmpty(this.language)) {
                throw new IllegalArgumentException("Invalid parameters language");
            }
            if (this.timestamp == 0L) {
                throw new IllegalArgumentException("Invalid parameters timestamp");
            }
        }
    }
}

