/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.engine.runner.longer;

import com.kingdee.bos.qing.core.engine.AbstractEngine;
import com.kingdee.bos.qing.core.engine.AbstractRuntimeFilter;
import com.kingdee.bos.qing.core.engine.DataSourceTraversal;
import com.kingdee.bos.qing.core.engine.ParentChildDimensionFilterPretreater;
import com.kingdee.bos.qing.core.engine.runner.longer.AbstractEngineRunner;
import com.kingdee.bos.qing.core.engine.runner.longer.Helper;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.longer.AnalyticalModel;
import com.kingdee.bos.qing.datasource.spec.IDataSourceVisitor;
import java.util.List;

public class EngineRunner
extends AbstractEngineRunner {
    private List<AbstractRuntimeFilter.IRuntimePushdownFilter> _pushdownFilters;

    public EngineRunner(IDataSourceVisitor dataSourceVisitor, AnalyticalModel model) {
        super(dataSourceVisitor);
        this.setModel(model);
    }

    @Override
    protected void beforeRun() throws AnalysisException {
        this._pushdownFilters = Helper.checkDimensionNecessity(this.getModel());
    }

    @Override
    protected void initFilter(List<AnalyticalField> dimensionFields, List<AnalyticalField> measureFields) throws AnalysisException {
        this.pretreatParentChildDimensionFilter(dimensionFields);
    }

    @Override
    protected DataSourceTraversal createDataSourceTraversal() {
        DataSourceTraversal dataSourceTraversal = super.createDataSourceTraversal();
        dataSourceTraversal.addPushdownFilters(this._pushdownFilters);
        return dataSourceTraversal;
    }

    @Override
    protected void initFilterPreparedValueGainer(AbstractEngine engine) throws AnalysisException {
    }

    private void pretreatParentChildDimensionFilter(List<AnalyticalField> dimensionFields) throws AnalysisException {
        if (this.getModel().getFilterFieldSet().getFieldCount() > 0) {
            ParentChildDimensionFilterPretreater pretreater = new ParentChildDimensionFilterPretreater();
            pretreater.pretreat(this.getModel(), dimensionFields, this.getDataSourceVisitor());
        }
    }
}

