/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.engine.runner.longer;

import com.kingdee.bos.qing.core.engine.AbstractEngine;
import com.kingdee.bos.qing.core.engine.DataSourceGreenChannel;
import com.kingdee.bos.qing.core.engine.FilterPreparedValueGainer;
import com.kingdee.bos.qing.core.engine.runner.longer.AbstractEngineRunnerForFilterPreparedValue;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.exception.DataTraversalException;
import com.kingdee.bos.qing.core.exception.FormulaExecutingException;
import com.kingdee.bos.qing.core.exception.UserStoppedException;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.common.filter.AbstractAnalyticalFilter;
import com.kingdee.bos.qing.core.model.analysis.longer.AnalyticalModel;
import com.kingdee.bos.qing.core.model.analysis.longer.FilterFieldSet;
import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.spec.IDataSourceVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class EngineRunnerForFilterPreparedValue
extends AbstractEngineRunnerForFilterPreparedValue {
    private List<AnalyticalField> _abandonedFields;

    public EngineRunnerForFilterPreparedValue(IDataSourceVisitor dataSourceVisitor, AnalyticalModel model) {
        super(dataSourceVisitor);
        this.setModel(this.cloneAndRemoveFilterFromModel2(model));
        this.setTargetFilterFields(model.getFilterFieldSet().getFields());
    }

    public EngineRunnerForFilterPreparedValue(IDataSourceVisitor dataSourceVisitor, AnalyticalModel model, AnalyticalField field) {
        super(dataSourceVisitor);
        this.setModel(this.cloneAndRemoveFilterFromModel1(model));
        this.setTargetFilterField(field);
    }

    private AnalyticalModel cloneAndRemoveFilterFromModel1(AnalyticalModel model) {
        AnalyticalModel noFilterModel = model.copy();
        noFilterModel.setFilterFieldSet(null);
        return noFilterModel;
    }

    private AnalyticalModel cloneAndRemoveFilterFromModel2(AnalyticalModel model) {
        AnalyticalModel clonedModel = model.copy();
        boolean isAnyPreparedValueGainedByCube = false;
        boolean isAnyPreparedValueGainedByDs = false;
        FilterFieldSet filterFieldSet = clonedModel.getFilterFieldSet();
        for (int i = 0; i < filterFieldSet.getFieldCount(); ++i) {
            AnalyticalField field = filterFieldSet.getField(i);
            boolean isGainedByCube = field.isMeasure();
            boolean isGainedByDs = !field.isCanPullDown();
            isAnyPreparedValueGainedByCube = isGainedByCube || isAnyPreparedValueGainedByCube;
            isAnyPreparedValueGainedByDs = isGainedByDs || isAnyPreparedValueGainedByDs;
        }
        if (isAnyPreparedValueGainedByCube) {
            clonedModel.setFilterFieldSet(null);
        } else {
            if (isAnyPreparedValueGainedByDs) {
                for (AbstractAnalyticalFilter filter : filterFieldSet.getFilters()) {
                    filter.forcedPullDownDisabled();
                }
            }
            this._abandonedFields = new ArrayList<AnalyticalField>();
            this._abandonedFields.addAll(clonedModel.getRow().getFields());
            this._abandonedFields.addAll(clonedModel.getColumn().getFields());
            this._abandonedFields.addAll(clonedModel.getMarkFieldSet().getFields());
            clonedModel.getRow().getFields().clear();
            clonedModel.getColumn().getFields().clear();
            clonedModel.getMarkFieldSet().getFields().clear();
            clonedModel.getMarkFieldSet().getMarkTypes().clear();
        }
        return clonedModel;
    }

    @Override
    protected AbstractEngine createEngine() {
        AbstractEngine engine = super.createEngine();
        if (this._abandonedFields != null) {
            engine.addAdditionalFields(this._abandonedFields);
        }
        return engine;
    }

    @Override
    protected void initFilter(List<AnalyticalField> dimensionFields, List<AnalyticalField> measureFields) {
        this.applyAppointedFilterFieldToMeasuresSafely(dimensionFields, measureFields);
    }

    @Override
    protected void initGainers(AbstractEngine engine, List<FilterPreparedValueGainer.AbstractPreparedValueGainer> gainers) throws AnalysisException {
        ArrayList<FilterPreparedValueGainer.AbstractPreparedValueGainer> quick = null;
        ArrayList<FilterPreparedValueGainer.AbstractPreparedValueGainer> slow = null;
        for (FilterPreparedValueGainer.AbstractPreparedValueGainer gainer : gainers) {
            if (gainer.isCanPullDown()) {
                if (quick == null) {
                    quick = new ArrayList<FilterPreparedValueGainer.AbstractPreparedValueGainer>();
                }
                quick.add(gainer);
                continue;
            }
            if (slow == null) {
                slow = new ArrayList<FilterPreparedValueGainer.AbstractPreparedValueGainer>();
            }
            slow.add(gainer);
        }
        engine.setFilterPreparedValueGainer(slow);
        if (quick != null) {
            this.pullDown(quick);
        }
    }

    private void pullDown(List<FilterPreparedValueGainer.AbstractPreparedValueGainer> gainers) throws DataTraversalException, UserStoppedException {
        DataSourceGreenChannel greenChannel = new DataSourceGreenChannel(this.getDataSourceVisitor());
        for (final FilterPreparedValueGainer.AbstractPreparedValueGainer gainer : gainers) {
            AnalyticalField analyticalField = gainer.getField();
            DataSourceGreenChannel.AbstractValueCollecter valueCollecter = new DataSourceGreenChannel.AbstractValueCollecter(){

                @Override
                public void accept(Map<String, Object> values) {
                    Object value;
                    try {
                        value = gainer.getDataGetter(null).getData(values);
                    }
                    catch (FormulaExecutingException e) {
                        value = null;
                    }
                    gainer.gain(value);
                }
            };
            try {
                greenChannel.getDistinctValue(analyticalField, valueCollecter);
            }
            catch (AbstractDataSourceException e) {
                throw DataTraversalException.createGetDistinctError((Exception)((Object)e));
            }
        }
    }
}

