/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.flattening.common.sort;

import com.kingdee.bos.qing.core.engine.Aggregator;
import com.kingdee.bos.qing.core.engine.CompositeKey;
import com.kingdee.bos.qing.core.engine.Cuboid;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractSortProcessor {
    private boolean _isAscendent = false;
    private int _topN = -1;
    private boolean _isOthersAsAnItem = false;

    public final void setAscendent(boolean isAsc) {
        this._isAscendent = isAsc;
    }

    public final void setTopN(int topN) {
        this._topN = topN;
    }

    public final void setOthersAsAnItem(boolean isOthersAsAnItem) {
        this._isOthersAsAnItem = isOthersAsAnItem;
    }

    protected final boolean isAscendent() {
        return this._isAscendent;
    }

    protected final boolean isNeedToDealWithTopN() {
        return this._topN > 0;
    }

    protected final boolean isOthersAsAnItem() {
        return this._isOthersAsAnItem;
    }

    public final void sortAndTopN(Cuboid cuboid, ICuboidShell insteadCuboid) throws AnalysisException {
        int topN;
        boolean hasItemForOthers;
        List<SortableItem> list = this.preSort(cuboid, insteadCuboid);
        Object[] allItems = list.toArray(new SortableItem[0]);
        Arrays.sort(allItems);
        if (this.isNeedToDealWithTopN()) {
            hasItemForOthers = this.isOthersAsAnItem() ? this._topN < allItems.length : false;
            topN = this._topN;
        } else {
            hasItemForOthers = false;
            topN = Integer.MAX_VALUE;
        }
        OthersMember categoryValueForOthers = hasItemForOthers ? new OthersMember() : null;
        for (int i = 0; i < allItems.length; ++i) {
            Object item = allItems[i];
            if (i < topN) {
                Object categoryValue = ((SortableItem)item).getCategoryValue();
                this.collectCategory(categoryValue, i);
            } else if (!hasItemForOthers) break;
            Iterator<CompositeKey> it = ((SortableItem)item).cellsKeyIterator();
            while (it.hasNext()) {
                CompositeKey dimKey = it.next();
                Aggregator[] aggs = ((SortableItem)item).getCuboidCell(dimKey);
                if (i < topN) {
                    insteadCuboid.retract(dimKey, aggs);
                    continue;
                }
                if (!hasItemForOthers) continue;
                CompositeKey insteadDimKey = this.replaceMemberForOthers(dimKey, categoryValueForOthers);
                this.mergeMeasureForOthers((Cuboid)((Object)insteadCuboid), insteadDimKey, aggs);
            }
        }
        if (hasItemForOthers) {
            this.collectCategory(categoryValueForOthers, Integer.MAX_VALUE);
        }
    }

    protected abstract List<SortableItem> preSort(Cuboid var1, ICuboidShell var2);

    protected abstract void collectCategory(Object var1, int var2) throws AnalysisException;

    protected abstract CompositeKey replaceMemberForOthers(CompositeKey var1, OthersMember var2);

    protected abstract void mergeMeasureForOthers(Cuboid var1, CompositeKey var2, Aggregator[] var3);

    public static class CuboidShell
    extends Cuboid
    implements ICuboidShell {
        private List<CompositeKey> _keys = new ArrayList<CompositeKey>();

        @Override
        public void retract(CompositeKey dimKey, Aggregator[] aggregators) {
            this._keys.add(dimKey);
            this._cells.put(dimKey, aggregators);
        }

        @Override
        public Iterator<CompositeKey> createDimensionKeyIterator() {
            return this._keys.iterator();
        }

        @Override
        public Aggregator[] getCellAggregators(CompositeKey dimKey) {
            if (!this._cells.containsKey(dimKey)) {
                this._keys.add(dimKey);
            }
            return super.getCellAggregators(dimKey);
        }

        public static CuboidShell copyShellFrom(Cuboid cuboid) {
            CuboidShell shell = new CuboidShell();
            shell.setDimensionFields(cuboid.getDimensionFields());
            shell.setMeasureFields(cuboid.getMeasureFields());
            return shell;
        }
    }

    public static interface ICuboidShell {
        public void retract(CompositeKey var1, Aggregator[] var2);
    }

    public static class OthersMember {
        private Set<Object> _members = new HashSet<Object>();

        public void addRealMember(Object member) {
            this._members.add(member);
        }

        public Set<Object> getAllRealMembers() {
            return this._members;
        }
    }

    public static class SortableItem
    implements Comparable<SortableItem> {
        private boolean _isAsc = false;
        private Object _categoryValue;
        private Map<CompositeKey, Aggregator[]> _cells = new HashMap<CompositeKey, Aggregator[]>();
        private BigDecimal _sortAccording;

        public void setAscendent(boolean isAsc) {
            this._isAsc = isAsc;
        }

        public void setCategoryValue(Object dimensionMember) {
            this._categoryValue = dimensionMember;
        }

        public Object getCategoryValue() {
            return this._categoryValue;
        }

        public void addCuboidCell(CompositeKey compositeKey, Aggregator[] aggregators, BigDecimal partOfSortAccording) {
            this._cells.put(compositeKey, aggregators);
            if (this._sortAccording == null) {
                this._sortAccording = partOfSortAccording;
            } else if (partOfSortAccording != null) {
                this._sortAccording = this._sortAccording.add(partOfSortAccording);
            }
        }

        public Iterator<CompositeKey> cellsKeyIterator() {
            return this._cells.keySet().iterator();
        }

        public Aggregator[] getCuboidCell(CompositeKey dimKey) {
            return this._cells.get(dimKey);
        }

        @Override
        public int compareTo(SortableItem o) {
            int compared = this._sortAccording == null ? (o._sortAccording == null ? 0 : 1) : (o._sortAccording == null ? -1 : o._sortAccording.compareTo(this._sortAccording));
            if (this._isAsc) {
                compared = -compared;
            }
            return compared;
        }
    }
}

