/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.flattening.square;

import com.kingdee.bos.qing.core.engine.Aggregator;
import com.kingdee.bos.qing.core.engine.CompositeKey;
import com.kingdee.bos.qing.core.engine.sort.CommonComparator;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.flattening.square.AbstractSquareViewMaker;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.square.chart.Funnel;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.FunnelChartProperty;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractNormalChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.MultiSeriesChartModel;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

class MakerForFunnel
extends AbstractSquareViewMaker {
    private CommonComparator _comparer;
    private MultiSeriesChartModel _chart;
    private AbstractNormalChartModel.Series _singleSeries;

    MakerForFunnel() {
    }

    private Funnel getDesignChartModel() {
        return (Funnel)this.getModel().getChartModel();
    }

    private FunnelChartProperty getDesignChartProperty() {
        return (FunnelChartProperty)this.getModel().getChartModel().getChartProperty();
    }

    @Override
    protected int getCategoryMemberLimitedCount() {
        return 16;
    }

    @Override
    protected int getSeriesMemberLimitedCount() {
        return 1;
    }

    @Override
    protected AbstractChartModel makeChart() throws AnalysisException {
        this._chart = new MultiSeriesChartModel();
        this._singleSeries = this._chart.addSeries("");
        if (this.getDesignChartModel().getMeasure().getFieldCount() > 0) {
            if (this.getCuboid().getCellCount() == 0) {
                this.makeChartWhenDataEmpty();
            } else if (this.getDesignChartModel().getDimension().getFieldCount() > 0) {
                this.outputByDimensionMembers();
            } else {
                this.outputByMultiMeasures();
            }
        }
        return this._chart;
    }

    private void makeChartWhenDataEmpty() {
        AbstractNormalChartModel.Category category = new AbstractNormalChartModel.Category();
        category.setLabel("");
        category.setColor(this.getDefaultColor());
        this._chart.addCategory(category);
        AbstractNormalChartModel.Node node = this.createNode(BigDecimal.ZERO, null);
        node.setText("");
        this._singleSeries.getNodes().add(node);
    }

    private void outputByDimensionMembers() {
        AnalyticalField dimensionField = this.getDesignChartModel().getDimension().getField(0);
        AnalyticalField measureField = this.getDesignChartModel().getMeasure().getField(0);
        boolean[] ignore = new boolean[]{false};
        ArrayList<SortableItem> items = new ArrayList<SortableItem>(5);
        Iterator<CompositeKey> it = this.getCuboid().createDimensionKeyIterator();
        while (it.hasNext()) {
            CompositeKey dimKey = it.next();
            BigDecimal measure = this.getCuboid().getCellAggregators(dimKey)[0].getNumberValue();
            BigDecimal sortableMeasure = this.checkNegative(measure, ignore);
            if (ignore[0]) continue;
            Object member = dimKey.getMember(0);
            AbstractNormalChartModel.Category category = this.createCategory(member, dimensionField);
            category.setOrderingValue(member);
            AbstractNormalChartModel.Node node = this.createNodeNotNull(measure, measureField);
            node.setOrderingValue(sortableMeasure);
            items.add(new SortableItem(category, node));
        }
        this.sortAndOutput(items);
        this._chart.setCategoryTitle(dimensionField.getTitle(this.getI18nContext()));
        this._singleSeries.setName(this.getMeasureTitle(measureField));
    }

    private void outputByMultiMeasures() {
        boolean[] ignore = new boolean[]{false};
        ArrayList<SortableItem> items = new ArrayList<SortableItem>(5);
        Iterator<CompositeKey> it = this.getCuboid().createDimensionKeyIterator();
        CompositeKey dimKey = it.next();
        Aggregator[] aggs = this.getCuboid().getCellAggregators(dimKey);
        int c = this.getDesignChartModel().getMeasure().getFieldCount();
        for (int i = 0; i < c; ++i) {
            Aggregator agg = aggs[i];
            BigDecimal measure = agg.getNumberValue();
            BigDecimal sortableMeasure = this.checkNegative(measure, ignore);
            if (ignore[0]) continue;
            AnalyticalField measureField = this.getDesignChartModel().getMeasure().getField(i);
            AbstractNormalChartModel.Category category = new AbstractNormalChartModel.Category();
            category.setLabel(this.getMeasureTitle(measureField));
            category.setOrderingValue(i);
            AbstractNormalChartModel.Node node = this.createNodeNotNull(measure, measureField);
            node.setOrderingValue(sortableMeasure);
            items.add(new SortableItem(category, node));
        }
        this.sortAndOutput(items);
    }

    private void sortAndOutput(List<SortableItem> items) {
        if (items.isEmpty()) {
            this.makeChartWhenDataEmpty();
        } else {
            Object[] itemArray = items.toArray(new SortableItem[0]);
            Arrays.sort(itemArray);
            for (int i = 0; i < itemArray.length; ++i) {
                Object item = itemArray[i];
                AbstractNormalChartModel.Category category = ((SortableItem)item).getCategory();
                String color = this.makeDiscreteColorValue(category, category.getLabel(), false);
                category.setColor(color);
                this._chart.addCategory(category);
                this._singleSeries.getNodes().add(((SortableItem)item).getNode());
            }
        }
    }

    private BigDecimal checkNegative(BigDecimal measure, boolean[] ignore) {
        ignore[0] = false;
        if (measure != null && measure.compareTo(BigDecimal.ZERO) < 0) {
            if (this.getDesignChartProperty().isHideNegative()) {
                ignore[0] = true;
            } else {
                measure = measure.abs();
            }
        }
        return measure;
    }

    private AbstractNormalChartModel.Category createCategory(Object member, AnalyticalField dimensionField) {
        String text = this.formatValue(member, dimensionField);
        String value = MakerForFunnel.encodeCategoryValue(member, text);
        AbstractNormalChartModel.Category category = new AbstractNormalChartModel.Category();
        category.setLabel(text);
        category.setValue(value);
        return category;
    }

    private CommonComparator getCommonComparator() {
        if (this._comparer == null) {
            Locale locale = this.getI18nContext().getLanManager().getLocale();
            this._comparer = new CommonComparator(locale);
            this._comparer.setEmptyAheadAlways(false);
        }
        return this._comparer;
    }

    private class SortableItem
    implements Comparable<SortableItem> {
        private AbstractNormalChartModel.Category _category;
        private AbstractNormalChartModel.Node _node;

        public SortableItem(AbstractNormalChartModel.Category category, AbstractNormalChartModel.Node node) {
            this._category = category;
            this._node = node;
        }

        public AbstractNormalChartModel.Category getCategory() {
            return this._category;
        }

        public AbstractNormalChartModel.Node getNode() {
            return this._node;
        }

        @Override
        public int compareTo(SortableItem o) {
            int compared;
            Comparable n1 = (Comparable)this._category.getOrderingValue();
            Comparable n2 = (Comparable)o._category.getOrderingValue();
            Comparable v1 = (Comparable)this._node.getOrderingValue();
            Comparable v2 = (Comparable)o._node.getOrderingValue();
            if (MakerForFunnel.this.getDesignChartProperty().isSortByName()) {
                compared = MakerForFunnel.this.getCommonComparator().compare(n1, n2);
                if (compared == 0) {
                    int valueCompared = MakerForFunnel.this.getCommonComparator().compare(v1, v2);
                    compared = MakerForFunnel.this.getCommonComparator().isReversedEnabled() ? -valueCompared : valueCompared;
                }
            } else {
                int valueCompared = MakerForFunnel.this.getCommonComparator().compare(v1, v2);
                compared = valueCompared == 0 ? MakerForFunnel.this.getCommonComparator().compare(n1, n2) : (MakerForFunnel.this.getCommonComparator().isReversedEnabled() ? -valueCompared : valueCompared);
            }
            return compared;
        }
    }
}

