/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.flattening.square;

import com.kingdee.bos.qing.core.engine.Aggregator;
import com.kingdee.bos.qing.core.engine.CompositeKey;
import com.kingdee.bos.qing.core.flattening.common.Palette;
import com.kingdee.bos.qing.core.flattening.common.Scope;
import com.kingdee.bos.qing.core.flattening.square.AbstractSquareViewMaker;
import com.kingdee.bos.qing.core.i18n.Messages;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.square.FieldSet;
import com.kingdee.bos.qing.core.model.analysis.square.chart.Radar;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.RadarChartProperty;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractNormalChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.MultiSeriesChartModel;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;

class MakerForRadar
extends AbstractSquareViewMaker {
    MakerForRadar() {
    }

    private Radar getDesignChartModel() {
        return (Radar)this.getModel().getChartModel();
    }

    @Override
    protected Palette.PaletteType getPaletteType() {
        return Palette.PaletteType.CONTRASTING_LINE;
    }

    @Override
    protected int getCategoryMemberLimitedCount() {
        return 128;
    }

    @Override
    protected int getSeriesMemberLimitedCount() {
        return 16;
    }

    @Override
    protected AbstractChartModel makeChart() {
        MultiSeriesChartModel chart = new MultiSeriesChartModel();
        if (this.getCuboid().getCellCount() == 0) {
            this.makeChartWhenDataEmpty(chart);
        } else {
            RadarChartProperty property = (RadarChartProperty)this.getDesignChartModel().getChartProperty();
            if (property.isMeasureOutside()) {
                new MeasureOutsideHandler(chart).make();
            } else {
                new DimentionOutsideHandler(chart).make();
            }
        }
        return chart;
    }

    private void makeChartWhenDataEmpty(MultiSeriesChartModel chart) {
        int count = 5;
        AbstractNormalChartModel.Series series = chart.addSeries("");
        for (int i = 0; i < count; ++i) {
            AbstractNormalChartModel.Category category = new AbstractNormalChartModel.Category();
            category.setLabel("");
            chart.addCategory(category);
            AbstractNormalChartModel.Node node = this.createNodeNotNull(BigDecimal.ZERO, null);
            node.setText("");
            series.getCategoryFitnessNodeList(count).set(i, node);
        }
        chart.addValueScope("0", "1");
    }

    private void sortSeriesAndConfirmColor(MultiSeriesChartModel chart, boolean isLegendLonelyIgnored) {
        chart.sortSeries(this.getI18nContext().getLanManager().getLocale());
        for (AbstractNormalChartModel.Series series : chart.getSeries()) {
            String text = series.getSeriesFieldText() != null ? series.getSeriesFieldText() : series.getName();
            series.setColor(this.makeDiscreteColorValue(series, text, isLegendLonelyIgnored));
        }
    }

    private void acceptScope(MultiSeriesChartModel chart, Scope scope) {
        AbstractNormalChartModel.AxisValueScope axisValueScope = chart.addValueScope(scope.getMin().toString(), scope.getMax().toString());
        scope.makeRulerScale(axisValueScope);
    }

    private class MeasureOutsideHandler {
        private MultiSeriesChartModel _chart;

        public MeasureOutsideHandler(MultiSeriesChartModel chart) {
            this._chart = chart;
        }

        public void make() {
            int measureCount = MakerForRadar.this.getDesignChartModel().getMeasure().getFieldCount();
            if (measureCount == 0) {
                MakerForRadar.this.makeChartWhenDataEmpty(this._chart);
            } else {
                this.makeMeasureFieldAsCategory();
                Scope scope = new Scope();
                if (MakerForRadar.this.getDesignChartModel().getDimension().getFieldCount() == 0) {
                    this.makeOnlyOneSeries(scope);
                    MakerForRadar.this.sortSeriesAndConfirmColor(this._chart, true);
                } else {
                    AnalyticalField field = MakerForRadar.this.getDesignChartModel().getDimension().getField(0);
                    this.makeDimensionMemberAsSeries(scope, field);
                    MakerForRadar.this.sortSeriesAndConfirmColor(this._chart, false);
                }
                MakerForRadar.this.acceptScope(this._chart, scope);
            }
        }

        private void makeMeasureFieldAsCategory() {
            FieldSet measureFields = MakerForRadar.this.getDesignChartModel().getMeasure();
            int measureCount = measureFields.getFieldCount();
            for (int i = 0; i < measureCount; ++i) {
                AbstractNormalChartModel.Category category = new AbstractNormalChartModel.Category();
                category.setLabel(MakerForRadar.this.getMeasureTitle(measureFields.getField(i)));
                this._chart.addCategory(category);
            }
        }

        private void makeOnlyOneSeries(Scope scope) {
            String text = Messages.getLangMessage(MakerForRadar.this.getI18nContext(), "total", "All");
            AbstractNormalChartModel.Series series = this._chart.addSeries(text);
            Aggregator[] aggs = MakerForRadar.this.getCuboid().getCellAggregators(MakerForRadar.this.getCuboid().createDimensionKeyIterator().next());
            this.createNodes(scope, series, aggs);
        }

        private void makeDimensionMemberAsSeries(Scope scope, AnalyticalField field) {
            Iterator<CompositeKey> it = MakerForRadar.this.getCuboid().createDimensionKeyIterator();
            while (it.hasNext()) {
                CompositeKey dimKey = it.next();
                Object member = dimKey.getMember(0);
                String text = MakerForRadar.this.formatValue(member, field);
                AbstractNormalChartModel.Series series = this._chart.addSeries(text);
                series.setOrderingValue(member);
                Aggregator[] aggs = MakerForRadar.this.getCuboid().getCellAggregators(dimKey);
                this.createNodes(scope, series, aggs);
            }
        }

        private void createNodes(Scope scope, AbstractNormalChartModel.Series series, Aggregator[] aggs) {
            FieldSet measureFields = MakerForRadar.this.getDesignChartModel().getMeasure();
            int measureCount = measureFields.getFieldCount();
            for (int i = 0; i < measureCount; ++i) {
                BigDecimal value = aggs[i].getNumberValue();
                AbstractNormalChartModel.Node node = MakerForRadar.this.createNode(value, measureFields.getField(i));
                series.getCategoryFitnessNodeList(measureCount).set(i, node);
                scope.join(value);
            }
        }
    }

    private class DimentionOutsideHandler {
        private MultiSeriesChartModel _chart;

        public DimentionOutsideHandler(MultiSeriesChartModel chart) {
            this._chart = chart;
        }

        public void make() {
            int measureCount = MakerForRadar.this.getDesignChartModel().getMeasure().getFieldCount();
            int dimensionCount = MakerForRadar.this.getDesignChartModel().getDimension().getFieldCount();
            if (measureCount == 0 || dimensionCount == 0) {
                MakerForRadar.this.makeChartWhenDataEmpty(this._chart);
            } else {
                Scope scope = new Scope();
                if (dimensionCount == 1) {
                    this.makeCategoryByDimensionAndSeriesByMeasureField(scope);
                } else {
                    this.makeCategoryBy1stDimensionAndSeriesBy2ndDimension(scope);
                }
                MakerForRadar.this.acceptScope(this._chart, scope);
            }
        }

        private void makeCategoryByDimensionAndSeriesByMeasureField(Scope scope) {
            AnalyticalField dimensionField = MakerForRadar.this.getDesignChartModel().getDimension().getField(0);
            this._chart.setCategoryTitle(dimensionField.getTitle(MakerForRadar.this.getI18nContext()));
            HashMap<Object, AbstractNormalChartModel.Category> categoryMap = new HashMap<Object, AbstractNormalChartModel.Category>();
            Iterator<CompositeKey> it = MakerForRadar.this.getCuboid().createDimensionKeyIterator();
            while (it.hasNext()) {
                CompositeKey dimKey = it.next();
                Object member = dimKey.getMember(0);
                String text = MakerForRadar.this.formatValue(member, dimensionField);
                AbstractNormalChartModel.Category category = new AbstractNormalChartModel.Category();
                category.setOrderingValue(member);
                category.setLabel(text);
                categoryMap.put(member, category);
                this._chart.addCategory(category);
            }
            this._chart.sortCategories(MakerForRadar.this.getI18nContext().getLanManager().getLocale());
            FieldSet measureFields = MakerForRadar.this.getDesignChartModel().getMeasure();
            int measureFieldCount = measureFields.getFieldCount();
            for (int i = 0; i < measureFieldCount; ++i) {
                AnalyticalField measureField = measureFields.getField(i);
                AbstractNormalChartModel.Series series = this._chart.addSeries(MakerForRadar.this.getMeasureTitle(measureField));
                series.setOrderingValue(i);
            }
            MakerForRadar.this.sortSeriesAndConfirmColor(this._chart, true);
            int categoryCount = this._chart.getCategories().size();
            it = MakerForRadar.this.getCuboid().createDimensionKeyIterator();
            while (it.hasNext()) {
                CompositeKey dimKey = it.next();
                Object member = dimKey.getMember(0);
                AbstractNormalChartModel.Category category = (AbstractNormalChartModel.Category)categoryMap.get(member);
                int categoryIndex = this._chart.getCategories().indexOf(category);
                Aggregator[] aggs = MakerForRadar.this.getCuboid().getCellAggregators(dimKey);
                for (int i = 0; i < measureFieldCount; ++i) {
                    BigDecimal value = aggs[i].getNumberValue();
                    AbstractNormalChartModel.Node node = MakerForRadar.this.createNode(value, measureFields.getField(i));
                    this._chart.getSeries(i).getCategoryFitnessNodeList(categoryCount).set(categoryIndex, node);
                    scope.join(value);
                }
            }
        }

        private void makeCategoryBy1stDimensionAndSeriesBy2ndDimension(Scope scope) {
            AnalyticalField meaureField = MakerForRadar.this.getDesignChartModel().getMeasure().getField(0);
            int categoryFieldIndex = 0;
            int seriesFieldIndex = 1;
            AnalyticalField fieldA = MakerForRadar.this.getDesignChartModel().getDimension().getField(categoryFieldIndex);
            AnalyticalField fieldB = MakerForRadar.this.getDesignChartModel().getDimension().getField(seriesFieldIndex);
            this._chart.setCategoryTitle(fieldA.getTitle(MakerForRadar.this.getI18nContext()));
            HashMap<Object, AbstractNormalChartModel.Category> categoryMap = new HashMap<Object, AbstractNormalChartModel.Category>();
            HashMap<Object, AbstractNormalChartModel.Series> seriesMap = new HashMap<Object, AbstractNormalChartModel.Series>();
            Iterator<CompositeKey> it = MakerForRadar.this.getCuboid().createDimensionKeyIterator();
            while (it.hasNext()) {
                Object memberB;
                AbstractNormalChartModel.Series series;
                CompositeKey dimKey = it.next();
                Object memberA = dimKey.getMember(categoryFieldIndex);
                AbstractNormalChartModel.Category category = (AbstractNormalChartModel.Category)categoryMap.get(memberA);
                if (category == null) {
                    String text = MakerForRadar.this.formatValue(memberA, fieldA);
                    category = new AbstractNormalChartModel.Category();
                    category.setOrderingValue(memberA);
                    category.setLabel(text);
                    this._chart.addCategory(category);
                    categoryMap.put(memberA, category);
                }
                if ((series = (AbstractNormalChartModel.Series)seriesMap.get(memberB = dimKey.getMember(seriesFieldIndex))) != null) continue;
                String text = MakerForRadar.this.formatValue(memberB, fieldB);
                series = this._chart.addSeries(text);
                series.setOrderingValue(memberB);
                seriesMap.put(memberB, series);
            }
            MakerForRadar.this.sortSeriesAndConfirmColor(this._chart, false);
            this._chart.sortCategories(MakerForRadar.this.getI18nContext().getLanManager().getLocale());
            int categoryCount = this._chart.getCategories().size();
            HashMap<Object, Integer> categoryIndexMap = new HashMap<Object, Integer>();
            it = MakerForRadar.this.getCuboid().createDimensionKeyIterator();
            while (it.hasNext()) {
                int categoryIndex;
                CompositeKey dimKey = it.next();
                Object memberA = dimKey.getMember(categoryFieldIndex);
                if (categoryIndexMap.containsKey(memberA)) {
                    categoryIndex = (Integer)categoryIndexMap.get(memberA);
                } else {
                    AbstractNormalChartModel.Category category = (AbstractNormalChartModel.Category)categoryMap.get(memberA);
                    categoryIndex = this._chart.getCategories().indexOf(category);
                    categoryIndexMap.put(memberA, categoryIndex);
                }
                Object memberB = dimKey.getMember(seriesFieldIndex);
                AbstractNormalChartModel.Series series = (AbstractNormalChartModel.Series)seriesMap.get(memberB);
                Aggregator[] aggs = MakerForRadar.this.getCuboid().getCellAggregators(dimKey);
                BigDecimal value = aggs[0].getNumberValue();
                AbstractNormalChartModel.Node node = MakerForRadar.this.createNode(value, meaureField);
                series.getCategoryFitnessNodeList(categoryCount).set(categoryIndex, node);
                scope.join(value);
            }
        }
    }
}

