/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.model.analysis.longer;

import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.core.model.analysis.common.filter.AbstractAnalyticalFilter;
import com.kingdee.bos.qing.core.model.analysis.common.filter.ContinuousDateFilter;
import com.kingdee.bos.qing.core.model.analysis.common.filter.ContinuousFilter;
import com.kingdee.bos.qing.core.model.analysis.common.filter.DiscreteFilter;
import com.kingdee.bos.qing.core.model.analysis.longer.AbstractFieldSet;
import com.kingdee.bos.qing.util.XmlUtil;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class FilterFieldSet
extends AbstractFieldSet {
    private List<AbstractAnalyticalFilter> filters = new ArrayList<AbstractAnalyticalFilter>();

    public List<AbstractAnalyticalFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<AbstractAnalyticalFilter> filters) {
        this.filters = filters;
    }

    public AbstractAnalyticalFilter getFilter(int idx) {
        return this.filters.get(idx);
    }

    public void safety() {
        for (int i = 0; i < this.filters.size(); ++i) {
            AbstractAnalyticalFilter filter = this.filters.get(i);
            filter.safety();
        }
    }

    @Override
    protected Element itemToXml(int idx) {
        Element nodeField = super.fieldToXml(idx);
        nodeField.setName("Field");
        AbstractAnalyticalFilter filter = this.filters.get(idx);
        Element nodeFilter = new Element("Filter");
        XmlUtil.writeAttrNotNull((Element)nodeFilter, (String)"name", (String)filter.getName());
        filter.toXml(nodeFilter);
        Element nodeItem = new Element("Item");
        nodeItem.addContent((Content)nodeField);
        nodeItem.addContent((Content)nodeFilter);
        return nodeItem;
    }

    @Override
    protected void itemFromXml(Element nodeItem, int idx) throws PersistentModelParseException {
        AbstractAnalyticalFilter filter;
        String filterName;
        Element nodeFilter;
        Element nodeField;
        try {
            nodeField = XmlUtil.getChildNotNull((Element)nodeItem, (String)"Field");
            nodeFilter = XmlUtil.getChildNotNull((Element)nodeItem, (String)"Filter");
            filterName = XmlUtil.readAttrNotNull((Element)nodeFilter, (String)"name");
        }
        catch (XmlUtil.NullException e) {
            throw new PersistentModelParseException(e);
        }
        super.fieldFromXml(nodeField, idx);
        if ("continuous".equals(filterName)) {
            filter = new ContinuousFilter();
        } else if ("continuousDate".equals(filterName)) {
            filter = new ContinuousDateFilter();
        } else if ("discrete".equals(filterName)) {
            filter = new DiscreteFilter();
        } else {
            throw new PersistentModelParseException("Unknown filter name");
        }
        filter.fromXml(nodeFilter);
        this.filters.add(idx, filter);
    }

    public FilterFieldSet copy() {
        FilterFieldSet inst = new FilterFieldSet();
        this.copyProperties(inst);
        for (AbstractAnalyticalFilter filter : this.filters) {
            inst.filters.add(filter.copy());
        }
        return inst;
    }
}

