/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.model.analysis.square.chart.property;

import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.core.model.analysis.common.Aggregation;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.AbstractChartProperty;
import com.kingdee.bos.qing.core.model.meta.MetaField;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.XmlUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jdom2.Content;
import org.jdom2.Element;

public class DialChartProperty
extends AbstractChartProperty
implements AbstractChartProperty.IAdditionalMeasureProvider {
    private PanStyle panStyle;
    private int arcDegree;
    private Integer rotateDegree;
    private boolean showRulerLabel;
    private String rulerLabelFormat;
    private List<Section> sections;
    private boolean showPointerName;
    private boolean showPointerNumber;
    private boolean showPointerPercent;
    private String pointerName;
    private String pointerNumberFormat;
    private String dataEmptyInstead = "0";

    public PanStyle getPanStyle() {
        return this.panStyle;
    }

    public int getArcDegree() {
        return this.arcDegree;
    }

    public int getRotateDegree() {
        return this.rotateDegree == null ? 0 : this.rotateDegree;
    }

    public boolean isShowRulerLabel() {
        return this.showRulerLabel;
    }

    public String getRulerLabelFormat() {
        return this.rulerLabelFormat;
    }

    public int getSectionCount() {
        return this.sections == null ? 0 : this.sections.size();
    }

    public Section getSection(int idx) {
        return this.sections.get(idx);
    }

    public boolean isShowPointerName() {
        return this.showPointerName;
    }

    public boolean isShowPointerNumber() {
        return this.showPointerNumber;
    }

    public boolean isShowPointerPercent() {
        return this.showPointerPercent;
    }

    public String getPointerName() {
        return this.pointerName;
    }

    public String getPointerNumberFormat() {
        return this.pointerNumberFormat;
    }

    public String getDataEmptyInstead() {
        return this.dataEmptyInstead;
    }

    @Override
    protected boolean isShowDataEmptyTipsByDefault() {
        if (this.getSectionCount() == 0) {
            return true;
        }
        int c = this.getSectionCount();
        for (int i = 0; i < c; ++i) {
            Section section = this.getSection(i);
            if (section.getMetaFieldFullName() == null || section.getAggregation() == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void confirmAdditionalMeasure(List<AnalyticalField> measures, AbstractChartProperty.IAdditionalMeasureProvider.IMetaFieldSearcher metaFieldSearcher) {
        int c = this.getSectionCount();
        for (int i = 0; i < c; ++i) {
            MetaField metaField;
            Section section = this.getSection(i);
            section.setRuntimeMeasureIndex(-1);
            if (section.getMetaFieldFullName() == null || section.getAggregation() == null || (metaField = metaFieldSearcher.search(section.getMetaFieldFullName())) == null) continue;
            int measureIndex = DialChartProperty.confirmAdditionalMeasure(measures, metaField, section.getAggregation());
            section.setRuntimeMeasureIndex(measureIndex);
        }
    }

    @Override
    protected void toXmlMore(Element node) {
        XmlUtil.writeAttrWhenExist((Element)node, (String)"panStyle", this.panStyle == null ? null : this.panStyle.toPersistance());
        XmlUtil.writeAttrInt((Element)node, (String)"arcDegree", (int)this.arcDegree);
        XmlUtil.writeAttrIntWhenExist((Element)node, (String)"rotateDegree", (Integer)this.rotateDegree);
        XmlUtil.writeAttrDefaultFalse((Element)node, (String)"showRulerLabel", (boolean)this.showRulerLabel);
        XmlUtil.writeAttrWhenExist((Element)node, (String)"rulerLabelFormat", (String)this.rulerLabelFormat);
        XmlUtil.writeAttrDefaultFalse((Element)node, (String)"showPointerName", (boolean)this.showPointerName);
        XmlUtil.writeAttrDefaultFalse((Element)node, (String)"showPointerNumber", (boolean)this.showPointerNumber);
        XmlUtil.writeAttrDefaultFalse((Element)node, (String)"showPointerPercent", (boolean)this.showPointerPercent);
        XmlUtil.writeAttrWhenExist((Element)node, (String)"pointerName", (String)this.pointerName);
        XmlUtil.writeAttrWhenExist((Element)node, (String)"pointerNumberFormat", (String)this.pointerNumberFormat);
        XmlUtil.writeAttrWhenExist((Element)node, (String)"dataEmptyInstead", (String)this.dataEmptyInstead);
        Element nodeSection = new Element("Section");
        int c = this.getSectionCount();
        for (int i = 0; i < c; ++i) {
            Section section = this.getSection(i);
            Element nodeItem = new Element("Item");
            section.toXml(nodeItem);
            nodeSection.addContent((Content)nodeItem);
        }
        node.addContent((Content)nodeSection);
    }

    @Override
    protected void fromXmlMore(Element node) throws PersistentModelParseException {
        String ps = XmlUtil.readAttrWhenExist((Element)node, (String)"panStyle");
        this.panStyle = ps == null ? null : PanStyle.fromPersistance(ps);
        try {
            this.arcDegree = XmlUtil.readAttrInt((Element)node, (String)"arcDegree");
        }
        catch (XmlUtil.NullException e) {
            this.arcDegree = 240;
        }
        this.rotateDegree = XmlUtil.readAttrIntWhenExist((Element)node, (String)"rotateDegree");
        this.showRulerLabel = XmlUtil.readAttrDefaultFalse((Element)node, (String)"showRulerLabel");
        this.rulerLabelFormat = XmlUtil.readAttrWhenExist((Element)node, (String)"rulerLabelFormat");
        this.showPointerName = XmlUtil.readAttrDefaultFalse((Element)node, (String)"showPointerName");
        this.showPointerNumber = XmlUtil.readAttrDefaultFalse((Element)node, (String)"showPointerNumber");
        this.showPointerPercent = XmlUtil.readAttrDefaultFalse((Element)node, (String)"showPointerPercent");
        this.pointerName = XmlUtil.readAttrWhenExist((Element)node, (String)"pointerName");
        this.pointerNumberFormat = XmlUtil.readAttrWhenExist((Element)node, (String)"pointerNumberFormat");
        String instead = XmlUtil.readAttrWhenExist((Element)node, (String)"dataEmptyInstead");
        this.dataEmptyInstead = instead == null ? "0" : instead;
        Element nodeSection = XmlUtil.getChild((Element)node, (String)"Section");
        List itemNodes = XmlUtil.getChildren((Element)nodeSection);
        for (Element nodeItem : itemNodes) {
            Section section = new Section();
            section.fromXml(nodeItem);
            if (this.sections == null) {
                this.sections = new ArrayList<Section>();
            }
            this.sections.add(section);
        }
    }

    public static Element upgradeGauge(Element nodeGaugeProperty) {
        DialChartProperty property = new DialChartProperty();
        try {
            property.fromXmlBase(nodeGaugeProperty);
        }
        catch (PersistentModelParseException persistentModelParseException) {
            // empty catch block
        }
        String panStyle = XmlUtil.readAttrWhenExist((Element)nodeGaugeProperty, (String)"panStyle");
        property.panStyle = "ruler".equals(panStyle) ? PanStyle.OnlyMark : PanStyle.WithTrack;
        String angleStyle = XmlUtil.readAttrWhenExist((Element)nodeGaugeProperty, (String)"angleStyle");
        property.arcDegree = "semicircle".equals(angleStyle) ? 180 : 240;
        property.showRulerLabel = XmlUtil.readAttrDefaultFalse((Element)nodeGaugeProperty, (String)"showRuler");
        property.rulerLabelFormat = XmlUtil.readAttrWhenExist((Element)nodeGaugeProperty, (String)"panNumberFormat");
        Integer pointerLabelType = XmlUtil.readAttrIntWhenExist((Element)nodeGaugeProperty, (String)"pointerLabelType");
        if (pointerLabelType != null) {
            property.showPointerName = (pointerLabelType & 1) == 1;
            property.showPointerNumber = (pointerLabelType & 2) == 2;
            property.showPointerPercent = (pointerLabelType & 4) == 4;
        }
        property.pointerName = XmlUtil.readAttrWhenExist((Element)nodeGaugeProperty, (String)"pointerLabelName");
        property.pointerNumberFormat = XmlUtil.readAttrWhenExist((Element)nodeGaugeProperty, (String)"pointerNumberFormat");
        String instead = XmlUtil.readAttrWhenExist((Element)nodeGaugeProperty, (String)"dataEmptyInstead");
        if (instead != null) {
            property.dataEmptyInstead = instead;
        }
        ArrayList<Section> sections = new ArrayList<Section>();
        Element nodeDetail = XmlUtil.getChild((Element)nodeGaugeProperty, (String)"gaugeDetail");
        if (nodeDetail != null) {
            Section section;
            String startValue = XmlUtil.readAttrWhenExist((Element)nodeDetail, (String)"startValue");
            String endValue = XmlUtil.readAttrWhenExist((Element)nodeDetail, (String)"endValue");
            String json = XmlUtil.readAttrWhenExist((Element)nodeDetail, (String)"segments");
            if (startValue != null) {
                section = new Section();
                section.endValue = startValue;
                sections.add(section);
            }
            if (json != null) {
                List list = (List)JsonUtil.decodeFromString((String)json, ArrayList.class);
                for (Map map : list) {
                    Section section2 = new Section();
                    section2.endValue = (String)map.get("value");
                    section2.label = (String)map.get("label");
                    section2.color = (String)map.get("color");
                    sections.add(section2);
                }
            } else if (endValue != null) {
                section = new Section();
                section.endValue = endValue;
                sections.add(section);
            }
        }
        if (!sections.isEmpty()) {
            property.sections = sections;
        }
        Element nodeProperty = new Element("Property");
        property.toXml(nodeProperty);
        return nodeProperty;
    }

    public static class Section {
        private String endValue;
        private String label;
        private String color;
        private String metaField;
        private Aggregation aggregation;
        private transient int _runtimeMeasureIndex = -1;

        public void setRuntimeMeasureIndex(int idx) {
            this._runtimeMeasureIndex = idx;
        }

        public int getRuntimeMeasureIndex() {
            return this._runtimeMeasureIndex;
        }

        public String getEndValue() {
            return this.endValue;
        }

        public String getLabel() {
            return this.label;
        }

        public String getColor() {
            return this.color;
        }

        public String getMetaFieldFullName() {
            return this.metaField;
        }

        public Aggregation getAggregation() {
            return this.aggregation;
        }

        public void toXml(Element node) {
            XmlUtil.writeAttrWhenExist((Element)node, (String)"value", (String)this.endValue);
            XmlUtil.writeAttrWhenExist((Element)node, (String)"label", (String)this.label);
            XmlUtil.writeAttrWhenExist((Element)node, (String)"color", (String)this.color);
            XmlUtil.writeAttrWhenExist((Element)node, (String)"metaField", (String)this.metaField);
            XmlUtil.writeAttrWhenExist((Element)node, (String)"aggregation", this.aggregation == null ? null : this.aggregation.toPersistance());
        }

        public void fromXml(Element node) throws PersistentModelParseException {
            this.endValue = XmlUtil.readAttrWhenExist((Element)node, (String)"value");
            this.label = XmlUtil.readAttrWhenExist((Element)node, (String)"label");
            this.color = XmlUtil.readAttrWhenExist((Element)node, (String)"color");
            this.metaField = XmlUtil.readAttrWhenExist((Element)node, (String)"metaField");
            String agg = XmlUtil.readAttrWhenExist((Element)node, (String)"aggregation");
            this.aggregation = agg == null ? null : Aggregation.fromPersistance(agg);
        }
    }

    public static enum PanStyle {
        OnlyMark,
        WithTrack;


        public String toPersistance() {
            return this.name();
        }

        public static PanStyle fromPersistance(String name) {
            try {
                return PanStyle.valueOf(name);
            }
            catch (Exception ex) {
                return WithTrack;
            }
        }
    }
}

