/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.framework.server.task.ServerRequestInvokeContext;
import com.kingdee.bos.qing.common.grammar.AbstractExecuteContext;
import com.kingdee.bos.qing.common.grammar.IExecuteContext;
import com.kingdee.bos.qing.common.grammar.exception.ExecuteException;
import com.kingdee.bos.qing.common.grammar.expr.IExpr;
import com.kingdee.bos.qing.common.grammar.expr.RefExpr;
import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.core.charttype.longer.AbstractChartTypeCoupler;
import com.kingdee.bos.qing.core.charttype.longer.ChartTypeComposerFactory;
import com.kingdee.bos.qing.core.engine.AbstractEngine;
import com.kingdee.bos.qing.core.engine.Aggregator;
import com.kingdee.bos.qing.core.engine.CompositeKey;
import com.kingdee.bos.qing.core.engine.Cuboid;
import com.kingdee.bos.qing.core.engine.FilterPreparedValueGainer;
import com.kingdee.bos.qing.core.engine.ParentChildDimensionMember;
import com.kingdee.bos.qing.core.engine.func.AbstractAggregationFunction;
import com.kingdee.bos.qing.core.engine.runner.longer.AbstractEngineRunner;
import com.kingdee.bos.qing.core.engine.runner.longer.EngineRunner;
import com.kingdee.bos.qing.core.engine.runner.longer.EngineRunnerForDataDetail;
import com.kingdee.bos.qing.core.engine.runner.longer.MdEngineRunnerForDataDetail;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.exception.DataTraversalException;
import com.kingdee.bos.qing.core.exception.InvalidMetaFieldException;
import com.kingdee.bos.qing.core.exception.UserStoppedException;
import com.kingdee.bos.qing.core.flattening.common.ExecutableValueCoder;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.common.ExecutableValue;
import com.kingdee.bos.qing.core.model.analysis.common.filter.AbstractAnalyticalFilter;
import com.kingdee.bos.qing.core.model.analysis.common.filter.DiscreteFilter;
import com.kingdee.bos.qing.core.model.analysis.longer.AbstractFieldSet;
import com.kingdee.bos.qing.core.model.analysis.longer.AnalyticalModel;
import com.kingdee.bos.qing.core.model.analysis.longer.FilterFieldSet;
import com.kingdee.bos.qing.core.model.analysis.longer.ModelAssistantStructure;
import com.kingdee.bos.qing.core.model.meta.DataType;
import com.kingdee.bos.qing.core.model.meta.Meta;
import com.kingdee.bos.qing.core.model.meta.MetaField;
import com.kingdee.bos.qing.core.model.meta.MetaTable;
import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.meta.DSFieldKey;
import com.kingdee.bos.qing.datasource.meta.DSMeta;
import com.kingdee.bos.qing.datasource.model.filter.IPushdownFilter;
import com.kingdee.bos.qing.datasource.spec.IDataIterator;
import com.kingdee.bos.qing.datasource.spec.IDataSourceExtend;
import com.kingdee.bos.qing.datasource.spec.IDataSourceVisitor;
import com.kingdee.bos.qing.datasource.spec.IDistinctValueCollecter;
import com.kingdee.bos.qing.domain.AbstractDomain;
import com.kingdee.bos.qing.domain.AdditionalFilterDomain;
import com.kingdee.bos.qing.domain.ExportDomain;
import com.kingdee.bos.qing.export.common.util.UnitUtil;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IWriteCall;
import com.kingdee.bos.qing.monitor.ICorrespondent;
import com.kingdee.bos.qing.util.CloseUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class DataDetailDomain
extends AbstractDomain {
    private static final String DEFAULT_SHEET_NAME = "Sheet1";
    private static final int DEFAULT_KEEP_CELLS = 2000;
    private String CUSTOM_BIZ_ENTITY_NAME_FIELD = ".custom_biz_entity_name";
    private static ThreadLocal<DateFormat> fullDateFormat = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };

    public DataDetailDomain(AbstractDomain.IDataSourceCreator dataSourceCreator) {
        super(dataSourceCreator);
    }

    public DataDetailSegment getDataDetailData(AnalyticalModel analyticalModel, String dataSourceCacheKey, DataRowInfo dri) throws AnalysisException {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<MetaField> metaFields = new ArrayList<MetaField>();
        HashSet<MetaTable> usedMetaTables = new HashSet<MetaTable>();
        Map<String, MetaField> allMetaFields = analyticalModel.getMeta().createSearchingMap();
        this.addToMetaTableSet(allMetaFields, usedMetaTables, analyticalModel.getColumn());
        this.addToMetaTableSet(allMetaFields, usedMetaTables, analyticalModel.getRow());
        this.addToMetaTableSet(allMetaFields, usedMetaTables, analyticalModel.getMarkFieldSet());
        this.addToMetaTableSet(allMetaFields, usedMetaTables, analyticalModel.getFilterFieldSet());
        HashSet<MetaField> usedMetaFields = new HashSet<MetaField>();
        this.addToMetaFieldSet(allMetaFields, usedMetaFields, analyticalModel.getColumn());
        this.addToMetaFieldSet(allMetaFields, usedMetaFields, analyticalModel.getRow());
        this.addToMetaFieldSet(allMetaFields, usedMetaFields, analyticalModel.getMarkFieldSet());
        this.addToMetaFieldSet(allMetaFields, usedMetaFields, analyticalModel.getFilterFieldSet());
        HashSet<DSFieldKey> usedDSFieldKey = new HashSet<DSFieldKey>();
        for (MetaTable metaTable : analyticalModel.getMeta().getTables()) {
            if (!usedMetaTables.contains(metaTable)) continue;
            for (MetaField metaField : metaTable.getFields()) {
                if (!metaField.isHide()) {
                    names.add(metaField.getFullName());
                    metaFields.add(metaField);
                }
                usedDSFieldKey.add(new DSFieldKey(metaField.getFullName()));
            }
        }
        try (IDataIterator rowIt = null;){
            IDataSourceVisitor dataSource = this.getDataSourceCreator().createCachedDataSourceVisitor(dataSourceCacheKey);
            rowIt = dataSource.iterator();
            rowIt.init(usedDSFieldKey, null, null);
            FormulaExecuteContext context = new FormulaExecuteContext();
            context.setMeta(analyticalModel.getMeta());
            context.setI18nContext(this.getI18nContext());
            DataDetailSegment dataDetailSegment = this.doGetDataDetailData(context, metaFields, names, rowIt, null, dri);
            return dataDetailSegment;
        }
    }

    public String getDataDetailValue(String dataSourceCacheKey, long rowNum, String metaFieldFullName, String bizUiId, String tag) throws InvalidMetaFieldException, AnalysisException {
        String member = null;
        try {
            IDataSourceVisitor dataSource = this.getDataSourceCreator().createCachedDataSourceVisitor(dataSourceCacheKey);
            IDataSourceVisitor dataSourceEntityVisitor = this.getDataSourceCreator().createDataSourceVisitor();
            member = this.getMember(metaFieldFullName, dataSource, rowNum, bizUiId, dataSourceEntityVisitor);
            if (member == null || member.isEmpty()) {
                throw InvalidMetaFieldException.createForLinkageForeignKeyUnused();
            }
        }
        catch (AbstractDataSourceException e) {
            throw new DataTraversalException((Exception)((Object)e));
        }
        catch (InterruptedException e) {
            throw new UserStoppedException();
        }
        return member;
    }

    private String getMember(String metaFieldFullName, IDataSourceVisitor dataSource, long rowIdx, String bizUiId, IDataSourceVisitor dataSourceVisitor) throws AbstractDataSourceException, InterruptedException {
        IDataSourceExtend dataSourceExtend;
        String member = null;
        HashSet<DSFieldKey> usedDSFieldKey = new HashSet<DSFieldKey>(1);
        Map unionTableAdditionFilter = null;
        String[] parts = MetaField.decodeFullName(metaFieldFullName);
        String metaFieldEntityName = parts[0] + this.CUSTOM_BIZ_ENTITY_NAME_FIELD;
        if (dataSourceVisitor instanceof IDataSourceExtend && !(unionTableAdditionFilter = (dataSourceExtend = (IDataSourceExtend)dataSourceVisitor).getUnionTableAdditionFilter(metaFieldFullName, bizUiId)).isEmpty()) {
            usedDSFieldKey.add(new DSFieldKey(metaFieldEntityName));
        }
        usedDSFieldKey.add(new DSFieldKey(metaFieldFullName));
        Map<String, Object> targetRowData = this.findTargetRow(dataSource, rowIdx, usedDSFieldKey);
        if (targetRowData != null && targetRowData.get(metaFieldFullName) != null) {
            String entityName;
            if (null != unionTableAdditionFilter && !unionTableAdditionFilter.isEmpty() && !(entityName = (String)unionTableAdditionFilter.get(metaFieldEntityName)).equals(targetRowData.get(metaFieldEntityName))) {
                return null;
            }
            member = String.valueOf(targetRowData.get(metaFieldFullName));
        }
        return member;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Object> findTargetRow(IDataSourceVisitor dataSource, long rowIdx, Set<DSFieldKey> usedDSFieldKey) throws AbstractDataSourceException, InterruptedException {
        Map targetRowData = null;
        IDataIterator rowIt = null;
        try {
            rowIt = dataSource.iterator();
            rowIt.init(usedDSFieldKey, null, null);
            int currentRowIndex = 1;
            while (rowIt.hasNextRow()) {
                Map currentRowData = rowIt.nextRow();
                if ((long)currentRowIndex <= rowIdx) {
                    if ((long)currentRowIndex == rowIdx) {
                        targetRowData = currentRowData;
                    }
                    ++currentRowIndex;
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{rowIt});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{rowIt});
        return targetRowData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getDataDetailRowNums(AnalyticalModel model, AdditionalFilterDomain.AdditionalFilters additionalFilters, TableViewCoordinate coordinate, boolean showAllField) throws AnalysisException {
        DataRowInfo dri;
        String cacheKey;
        long dataRowTotal;
        AbstractEngine engine;
        if (additionalFilters != null) {
            AdditionalFilterDomain afd = new AdditionalFilterDomain(this.getDataSourceCreator());
            afd.mergeIntoLonger(model, additionalFilters);
        }
        coordinate.addFilterToModel(model, this.getI18nContext());
        boolean isWholeCachedRows = !this.hasCalculationField(model);
        IDataSourceVisitor dataSource = this.createDataSourceVisitor();
        DetailDataSourceVisitor dataSrcVisitorWrap = new DetailDataSourceVisitor(dataSource, showAllField);
        ICorrespondent correspondent = DataDetailDomain.createExecutingCorrespondent();
        try {
            AbstractEngineRunner engineRunner;
            if (model.getMeta().getSrcMode() == Meta.Src.MD) {
                engineRunner = new MdEngineRunnerForDataDetail(dataSrcVisitorWrap, model, isWholeCachedRows);
                engineRunner.setContext(this.getI18nContext());
                engine = ((EngineRunner)engineRunner).run(correspondent);
                dataRowTotal = ((MdEngineRunnerForDataDetail)engineRunner).getDataRowTotal();
                cacheKey = ((MdEngineRunnerForDataDetail)engineRunner).getSubDataSourceCacheKey();
            } else {
                engineRunner = new EngineRunnerForDataDetail(dataSrcVisitorWrap, model, isWholeCachedRows);
                engineRunner.setContext(this.getI18nContext());
                engine = ((EngineRunnerForDataDetail)engineRunner).run(correspondent);
                dataRowTotal = ((EngineRunnerForDataDetail)engineRunner).getDataRowTotal();
                cacheKey = ((EngineRunnerForDataDetail)engineRunner).getSubDataSourceCacheKey();
            }
        }
        finally {
            DataDetailDomain.destroyExecutingCorrespondent(correspondent);
        }
        if (isWholeCachedRows) {
            dri = new DataRowInfo();
            dri.setStart(1L);
            dri.setEnd(dataRowTotal);
        } else {
            dri = this.createDataRowInfo(engine);
        }
        dri.setContinuousRows(isWholeCachedRows);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("dataRowInfo", dri);
        result.put("dataSourceCacheKey", cacheKey);
        return result;
    }

    private boolean hasCalculationField(AnalyticalModel model) {
        List<AnalyticalField> fields = model.getFilterFieldSet().getFields();
        for (AnalyticalField field : fields) {
            if (field.isMeasure() || !field.getMetaField().isCalculation()) continue;
            return true;
        }
        return false;
    }

    private DataRowInfo createDataRowInfo(AbstractEngine engine) {
        DataRowInfo dri = new DataRowInfo();
        Cuboid cuboid = engine.getCuboid();
        List<Long> expectedRowNums = this.collectRowNumbers(cuboid);
        Collections.sort(expectedRowNums);
        dri.setRowNumbers(expectedRowNums);
        return dri;
    }

    public void checkEntityExportPermission(QingContext qingContext, String tag, AnalyticalModel analyticalModel) throws Exception {
        ExportDomain exportDomain = new ExportDomain();
        exportDomain.checkEntityExportPermission(qingContext, tag, analyticalModel);
    }

    public void exportDataDetail(IQingFile qingFile, String dataSourceCacheKey, boolean isAssignedOnly, AnalyticalModel analyticalModel, DataRowInfo dri) throws AnalysisException {
        final ArrayList<Integer> outputIdx = new ArrayList<Integer>();
        HashSet<MetaTable> usedMetaTables = new HashSet<MetaTable>();
        Map<String, MetaField> allMetaFields = analyticalModel.getMeta().createSearchingMap();
        this.addToMetaTableSet(allMetaFields, usedMetaTables, analyticalModel.getColumn());
        this.addToMetaTableSet(allMetaFields, usedMetaTables, analyticalModel.getRow());
        this.addToMetaTableSet(allMetaFields, usedMetaTables, analyticalModel.getMarkFieldSet());
        this.addToMetaTableSet(allMetaFields, usedMetaTables, analyticalModel.getFilterFieldSet());
        HashSet<MetaField> usedMetaFields = new HashSet<MetaField>();
        if (isAssignedOnly) {
            this.addToMetaFieldSet(allMetaFields, usedMetaFields, analyticalModel.getColumn());
            this.addToMetaFieldSet(allMetaFields, usedMetaFields, analyticalModel.getRow());
            this.addToMetaFieldSet(allMetaFields, usedMetaFields, analyticalModel.getMarkFieldSet());
            this.addToMetaFieldSet(allMetaFields, usedMetaFields, analyticalModel.getFilterFieldSet());
        }
        Meta meta = analyticalModel.getMeta();
        int index = 0;
        final ArrayList<MetaField> allMetaFiled = new ArrayList<MetaField>();
        final DupplicatedNameRecognizer namer = new DupplicatedNameRecognizer();
        for (MetaTable metaTable : meta.getTables()) {
            if (!usedMetaTables.contains(metaTable)) continue;
            for (MetaField metaField : metaTable.getFields()) {
                allMetaFiled.add(metaField);
                if (!(metaField.isHide() || !usedMetaFields.contains(metaField) && isAssignedOnly)) {
                    outputIdx.add(index);
                    namer.collect(metaField);
                }
                ++index;
            }
        }
        try (DataDetailSegmentPageGetter segmentGetter = null;){
            DataDetailSegmentPageGetterFactory factory = new DataDetailSegmentPageGetterFactory();
            final DataDetailSegmentPageGetter segmentGetterFinal = segmentGetter = factory.getSegmentPageGetter(analyticalModel, dataSourceCacheKey, dri);
            qingFile.write(new IWriteCall(){

                public void call(OutputStream outputStream) throws IOException {
                    try {
                        DataDetailDomain.this.convertDataDetailToExcel(outputStream, segmentGetterFinal, outputIdx, allMetaFiled, namer);
                    }
                    catch (UserStoppedException e) {
                        throw new IOException((Throwable)((Object)e));
                    }
                    catch (AnalysisException e) {
                        throw new IOException((Throwable)((Object)e));
                    }
                }
            }, true);
        }
    }

    private DataDetailSegment doGetDataDetailData(FormulaExecuteContext context, List<MetaField> metaFields, List<String> names, IDataIterator rowIt, DataDetailSegmentPageGetter segmentGetter, DataRowInfo dri) throws UserStoppedException, DataTraversalException {
        ArrayList<List<Object>> rows = new ArrayList<List<Object>>();
        try {
            long currentRowIndex;
            boolean continuousRows = dri.isContinuousRows();
            long l = currentRowIndex = segmentGetter == null ? 0L : segmentGetter.getCurrentRowIndex();
            if (!continuousRows) {
                List<Long> expectedRowNums = dri.getRowNumbers();
                Collections.sort(expectedRowNums);
                Iterator<Long> expectRowIt = expectedRowNums.iterator();
                if (expectRowIt.hasNext()) {
                    long expectRow = expectRowIt.next();
                    while (rowIt.hasNextRow()) {
                        Map row = rowIt.nextRow();
                        if (row == null || ++currentRowIndex != expectRow) continue;
                        this.getData(context, row, metaFields, rows);
                        if (expectRowIt.hasNext()) {
                            expectRow = expectRowIt.next();
                            continue;
                        }
                        break;
                    }
                }
            } else {
                long expectRow = dri.getStart();
                long endRow = dri.getEnd();
                while (rowIt.hasNextRow()) {
                    Map row = rowIt.nextRow();
                    if (row == null || ++currentRowIndex != expectRow) continue;
                    this.getData(context, row, metaFields, rows);
                    if (expectRow < endRow) {
                        ++expectRow;
                        continue;
                    }
                    break;
                }
            }
            if (segmentGetter != null) {
                segmentGetter.setCurrentRowIndex(currentRowIndex);
            }
            return new DataDetailSegment(names, rows);
        }
        catch (InterruptedException e) {
            throw new UserStoppedException();
        }
        catch (AbstractDataSourceException e) {
            throw new DataTraversalException((Exception)((Object)e));
        }
    }

    private void getData(FormulaExecuteContext context, Map<String, Object> row, List<MetaField> metaFields, List<List<Object>> rows) {
        context.bindData(row);
        ArrayList<Object> rowData = new ArrayList<Object>(metaFields.size());
        for (MetaField metaField : metaFields) {
            Object cellData = row.get(metaField.getFullName());
            if (metaFields != null && metaField.isCalculation() && metaField.isValidCalculation()) {
                cellData = this.calculateFieldValue(metaField, (IExecuteContext)context);
            }
            Object serializedCellData = DataDetailDomain.serializeCellData(cellData);
            rowData.add(serializedCellData);
        }
        rows.add(rowData);
    }

    private Object calculateFieldValue(MetaField metaField, IExecuteContext context) {
        try {
            return metaField.getExpr().execute(context);
        }
        catch (Exception e) {
            return null;
        }
    }

    private List<Long> collectRowNumbers(Cuboid cuboid) {
        Aggregator.RowNum agg = new Aggregator.RowNum();
        Iterator<CompositeKey> it = cuboid.createDimensionKeyIterator();
        while (it.hasNext()) {
            Aggregator[] aggregators;
            for (Aggregator aggregator : aggregators = cuboid.getCellAggregators(it.next())) {
                if (!(aggregator instanceof Aggregator.RowNum)) continue;
                agg.add(aggregator);
            }
        }
        return agg.getRowNums();
    }

    private void addToMetaTableSet(Map<String, MetaField> allMetaFields, Set<MetaTable> usedMetaTables, AbstractFieldSet analyticalFieldSet) {
        for (AnalyticalField field : analyticalFieldSet.getFields()) {
            Set<String> dependence;
            MetaField metaField = field.getMetaField();
            if (metaField.isValidCalculation() && (dependence = metaField.getAllDependence()) != null) {
                for (String fullName : dependence) {
                    MetaField metaFieldDependence = allMetaFields.get(fullName);
                    usedMetaTables.add(metaFieldDependence.getMetaTable());
                }
            }
            usedMetaTables.add(metaField.getMetaTable());
        }
    }

    private void addToMetaFieldSet(Map<String, MetaField> allMetaFields, Set<MetaField> usedMetas, AbstractFieldSet analyticalFieldSet) {
        for (AnalyticalField field : analyticalFieldSet.getFields()) {
            Set<String> dependence;
            MetaField metaField = field.getMetaField();
            if (metaField.isValidCalculation() && (dependence = metaField.getAllDependence()) != null) {
                for (String fullName : dependence) {
                    MetaField metaFieldDependence = allMetaFields.get(fullName);
                    usedMetas.add(metaFieldDependence);
                }
            }
            usedMetas.add(metaField);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] convertDataDetailToExcel(OutputStream outputStream, DataDetailSegmentPageGetter segmentGetter, List<Integer> outputIdx, List<MetaField> allMetaField, DupplicatedNameRecognizer namer) throws IOException, AnalysisException {
        int rowHeight = 24;
        int colWidth = 100;
        ArrayList<DataType> usedDataTypes = new ArrayList<DataType>();
        HashSet<String> usedColumns = new HashSet<String>();
        SXSSFWorkbook wb = null;
        SXSSFSheet sheet = null;
        int columnIdx = 0;
        try {
            int i = 0;
            while ((long)i < segmentGetter.getTotalPages()) {
                Object value;
                DataType dataType;
                DataDetailSegment segment = segmentGetter.getByPage(i);
                List<String> columnInfos = segment.getColumnInfos();
                if (i == 0) {
                    int colNums = segment.getColumnInfos().size();
                    int keepRows = 2000 / colNums;
                    if (keepRows == 0) {
                        keepRows = 1;
                    }
                    wb = new SXSSFWorkbook(keepRows);
                    sheet = wb.createSheet(DEFAULT_SHEET_NAME);
                    Row head = sheet.createRow(0);
                    head.setHeight((short)UnitUtil.pixelToTwip(rowHeight));
                    for (int j = 0; j < allMetaField.size(); ++j) {
                        if (!outputIdx.contains(j)) continue;
                        Cell cell = head.createCell(columnIdx);
                        sheet.setColumnWidth(columnIdx, (int)UnitUtil.pixelToExcelWidth(colWidth));
                        MetaField metaField = allMetaField.get(j);
                        dataType = metaField.getDataType();
                        value = namer.getDisplayName(metaField);
                        if (value != null && ((String)value).length() > Short.MAX_VALUE) {
                            value = ((String)value).substring(0, 32764) + "...";
                        }
                        cell.setCellValue((String)value);
                        usedDataTypes.add(dataType);
                        usedColumns.add(metaField.getFullName());
                        ++columnIdx;
                    }
                }
                for (int j = 1; j <= segment.getDataSegment().size(); ++j) {
                    List<Object> rowData = segment.getDataSegment().get(j - 1);
                    Row row = sheet.createRow(j + i * (int)segmentGetter.getPageSize());
                    row.setHeight((short)UnitUtil.pixelToTwip(rowHeight));
                    columnIdx = 0;
                    this.checkStoppedByUser();
                    for (int k = 0; k < columnInfos.size(); ++k) {
                        String sValue;
                        String columnInfo = columnInfos.get(k);
                        if (!usedColumns.contains(columnInfo)) continue;
                        Cell cell = row.createCell(columnIdx);
                        dataType = (DataType)((Object)usedDataTypes.get(columnIdx));
                        value = rowData.get(k);
                        String string = sValue = value == null ? "" : value.toString();
                        if (sValue.length() > Short.MAX_VALUE) {
                            sValue = sValue.substring(0, 32764) + "...";
                        }
                        if (value == null) {
                            cell.setBlank();
                        } else if (DataType.NUMBER == dataType) {
                            try {
                                cell.setCellValue(Double.parseDouble(sValue));
                            }
                            catch (NumberFormatException e) {
                                cell.setCellValue(sValue);
                            }
                        } else {
                            cell.setCellValue(sValue);
                        }
                        ++columnIdx;
                    }
                }
                ++i;
            }
            wb.write(outputStream);
            if (wb == null) return null;
        }
        catch (Throwable throwable) {
            if (wb == null) throw throwable;
            wb.dispose();
            CloseUtil.close((Closeable[])new Closeable[]{wb});
            throw throwable;
        }
        wb.dispose();
        CloseUtil.close((Closeable[])new Closeable[]{wb});
        return null;
    }

    private void checkStoppedByUser() throws UserStoppedException {
        try {
            ServerRequestInvokeContext.staticCheckInterrupt();
        }
        catch (InterruptedException e) {
            throw new UserStoppedException();
        }
    }

    private static Object serializeCellData(Object value) {
        if (value instanceof Calendar) {
            return fullDateFormat.get().format(((Calendar)value).getTime());
        }
        return value;
    }

    private static class DetailDataSourceVisitor
    implements IDataSourceVisitor {
        private IDataSourceVisitor dataSourceVisitor;
        private boolean showAllField;

        public DetailDataSourceVisitor(IDataSourceVisitor dataSourceVisitor, boolean showAllField) {
            this.dataSourceVisitor = dataSourceVisitor;
            this.showAllField = showAllField;
        }

        public IDataIterator iterator() throws AbstractDataSourceException {
            IDataIterator dir = this.dataSourceVisitor.iterator();
            dir.setAllFieldsNeeded(this.showAllField);
            return dir;
        }

        public void collectDistinctValue(IDistinctValueCollecter valueCollecter, List<DSFieldKey> fields, Set<IPushdownFilter> filters) throws AbstractDataSourceException, InterruptedException {
            this.dataSourceVisitor.collectDistinctValue(valueCollecter, fields, filters);
        }

        public Calendar[] getDateScope(DSFieldKey field) throws AbstractDataSourceException, InterruptedException {
            return this.dataSourceVisitor.getDateScope(field);
        }

        public BigDecimal[] getNumberScope(DSFieldKey field) throws AbstractDataSourceException, InterruptedException {
            return this.dataSourceVisitor.getNumberScope(field);
        }

        public DSMeta getMeta() {
            return this.dataSourceVisitor.getMeta();
        }
    }

    private static class DupplicatedNameRecognizer {
        private Map<String, Set<MetaField>> _fields = new HashMap<String, Set<MetaField>>();

        private DupplicatedNameRecognizer() {
        }

        public void collect(MetaField field) {
            String displayName = field.getPureDisplayName();
            Set<MetaField> some = this._fields.get(displayName);
            if (some == null) {
                some = new HashSet<MetaField>();
                this._fields.put(displayName, some);
            }
            some.add(field);
        }

        public String getDisplayName(MetaField field) {
            String displayName = field.getPureDisplayName();
            Set<MetaField> some = this._fields.get(displayName);
            if (some != null && some.size() > 1) {
                MetaTable table = field.getMetaTable();
                return displayName + "(" + table.getDisplayName() + ")";
            }
            return displayName;
        }
    }

    private class DiscreteRowDataDetailSegmentPageGetter
    extends DataDetailSegmentPageGetter {
        private List<Long> rowNums;

        public DiscreteRowDataDetailSegmentPageGetter(AnalyticalModel analyticalModel, String dataSourceCacheKey, DataRowInfo dri) throws AbstractDataSourceException, InterruptedException {
            super(analyticalModel, dataSourceCacheKey, dri);
            this.rowNums = dri.getRowNumbers();
            this.totalSize = this.rowNums.size();
            this.totalPages = this.totalSize % this.pageSize == 0L ? this.totalSize / this.pageSize : this.totalSize / this.pageSize + 1L;
        }

        @Override
        public DataDetailSegment getByPage(int page) throws AnalysisException {
            int startIdx = (int)((long)page * this.pageSize);
            int endIdx = (int)((long)(page + 1) * this.pageSize);
            endIdx = endIdx > this.rowNums.size() ? this.rowNums.size() : endIdx;
            List<Long> rowNumsOnePage = this.rowNums.subList(startIdx, endIdx);
            this.tempDRI.setRowNumbers(rowNumsOnePage);
            return DataDetailDomain.this.doGetDataDetailData(this.context, this.metaFields, this.names, this.rowIt, this, this.tempDRI);
        }
    }

    private class ContinuousRowDataDetailSegmentPageGetter
    extends DataDetailSegmentPageGetter {
        private long start;
        private long end;

        public ContinuousRowDataDetailSegmentPageGetter(AnalyticalModel analyticalModel, String dataSourceCacheKey, DataRowInfo dri) throws AbstractDataSourceException, InterruptedException {
            super(analyticalModel, dataSourceCacheKey, dri);
            this.start = dri.getStart();
            this.end = dri.getEnd();
            this.totalSize = this.end - this.start + 1L;
            this.totalPages = this.totalSize % this.pageSize == 0L ? this.totalSize / this.pageSize : this.totalSize / this.pageSize + 1L;
        }

        @Override
        public DataDetailSegment getByPage(int page) throws AnalysisException {
            this.tempDRI.setStart(this.start + (long)page * this.pageSize);
            this.tempDRI.setEnd(this.start + (long)(page + 1) * this.pageSize - 1L > this.end ? this.end : this.start + (long)(page + 1) * this.pageSize - 1L);
            return DataDetailDomain.this.doGetDataDetailData(this.context, this.metaFields, this.names, this.rowIt, this, this.tempDRI);
        }
    }

    private abstract class DataDetailSegmentPageGetter {
        protected long totalSize;
        protected long totalPages;
        protected long pageSize = 5000L;
        protected DataRowInfo tempDRI;
        protected FormulaExecuteContext context;
        protected List<String> names = new ArrayList<String>();
        protected List<MetaField> metaFields = new ArrayList<MetaField>();
        protected IDataIterator rowIt;
        private long currentRowIndex = 0L;

        public DataDetailSegmentPageGetter(AnalyticalModel analyticalModel, String dataSourceCacheKey, DataRowInfo dri) throws AbstractDataSourceException, InterruptedException {
            this.tempDRI = dri;
            HashSet usedMetaTables = new HashSet();
            Map<String, MetaField> allMetaFields = analyticalModel.getMeta().createSearchingMap();
            DataDetailDomain.this.addToMetaTableSet(allMetaFields, usedMetaTables, analyticalModel.getColumn());
            DataDetailDomain.this.addToMetaTableSet(allMetaFields, usedMetaTables, analyticalModel.getRow());
            DataDetailDomain.this.addToMetaTableSet(allMetaFields, usedMetaTables, analyticalModel.getMarkFieldSet());
            DataDetailDomain.this.addToMetaTableSet(allMetaFields, usedMetaTables, analyticalModel.getFilterFieldSet());
            HashSet usedMetaFields = new HashSet();
            DataDetailDomain.this.addToMetaFieldSet(allMetaFields, usedMetaFields, analyticalModel.getColumn());
            DataDetailDomain.this.addToMetaFieldSet(allMetaFields, usedMetaFields, analyticalModel.getRow());
            DataDetailDomain.this.addToMetaFieldSet(allMetaFields, usedMetaFields, analyticalModel.getMarkFieldSet());
            DataDetailDomain.this.addToMetaFieldSet(allMetaFields, usedMetaFields, analyticalModel.getFilterFieldSet());
            HashSet<DSFieldKey> usedDSFieldKey = new HashSet<DSFieldKey>();
            for (MetaTable metaTable : analyticalModel.getMeta().getTables()) {
                if (!usedMetaTables.contains(metaTable)) continue;
                for (MetaField metaField : metaTable.getFields()) {
                    if (!metaField.isHide()) {
                        this.names.add(metaField.getFullName());
                        this.metaFields.add(metaField);
                    }
                    usedDSFieldKey.add(new DSFieldKey(metaField.getFullName()));
                }
            }
            try {
                IDataSourceVisitor dataSource = DataDetailDomain.this.getDataSourceCreator().createCachedDataSourceVisitor(dataSourceCacheKey);
                this.rowIt = dataSource.iterator();
                this.rowIt.init(usedDSFieldKey, null, null);
                this.context = new FormulaExecuteContext();
                this.context.setMeta(analyticalModel.getMeta());
            }
            catch (AbstractDataSourceException e) {
                if (this.rowIt != null) {
                    this.rowIt.close();
                    this.rowIt = null;
                }
                throw e;
            }
            catch (InterruptedException e) {
                if (this.rowIt != null) {
                    this.rowIt.close();
                    this.rowIt = null;
                }
                throw e;
            }
        }

        public long getTotalPages() {
            return this.totalPages;
        }

        public long getPageSize() {
            return this.pageSize;
        }

        public long getCurrentRowIndex() {
            return this.currentRowIndex;
        }

        public void setCurrentRowIndex(long currentRowIndex) {
            this.currentRowIndex = currentRowIndex;
        }

        public abstract DataDetailSegment getByPage(int var1) throws AnalysisException;

        public void close() {
            if (this.rowIt != null) {
                this.rowIt.close();
                this.rowIt = null;
            }
        }
    }

    private class DataDetailSegmentPageGetterFactory {
        private DataDetailSegmentPageGetterFactory() {
        }

        public DataDetailSegmentPageGetter getSegmentPageGetter(AnalyticalModel analyticalModel, String dataSourceCacheKey, DataRowInfo dri) throws AbstractDataSourceException, InterruptedException {
            if (dri.isContinuousRows()) {
                return new ContinuousRowDataDetailSegmentPageGetter(analyticalModel, dataSourceCacheKey, dri);
            }
            return new DiscreteRowDataDetailSegmentPageGetter(analyticalModel, dataSourceCacheKey, dri);
        }
    }

    public static class DataDetailSegment {
        private List<String> columnInfos;
        private List<List<Object>> dataSegment;

        public DataDetailSegment(List<String> names, List<List<Object>> dataSegment) {
            this.columnInfos = names;
            this.dataSegment = dataSegment;
        }

        public List<String> getColumnInfos() {
            return this.columnInfos;
        }

        public void setColumnInfos(List<String> columnInfos) {
            this.columnInfos = columnInfos;
        }

        public List<List<Object>> getDataSegment() {
            return this.dataSegment;
        }

        public void setDataSegment(List<List<Object>> dataSegment) {
            this.dataSegment = dataSegment;
        }
    }

    public static class DataRowInfo {
        private List<Long> rowNumbers;
        private Long start;
        private Long end;
        private boolean continuousRows;

        public List<Long> getRowNumbers() {
            return this.rowNumbers;
        }

        public void setRowNumbers(List<Long> rowNumers) {
            this.rowNumbers = rowNumers;
        }

        public Long getStart() {
            return this.start;
        }

        public void setStart(Long start) {
            this.start = start;
        }

        public Long getEnd() {
            return this.end;
        }

        public void setEnd(Long end) {
            this.end = end;
        }

        public boolean isContinuousRows() {
            return this.continuousRows;
        }

        public void setContinuousRows(boolean continuousRows) {
            this.continuousRows = continuousRows;
        }
    }

    private static class FormulaExecuteContext
    extends AbstractExecuteContext {
        private Map<String, MetaField> _metaFields;
        private Map<String, ?> _row;

        private FormulaExecuteContext() {
        }

        public void setMeta(Meta meta) {
            this._metaFields = meta.createSearchingMap();
        }

        public void bindData(Map<String, ?> row) {
            this._row = row;
        }

        public Object getValue(IExpr expr) throws ExecuteException {
            if (expr instanceof RefExpr) {
                MetaField mf;
                String fieldName = ((RefExpr)expr).getName();
                Object value = this._row.get(fieldName);
                if (value == null && (mf = this._metaFields.get(fieldName)) != null && mf.isValidCalculation()) {
                    IExpr refExpr = mf.getExpr();
                    value = refExpr.execute((IExecuteContext)this);
                }
                return value;
            }
            if (expr instanceof AbstractAggregationFunction) {
                return this.processAggFunction((AbstractAggregationFunction)expr);
            }
            throw new RuntimeException("Unsupported");
        }

        private Object processAggFunction(AbstractAggregationFunction expr) throws ExecuteException {
            Aggregator aggregator = Aggregator.create(expr.getAggregation());
            Object value = expr.getSubExprs()[0].execute((IExecuteContext)this);
            aggregator.append(value);
            return aggregator.getValue();
        }
    }

    public static class TableViewCoordinate {
        private List<CellExecutableValue> row = new ArrayList<CellExecutableValue>();
        private List<CellExecutableValue> column = new ArrayList<CellExecutableValue>();
        private List<CellExecutableValue> others = new ArrayList<CellExecutableValue>();

        public List<CellExecutableValue> getRow() {
            return this.row;
        }

        public List<CellExecutableValue> getColumn() {
            return this.column;
        }

        public List<CellExecutableValue> getOthers() {
            return this.others;
        }

        public void addFilterToModel(AnalyticalModel model, II18nContext i18nCtx) {
            AbstractChartTypeCoupler ctc = ChartTypeComposerFactory.getInstance(model.getChartType());
            ModelAssistantStructure modelAssistantStructure = ctc.parseAssistantStructure(model);
            List<AnalyticalField> colFields = modelAssistantStructure.getColumnDimensionFields();
            List<AnalyticalField> rowFields = modelAssistantStructure.getRowDimensionFields();
            List<AnalyticalField> cellFields = modelAssistantStructure.getCellDimensionFields();
            FilterFieldSet filterFieldSet = model.getFilterFieldSet();
            TableViewCoordinate.modifyFilterFieldSet(filterFieldSet, colFields, this.getColumn(), i18nCtx);
            TableViewCoordinate.modifyFilterFieldSet(filterFieldSet, rowFields, this.getRow(), i18nCtx);
            TableViewCoordinate.modifyFilterFieldSet(filterFieldSet, cellFields, this.getOthers(), i18nCtx);
            model.setFilterFieldSet(filterFieldSet);
        }

        private static void modifyFilterFieldSet(FilterFieldSet originFilterFieldSet, List<AnalyticalField> fields, List<CellExecutableValue> cevs, II18nContext i18nCtx) {
            if (null == fields) {
                return;
            }
            List<AnalyticalField> filterFields = originFilterFieldSet.getFields();
            List<AbstractAnalyticalFilter> filters = originFilterFieldSet.getFilters();
            int actualSize = Math.min(cevs.size(), fields.size());
            for (int i = 0; i < actualSize; ++i) {
                AnalyticalField field = fields.get(i);
                field = TableViewCoordinate.createFilterField(field);
                DiscreteFilter filter = TableViewCoordinate.createFilter(cevs.get(i), field, i18nCtx);
                filterFields.add(field);
                filters.add(filter);
            }
            originFilterFieldSet.setFields(filterFields);
            originFilterFieldSet.setFilters(filters);
        }

        private static AnalyticalField createFilterField(AnalyticalField field) {
            if (DataType.DATE != field.getDataType()) {
                field = field.copy();
                field.setNumberFormat("");
            }
            return field;
        }

        private static DiscreteFilter createFilter(CellExecutableValue cev, AnalyticalField field, II18nContext i18nCtx) {
            FilterPreparedValueGainer.GainerPeers gainerPeer = new FilterPreparedValueGainer.GainerPeers(field, i18nCtx);
            DiscreteFilter filter = new DiscreteFilter();
            if (cev.hasComplex()) {
                List<ExecutableValue> complexValues = cev.getComplexValues();
                for (ExecutableValue each : complexValues) {
                    Object member = each.getOriginalValue();
                    if (field.isParentChildDimension()) {
                        ParentChildDimensionMember pcd = ParentChildDimensionMember.createSearchingKey(member);
                        gainerPeer.gain(pcd);
                        continue;
                    }
                    gainerPeer.gain(member);
                }
            } else {
                Object member = cev.getOriginalValue();
                if (field.isParentChildDimension()) {
                    ParentChildDimensionMember pcd = ParentChildDimensionMember.createSearchingKey(member);
                    gainerPeer.gain(pcd);
                } else {
                    gainerPeer.gain(member);
                }
            }
            List<String> selecteds = gainerPeer.getAllPreparedValue();
            filter.setSelecteds(selecteds);
            return filter;
        }
    }

    public static class CellExecutableValue
    extends ExecutableValue {
        private String complex;
        private transient List<ExecutableValue> _parsed;

        public boolean hasComplex() {
            if (this.complex != null) {
                this._parsed = ExecutableValueCoder.decodeComplexValue(this.complex);
                return true;
            }
            return false;
        }

        public List<ExecutableValue> getComplexValues() {
            return this._parsed;
        }
    }
}

