/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.domain;

import com.kingdee.bos.qing.common.i18n.NationalFormatInfo;
import com.kingdee.bos.qing.core.exception.DataParseException;
import com.kingdee.bos.qing.core.exception.MetaParseException;
import com.kingdee.bos.qing.core.model.meta.DimensionNecessity;
import com.kingdee.bos.qing.core.model.meta.Meta;
import com.kingdee.bos.qing.core.model.meta.MetaField;
import com.kingdee.bos.qing.core.model.meta.MetaTable;
import com.kingdee.bos.qing.core.model.meta.ParentChildDimension;
import com.kingdee.bos.qing.core.model.meta.view.AbstractViewItem;
import com.kingdee.bos.qing.core.model.meta.view.MetaFieldGroup;
import com.kingdee.bos.qing.core.model.meta.view.MetaFieldItem;
import com.kingdee.bos.qing.core.model.meta.view.MetaTableSubView;
import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.exception.DataSourceNoDataException;
import com.kingdee.bos.qing.datasource.meta.DSFieldKey;
import com.kingdee.bos.qing.datasource.meta.DSMeta;
import com.kingdee.bos.qing.datasource.meta.DSMetaEntity;
import com.kingdee.bos.qing.datasource.meta.DSMetaProperty;
import com.kingdee.bos.qing.datasource.meta.DSParentChildDimension;
import com.kingdee.bos.qing.datasource.meta.DataType;
import com.kingdee.bos.qing.datasource.meta.view.AbstractDSViewItem;
import com.kingdee.bos.qing.datasource.meta.view.DSMetaEntitySubView;
import com.kingdee.bos.qing.datasource.meta.view.DSMetaFieldGroup;
import com.kingdee.bos.qing.datasource.meta.view.DSMetaFieldItem;
import com.kingdee.bos.qing.datasource.spec.IDataIterator;
import com.kingdee.bos.qing.datasource.spec.IDataSourceVisitor;
import com.kingdee.bos.qing.datasource.spec.IMetaVisitor;
import com.kingdee.bos.qing.domain.AbstractDomain;
import com.kingdee.bos.qing.util.NameUtil;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MetaDomain
extends AbstractDomain {
    private String _formatStringForInt;
    private String _fromatStringForDecimal;

    public MetaDomain(AbstractDomain.IDataSourceCreator dataSourceCreator) {
        super(dataSourceCreator);
    }

    public Meta getMeta() throws MetaParseException {
        IMetaVisitor metaVisitor = this.createMetaVisitor();
        Meta meta = this.parser(metaVisitor);
        return meta;
    }

    private Meta parser(IMetaVisitor metaVisitor) {
        NationalFormatInfo formatInfo = this.getI18nContext().getFormatInfo();
        this._formatStringForInt = "#" + formatInfo.getGroupingSeparator() + "##0";
        this._fromatStringForDecimal = this._formatStringForInt + formatInfo.getDecimalSeparator() + formatInfo.getDecimalZeroStr();
        DSMeta dsMeta = metaVisitor.getMeta();
        List dsmes = dsMeta.getEntities();
        ArrayList<MetaTable> mts = new ArrayList<MetaTable>(dsmes.size());
        int c = dsmes.size();
        for (int i = 0; i < c; ++i) {
            DSMetaEntity dsme = (DSMetaEntity)dsmes.get(i);
            MetaTable mt = this.parseTable(dsme);
            mts.add(mt);
        }
        Meta meta = new Meta();
        meta.setTables(mts);
        meta.fixMetaFieldOwner();
        return meta;
    }

    private MetaTable parseTable(DSMetaEntity dsme) {
        List dsmps = dsme.getProperties();
        HashMap<String, MetaField> allFields = new HashMap<String, MetaField>(dsmps.size());
        ArrayList<MetaField> dateFields = new ArrayList<MetaField>();
        ArrayList<MetaField> stringFields = new ArrayList<MetaField>();
        ArrayList<MetaField> numberFields = new ArrayList<MetaField>();
        int c = dsmps.size();
        for (int i = 0; i < c; ++i) {
            DSMetaProperty dsmp = (DSMetaProperty)dsmps.get(i);
            MetaField mf = MetaDomain.parseField(dsmp);
            com.kingdee.bos.qing.core.model.meta.DataType dataType = mf.getDataType();
            if (dataType == com.kingdee.bos.qing.core.model.meta.DataType.NUMBER) {
                if (mf.getFormatString() == null) {
                    if (dsmp.getDataType().equals((Object)DataType.INT)) {
                        mf.setFormatString(this._formatStringForInt);
                    } else {
                        mf.setFormatString(this._fromatStringForDecimal);
                    }
                }
                numberFields.add(mf);
            } else {
                if (mf.getFormatString() == null) {
                    mf.setFormatString(this._formatStringForInt);
                }
                if (dataType == com.kingdee.bos.qing.core.model.meta.DataType.DATE) {
                    dateFields.add(mf);
                } else if (dataType == com.kingdee.bos.qing.core.model.meta.DataType.STRING) {
                    stringFields.add(mf);
                } else {
                    throw new RuntimeException("New data-type, modify here.");
                }
            }
            allFields.put(mf.getPureName(), mf);
        }
        ArrayList<MetaField> mfs = new ArrayList<MetaField>();
        mfs.addAll(dateFields);
        mfs.addAll(stringFields);
        mfs.addAll(numberFields);
        MetaTable mt = new MetaTable();
        mt.setFields(mfs);
        mt.setName(dsme.getName());
        mt.setDisplayName(dsme.getDisplayName());
        mt.setParentName(dsme.getParentName());
        mt.setParentChildDimensions(MetaDomain.parseParentChildDimensions(dsme.getParentChildDimensions(), allFields));
        mt.setSubViews(MetaDomain.parseSubViews(dsme.getSubViews()));
        mt.setViewItems(MetaDomain.parseViewItems(dsme.getViewItems()));
        return mt;
    }

    private static List<AbstractViewItem> parseViewItems(List<AbstractDSViewItem> dsViewItems) {
        if (dsViewItems == null || dsViewItems.isEmpty()) {
            return null;
        }
        ArrayList<AbstractViewItem> viewItems = new ArrayList<AbstractViewItem>();
        for (AbstractDSViewItem dsViewItem : dsViewItems) {
            if (dsViewItem instanceof DSMetaFieldItem) {
                DSMetaFieldItem dsMetaFieldItem = (DSMetaFieldItem)dsViewItem;
                viewItems.add(MetaDomain.parseMetaFieldItem(dsMetaFieldItem));
                continue;
            }
            if (!(dsViewItem instanceof DSMetaFieldGroup)) continue;
            DSMetaFieldGroup dsMetaFieldGroup = (DSMetaFieldGroup)dsViewItem;
            viewItems.add(MetaDomain.parseMetaFieldGroup(dsMetaFieldGroup));
        }
        return viewItems;
    }

    private static MetaFieldItem parseMetaFieldItem(DSMetaFieldItem dsMetaFieldItem) {
        return new MetaFieldItem(dsMetaFieldItem.getName());
    }

    private static MetaFieldGroup parseMetaFieldGroup(DSMetaFieldGroup dsMetaFieldGroup) {
        MetaFieldGroup metaFieldGroup = new MetaFieldGroup(dsMetaFieldGroup.getName(), dsMetaFieldGroup.getDisplayName());
        for (DSMetaFieldItem dsMetaFieldItem : dsMetaFieldGroup.getFields()) {
            metaFieldGroup.getFieldItems().add(MetaDomain.parseMetaFieldItem(dsMetaFieldItem));
        }
        return metaFieldGroup;
    }

    private static List<MetaTableSubView> parseSubViews(List<DSMetaEntitySubView> dsSubViews) {
        if (dsSubViews == null || dsSubViews.isEmpty()) {
            return null;
        }
        ArrayList<MetaTableSubView> subViews = new ArrayList<MetaTableSubView>(dsSubViews.size());
        for (DSMetaEntitySubView dsSubView : dsSubViews) {
            MetaTableSubView metaTableSubView = new MetaTableSubView(dsSubView.getName(), dsSubView.getDisplayName());
            metaTableSubView.setSubViews(MetaDomain.parseSubViews(dsSubView.getSubViews()));
            metaTableSubView.setViewItems(MetaDomain.parseViewItems(dsSubView.getViewItems()));
            metaTableSubView.setDisplayAs(dsSubView.getSubViewType() == 0 ? MetaTableSubView.DisplayAs.Table : MetaTableSubView.DisplayAs.ElasticField);
            subViews.add(metaTableSubView);
        }
        return subViews;
    }

    public static MetaField parseField(DSMetaProperty dsmp) {
        com.kingdee.bos.qing.core.model.meta.DataType dataType;
        MetaField mf = new MetaField();
        mf.setGaoupName(dsmp.getGroup());
        mf.setHide(dsmp.isHide());
        mf.setFormatString(dsmp.getFormatString());
        mf.setPureName(dsmp.getName());
        mf.setPureDisplayName(dsmp.getDisplayName());
        switch (dsmp.getDataType()) {
            case INT: 
            case NUMBER: {
                dataType = com.kingdee.bos.qing.core.model.meta.DataType.NUMBER;
                break;
            }
            case DATE: 
            case DATETIME: {
                dataType = com.kingdee.bos.qing.core.model.meta.DataType.DATE;
                break;
            }
            default: {
                dataType = com.kingdee.bos.qing.core.model.meta.DataType.STRING;
            }
        }
        mf.setDataType(dataType);
        return mf;
    }

    private static List<ParentChildDimension> parseParentChildDimensions(List<DSParentChildDimension> dspcds, Map<String, MetaField> allFields) {
        if (dspcds == null) {
            return null;
        }
        ArrayList<ParentChildDimension> pcds = new ArrayList<ParentChildDimension>(dspcds.size());
        for (DSParentChildDimension dspcd : dspcds) {
            pcds.add(MetaDomain.parseParentChildDimension(dspcd, allFields));
        }
        return pcds;
    }

    private static ParentChildDimension parseParentChildDimension(DSParentChildDimension dspcd, Map<String, MetaField> allFields) {
        String groupName = dspcd.getName();
        ParentChildDimension pcd = new ParentChildDimension();
        pcd.setName(groupName);
        pcd.setAlias(dspcd.getAlias());
        String idFieldName = dspcd.getIdFieldName();
        MetaField idField = allFields.get(idFieldName);
        idField.setGaoupName(groupName);
        pcd.setIdFieldName(idFieldName);
        String parentIdFieldName = dspcd.getParentIdFieldName();
        MetaField parentIdField = allFields.get(parentIdFieldName);
        parentIdField.setGaoupName(groupName);
        pcd.setParentIdFieldName(parentIdFieldName);
        String displayFieldName = dspcd.getDisplayFieldName();
        MetaField displayField = allFields.get(displayFieldName);
        displayField.setGaoupName(groupName);
        pcd.setDisplayFieldName(displayFieldName);
        String sortAccordingFieldName = dspcd.getSortAccordingFieldName();
        MetaField sortAccordingField = allFields.get(sortAccordingFieldName);
        sortAccordingField.setGaoupName(groupName);
        pcd.setSortAccordingFieldName(sortAccordingFieldName);
        if (dspcd.getNecessary() != null) {
            switch (dspcd.getNecessary()) {
                case Indispensable: {
                    pcd.setDimensionNecessity(DimensionNecessity.Indispensable);
                    break;
                }
                case RootRepresented: {
                    pcd.setDimensionNecessity(DimensionNecessity.RootRepresented);
                    break;
                }
            }
        }
        return pcd;
    }

    public static void verifyMetaFieldsExist(Meta meta, DSMeta dsMeta) {
        HashSet<String> existDsFields = new HashSet<String>();
        for (DSMetaEntity entity : dsMeta.getEntities()) {
            String entityName = entity.getName();
            for (DSMetaProperty property : entity.getProperties()) {
                String propertyName = property.getName();
                String fullName = NameUtil.encodeFullName((String)entityName, (String)propertyName);
                existDsFields.add(fullName);
            }
        }
        Iterator<MetaField> it = meta.createAllFieldsIterator();
        while (it.hasNext()) {
            MetaField mf = it.next();
            if (mf.isCalculation() || existDsFields.contains(mf.getFullName())) continue;
            mf.setLost(true);
        }
    }

    public TableRowsSegment getMetaTableDetailRowData(MetaTable metaTable, long startRowNum, long endRowNum) throws DataParseException, InterruptedException {
        String metaTableName = metaTable.getName();
        List<MetaField> fields = metaTable.getFields();
        DSMetaEntity dsMetaEntity = null;
        IDataSourceVisitor dataSourceVisitor = this.createDataSourceVisitor();
        DSMeta dsMeta = dataSourceVisitor.getMeta();
        if (metaTableName == null) {
            dsMetaEntity = (DSMetaEntity)dsMeta.getEntities().get(0);
        } else {
            for (DSMetaEntity each : dsMeta.getEntities()) {
                if (!metaTableName.equals(each.getName())) continue;
                dsMetaEntity = each;
                break;
            }
        }
        HashSet<DSFieldKey> allField = new HashSet<DSFieldKey>();
        HashMap<String, DataType> dataTypes = new HashMap<String, DataType>();
        for (DSMetaProperty each : dsMetaEntity.getProperties()) {
            DSFieldKey key = new DSFieldKey(dsMetaEntity.getName(), each.getName());
            allField.add(key);
            dataTypes.put(key.toFullName(), each.getDataType());
        }
        TableRowsSegment rows = new TableRowsSegment();
        try {
            IDataIterator it = dataSourceVisitor.iterator();
            it.init(allField, null, null);
            long rowNum = 1L;
            while (it.hasNextRow()) {
                Map rowDataMap = it.nextRow();
                if (rowNum >= startRowNum && rowNum <= endRowNum) {
                    List<String> row = rows.addOneRow();
                    for (int i = 0; i < fields.size(); ++i) {
                        String fullName = fields.get(i).getFullName();
                        DataType dataType = (DataType)dataTypes.get(fullName);
                        Object value = rowDataMap.get(fullName);
                        rows.addValue(row, value, dataType);
                    }
                }
                if (startRowNum <= 1L || ++rowNum <= endRowNum) continue;
                break;
            }
            if (startRowNum == 1L) {
                rows.setTotalRows(rowNum - 1L);
            }
        }
        catch (DataSourceNoDataException ex) {
            rows.setTotalRows(0L);
        }
        catch (AbstractDataSourceException ex) {
            throw new DataParseException(ex);
        }
        return rows;
    }

    public static class TableRowsSegment {
        private transient SimpleDateFormat _dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        private transient SimpleDateFormat _dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        private Long totalRows;
        private List<List<String>> rows = new LinkedList<List<String>>();

        public void setTotalRows(long totalRows) {
            this.totalRows = totalRows;
        }

        public List<String> addOneRow() {
            ArrayList<String> row = new ArrayList<String>();
            this.rows.add(row);
            return row;
        }

        public void addValue(List<String> row, Object value, DataType dataType) {
            String text = this.format(dataType, value);
            row.add(text);
        }

        private String format(DataType dataType, Object value) {
            if (value == null) {
                return "";
            }
            switch (dataType) {
                case DATE: {
                    return this._dateFormat.format(((Calendar)value).getTime());
                }
                case DATETIME: {
                    return this._dateTimeFormat.format(((Calendar)value).getTime());
                }
            }
            if (value instanceof BigDecimal) {
                return ((BigDecimal)value).toPlainString();
            }
            return value.toString();
        }
    }
}

